﻿// PROSTY QUIZ
// Rozdział 7 (Warianty drzew)
// Struktury danych i algorytmy w C#, wydanie II

BinaryTree<string> tree = GetTree();
BinaryTreeNode<string>? node = tree.Root;
while (node != null)
{
    if (node.Left != null && node.Right != null)
    {
        Console.WriteLine(node.Data);
        node = Console.ReadKey(true).Key switch
        {
            ConsoleKey.Y => node.Left,
            ConsoleKey.N => node.Right,
            _ => node
        };
    }
    else
    {
        Console.WriteLine(node.Data);
        node = null;
    }
}

BinaryTree<string> GetTree()
{
    BinaryTree<string> tree = new();
    tree.Root = new BinaryTreeNode<string>()
    {
        Data = "Czy masz doświadczenie w programowaniu aplikacji?",
        Children =
        [
            new BinaryTreeNode<string>()
            {
                Data = "Czy pracowałeś jako programista przez ponad 5 lat?",
                Children =
                [
                    new() { Data = "Aplikuj na stanowisko starszego programisty" },
                    new() { Data = "Aplikuj na stanowisko programisty średniego szczebla" }
                ]
            },
            new BinaryTreeNode<string>()
            {
                Data = "Czy skończyłeś studia?",
                Children =
                [
                    new() { Data = "Aplikuj na stanowisko młodszego programisty!" },
                    new BinaryTreeNode<string>()
                    {
                        Data = "Czy w ciągu semestru znajdziesz trochę czasu?",
                        Children =
                        [
                            new() { Data = "Aplikuj do naszego programu praktyk długoterminowych!" },
                            new() { Data = "Aplikuj do programu praktyk wakacyjnych!" }
                        ]
                    }
                ]
            }
        ]
    };
    tree.Count = 9;
    return tree;
}
