﻿// TELEFONICZNE BIURO OBSŁUGI KLIENTA Z WIELOMA KONSULTANTAMI
// Rozdział 5. (Stosy i kolejki)
// Struktury danych i algorytmy w języku C#, wydanie drugie

Random random = new();
CallCenter center = new();
Parallel.Invoke(
    () => Clients(center),
    () => Consultant(center, "Marcin", ConsoleColor.Red),
    () => Consultant(center, "Jakub", ConsoleColor.Yellow),
    () => Consultant(center, "Oliwia", ConsoleColor.Green));

void Clients(CallCenter center)
{
    while (true)
    {
        int clientId = random.Next(1, 10000);
        IncomingCall call = center.Call(clientId);
        Log($"Połączenie przychodzące nr {call.Id} od klienta {clientId}");
        Log($"Liczba oczekujących w kolejce: {center.Calls.Count}");
        Thread.Sleep(random.Next(500, 2000));
    }
}

void Consultant(CallCenter center, string name, ConsoleColor color)
{
    while (true)
    {
        Thread.Sleep(random.Next(500, 1000));
        IncomingCall? call = center.Answer(name);
        if (call == null) { continue; }

        Log($"Połączenie nr {call.Id} od klienta {call.ClientId} odebrał(a) {call.Consultant}.", color);
        Thread.Sleep(random.Next(1000, 10000));
        center.End(call);
        Log($"Połączenie nr {call.Id} z klientem {call.ClientId} zakończył(a) {call.Consultant}.", color);
    }
}

void Log(string text, ConsoleColor color = ConsoleColor.Gray)
{
    Console.ForegroundColor = color;
    Console.WriteLine($"[{DateTime.Now:HH:mm:ss.fff}] {text}");
    Console.ResetColor();
}
