﻿using System;
using System.Data.SqlTypes;
using Microsoft.SqlServer.Server;


[Serializable]
[Microsoft.SqlServer.Server.SqlUserDefinedAggregate(
    Format.Native,
    Name = "ufnAvgWeighted")]
public struct AvgWithWeight : IBinarySerialize 
{
    double sum;
    int count;

    public void Init()
    {
    }

    public void Accumulate(Nullable<double> Value, Nullable<double> Weight)
    {
        if (!Value.HasValue || !Weight.HasValue)
        {
            return;
        }
        sum += Value.Value * Weight.Value;
        count++;
    }

    public void Merge(AvgWithWeight Group)
    {
        sum += Group.sum;
        count += Group.count;
    }

    public double Terminate()
    {
        if (count == 0)
        {
            return 0;
        }
        return sum / count;
    }

    public void Read(System.IO.BinaryReader r)
    {
        sum = r.ReadDouble();
        count = r.ReadInt32();
    }

    public void Write(System.IO.BinaryWriter w)
    {
        w.Write(sum);
        w.Write(count);
    }
}
