﻿using System;
using System.Data.SqlTypes;
using Microsoft.SqlServer.Server;
using System.Collections;
using System.Diagnostics;

public partial class UserDefinedFunctions
{
    [Microsoft.SqlServer.Server.SqlFunction(
        Name="ufnReadLog",
        FillRowMethodName="FillRow",
        TableDefinition="TimeWritten datetime, Message nvarchar(max), " + 
                        "Category nvarchar(255), InstanceId bigint")]
    public static IEnumerable ReadLog(string logName)
    {
        return new EventLog(logName).Entries;
    }

    public static void FillRow(Object obj, out SqlDateTime timeWritten, 
        out SqlString message, out SqlString category, out long instanceId)
    {
        EventLogEntry eventLogEntry = (EventLogEntry)obj;
        timeWritten = new SqlDateTime(eventLogEntry.TimeWritten);
        message = eventLogEntry.Message;
        category = eventLogEntry.Category;
        instanceId = eventLogEntry.InstanceId;
    }
};

