/****
This SQL script was generated by the Configure Data Synchronization
dialog box. This script contains statements that create the
change-tracking columns, deleted-items table, and triggers on the
server database. These database objects are required by Synchronization
Services to successfully synchronize data between client and server
databases. For more information, see the
‘How to: Configure a Database Server for Synchronization’ topic in Help.
****/


IF @@TRANCOUNT > 0
set ANSI_NULLS ON 
set QUOTED_IDENTIFIER ON 

GO
BEGIN TRANSACTION;


IF @@TRANCOUNT > 0
ALTER TABLE [dbo].[Produkty] 
ADD [LastEditDate] DateTime NULL CONSTRAINT [DF_Produkty_LastEditDate] DEFAULT (GETUTCDATE()) WITH VALUES
GO
IF @@ERROR <> 0 
     ROLLBACK TRANSACTION;


IF @@TRANCOUNT > 0
ALTER TABLE [dbo].[Produkty] 
ADD [CreationDate] DateTime NULL CONSTRAINT [DF_Produkty_CreationDate] DEFAULT (GETUTCDATE()) WITH VALUES
GO
IF @@ERROR <> 0 
     ROLLBACK TRANSACTION;


IF @@TRANCOUNT > 0
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Produkty_Tombstone]')) 
BEGIN 
CREATE TABLE [dbo].[Produkty_Tombstone]( 
    [ProductID] Int NOT NULL,
    [DeletionDate] DateTime NULL
) ON [PRIMARY] 
END 

GO
IF @@ERROR <> 0 
     ROLLBACK TRANSACTION;


IF @@TRANCOUNT > 0
ALTER TABLE [dbo].[Produkty_Tombstone] ADD CONSTRAINT [PKDEL_Produkty_Tombstone_ProductID]
   PRIMARY KEY CLUSTERED
    ([ProductID])
    ON [PRIMARY]
GO
IF @@ERROR <> 0 
     ROLLBACK TRANSACTION;


IF @@TRANCOUNT > 0
IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Produkty_DeletionTrigger]') AND type = 'TR') 
   DROP TRIGGER [dbo].[Produkty_DeletionTrigger] 

GO
CREATE TRIGGER [dbo].[Produkty_DeletionTrigger] 
    ON [dbo].[Produkty] 
    AFTER DELETE 
AS 
SET NOCOUNT ON 
UPDATE [dbo].[Produkty_Tombstone] 
    SET [DeletionDate] = GETUTCDATE() 
    FROM deleted 
    WHERE deleted.[ProductID] = [dbo].[Produkty_Tombstone].[ProductID] 
IF @@ROWCOUNT = 0 
BEGIN 
    INSERT INTO [dbo].[Produkty_Tombstone] 
    ([ProductID], DeletionDate)
    SELECT [ProductID], GETUTCDATE()
    FROM deleted 
END 

GO
IF @@ERROR <> 0 
     ROLLBACK TRANSACTION;


IF @@TRANCOUNT > 0
IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Produkty_UpdateTrigger]') AND type = 'TR') 
   DROP TRIGGER [dbo].[Produkty_UpdateTrigger] 

GO
CREATE TRIGGER [dbo].[Produkty_UpdateTrigger] 
    ON [dbo].[Produkty] 
    AFTER UPDATE 
AS 
BEGIN 
    SET NOCOUNT ON 
    UPDATE [dbo].[Produkty] 
    SET [LastEditDate] = GETUTCDATE() 
    FROM inserted 
    WHERE inserted.[ProductID] = [dbo].[Produkty].[ProductID] 
END;
GO
IF @@ERROR <> 0 
     ROLLBACK TRANSACTION;


IF @@TRANCOUNT > 0
IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[Produkty_InsertTrigger]') AND type = 'TR') 
   DROP TRIGGER [dbo].[Produkty_InsertTrigger] 

GO
CREATE TRIGGER [dbo].[Produkty_InsertTrigger] 
    ON [dbo].[Produkty] 
    AFTER INSERT 
AS 
BEGIN 
    SET NOCOUNT ON 
    UPDATE [dbo].[Produkty] 
    SET [CreationDate] = GETUTCDATE() 
    FROM inserted 
    WHERE inserted.[ProductID] = [dbo].[Produkty].[ProductID] 
END;
GO
IF @@ERROR <> 0 
     ROLLBACK TRANSACTION;
COMMIT TRANSACTION;
