/*
 Sams Teach Yourself Oracle PL/SQL in Ten Minutes
 http://forta.com/books/0672328666
 Example table population scripts
*/


/*
 Utwórz tabelę klienci table
*/
CREATE TABLE klienci
(
  kl_id      INT       NOT NULL IDENTITY(1,1),
  nazwa_kl   NCHAR(50)  NOT NULL ,
  adres_kl   NCHAR(50)  NULL ,
  miasto_kl  NCHAR(50)  NULL ,
  woj_kl     NCHAR(5)   NULL ,
  kod_kl     NCHAR(10)  NULL ,
  kraj_kl    NCHAR(50)  NULL ,
  kontakt_kl NCHAR(50)  NULL ,
  email_kl   NCHAR(255) NULL 
);
ALTER TABLE klienci
ADD CONSTRAINT pk_klienci PRIMARY KEY (kl_id);


/*
 Utwórz tabelę pozycje
*/
CREATE TABLE pozycje
(
  numer_zam   INT          NOT NULL ,
  pozycja_zam INT          NOT NULL ,
  id_prod     NCHAR(10)     NOT NULL ,
  ilosc       INT          NOT NULL ,
  cena_poz    MONEY NOT NULL
);
ALTER TABLE pozycje
ADD CONSTRAINT pk_pozycje PRIMARY KEY (numer_zam, pozycja_zam);

/*
 Utwórz tabelę zamowienia
*/
CREATE TABLE zamowienia
(
  numer_zam  INT  NOT NULL identity(1,1),
  data_zam   DATETIME NOT NULL ,
  kl_id      INT  NOT NULL
);
ALTER TABLE zamowienia
ADD CONSTRAINT pk_zamowienia PRIMARY KEY (numer_zam);

/*
 Utwórz tabelę produkty
*/
CREATE TABLE produkty
(
  id_prod     NCHAR(10)      NOT NULL,
  id_dost     INT           NOT NULL ,
  nazwa_prod  NCHAR(255)     NOT NULL ,
  cena_prod   MONEY		     NOT NULL ,
  opis_prod   NTEXT          NULL
);
ALTER TABLE produkty
ADD CONSTRAINT pk_produkty PRIMARY KEY (id_prod);



/*
 Utwórz tabelę dostawcy
*/
CREATE TABLE dostawcy
(
  id_dost     INT       NOT NULL identity(1,1),
  nazwa_dost  NCHAR(50) NOT NULL ,
  adres_dost  NCHAR(50) NULL ,
  miasto_dost NCHAR(50) NULL ,
  woj_dost    NCHAR(5)  NULL ,
  kod_dost    NCHAR(10) NULL ,
  kraj_dost   NCHAR(50) NULL
);
ALTER TABLE dostawcy
ADD CONSTRAINT pk_dostawcy PRIMARY KEY (id_dost);

/*
Utwórz tabelę prod_uwagi
*/
CREATE TABLE prod_uwagi
(
  id_uw    INT      NOT NULL identity(1,1),
  id_prod  NCHAR(10) NOT NULL ,
  data_uw  DATETIME     NOT NULL ,
  tekst_uw NTEXT     NULL
);
ALTER TABLE prod_uwagi
ADD CONSTRAINT pk_prod_uwagi PRIMARY KEY (id_uw);



/*
 Definicja kluczy obcych
*/
ALTER TABLE pozycje ADD CONSTRAINT fk_pozycje_zamowienia FOREIGN KEY (numer_zam) REFERENCES zamowienia (numer_zam);
ALTER TABLE pozycje ADD CONSTRAINT fk_pozycje_produkty FOREIGN KEY (id_prod) REFERENCES produkty (id_prod);
ALTER TABLE zamowienia ADD CONSTRAINT fk_zamowienia_klienci FOREIGN KEY (kl_id) REFERENCES klienci (kl_id);
ALTER TABLE produkty ADD CONSTRAINT fk_produkty_dostawcy FOREIGN KEY (id_dost) REFERENCES dostawcy (id_dost);
ALTER TABLE prod_uwagi ADD CONSTRAINT fk_prod_uwagi_produkty FOREIGN KEY (id_prod) REFERENCES produkty (id_prod);
