﻿using System;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using Helpers;

namespace CompleteDataDemo
{
    public partial class CompleteData : Form
    {
        public CompleteData()
        {
            InitializeComponent();
        }

        private void btnSubmit_Click(object sender, EventArgs e)
        {
            var ageProbability = DatabaseHelper.GetAgeProbability(txtChildren.Text, cmbCommuteDistance.Items[cmbCommuteDistance.SelectedIndex].ToString(),
                cmbCountry.Items[cmbCountry.SelectedIndex].ToString(), cmbGender.Items[cmbGender.SelectedIndex].ToString(), cmbHouseOwner.Items[cmbHouseOwner.SelectedIndex].ToString(),
                cmbMaritalStatus.Items[cmbMaritalStatus.SelectedIndex].ToString(), txtNumberCarsOwned.Text, cmbOccupation.Items[cmbOccupation.SelectedIndex].ToString(),
                cmbRegion.Items[cmbRegion.SelectedIndex].ToString(), txtYearlyIncome.Text);

            if (String.IsNullOrEmpty(ageProbability.Error))
            {
                txtAge.Text = ageProbability.Age.ToString();
                txtAge.BackColor = Color.Yellow;
                arcScaleComponentAge.Value = (float)Math.Round(ageProbability.Probability * 100, 0);
            }
            else
                MessageBox.Show(ageProbability.Error);

            var educationProbability = DatabaseHelper.GetEducationProbability(txtChildren.Text, cmbCommuteDistance.Items[cmbCommuteDistance.SelectedIndex].ToString(),
                cmbCountry.Items[cmbCountry.SelectedIndex].ToString(), cmbGender.Items[cmbGender.SelectedIndex].ToString(), cmbHouseOwner.Items[cmbHouseOwner.SelectedIndex].ToString(),
                cmbMaritalStatus.Items[cmbMaritalStatus.SelectedIndex].ToString(), txtNumberCarsOwned.Text, cmbOccupation.Items[cmbOccupation.SelectedIndex].ToString(),
                cmbRegion.Items[cmbRegion.SelectedIndex].ToString(), txtYearlyIncome.Text);

            if (String.IsNullOrEmpty(educationProbability.Error))
            {
                cmbEducation.SelectedIndex = cmbEducation.FindStringExact(educationProbability.Education);
                cmbEducation.BackColor = Color.Yellow;
                arcScaleComponentEducation.Value = (float)Math.Round(educationProbability.Probability * 100, 0);
            }
            else
                MessageBox.Show(educationProbability.Error);
        }

        private void CompleteData_Load(object sender, EventArgs e)
        {
            var model = new CustomersModelDataContext();

            var countryList = (from cou in model.Customers
                               select cou.Country).Distinct();
            cmbCountry.Items.Add("");
            foreach (var item in countryList)
                cmbCountry.Items.Add(item);

            var maritalStatusList = (from mar in model.Customers
                                     select mar.MaritalStatus).Distinct();
            cmbMaritalStatus.Items.Add("");
            foreach (var item in maritalStatusList)
                cmbMaritalStatus.Items.Add(item);

            var educationList = (from edu in model.Customers
                                 select edu.Education).Distinct();
            cmbEducation.Items.Add("");
            foreach (var item in educationList)
            {
                cmbEducation.Items.Add(item);
            }

            var occupationList = (from occ in model.Customers
                                  select occ.Occupation).Distinct();
            cmbOccupation.Items.Add("");
            foreach (var item in occupationList)
                cmbOccupation.Items.Add(item);

            var houseOwnerList = (from hou in model.Customers
                                  select hou.HouseOwnerFlag).Distinct();
            cmbHouseOwner.Items.Add("");
            foreach (var item in houseOwnerList)
                cmbHouseOwner.Items.Add(item);

            var commuteDistance = (from com in model.Customers
                                   select com.CommuteDistance).Distinct();
            cmbCommuteDistance.Items.Add("");
            foreach (var item in commuteDistance)
                cmbCommuteDistance.Items.Add(item);

            var regionList = (from reg in model.Customers
                              select reg.Region).Distinct();
            cmbRegion.Items.Add("");
            foreach (var item in regionList)
                cmbRegion.Items.Add(item);

            var genderList = (from gen in model.Customers
                              select gen.Gender).Distinct();
            cmbGender.Items.Add("");
            foreach (var item in genderList)
                cmbGender.Items.Add(item);
        }
    }
}
