---------------------------------------------------------------------------
-- SQL w praktyce. Jak dzięki danym uzyskiwać cenne informacje. Wydanie II
-- Anthony DeBarros

-- Rozdział 6. Przykłady z kodem
----------------------------------------------------------------------------

-- Listing 6.1: Wykonywanie podstawowych operacji dodawania, odejmowania i mnożenia z użyciem języka SQL

SELECT 2 + 2;    -- dodawanie
SELECT 9 - 1;    -- odejmowanie
SELECT 3 * 4;    -- mnożenie

-- Listing 6.2: Obsługa dzielenia liczb całkowitych i dziesiętnych przez język SQL

SELECT 11 / 6;   -- dzielenie liczb całkowitych
SELECT 11 % 6;   -- dzielenie z resztą (modulo)
SELECT 11.0 / 6; -- dzielenie liczb dziesiętnych
SELECT CAST(11 AS numeric(3,1)) / 6;

-- Listing 6.3: Użycie wykładników, pierwiastków i silni w języku SQL

SELECT 3 ^ 4;         -- potęgowanie
SELECT |/ 10;         -- pierwiastek kwadratowy (operator)
SELECT sqrt(10);      -- pierwiastek kwadratowy (funkcja)
SELECT ||/ 10;        -- pierwiastek sześcienny
SELECT factorial(4);  -- silnia (funkcja)
SELECT 4 !;           -- silnia (operator; tylko system PostgreSQL w wersji 13 i nowszych)


-- Kolejność operacji

SELECT 7 + 8 * 9; 	-- wynik: 79
SELECT (7 + 8) * 9;	-- wynik: 135

SELECT 3 ^ 3 - 1;   -- wynik: 26
SELECT 3 ^ (3 - 1); -- wynik: 9

-- Listing 6.4: Wybieranie kolumn identyfikowanych przez aliasy z danymi szacunkowymi dotyczącymi populacji objętej spisem ludności

SELECT county_name AS county,
       state_name AS state,
       pop_est_2019 AS pop,
       births_2019 AS births,
       deaths_2019 AS deaths,
       international_migr_2019 AS int_migr,
       domestic_migr_2019 AS dom_migr,
       residual_2019 AS residual
FROM us_counties_pop_est_2019;

-- Listing 6.5: Odejmowanie wartości dwóch kolumn tabeli us_counties_pop_est_2019

SELECT county_name AS county,
       state_name AS state,
       births_2019 AS births,
       deaths_2019 AS deaths,
       births_2019 - deaths_2019 AS natural_increase
FROM us_counties_pop_est_2019
ORDER BY state_name, county_name;

-- Listing 6.6: Sprawdzanie sum dla danych spisu ludności

SELECT county_name AS county,
       state_name AS state,
       pop_est_2019 AS pop,
       pop_est_2018 + births_2019 - deaths_2019 + 
           international_migr_2019 + domestic_migr_2019 +
           residual_2019 AS components_total,
       pop_est_2019 - (pop_est_2018 + births_2019 - deaths_2019 + 
           international_migr_2019 + domestic_migr_2019 +
           residual_2019) AS difference
FROM us_counties_pop_est_2019
ORDER BY difference DESC;

-- Listing 6.7: Wyznaczanie wartości procentowej obszaru hrabstwa pokrytego wodą

SELECT county_name AS county,
       state_name AS state,
       area_water::numeric / (area_land + area_water) * 100 AS pct_water
FROM us_counties_pop_est_2019
ORDER BY pct_water DESC;


-- Listing 6.8: Obliczanie zmiany procentowej

CREATE TABLE percent_change (
    department text,
    spend_2019 numeric(10,2),
    spend_2022 numeric(10,2)
);

INSERT INTO percent_change
VALUES
    ('Assessor', 178556, 179500),
    ('Building', 250000, 289000),
    ('Clerk', 451980, 650000),
    ('Library', 87777, 90001),
    ('Parks', 250000, 223000),
    ('Water', 199000, 195000);

SELECT department,
       spend_2019,
       spend_2022,
       round( (spend_2022 - spend_2019) /
                    spend_2019 * 100, 1) AS pct_change
FROM percent_change;

-- Listing 6.9: Użycie funkcji agregujących sum() i avg()

SELECT sum(pop_est_2019) AS county_sum,
       round(avg(pop_est_2019), 0) AS county_average
FROM us_counties_pop_est_2019;

-- Listing 6.10: Testowanie funkcji percentyla języka SQL

CREATE TABLE percentile_test (
    numbers integer
);

INSERT INTO percentile_test (numbers) VALUES
    (1), (2), (3), (4), (5), (6);

SELECT
    percentile_cont(.5)
    WITHIN GROUP (ORDER BY numbers),
    percentile_disc(.5)
    WITHIN GROUP (ORDER BY numbers)
FROM percentile_test;

-- Listing 6.11: Zastosowanie funkcji agregujących sum() i avg() oraz funkcji percentile_cont()

SELECT sum(pop_est_2019) AS county_sum,
       round(avg(pop_est_2019), 0) AS county_average,
       percentile_cont(.5)
       WITHIN GROUP (ORDER BY pop_est_2019) AS county_median
FROM us_counties_pop_est_2019;

-- Listing 6.12: Przekazanie tablicy wartości funkcji percentile_cont()

-- kwartyle
SELECT percentile_cont(ARRAY[.25,.5,.75])
       WITHIN GROUP (ORDER BY pop_est_2019) AS quartiles
FROM us_counties_pop_est_2019;

-- Dodatki:
-- kwartyle
SELECT percentile_cont(ARRAY[.2,.4,.6,.8])
       WITHIN GROUP (ORDER BY pop_est_2019) AS quintiles
FROM us_counties_pop_est_2019;

-- decyle
SELECT percentile_cont(ARRAY[.1,.2,.3,.4,.5,.6,.7,.8,.9])
       WITHIN GROUP (ORDER BY pop_est_2019) AS deciles
FROM us_counties_pop_est_2019;

-- Listing 6.13: Użycie funkcji unnest() do przekształcenia tablicy w wiersze

SELECT unnest(
            percentile_cont(ARRAY[.25,.5,.75])
            WITHIN GROUP (ORDER BY pop_est_2019)
            ) AS quartiles
FROM us_counties_pop_est_2019;

-- Listing 6.14: Znajdowanie najczęściej występującej wartości przy użyciu funkcji mode()

SELECT mode() WITHIN GROUP (ORDER BY births_2019)
FROM us_counties_pop_est_2019;
