---------------------------------------------------------------------------
-- SQL w praktyce. Jak dzięki danym uzyskiwać cenne informacje. Wydanie II
-- Anthony DeBarros

-- Rozdział 5. Przykłady z kodem
----------------------------------------------------------------------------

-- Listing 5.1: Użycie instrukcji COPY do importowania danych
-- Jest to tylko przykładowa składnia. Wykonanie tego kodu spowoduje błąd.

COPY table_name
FROM 'C:\TwojKatalog\twoj_plik.csv'
WITH (FORMAT CSV, HEADER);


-- Listing 5.2: Instrukcja CREATE TABLE użyta dla szacunkowych danych dotyczących populacji w hrabstwach objętych spisem ludności
-- Słownik szacunkowych danych jest dostępny tutaj: https://www2.census.gov/programs-surveys/popest/technical-documentation/file-layouts/2010-2019/co-est2019-alldata.pdf
-- Słownik danych dla dodatkowych kolumn dostępny jest tutaj: http://www.census.gov/prod/cen2010/doc/pl94-171.pdf
-- Uwaga: niektórym kolumnom nadano bardziej opisowe nazwy

CREATE TABLE us_counties_pop_est_2019 (
    state_fips text,                         -- Kod stanu określony przez urząd FIPS
    county_fips text,                        -- Kod hrabstwa określony przez urząd FIPS
    region smallint,                         -- Region
    state_name text,                         -- Nazwa stanu	
    county_name text,                        -- Nazwa hrabstwa
    area_land bigint,                        -- Powierzchnia (lądowa) w metrach kwadratowych
    area_water bigint,                       -- Powierzchnia (wodna) w metrach kwadratowych
    internal_point_lat numeric(10,7),        -- Punkt wewnętrzny (szerokość geograficzna)
    internal_point_lon numeric(10,7),        -- Punkt wewnętrzny (długość geograficzna)
    pop_est_2018 integer,                    -- Łączna, szacunkowa populacja mieszkańców (2018-07-01)
    pop_est_2019 integer,                    -- Łączna, szacunkowa populacja mieszkańców (2019-07-01)
    births_2019 integer,                     -- Liczba urodzeń w okresie od 2018-07-01 do 2019-06-30
    deaths_2019 integer,                     -- Liczba zgonów w okresie od 2018-07-01 do 2019-06-30
    international_migr_2019 integer,         -- Migracja międzynarodowa netto w okresie od 2018-07-01 do 2019-06-30
    domestic_migr_2019 integer,              -- Migracja krajowa netto w okresie od 2018-07-01 do 2019-06-30
    residual_2019 integer,                   -- Residuum dla okresu od 2018-07-01 do 2019-06-30
    CONSTRAINT counties_2019_key PRIMARY KEY (state_fips, county_fips)	
);

SELECT * FROM us_counties_pop_est_2019;

-- Listing 5.3: Importowanie zbioru danych spisu ludności przy użyciu polecenia COPY
-- Uwaga! Jeśli wystąpi tutaj błąd importowania, upewnij się, że pobrałeś kod i dane
-- dołączony do książki zgodnie z krokami podanymi w rozdziale 1.
-- Użytkownicy systemu Windows: proszę sprawdzić też uwagę na stronie XXXXXX.

COPY us_counties_pop_est_2019
FROM 'C:\TwojKatalog\us_counties_pop_est_2019.csv'
WITH (FORMAT CSV, HEADER);

-- Sprawdzanie danych

SELECT * FROM us_counties_pop_est_2019;

SELECT county_name, state_name, area_land
FROM us_counties_pop_est_2019
ORDER BY area_land DESC
LIMIT 3;

SELECT county_name, state_name, internal_point_lat, internal_point_lon
FROM us_counties_pop_est_2019
ORDER BY internal_point_lon DESC
LIMIT 5;


-- Listing 5.4: Tworzenie tabeli służącej do monitorowania zarobków osób zarządzających

CREATE TABLE supervisor_salaries (
    id integer GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    town text,
    county text,
    supervisor text,
    start_date date,
    salary numeric(10,2),
    benefits numeric(10,2)
);

-- Listing 5.5: Importowanie danych o zarobkach z pliku CSV do trzech kolumn tabeli

COPY supervisor_salaries (town, supervisor, salary)
FROM 'C:\TwojKatalog\supervisor_salaries.csv'
WITH (FORMAT CSV, HEADER);

-- Sprawdzenie danych
SELECT * FROM supervisor_salaries ORDER BY id LIMIT 2;


-- Listing 5.6: Importowanie podzbioru wierszy z użyciem klauzuli WHERE

DELETE FROM supervisor_salaries;

COPY supervisor_salaries (town, supervisor, salary)
FROM 'C:\TwojKatalog\supervisor_salaries.csv'
WITH (FORMAT CSV, HEADER)
WHERE town = 'New Brillig';

SELECT * FROM supervisor_salaries;


-- Listing 5.7: Użycie tabeli tymczasowej w celu dodania wartości domyślnej do kolumny podczas
-- importowania

DELETE FROM supervisor_salaries;

CREATE TEMPORARY TABLE supervisor_salaries_temp 
    (LIKE supervisor_salaries INCLUDING ALL);

COPY supervisor_salaries_temp (town, supervisor, salary)
FROM 'C:\TwojKatalog\supervisor_salaries.csv'
WITH (FORMAT CSV, HEADER);

INSERT INTO supervisor_salaries (town, county, supervisor, salary)
SELECT town, 'Mills', supervisor, salary
FROM supervisor_salaries_temp;

DROP TABLE supervisor_salaries_temp;

-- Sprawdzenie danych
SELECT * FROM supervisor_salaries ORDER BY id LIMIT 2;


-- Listing 5.8: Eksportowanie całej tabeli za pomocą instrukcji COPY

COPY us_counties_pop_est_2019
TO 'C:\TwojKatalog\us_counties_export.txt'
WITH (FORMAT CSV, HEADER, DELIMITER '|');


-- Listing 5.9: Eksportowanie wybranych kolumn tabeli za pomocą instrukcji COPY

COPY us_counties_pop_est_2019 
    (county_name, internal_point_lat, internal_point_lon)
TO 'C:\TwojKatalog\us_counties_latlon_export.txt'
WITH (FORMAT CSV, HEADER, DELIMITER '|');

-- Listing 5.10: Eksportowanie wyników zapytania za pomocą instrukcji COPY

COPY (
    SELECT county_name, state_name
    FROM us_counties_pop_est_2019
    WHERE county_name ILIKE '%mill%'
     )
TO 'C:\TwojKatalog\us_counties_mill_export.csv'
WITH (FORMAT CSV, HEADER);
