---------------------------------------------------------------------------
-- SQL w praktyce. Jak dzięki danym uzyskiwać cenne informacje. Wydanie II
-- Anthony DeBarros

-- Rozdział 3. Przykłady z kodem
----------------------------------------------------------------------------

-- Listing 3.1: Użycie zapytania zwracającego wszystkie wiersze i kolumny tabeli teachers

SELECT * FROM teachers;

-- Zauważ, że ta standardowa, uproszczona instrukcja SQL również działa:

TABLE teachers;

-- Listing 3.2: Tworzenie zapytania dotyczącego podzbioru kolumn

SELECT last_name, first_name, salary FROM teachers;

-- Listing 3.3: Sortowanie kolumny za pomocą klauzuli ORDER BY

SELECT first_name, last_name, salary
FROM teachers
ORDER BY salary DESC;

-- Zauważ, że możesz też określić kolumnę sortowania za
-- pomocą liczby reprezentującej jej pozycję w wyniku.

SELECT first_name, last_name, salary
FROM teachers
ORDER BY 3 DESC;

-- Listing 3.4: Sortowanie wielu kolumn za pomocą klauzuli ORDER BY

SELECT last_name, school, hire_date
FROM teachers
ORDER BY school ASC, hire_date DESC;

-- Listing 3.5: Uzyskiwanie różnych wartości z kolumny school

SELECT DISTINCT school
FROM teachers
ORDER BY school;

-- Listing 3.6: Uzyskiwanie różnych par wartości z kolumn school i salary

SELECT DISTINCT school, salary
FROM teachers
ORDER BY school, salary;

-- Listing 3.7: Filtrowanie wierszy przy użyciu klauzuli WHERE

SELECT last_name, school, hire_date
FROM teachers
WHERE school = 'Myers Middle School';

-- Przykłady operatorów porównania klauzuli WHERE

-- Nauczyciele o imieniu Janet
SELECT first_name, last_name, school
FROM teachers
WHERE first_name = 'Janet';

-- Nazwy szkół z wyłączeniem szkoły F.D. Roosevelt HS
SELECT school
FROM teachers
WHERE school <> 'F.D. Roosevelt HS';

-- Nauczyciele zatrudnieni przed 1 styczniem 2000 r.
SELECT first_name, last_name, hire_date
FROM teachers
WHERE hire_date < '2000-01-01';

-- Nauczycieli, których zarobki wynoszą co najmniej 43500 dolarów
SELECT first_name, last_name, salary
FROM teachers
WHERE salary >= 43500;

-- Nauczyciele, których pensja zawiera się w przedziale od 40000 do 65000 dolarów
SELECT first_name, last_name, school, salary
FROM teachers
WHERE salary BETWEEN 40000 AND 65000;

SELECT first_name, last_name, school, salary
FROM teachers
WHERE salary >= 40000 AND salary <= 65000;

-- Listing 3.8: Filtrowanie z użyciem operatorów LIKE i ILIKE

SELECT first_name
FROM teachers
WHERE first_name LIKE 'sam%';

SELECT first_name
FROM teachers
WHERE first_name ILIKE 'sam%';

-- Listing 3.9: Łączenie operatorów za pomocą operatorów logicznych AND i OR

SELECT *
FROM teachers
WHERE school = 'Myers Middle School'
      AND salary < 40000;

SELECT *
FROM teachers
WHERE last_name = 'Cole'
      OR last_name = 'Bush';

SELECT *
FROM teachers
WHERE school = 'F.D. Roosevelt HS'
      AND (salary < 38000 OR salary > 40000);

-- Zauważ, jak zmieniają się wyniki, jeśli pominięto nawiasy okrągłe. Wynika to z tego,
-- że operator AND ma pierwszeństwo względem operatora OR, dlatego najpierw dla niego
-- jest określana wartość:

SELECT *
FROM teachers
WHERE school = 'F.D. Roosevelt HS'
      AND salary < 38000 OR salary > 40000;

-- Listing 3.10: Instrukcja SELECT obejmująca klauzule WHERE i ORDER BY

SELECT first_name, last_name, school, hire_date, salary
FROM teachers
WHERE school LIKE '%Roos%'
ORDER BY hire_date DESC;
