Listing 16.1
PRINT @@version


Listing 16.2
DECLARE @lan VARCHAR(50)
SELECT @lan = 'foo'
RAISERROR ('Ten komunikat zawiera znacznik: %s', 18, 1, @lan)


Listing 16.3
BEGIN TRAN T1

UPDATE Movies
SET movie_title = NULL
WHERE movie_id > 5

IF @@error <> 0
	BEGIN
		ROLLBACK TRAN
		RAISERROR ('Uaktualnienie tabeli Movies nie powiodo si.', 18, 1)
	END
ELSE
	COMMIT TRAN


Listing 16.4
DELETE FROM Movies
WHERE movie_id > 10

IF @@rowcount = 0 
	RAISERROR ('Nie usunito adnych wierszy', 18, 7)


Listing 16.5
CREATE PROCEDURE update_movie_gross @gross_limit DEC = NULL
AS
UPDATE Movies
SET gross = gross * 1.25
WHERE gross < @gross_limit

IF @@rowcount = 0
	RETURN 1

SELECT movie_title, gross
FROM Movies
WHERE gross < @gross_limit * 1.25


Listing 16.6
CREATE TABLE #Movies
(movie_id	    int,
movie_title   varchar(25),
studio_id     int,
budget        dec,
gross         dec,
release_date  datetime,
director_id   int)


Listing 16.7
CREATE TRIGGER movies_modify_trigger
ON Movies
FOR INSERT, UPDATE, DELETE
AS
IF @@rowcount > 5
ROLLBACK TRIGGER WITH RAISERROR 'Zmodyfikowano zbyt du liczb wierszy.'
PRINT 'Wyzwalacz nie wykry bdu.'


Listing 16.8
UPDATE Movies
SET movie_title = 'Modified title'


Listing 16.9
CREATE TRIGGER movies_delete_trigger
ON Movies
FOR DELETE
AS
IF (SELECT COUNT(*) FROM DELETED) > 5
	ROLLBACK TRIGGER


Listing 16.10
DELETE FROM Movies


Listing 16.11
CREATE TRIGGER movies_date_test_trigger
ON Movies
FOR INSERT
AS
IF EXISTS (SELECT * FROM INSERTED WHERE release_date < GETDATE())
	ROLLBACK TRIGGER 
WITH RAISERROR 'Data dystrybucji musi dotyczy przyszoci.' 




