Listing 8.1
SELECT movie_title, director_id
FROM Movies
ORDER BY director_id


Listing 8.2
SELECT person_id, person_fname, person_lname
FROM People
ORDER BY person_id


Listing 8.3
SELECT movie_title, person_fname, person_lname
FROM Movies, People
WHERE director_id = person_id


Listing 8.4
SELECT person_fname, person_lname, studio_name
FROM People, Studios
WHERE person_state = studio_state
AND person_city = studio_city


Listing 8.5
SELECT Movies.movie_title, 
People.person_fname, People.person_lname
FROM Movies, People
WHERE Movies.director_id = People.person_id


Listing 8.6
SELECT *
FROM Movies, People
WHERE Movies.director_id = People.person_id
AND Movies.movie_title = 'The Code Warrior'


Listing 8.7
SELECT M.movie_title, P.person_fname, P.person_lname
FROM Movies M, People P
WHERE M.director_id = P.person_id


Listing 8.8
SELECT gross
FROM Movies
WHERE movie_title = 'The Code Warrior'


Listing 8.9
SELECT M.studio_id, movie_title,
Studio_name
FROM Movies M, Studios S
WHERE M.studio_id = S.studio_id


Listing 8.10
SELECT M.movie_title, C.person_id,
(M.gross * 1000000), C.payment
FROM Movies M, Cast_Movies C
WHERE M.movie_id = C.movie_id
AND C.payment > (M.gross * 1000000)


Listing 8.11
SELECT person_fname, person_lname, studio_name
FROM People, Studios
WHERE person_state = studio_state
AND person_city <> studio_city


Listing 8.12
SELECT DISTINCT P1.person_id, P1.person_fname, 
P1.person_lname, P1.person_state
FROM People P1, People P2
WHERE P1.person_state = P2.person_state
AND P1.person_id != P2.person_id


Listing 8.13
SELECT M.movie_title, M.studio_id, P.person_fname, 
P.person_lname, S.studio_city
FROM Movies M, People P, Studios S
WHERE M.director_id = P.person_id
AND M.studio_id = S.studio_id


Listing 8.14
SELECT P.person_fname, P.person_lname, 
CM.role
FROM Movies M, People P, Cast_Movies CM
WHERE M.movie_id = CM.movie_id
AND CM.person_id = P.person_id
AND M.movie_title = 'The Code Warrior'


Listing 8.15
SELECT M.movie_title, P.person_fname, P.person_lname
FROM Movies M, People P
WHERE M.director_id = P.person_id
AND M.movie_title = 'The Code Warrior'


Listing 8.16
SELECT person_fname, person_lname, movie_title
FROM People, Movies
WHERE person_id = director_id


Listing 8.17
SELECT person_fname, person_lname, movie_title
FROM People, Movies
WHERE person_id = director_id(+)


Listing 8.18
SELECT person_id, person_city, person_state
FROM People
UNION
SELECT studio_id, studio_city, studio_state
FROM Studios


Listing 8.19
SELECT person_id, person_city
FROM People
UNION
SELECT studio_id, studio_city, studio_state
FROM Studios


Listing 8.20
SELECT person_id, person_city, person_fname
FROM People
UNION
SELECT studio_id, studio_city, studio_state
FROM Studios


Listing 8.21
SELECT person_state
FROM People
UNION
SELECT studio_state
FROM Studios


Listing 8.22
SELECT person_state
FROM People
UNION ALL
SELECT studio_state
FROM Studios


Listing 8.23
SELECT studio_id, studio_state      
FROM Studios
UNION
SELECT person_id, person_state
FROM People


Listing 8.24
SELECT studio_id, studio_state      
FROM Studios
UNION
SELECT person_id, person_state
FROM People
ORDER BY studio_state


Listing 8.25
SELECT person_state
FROM People
INTERSECT
SELECT studio_state
FROM Studios


Listing 8.26
SELECT person_state
FROM People
MINUS
SELECT studio_state
FROM Studios


Listing 8.27
SELECT studio_state
FROM Studios 
MINUS
SELECT person_state
FROM People


Listing 8.28
SELECT movie_title, person_fname, person_lname
FROM Movies, People
WHERE director_id = person_id


Listing 8.29
SELECT movie_title, person_fname, person_lname
FROM Movies INNER JOIN People
ON director_id = person_id


Listing 8.30
SELECT movie_title, person_fname, person_lname
FROM Movies INNER JOIN People
ON director_id = person_id
WHERE movie_id = 1


Listing 8.31
SELECT person_fname, person_lname, movie_title
FROM Movies INNER JOIN 
(Cast_Movies INNER JOIN People
ON Cast_Movies.person_id = People.person_id)
ON Movies.movie_id = Cast_Movies.movie_id


Listing 8.32
SELECT movie_title, city, state
FROM Movies LEFT JOIN Locations
ON Movies.movie_id = Locations.movie_id


Listing 8.33
SELECT movie_title, person_fname, person_lname
FROM Movies RIGHT JOIN People
ON Movies.director_id = People.person_id


Listing 8.34
SELECT movie_title, studio_name, city, state
FROM Studios INNER JOIN 
(Movies LEFT JOIN Locations
ON Movies.movie_id = Locations.movie_id)
ON Studios.studio_id = Movies.movie_id


Listing 8.35
SELECT movie_title, studio_name, studio_city, studio_state
FROM Movies, Studios
WHERE Movies.studio_id = Studios.studio_id


