CREATE DATABASE  IF NOT EXISTS `farmers_market` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;
USE `farmers_market`;
-- MySQL dump 10.13  Distrib 8.0.17, for Win64 (x86_64)
--
-- Host: localhost    Database: farmers_market5
-- ------------------------------------------------------
-- Server version	8.0.17

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `booth`
--

DROP TABLE IF EXISTS `booth`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `booth` (
  `booth_number` int(11) NOT NULL,
  `booth_price_level` varchar(45) NOT NULL,
  `booth_description` varchar(255) NOT NULL,
  `booth_type` varchar(45) NOT NULL,
  PRIMARY KEY (`booth_number`),
  UNIQUE KEY `booth_number_UNIQUE` (`booth_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `booth`
--

LOCK TABLES `booth` WRITE;
/*!40000 ALTER TABLE `booth` DISABLE KEYS */;
INSERT INTO `booth` VALUES (1,'A','First booth to the left as you enter the center door','Standard'),(2,'A','Second booth to the left as you enter the center door','Standard'),(3,'B','Third booth to the left as you enter the center door - Small square table size','Small'),(4,'C','First booth on left end of building - Small square table size','Small'),(5,'C','Second booth on left end of building  - Small square table size','Small'),(6,'C','Third booth on left end of building  - Small square table size','Small'),(7,'A','First booth to the right as you enter the center door','Standard'),(8,'C','First booth on right end of building  - Small square table size','Small'),(9,'C','First booth on right end of building  - Small square table size','Small'),(10,'B','Back right booth  - Large rectangular table size','Large'),(11,'B','Back center booth  - Large rectangular table size','Large'),(12,'B','Back left booth  - Large rectangular table size','Large');
/*!40000 ALTER TABLE `booth` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customer`
--

DROP TABLE IF EXISTS `customer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer` (
  `customer_id` int(11) NOT NULL,
  `customer_first_name` varchar(45) DEFAULT NULL,
  `customer_last_name` varchar(45) DEFAULT NULL,
  `customer_zip` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customer`
--

LOCK TABLES `customer` WRITE;
/*!40000 ALTER TABLE `customer` DISABLE KEYS */;
INSERT INTO `customer` VALUES (1,'Jane','Connor','22801'),(2,'Manuel','Diaz','22821'),(3,'Bob','Wilson','22821'),(4,'Deanna','Washington','22801'),(5,'Abigail','Harris','22801'),(6,'Betty','Bullard','22801'),(7,'Jessica','Armenta','22821'),(8,'Norma','Valenzuela','22821'),(9,'Janet','Forbes','22801'),(10,'Russell','Edwards','22801'),(11,'Richard','Paulson','22801'),(12,'Jack','Wise','22821'),(13,'Jeremy','Gruber','22821'),(14,'William','Lopes','22801'),(15,'Darrell','Messina','22801'),(16,'Ada','Nieves','22801'),(17,'Carlos','Diaz','22802'),(18,'Jeri','Mitchell','22802'),(19,'Iva','Kienzler','22802'),(20,'Valerie','Loftis','22802'),(21,'Duane','Sipp','22801'),(22,'George','Rai','22801'),(23,'Alvin','Laurie','22801'),(24,'Dawn','Nale','22801'),(25,'Bonnie','Hassan','22801'),(26,'Tracie','Goehring','22821');
/*!40000 ALTER TABLE `customer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customer_purchases`
--

DROP TABLE IF EXISTS `customer_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_purchases` (
  `product_id` int(11) NOT NULL,
  `vendor_id` int(11) NOT NULL,
  `market_date` date NOT NULL,
  `customer_id` int(11) NOT NULL,
  `quantity` decimal(16,2) DEFAULT NULL,
  `cost_to_customer_per_qty` decimal(16,2) DEFAULT NULL,
  `transaction_time` time NOT NULL,
  PRIMARY KEY (`product_id`,`vendor_id`,`market_date`,`customer_id`,`transaction_time`),
  KEY `fk_customer_purchases_vendor_inventory1_idx` (`product_id`,`vendor_id`,`market_date`),
  KEY `fk_customer_purchases_customer1_idx` (`customer_id`),
  CONSTRAINT `fk_customer_purchases_customer1` FOREIGN KEY (`customer_id`) REFERENCES `customer` (`customer_id`),
  CONSTRAINT `fk_customer_purchases_vendor_inventory1` FOREIGN KEY (`product_id`, `vendor_id`, `market_date`) REFERENCES `vendor_inventory` (`product_id`, `vendor_id`, `market_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customer_purchases`
--

LOCK TABLES `customer_purchases` WRITE;
/*!40000 ALTER TABLE `customer_purchases` DISABLE KEYS */;
INSERT INTO `customer_purchases` VALUES (1,7,'2019-07-03',14,0.99,6.99,'17:32:00'),(1,7,'2019-07-03',14,2.18,6.99,'18:23:00'),(1,7,'2019-07-03',15,1.53,6.99,'18:41:00'),(1,7,'2019-07-03',16,2.02,6.99,'18:18:00'),(1,7,'2019-07-03',22,0.66,6.99,'17:34:00'),(1,7,'2019-07-06',4,0.27,6.99,'12:20:00'),(1,7,'2019-07-06',12,3.60,6.99,'09:33:00'),(1,7,'2019-07-06',14,3.04,6.99,'13:05:00'),(1,7,'2019-07-06',23,1.49,6.99,'12:26:00'),(1,7,'2019-07-06',23,2.56,6.99,'12:46:00'),(1,7,'2019-07-10',3,2.48,6.99,'18:40:00'),(1,7,'2019-07-10',4,2.13,6.99,'18:06:00'),(1,7,'2019-07-10',8,2.71,6.99,'18:35:00'),(1,7,'2019-07-10',23,3.61,6.99,'18:56:00'),(1,7,'2019-07-13',2,4.24,6.99,'09:02:00'),(1,7,'2019-07-13',5,0.71,6.99,'13:43:00'),(1,7,'2019-07-13',10,2.34,6.99,'10:21:00'),(1,7,'2019-07-13',10,2.28,6.99,'10:29:00'),(1,7,'2019-07-13',24,0.65,6.99,'12:52:00'),(1,7,'2019-07-17',4,3.03,6.99,'18:44:00'),(1,7,'2019-07-17',5,4.11,6.99,'16:30:00'),(1,7,'2019-07-20',1,2.09,6.99,'12:48:00'),(1,7,'2019-07-20',1,4.93,6.99,'13:00:00'),(1,7,'2019-07-20',15,0.02,6.99,'12:04:00'),(1,7,'2019-07-20',21,2.00,6.99,'11:33:00'),(1,7,'2019-07-24',14,0.39,6.99,'17:16:00'),(1,7,'2019-07-24',19,2.74,6.99,'17:30:00'),(1,7,'2019-07-27',13,1.15,6.99,'09:08:00'),(1,7,'2019-07-27',17,1.55,6.99,'13:58:00'),(1,7,'2019-07-27',24,3.04,6.99,'09:37:00'),(1,7,'2019-07-31',3,2.64,6.99,'18:36:00'),(1,7,'2019-07-31',8,3.83,6.99,'18:34:00'),(1,7,'2019-07-31',19,3.69,6.99,'18:11:00'),(1,7,'2019-07-31',22,1.07,6.99,'18:04:00'),(1,7,'2019-08-03',4,0.08,6.99,'12:12:00'),(1,7,'2019-08-03',13,0.05,6.99,'13:37:00'),(1,7,'2019-08-03',13,2.36,6.99,'13:46:00'),(1,7,'2019-08-07',13,0.31,6.99,'18:38:00'),(1,7,'2019-08-07',24,4.65,6.99,'18:30:00'),(1,7,'2019-08-10',2,0.32,6.99,'08:26:00'),(1,7,'2019-08-10',2,1.29,6.99,'09:29:00'),(1,7,'2019-08-10',12,4.09,6.99,'08:39:00'),(1,7,'2019-08-10',23,4.57,6.99,'13:20:00'),(1,7,'2019-08-10',23,0.46,6.99,'13:39:00'),(1,7,'2019-08-14',5,2.35,6.99,'17:32:00'),(1,7,'2019-08-14',8,3.57,6.99,'18:04:00'),(1,7,'2019-08-14',11,1.50,6.99,'17:06:00'),(1,7,'2019-08-14',25,3.21,6.99,'18:46:00'),(1,7,'2019-08-21',11,1.59,6.99,'18:18:00'),(1,7,'2019-08-24',10,1.67,6.99,'08:35:00'),(1,7,'2019-08-24',15,1.19,6.99,'08:47:00'),(1,7,'2019-08-24',16,4.48,6.99,'11:00:00'),(1,7,'2019-08-28',2,1.07,6.99,'18:56:00'),(1,7,'2019-08-28',9,3.68,6.99,'18:28:00'),(1,7,'2019-08-31',5,2.40,6.99,'10:00:00'),(1,7,'2019-08-31',10,0.14,6.99,'09:57:00'),(1,7,'2019-08-31',22,4.86,6.99,'09:12:00'),(1,7,'2019-09-04',4,2.28,6.99,'18:33:00'),(1,7,'2019-09-04',9,2.18,6.99,'16:30:00'),(1,7,'2019-09-04',20,5.67,6.99,'17:57:00'),(1,7,'2019-09-07',8,0.94,6.99,'13:33:00'),(1,7,'2019-09-07',12,2.04,6.99,'08:35:00'),(1,7,'2019-09-07',12,0.99,6.99,'08:49:00'),(1,7,'2019-09-07',14,0.03,6.99,'09:09:00'),(1,7,'2019-09-07',19,3.09,6.99,'11:57:00'),(1,7,'2019-09-11',4,2.25,6.99,'18:37:00'),(1,7,'2019-09-11',7,1.54,6.99,'17:37:00'),(1,7,'2019-09-11',18,2.89,6.99,'17:52:00'),(1,7,'2019-09-11',25,2.16,6.99,'17:21:00'),(1,7,'2019-09-14',2,4.14,6.99,'13:49:00'),(1,7,'2019-09-14',6,2.94,6.99,'13:42:00'),(1,7,'2019-09-18',11,2.34,6.99,'18:41:00'),(1,7,'2019-09-18',17,0.04,6.99,'17:14:00'),(1,7,'2019-09-21',6,1.99,6.99,'12:17:00'),(1,7,'2019-09-21',24,1.82,6.99,'11:11:00'),(1,7,'2019-09-21',24,4.40,6.99,'11:27:00'),(1,7,'2019-09-25',2,0.06,6.99,'16:47:00'),(1,7,'2019-09-25',3,0.08,6.99,'18:52:00'),(1,7,'2019-09-25',21,2.08,6.99,'17:28:00'),(1,7,'2019-09-28',3,2.43,6.99,'09:23:00'),(1,7,'2019-09-28',13,1.14,6.99,'08:54:00'),(1,7,'2020-07-01',2,1.03,6.99,'18:54:00'),(1,7,'2020-07-01',7,0.63,6.99,'17:21:00'),(1,7,'2020-07-01',11,3.64,6.99,'18:16:00'),(1,7,'2020-07-01',11,3.70,6.99,'18:27:00'),(1,7,'2020-07-01',25,0.04,6.99,'17:54:00'),(1,7,'2020-07-01',25,1.25,6.99,'17:56:00'),(1,7,'2020-07-04',5,4.27,6.99,'11:01:00'),(1,7,'2020-07-04',16,0.62,6.99,'12:51:00'),(1,7,'2020-07-04',21,1.82,6.99,'10:21:00'),(1,7,'2020-07-04',26,2.42,6.99,'12:37:00'),(1,7,'2020-07-08',4,4.44,6.99,'18:53:00'),(1,7,'2020-07-08',8,0.84,6.99,'18:39:00'),(1,7,'2020-07-08',10,1.33,6.99,'17:34:00'),(1,7,'2020-07-08',10,4.44,6.99,'17:36:00'),(1,7,'2020-07-08',22,0.80,6.99,'17:53:00'),(1,7,'2020-07-11',1,4.04,6.99,'13:03:00'),(1,7,'2020-07-11',4,1.63,6.99,'10:09:00'),(1,7,'2020-07-11',18,2.88,6.99,'13:44:00'),(1,7,'2020-07-11',24,1.53,6.99,'11:40:00'),(1,7,'2020-07-15',14,3.88,6.99,'18:51:00'),(1,7,'2020-07-15',20,4.50,6.99,'18:15:00'),(1,7,'2020-07-15',21,1.63,6.99,'18:43:00'),(1,7,'2020-07-18',2,2.50,6.99,'13:30:00'),(1,7,'2020-07-18',9,2.16,6.99,'13:54:00'),(1,7,'2020-07-22',1,2.12,6.99,'18:45:00'),(1,7,'2020-07-22',6,2.28,6.99,'18:49:00'),(1,7,'2020-07-22',11,3.06,6.99,'18:29:00'),(1,7,'2020-07-22',19,1.06,6.99,'18:44:00'),(1,7,'2020-07-25',7,5.71,6.99,'10:33:00'),(1,7,'2020-07-25',12,1.59,6.99,'10:20:00'),(1,7,'2020-07-25',12,2.25,6.99,'10:24:00'),(1,7,'2020-07-25',19,0.74,6.99,'12:03:00'),(1,7,'2020-08-01',11,0.50,6.99,'11:43:00'),(1,7,'2020-08-05',7,4.92,6.99,'17:43:00'),(1,7,'2020-08-05',16,1.69,6.99,'18:22:00'),(1,7,'2020-08-05',21,2.27,6.99,'18:52:00'),(1,7,'2020-08-05',23,4.41,6.99,'17:07:00'),(1,7,'2020-08-08',17,0.03,6.99,'12:56:00'),(1,7,'2020-08-08',26,1.51,6.99,'11:02:00'),(1,7,'2020-08-08',26,4.99,6.99,'11:38:00'),(1,7,'2020-08-12',2,4.59,6.99,'18:56:00'),(1,7,'2020-08-12',2,2.39,6.99,'18:59:00'),(1,7,'2020-08-15',7,1.08,6.99,'10:42:00'),(1,7,'2020-08-15',22,3.45,6.99,'09:33:00'),(1,7,'2020-08-22',4,4.56,6.99,'13:28:00'),(1,7,'2020-08-22',4,3.47,6.99,'13:33:00'),(1,7,'2020-08-22',5,2.07,6.99,'13:33:00'),(1,7,'2020-08-22',25,0.76,6.99,'11:02:00'),(1,7,'2020-08-26',1,2.97,6.99,'18:56:00'),(1,7,'2020-08-26',4,3.11,6.99,'18:36:00'),(1,7,'2020-08-26',9,2.21,6.99,'18:15:00'),(1,7,'2020-08-26',14,0.91,6.99,'17:35:00'),(1,7,'2020-08-26',15,2.57,6.99,'16:33:00'),(1,7,'2020-08-26',22,0.57,6.99,'18:16:00'),(1,7,'2020-08-29',2,0.62,6.99,'08:54:00'),(1,7,'2020-08-29',5,3.42,6.99,'09:52:00'),(1,7,'2020-08-29',5,1.26,6.99,'10:26:00'),(1,7,'2020-08-29',6,3.18,6.99,'12:37:00'),(1,7,'2020-08-29',12,0.15,6.99,'13:13:00'),(1,7,'2020-08-29',26,0.75,6.99,'11:29:00'),(1,7,'2020-09-02',4,3.31,6.99,'18:21:00'),(1,7,'2020-09-02',7,2.40,6.99,'16:58:00'),(1,7,'2020-09-02',7,2.73,6.99,'17:08:00'),(1,7,'2020-09-02',14,2.68,6.99,'16:41:00'),(1,7,'2020-09-05',1,5.20,6.99,'11:34:00'),(1,7,'2020-09-05',1,0.27,6.99,'11:41:00'),(1,7,'2020-09-05',8,2.12,6.99,'10:07:00'),(1,7,'2020-09-05',25,1.79,6.99,'10:39:00'),(1,7,'2020-09-09',1,3.43,6.99,'18:35:00'),(1,7,'2020-09-09',1,1.92,6.99,'18:44:00'),(1,7,'2020-09-09',4,4.14,6.99,'17:50:00'),(1,7,'2020-09-09',9,1.14,6.99,'18:26:00'),(1,7,'2020-09-09',20,0.12,6.99,'18:30:00'),(1,7,'2020-09-12',2,4.92,6.99,'10:58:00'),(1,7,'2020-09-12',7,0.64,6.99,'11:14:00'),(1,7,'2020-09-12',14,3.38,6.99,'13:14:00'),(1,7,'2020-09-12',15,1.22,6.99,'13:11:00'),(1,7,'2020-09-16',2,5.18,6.99,'16:28:00'),(1,7,'2020-09-16',3,3.71,6.99,'18:14:00'),(1,7,'2020-09-19',15,3.04,6.99,'11:10:00'),(1,7,'2020-09-19',15,5.06,6.99,'11:57:00'),(1,7,'2020-09-19',17,0.45,6.99,'11:29:00'),(1,7,'2020-09-19',25,1.49,6.99,'13:29:00'),(1,7,'2020-09-23',8,2.89,6.99,'17:23:00'),(1,7,'2020-09-26',3,1.82,6.99,'12:04:00'),(1,7,'2020-09-26',4,2.96,6.99,'10:44:00'),(1,7,'2020-09-26',14,3.91,6.99,'10:32:00'),(1,7,'2020-09-26',21,1.19,6.99,'13:25:00'),(1,7,'2020-09-30',9,3.61,6.99,'18:49:00'),(1,7,'2020-09-30',9,3.82,6.99,'18:53:00'),(1,7,'2020-09-30',14,0.10,6.99,'18:32:00'),(1,7,'2020-09-30',18,2.26,6.99,'18:58:00'),(1,7,'2020-09-30',26,3.97,6.99,'17:04:00'),(2,7,'2019-07-03',4,3.73,3.49,'16:46:00'),(2,7,'2019-07-03',9,4.85,3.49,'16:42:00'),(2,7,'2019-07-03',12,0.12,3.49,'17:38:00'),(2,7,'2019-07-03',16,3.46,3.49,'17:48:00'),(2,7,'2019-07-03',17,1.76,3.49,'17:14:00'),(2,7,'2019-07-03',17,4.74,3.49,'17:38:00'),(2,7,'2019-07-03',24,2.28,3.49,'18:37:00'),(2,7,'2019-07-06',3,2.28,3.49,'12:20:00'),(2,7,'2019-07-06',13,1.94,3.49,'10:55:00'),(2,7,'2019-07-06',14,1.00,3.49,'13:19:00'),(2,7,'2019-07-06',14,1.68,3.49,'13:37:00'),(2,7,'2019-07-06',20,3.10,3.49,'12:51:00'),(2,7,'2019-07-10',11,2.89,3.49,'18:56:00'),(2,7,'2019-07-10',21,3.59,3.49,'17:13:00'),(2,7,'2019-07-13',1,2.81,3.49,'13:35:00'),(2,7,'2019-07-13',2,6.27,3.00,'08:58:00'),(2,7,'2019-07-13',10,6.70,3.00,'09:29:00'),(2,7,'2019-07-13',24,1.64,3.49,'12:42:00'),(2,7,'2019-07-17',1,4.88,3.49,'18:26:00'),(2,7,'2019-07-17',4,1.55,3.49,'17:45:00'),(2,7,'2019-07-17',7,4.13,3.49,'18:51:00'),(2,7,'2019-07-17',9,0.11,3.49,'16:44:00'),(2,7,'2019-07-17',13,3.09,3.49,'17:29:00'),(2,7,'2019-07-17',22,2.56,3.49,'18:31:00'),(2,7,'2019-07-20',3,2.70,3.49,'13:52:00'),(2,7,'2019-07-20',8,3.69,3.49,'13:11:00'),(2,7,'2019-07-20',8,1.18,3.49,'13:18:00'),(2,7,'2019-07-20',9,1.20,3.49,'08:17:00'),(2,7,'2019-07-24',10,5.57,3.49,'18:49:00'),(2,7,'2019-07-24',18,2.46,3.49,'17:29:00'),(2,7,'2019-07-24',19,2.40,3.49,'17:55:00'),(2,7,'2019-07-24',26,6.78,3.49,'16:38:00'),(2,7,'2019-07-27',6,4.57,3.49,'11:53:00'),(2,7,'2019-07-27',13,2.37,3.49,'09:31:00'),(2,7,'2019-07-27',16,3.21,3.49,'09:46:00'),(2,7,'2019-07-27',16,3.57,3.49,'10:08:00'),(2,7,'2019-07-27',23,1.05,3.49,'13:51:00'),(2,7,'2019-07-27',23,3.79,3.49,'13:58:00'),(2,7,'2019-07-31',3,2.34,3.49,'18:49:00'),(2,7,'2019-07-31',7,1.43,3.49,'17:04:00'),(2,7,'2019-07-31',11,1.54,3.49,'18:55:00'),(2,7,'2019-07-31',17,5.53,3.49,'16:28:00'),(2,7,'2019-07-31',18,3.41,3.49,'18:12:00'),(2,7,'2019-08-03',2,4.04,3.49,'11:00:00'),(2,7,'2019-08-03',4,4.90,3.49,'11:54:00'),(2,7,'2019-08-03',5,2.39,3.49,'09:01:00'),(2,7,'2019-08-03',12,2.82,3.49,'13:54:00'),(2,7,'2019-08-03',12,3.30,3.49,'13:58:00'),(2,7,'2019-08-03',13,0.02,3.49,'13:47:00'),(2,7,'2019-08-03',14,2.44,3.49,'09:48:00'),(2,7,'2019-08-07',1,1.87,3.49,'18:41:00'),(2,7,'2019-08-07',3,2.93,3.49,'18:09:00'),(2,7,'2019-08-07',6,6.90,3.49,'17:01:00'),(2,7,'2019-08-07',6,0.98,3.49,'17:14:00'),(2,7,'2019-08-07',10,4.31,3.49,'17:10:00'),(2,7,'2019-08-07',19,3.79,3.49,'18:01:00'),(2,7,'2019-08-07',24,2.47,3.49,'18:07:00'),(2,7,'2019-08-10',5,3.09,3.49,'09:06:00'),(2,7,'2019-08-10',12,1.48,3.49,'08:55:00'),(2,7,'2019-08-10',16,1.85,3.49,'08:57:00'),(2,7,'2019-08-10',18,4.46,3.49,'13:56:00'),(2,7,'2019-08-10',22,5.25,3.49,'09:04:00'),(2,7,'2019-08-10',22,3.62,3.49,'09:20:00'),(2,7,'2019-08-10',23,2.53,3.49,'13:30:00'),(2,7,'2019-08-10',25,3.27,3.49,'12:43:00'),(2,7,'2019-08-14',1,4.37,3.49,'17:03:00'),(2,7,'2019-08-14',3,5.30,3.49,'18:44:00'),(2,7,'2019-08-14',4,0.80,3.49,'18:05:00'),(2,7,'2019-08-14',26,3.90,3.49,'18:24:00'),(2,7,'2019-08-14',26,2.44,3.49,'18:33:00'),(2,7,'2019-08-17',2,6.55,3.49,'11:22:00'),(2,7,'2019-08-17',5,1.65,3.49,'11:39:00'),(2,7,'2019-08-17',14,1.05,3.49,'08:35:00'),(2,7,'2019-08-17',26,3.02,3.49,'13:17:00'),(2,7,'2019-08-21',2,2.93,3.49,'18:13:00'),(2,7,'2019-08-21',6,0.72,3.49,'18:37:00'),(2,7,'2019-08-21',17,0.61,3.49,'18:51:00'),(2,7,'2019-08-21',18,4.56,3.49,'16:20:00'),(2,7,'2019-08-21',26,2.44,3.49,'16:03:00'),(2,7,'2019-08-24',14,2.86,3.49,'09:37:00'),(2,7,'2019-08-24',16,2.65,3.49,'10:58:00'),(2,7,'2019-08-28',2,0.39,3.49,'18:46:00'),(2,7,'2019-08-28',5,2.51,3.49,'17:15:00'),(2,7,'2019-08-28',5,5.24,3.49,'17:38:00'),(2,7,'2019-08-28',8,1.86,3.49,'18:12:00'),(2,7,'2019-08-28',8,7.33,3.49,'18:30:00'),(2,7,'2019-08-28',17,2.99,3.49,'17:06:00'),(2,7,'2019-08-28',22,2.99,3.49,'18:28:00'),(2,7,'2019-08-31',2,3.31,3.49,'12:24:00'),(2,7,'2019-08-31',3,0.92,3.49,'11:36:00'),(2,7,'2019-08-31',4,3.26,3.49,'09:35:00'),(2,7,'2019-08-31',4,4.59,3.49,'10:06:00'),(2,7,'2019-08-31',5,6.18,3.49,'10:22:00'),(2,7,'2019-08-31',6,4.30,3.49,'11:38:00'),(2,7,'2019-08-31',26,4.78,3.49,'09:29:00'),(2,7,'2019-09-04',7,3.00,3.49,'18:53:00'),(2,7,'2019-09-04',11,3.51,3.49,'18:46:00'),(2,7,'2019-09-04',14,4.21,3.49,'17:30:00'),(2,7,'2019-09-04',21,3.45,3.49,'18:48:00'),(2,7,'2019-09-04',26,2.10,3.49,'18:54:00'),(2,7,'2019-09-07',4,1.66,3.49,'12:02:00'),(2,7,'2019-09-07',6,1.48,3.49,'12:38:00'),(2,7,'2019-09-07',6,1.26,3.49,'13:32:00'),(2,7,'2019-09-07',23,3.85,3.49,'11:43:00'),(2,7,'2019-09-11',1,3.45,3.49,'18:15:00'),(2,7,'2019-09-11',6,1.62,3.49,'18:53:00'),(2,7,'2019-09-11',7,6.14,3.49,'17:28:00'),(2,7,'2019-09-11',10,0.99,3.49,'17:24:00'),(2,7,'2019-09-11',12,2.21,3.49,'18:01:00'),(2,7,'2019-09-11',12,1.92,3.49,'18:30:00'),(2,7,'2019-09-11',25,6.42,3.49,'17:09:00'),(2,7,'2019-09-14',5,1.33,3.49,'09:06:00'),(2,7,'2019-09-14',6,2.23,3.49,'13:34:00'),(2,7,'2019-09-14',14,2.08,3.49,'12:58:00'),(2,7,'2019-09-14',16,2.28,3.49,'10:07:00'),(2,7,'2019-09-14',19,2.69,3.49,'10:20:00'),(2,7,'2019-09-18',1,3.62,3.49,'17:06:00'),(2,7,'2019-09-18',12,6.33,3.49,'18:34:00'),(2,7,'2019-09-21',2,2.31,3.49,'12:49:00'),(2,7,'2019-09-21',4,0.45,3.49,'10:18:00'),(2,7,'2019-09-21',6,2.22,3.49,'12:54:00'),(2,7,'2019-09-21',8,2.18,3.49,'13:31:00'),(2,7,'2019-09-21',22,2.81,3.49,'13:46:00'),(2,7,'2019-09-25',3,0.36,3.49,'18:31:00'),(2,7,'2019-09-25',7,2.63,3.49,'18:16:00'),(2,7,'2019-09-25',8,1.01,3.49,'16:08:00'),(2,7,'2019-09-25',8,4.71,3.49,'16:16:00'),(2,7,'2019-09-25',15,2.28,3.49,'17:31:00'),(2,7,'2019-09-28',2,0.80,3.49,'13:48:00'),(2,7,'2019-09-28',6,5.07,3.49,'09:53:00'),(2,7,'2019-09-28',19,3.93,3.49,'13:42:00'),(2,7,'2019-09-28',21,4.16,3.49,'10:09:00'),(2,7,'2020-07-01',1,1.58,3.49,'16:10:00'),(2,7,'2020-07-01',2,3.94,3.49,'18:52:00'),(2,7,'2020-07-01',2,3.37,3.49,'18:55:00'),(2,7,'2020-07-01',10,5.38,3.49,'18:11:00'),(2,7,'2020-07-01',10,2.86,3.49,'18:37:00'),(2,7,'2020-07-01',14,4.11,3.49,'18:18:00'),(2,7,'2020-07-01',22,2.75,3.49,'18:41:00'),(2,7,'2020-07-04',2,5.60,3.00,'12:25:00'),(2,7,'2020-07-04',5,4.61,3.49,'12:08:00'),(2,7,'2020-07-04',6,5.18,3.00,'10:01:00'),(2,7,'2020-07-04',6,3.47,3.49,'10:59:00'),(2,7,'2020-07-04',9,1.89,3.49,'09:28:00'),(2,7,'2020-07-04',9,0.59,3.49,'10:01:00'),(2,7,'2020-07-04',11,3.28,3.49,'12:15:00'),(2,7,'2020-07-04',15,3.31,3.49,'12:46:00'),(2,7,'2020-07-04',15,1.58,3.49,'13:12:00'),(2,7,'2020-07-04',19,1.82,3.49,'13:47:00'),(2,7,'2020-07-08',1,1.98,3.49,'18:56:00'),(2,7,'2020-07-08',4,2.28,3.49,'18:32:00'),(2,7,'2020-07-08',8,5.13,3.49,'18:43:00'),(2,7,'2020-07-08',12,4.40,3.49,'17:07:00'),(2,7,'2020-07-08',20,3.30,3.49,'17:37:00'),(2,7,'2020-07-08',23,2.93,3.49,'17:42:00'),(2,7,'2020-07-11',4,1.53,3.49,'10:08:00'),(2,7,'2020-07-11',13,1.89,3.49,'11:54:00'),(2,7,'2020-07-11',18,5.09,3.49,'13:28:00'),(2,7,'2020-07-11',18,3.13,3.49,'13:54:00'),(2,7,'2020-07-11',24,3.50,3.49,'11:34:00'),(2,7,'2020-07-15',1,2.45,3.49,'18:38:00'),(2,7,'2020-07-15',2,3.05,3.49,'18:16:00'),(2,7,'2020-07-15',2,1.32,3.49,'18:40:00'),(2,7,'2020-07-15',3,2.85,3.49,'18:47:00'),(2,7,'2020-07-15',6,2.56,3.49,'18:56:00'),(2,7,'2020-07-15',12,1.81,3.49,'16:50:00'),(2,7,'2020-07-15',12,2.61,3.49,'17:36:00'),(2,7,'2020-07-15',14,3.13,3.49,'18:31:00'),(2,7,'2020-07-15',19,3.42,3.49,'17:46:00'),(2,7,'2020-07-15',21,5.02,3.49,'18:52:00'),(2,7,'2020-07-18',4,1.39,3.49,'12:14:00'),(2,7,'2020-07-18',6,1.25,3.49,'09:35:00'),(2,7,'2020-07-18',9,3.10,3.49,'13:57:00'),(2,7,'2020-07-18',18,5.59,3.49,'09:04:00'),(2,7,'2020-07-18',19,4.67,3.49,'08:57:00'),(2,7,'2020-07-18',20,2.12,3.49,'12:18:00'),(2,7,'2020-07-18',20,6.64,3.49,'13:00:00'),(2,7,'2020-07-22',7,4.38,3.49,'17:57:00'),(2,7,'2020-07-22',9,2.31,3.49,'18:21:00'),(2,7,'2020-07-22',10,3.38,3.49,'16:24:00'),(2,7,'2020-07-22',11,3.14,3.49,'18:44:00'),(2,7,'2020-07-22',12,4.33,3.49,'16:25:00'),(2,7,'2020-07-22',12,1.95,3.49,'16:26:00'),(2,7,'2020-07-22',18,2.85,3.49,'18:00:00'),(2,7,'2020-07-22',25,5.15,3.49,'18:55:00'),(2,7,'2020-07-25',14,3.87,3.49,'13:37:00'),(2,7,'2020-07-25',14,1.38,3.49,'13:54:00'),(2,7,'2020-07-29',1,3.88,3.49,'18:52:00'),(2,7,'2020-07-29',4,3.35,3.49,'18:27:00'),(2,7,'2020-07-29',5,3.00,3.49,'18:43:00'),(2,7,'2020-07-29',6,2.38,3.49,'18:41:00'),(2,7,'2020-07-29',10,4.20,3.49,'18:52:00'),(2,7,'2020-07-29',15,2.59,3.49,'16:39:00'),(2,7,'2020-07-29',26,3.08,3.49,'18:38:00'),(2,7,'2020-07-29',26,3.64,3.49,'18:46:00'),(2,7,'2020-08-01',1,1.79,3.49,'10:18:00'),(2,7,'2020-08-01',3,4.87,3.49,'12:38:00'),(2,7,'2020-08-01',5,3.26,3.49,'09:18:00'),(2,7,'2020-08-01',11,2.27,3.49,'12:01:00'),(2,7,'2020-08-01',15,6.04,3.49,'09:52:00'),(2,7,'2020-08-05',8,2.84,3.49,'16:43:00'),(2,7,'2020-08-05',12,1.47,3.49,'18:11:00'),(2,7,'2020-08-05',12,0.22,3.49,'18:26:00'),(2,7,'2020-08-05',26,1.42,3.49,'18:50:00'),(2,7,'2020-08-05',26,2.74,3.49,'18:51:00'),(2,7,'2020-08-08',5,4.53,3.49,'11:31:00'),(2,7,'2020-08-08',5,5.20,3.49,'12:06:00'),(2,7,'2020-08-08',7,3.53,3.49,'08:23:00'),(2,7,'2020-08-08',9,0.18,3.49,'10:32:00'),(2,7,'2020-08-08',12,4.91,3.49,'09:45:00'),(2,7,'2020-08-08',12,3.18,3.49,'10:26:00'),(2,7,'2020-08-12',4,3.06,3.49,'18:59:00'),(2,7,'2020-08-12',7,3.05,3.49,'17:25:00'),(2,7,'2020-08-12',13,1.25,3.49,'16:16:00'),(2,7,'2020-08-12',13,3.96,3.49,'16:39:00'),(2,7,'2020-08-12',16,3.53,3.49,'17:53:00'),(2,7,'2020-08-12',23,1.78,3.49,'18:53:00'),(2,7,'2020-08-15',7,2.77,3.49,'09:40:00'),(2,7,'2020-08-15',8,3.85,3.49,'09:36:00'),(2,7,'2020-08-15',10,1.91,3.49,'12:13:00'),(2,7,'2020-08-15',18,4.74,3.49,'13:37:00'),(2,7,'2020-08-15',19,2.43,3.49,'12:36:00'),(2,7,'2020-08-15',19,3.01,3.49,'13:04:00'),(2,7,'2020-08-19',11,6.34,3.49,'16:47:00'),(2,7,'2020-08-19',12,2.47,3.49,'18:16:00'),(2,7,'2020-08-19',13,2.37,3.49,'18:50:00'),(2,7,'2020-08-19',15,2.83,3.49,'16:49:00'),(2,7,'2020-08-19',24,3.16,3.49,'18:43:00'),(2,7,'2020-08-22',2,2.88,3.49,'10:03:00'),(2,7,'2020-08-22',5,3.75,3.49,'13:46:00'),(2,7,'2020-08-22',5,4.99,3.49,'13:58:00'),(2,7,'2020-08-22',6,3.48,3.49,'09:39:00'),(2,7,'2020-08-22',17,8.05,3.49,'13:27:00'),(2,7,'2020-08-26',1,1.03,3.49,'18:49:00'),(2,7,'2020-08-26',5,3.68,3.49,'18:20:00'),(2,7,'2020-08-26',9,2.13,3.49,'18:21:00'),(2,7,'2020-08-26',13,3.30,3.49,'16:55:00'),(2,7,'2020-08-26',15,0.31,3.49,'17:27:00'),(2,7,'2020-08-26',19,5.26,3.49,'18:05:00'),(2,7,'2020-08-29',4,1.82,3.49,'13:32:00'),(2,7,'2020-08-29',6,1.04,3.49,'13:18:00'),(2,7,'2020-08-29',10,2.14,3.49,'13:29:00'),(2,7,'2020-08-29',21,2.16,3.49,'08:54:00'),(2,7,'2020-08-29',21,3.54,3.49,'08:55:00'),(2,7,'2020-09-02',4,4.75,3.49,'18:15:00'),(2,7,'2020-09-02',7,4.83,3.49,'16:51:00'),(2,7,'2020-09-02',23,1.28,3.49,'18:15:00'),(2,7,'2020-09-02',23,1.86,3.49,'18:54:00'),(2,7,'2020-09-02',26,4.31,3.49,'17:30:00'),(2,7,'2020-09-02',26,2.57,3.49,'18:17:00'),(2,7,'2020-09-05',4,3.41,3.49,'13:49:00'),(2,7,'2020-09-05',5,2.23,3.49,'13:57:00'),(2,7,'2020-09-05',6,0.82,3.49,'11:42:00'),(2,7,'2020-09-05',8,1.85,3.49,'09:26:00'),(2,7,'2020-09-05',12,6.31,3.49,'09:39:00'),(2,7,'2020-09-05',25,4.86,3.49,'11:32:00'),(2,7,'2020-09-05',26,4.24,3.49,'13:54:00'),(2,7,'2020-09-09',5,2.15,3.49,'17:29:00'),(2,7,'2020-09-09',6,4.57,3.49,'18:45:00'),(2,7,'2020-09-09',12,3.62,3.49,'16:45:00'),(2,7,'2020-09-09',15,1.78,3.49,'18:49:00'),(2,7,'2020-09-09',15,4.21,3.49,'18:52:00'),(2,7,'2020-09-09',20,0.31,3.49,'18:32:00'),(2,7,'2020-09-09',22,2.77,3.49,'18:45:00'),(2,7,'2020-09-12',4,4.22,3.49,'12:47:00'),(2,7,'2020-09-12',15,5.01,3.00,'12:47:00'),(2,7,'2020-09-12',15,0.72,3.49,'13:16:00'),(2,7,'2020-09-12',20,4.25,3.49,'11:16:00'),(2,7,'2020-09-16',2,4.43,3.49,'16:39:00'),(2,7,'2020-09-16',3,2.98,3.49,'18:29:00'),(2,7,'2020-09-16',10,3.22,3.49,'18:26:00'),(2,7,'2020-09-16',11,3.67,3.49,'18:40:00'),(2,7,'2020-09-16',14,3.26,3.49,'16:48:00'),(2,7,'2020-09-16',19,2.42,3.49,'18:53:00'),(2,7,'2020-09-19',3,2.06,3.49,'13:50:00'),(2,7,'2020-09-19',5,4.45,3.49,'11:31:00'),(2,7,'2020-09-19',5,3.36,3.49,'11:54:00'),(2,7,'2020-09-19',6,3.07,3.49,'12:30:00'),(2,7,'2020-09-19',10,5.16,3.49,'09:57:00'),(2,7,'2020-09-19',11,1.13,3.49,'13:06:00'),(2,7,'2020-09-19',11,2.10,3.49,'13:13:00'),(2,7,'2020-09-19',15,3.88,3.49,'11:24:00'),(2,7,'2020-09-19',26,3.37,3.49,'12:13:00'),(2,7,'2020-09-23',5,2.33,3.49,'17:21:00'),(2,7,'2020-09-23',6,2.01,3.49,'16:41:00'),(2,7,'2020-09-23',6,2.80,3.49,'17:35:00'),(2,7,'2020-09-26',4,2.73,3.49,'10:42:00'),(2,7,'2020-09-26',5,2.13,3.49,'10:21:00'),(2,7,'2020-09-26',5,2.64,3.49,'11:02:00'),(2,7,'2020-09-26',7,4.03,3.49,'11:26:00'),(2,7,'2020-09-26',14,6.56,3.49,'10:19:00'),(2,7,'2020-09-30',1,2.45,3.49,'18:36:00'),(2,7,'2020-09-30',2,5.04,3.49,'18:06:00'),(2,7,'2020-09-30',6,2.26,3.49,'18:04:00'),(2,7,'2020-09-30',9,2.93,3.49,'18:33:00'),(2,7,'2020-09-30',10,1.29,3.49,'18:07:00'),(2,7,'2020-09-30',19,3.36,3.49,'18:53:00'),(3,7,'2019-07-03',1,3.00,0.50,'17:36:00'),(3,7,'2019-07-03',3,5.00,0.50,'18:10:00'),(3,7,'2019-07-03',3,4.00,0.50,'18:32:00'),(3,7,'2019-07-03',11,4.00,0.50,'18:52:00'),(3,7,'2019-07-03',16,1.00,0.50,'18:22:00'),(3,7,'2019-07-03',22,5.00,0.50,'18:11:00'),(3,7,'2019-07-03',24,6.00,0.50,'18:55:00'),(3,7,'2019-07-03',25,2.00,0.50,'18:18:00'),(3,7,'2019-07-06',1,3.00,0.50,'13:03:00'),(3,7,'2019-07-06',5,1.00,0.50,'11:50:00'),(3,7,'2019-07-06',6,5.00,0.50,'11:51:00'),(3,7,'2019-07-06',6,4.00,0.50,'12:19:00'),(3,7,'2019-07-06',10,1.00,0.50,'09:52:00'),(3,7,'2019-07-06',15,2.00,0.50,'09:14:00'),(3,7,'2019-07-06',19,4.00,0.50,'09:54:00'),(3,7,'2019-07-10',3,4.00,0.50,'16:44:00'),(3,7,'2019-07-10',9,3.00,0.50,'17:27:00'),(3,7,'2019-07-10',11,1.00,0.50,'18:35:00'),(3,7,'2019-07-10',12,1.00,0.50,'17:45:00'),(3,7,'2019-07-10',23,1.00,0.50,'18:50:00'),(3,7,'2019-07-13',1,2.00,0.50,'11:50:00'),(3,7,'2019-07-13',6,2.00,0.50,'11:03:00'),(3,7,'2019-07-13',7,5.00,0.50,'10:20:00'),(3,7,'2019-07-13',10,1.00,0.50,'11:21:00'),(3,7,'2019-07-13',10,4.00,0.50,'11:59:00'),(3,7,'2019-07-17',2,3.00,0.50,'18:45:00'),(3,7,'2019-07-17',2,1.00,0.50,'18:56:00'),(3,7,'2019-07-17',5,4.00,0.50,'18:45:00'),(3,7,'2019-07-17',8,5.00,0.50,'16:08:00'),(3,7,'2019-07-17',14,5.00,0.50,'17:47:00'),(3,7,'2019-07-17',17,4.00,0.50,'18:36:00'),(3,7,'2019-07-17',17,5.00,0.50,'18:53:00'),(3,7,'2019-07-17',18,3.00,0.50,'17:44:00'),(3,7,'2019-07-20',1,5.00,0.50,'13:28:00'),(3,7,'2019-07-20',2,1.00,0.50,'12:16:00'),(3,7,'2019-07-20',4,1.00,0.50,'09:29:00'),(3,7,'2019-07-20',26,3.00,0.50,'13:24:00'),(3,7,'2019-07-24',3,2.00,0.50,'18:59:00'),(3,7,'2019-07-24',4,5.00,0.50,'18:36:00'),(3,7,'2019-07-24',5,4.00,0.50,'18:38:00'),(3,7,'2019-07-24',5,3.00,0.50,'18:53:00'),(3,7,'2019-07-24',6,5.00,0.50,'16:50:00'),(3,7,'2019-07-24',6,5.00,0.50,'17:16:00'),(3,7,'2019-07-24',13,4.00,0.50,'18:57:00'),(3,7,'2019-07-24',26,2.00,0.50,'16:29:00'),(3,7,'2019-07-27',1,5.00,0.50,'13:48:00'),(3,7,'2019-07-27',3,4.00,0.50,'11:41:00'),(3,7,'2019-07-27',4,2.00,0.50,'12:46:00'),(3,7,'2019-07-27',8,1.00,0.50,'13:47:00'),(3,7,'2019-07-27',8,2.00,0.50,'13:53:00'),(3,7,'2019-07-27',10,5.00,0.50,'10:34:00'),(3,7,'2019-07-27',20,3.00,0.50,'13:32:00'),(3,7,'2019-07-27',20,4.00,0.50,'13:59:00'),(3,7,'2019-07-31',1,5.00,0.50,'16:33:00'),(3,7,'2019-07-31',7,3.00,0.50,'18:51:00'),(3,7,'2019-07-31',19,4.00,0.50,'18:11:00'),(3,7,'2019-08-03',2,3.00,0.50,'08:27:00'),(3,7,'2019-08-03',2,3.00,0.50,'09:25:00'),(3,7,'2019-08-03',3,1.00,0.50,'09:28:00'),(3,7,'2019-08-03',8,4.00,0.50,'11:22:00'),(3,7,'2019-08-03',11,5.00,0.50,'12:33:00'),(3,7,'2019-08-03',15,1.00,0.50,'11:35:00'),(3,7,'2019-08-03',22,6.00,0.50,'12:07:00'),(3,7,'2019-08-03',22,3.00,0.50,'12:22:00'),(3,7,'2019-08-07',4,3.00,0.50,'16:48:00'),(3,7,'2019-08-07',5,4.00,0.50,'18:15:00'),(3,7,'2019-08-07',5,1.00,0.50,'18:53:00'),(3,7,'2019-08-07',10,4.00,0.50,'18:48:00'),(3,7,'2019-08-07',17,1.00,0.50,'16:34:00'),(3,7,'2019-08-07',23,2.00,0.50,'18:36:00'),(3,7,'2019-08-07',23,4.00,0.50,'18:51:00'),(3,7,'2019-08-10',5,1.00,0.50,'10:34:00'),(3,7,'2019-08-10',14,5.00,0.50,'09:35:00'),(3,7,'2019-08-14',2,5.00,0.50,'18:49:00'),(3,7,'2019-08-14',4,1.00,0.50,'17:31:00'),(3,7,'2019-08-14',16,2.00,0.50,'18:37:00'),(3,7,'2019-08-17',1,3.00,0.50,'13:55:00'),(3,7,'2019-08-17',5,4.00,0.50,'13:44:00'),(3,7,'2019-08-17',10,2.00,0.50,'09:26:00'),(3,7,'2019-08-17',14,2.00,0.50,'09:28:00'),(3,7,'2019-08-17',14,4.00,0.50,'09:31:00'),(3,7,'2019-08-17',17,3.00,0.50,'13:17:00'),(3,7,'2019-08-17',17,1.00,0.50,'13:30:00'),(3,7,'2019-08-17',26,5.00,0.50,'13:44:00'),(3,7,'2019-08-21',4,3.00,0.50,'17:34:00'),(3,7,'2019-08-21',4,4.00,0.50,'18:09:00'),(3,7,'2019-08-21',5,5.00,0.50,'17:22:00'),(3,7,'2019-08-21',10,3.00,0.50,'17:18:00'),(3,7,'2019-08-21',10,4.00,0.50,'17:19:00'),(3,7,'2019-08-21',12,4.00,0.50,'18:52:00'),(3,7,'2019-08-21',17,3.00,0.50,'18:59:00'),(3,7,'2019-08-21',24,3.00,0.50,'18:56:00'),(3,7,'2019-08-24',2,5.00,0.50,'09:12:00'),(3,7,'2019-08-24',2,3.00,0.50,'09:46:00'),(3,7,'2019-08-24',3,2.00,0.50,'10:32:00'),(3,7,'2019-08-24',3,4.00,0.50,'11:36:00'),(3,7,'2019-08-24',6,4.00,0.50,'08:56:00'),(3,7,'2019-08-24',8,5.00,0.50,'11:47:00'),(3,7,'2019-08-24',13,4.00,0.50,'13:02:00'),(3,7,'2019-08-24',17,4.00,0.50,'08:47:00'),(3,7,'2019-08-24',23,4.00,0.50,'13:28:00'),(3,7,'2019-08-28',2,4.00,0.50,'16:28:00'),(3,7,'2019-08-28',8,1.00,0.50,'17:40:00'),(3,7,'2019-08-31',1,5.00,0.50,'11:38:00'),(3,7,'2019-08-31',2,2.00,0.50,'11:02:00'),(3,7,'2019-08-31',3,4.00,0.50,'08:47:00'),(3,7,'2019-08-31',6,2.00,0.50,'13:37:00'),(3,7,'2019-08-31',8,4.00,0.50,'12:51:00'),(3,7,'2019-08-31',24,3.00,0.50,'10:19:00'),(3,7,'2019-09-04',2,2.00,0.50,'18:39:00'),(3,7,'2019-09-04',7,4.00,0.50,'17:09:00'),(3,7,'2019-09-04',12,4.00,0.50,'17:09:00'),(3,7,'2019-09-04',20,3.00,0.50,'17:20:00'),(3,7,'2019-09-07',1,4.00,0.50,'12:08:00'),(3,7,'2019-09-07',1,2.00,0.50,'12:22:00'),(3,7,'2019-09-07',4,1.00,0.50,'13:53:00'),(3,7,'2019-09-07',5,1.00,0.50,'12:46:00'),(3,7,'2019-09-07',6,2.00,0.50,'11:31:00'),(3,7,'2019-09-07',6,3.00,0.50,'11:53:00'),(3,7,'2019-09-07',10,2.00,0.50,'13:21:00'),(3,7,'2019-09-07',14,4.00,0.50,'13:25:00'),(3,7,'2019-09-07',14,5.00,0.50,'13:28:00'),(3,7,'2019-09-07',24,2.00,0.50,'09:23:00'),(3,7,'2019-09-11',1,4.00,0.50,'16:28:00'),(3,7,'2019-09-11',2,5.00,0.50,'17:21:00'),(3,7,'2019-09-11',5,4.00,0.50,'18:54:00'),(3,7,'2019-09-11',6,3.00,0.50,'17:06:00'),(3,7,'2019-09-11',22,5.00,0.50,'18:41:00'),(3,7,'2019-09-14',12,4.00,0.50,'11:10:00'),(3,7,'2019-09-14',14,4.00,0.50,'09:09:00'),(3,7,'2019-09-14',17,2.00,0.50,'12:32:00'),(3,7,'2019-09-14',25,5.00,0.50,'12:47:00'),(3,7,'2019-09-14',25,3.00,0.50,'13:22:00'),(3,7,'2019-09-18',8,1.00,0.50,'17:14:00'),(3,7,'2019-09-18',9,5.00,0.50,'17:16:00'),(3,7,'2019-09-18',17,3.00,0.50,'18:48:00'),(3,7,'2019-09-18',18,2.00,0.50,'18:52:00'),(3,7,'2019-09-18',18,2.00,0.50,'18:54:00'),(3,7,'2019-09-21',2,3.00,0.50,'09:24:00'),(3,7,'2019-09-21',5,4.00,0.50,'12:54:00'),(3,7,'2019-09-21',6,5.00,0.50,'13:42:00'),(3,7,'2019-09-21',13,5.00,0.50,'10:56:00'),(3,7,'2019-09-21',13,1.00,0.50,'11:05:00'),(3,7,'2019-09-25',1,1.00,0.50,'18:59:00'),(3,7,'2019-09-25',3,2.00,0.50,'17:39:00'),(3,7,'2019-09-25',7,3.00,0.50,'16:36:00'),(3,7,'2019-09-25',10,2.00,0.50,'17:30:00'),(3,7,'2019-09-25',12,5.00,0.50,'18:19:00'),(3,7,'2019-09-25',12,4.00,0.50,'18:35:00'),(3,7,'2019-09-25',15,1.00,0.50,'16:26:00'),(3,7,'2019-09-28',3,2.00,0.50,'13:31:00'),(3,7,'2019-09-28',7,3.00,0.50,'13:17:00'),(3,7,'2019-09-28',8,3.00,0.50,'13:54:00'),(3,7,'2019-09-28',9,5.00,0.50,'11:17:00'),(3,7,'2019-09-28',12,3.00,0.50,'12:56:00'),(3,7,'2019-09-28',18,5.00,0.50,'10:47:00'),(3,7,'2019-09-28',19,8.00,0.50,'13:32:00'),(3,7,'2019-09-28',21,3.00,0.50,'09:05:00'),(3,7,'2020-07-01',1,5.00,0.50,'18:23:00'),(3,7,'2020-07-01',3,3.00,0.50,'16:34:00'),(3,7,'2020-07-01',3,3.00,0.50,'16:38:00'),(3,7,'2020-07-01',4,4.00,0.50,'16:18:00'),(3,7,'2020-07-01',4,4.00,0.50,'17:19:00'),(3,7,'2020-07-01',5,2.00,0.50,'17:03:00'),(3,7,'2020-07-01',8,1.00,0.50,'17:46:00'),(3,7,'2020-07-01',13,1.00,0.50,'18:48:00'),(3,7,'2020-07-01',15,2.00,0.50,'18:34:00'),(3,7,'2020-07-01',15,3.00,0.50,'18:52:00'),(3,7,'2020-07-04',6,4.00,0.50,'12:06:00'),(3,7,'2020-07-04',7,5.00,0.50,'08:49:00'),(3,7,'2020-07-04',8,2.00,0.50,'12:15:00'),(3,7,'2020-07-04',9,4.00,0.50,'11:20:00'),(3,7,'2020-07-04',10,3.00,0.50,'13:12:00'),(3,7,'2020-07-04',19,4.00,0.50,'13:38:00'),(3,7,'2020-07-04',26,3.00,0.50,'12:09:00'),(3,7,'2020-07-04',26,4.00,0.50,'12:47:00'),(3,7,'2020-07-08',3,4.00,0.50,'18:52:00'),(3,7,'2020-07-08',4,4.00,0.50,'17:11:00'),(3,7,'2020-07-08',5,3.00,0.50,'18:54:00'),(3,7,'2020-07-08',5,1.00,0.50,'18:55:00'),(3,7,'2020-07-08',10,2.00,0.50,'18:42:00'),(3,7,'2020-07-11',1,5.00,0.50,'08:41:00'),(3,7,'2020-07-11',2,3.00,0.50,'13:49:00'),(3,7,'2020-07-11',2,2.00,0.50,'13:59:00'),(3,7,'2020-07-11',5,3.00,0.50,'10:21:00'),(3,7,'2020-07-11',10,2.00,0.50,'11:35:00'),(3,7,'2020-07-11',14,3.00,0.50,'13:52:00'),(3,7,'2020-07-11',14,3.00,0.50,'13:56:00'),(3,7,'2020-07-11',19,4.00,0.50,'13:45:00'),(3,7,'2020-07-11',19,2.00,0.50,'13:53:00'),(3,7,'2020-07-11',26,2.00,0.50,'12:44:00'),(3,7,'2020-07-11',26,2.00,0.50,'13:28:00'),(3,7,'2020-07-15',4,2.00,0.50,'16:09:00'),(3,7,'2020-07-15',4,5.00,0.50,'16:47:00'),(3,7,'2020-07-15',8,2.00,0.50,'18:10:00'),(3,7,'2020-07-15',15,5.00,0.50,'16:54:00'),(3,7,'2020-07-15',15,4.00,0.50,'17:24:00'),(3,7,'2020-07-15',19,3.00,0.50,'17:06:00'),(3,7,'2020-07-15',19,2.00,0.50,'17:41:00'),(3,7,'2020-07-15',20,3.00,0.50,'18:02:00'),(3,7,'2020-07-18',1,1.00,0.50,'10:52:00'),(3,7,'2020-07-18',1,3.00,0.50,'11:26:00'),(3,7,'2020-07-18',3,2.00,0.50,'13:30:00'),(3,7,'2020-07-18',5,4.00,0.50,'11:05:00'),(3,7,'2020-07-18',5,5.00,0.50,'11:15:00'),(3,7,'2020-07-18',6,4.00,0.50,'10:01:00'),(3,7,'2020-07-18',8,2.00,0.50,'11:59:00'),(3,7,'2020-07-18',20,3.00,0.50,'12:09:00'),(3,7,'2020-07-18',20,5.00,0.50,'12:37:00'),(3,7,'2020-07-22',2,2.00,0.50,'18:29:00'),(3,7,'2020-07-22',3,3.00,0.50,'17:16:00'),(3,7,'2020-07-22',10,2.00,0.50,'17:47:00'),(3,7,'2020-07-22',15,3.00,0.50,'17:33:00'),(3,7,'2020-07-22',18,4.00,0.50,'17:34:00'),(3,7,'2020-07-25',3,2.00,0.50,'13:34:00'),(3,7,'2020-07-25',7,1.00,0.50,'09:21:00'),(3,7,'2020-07-25',10,3.00,0.50,'11:32:00'),(3,7,'2020-07-25',14,5.00,0.50,'11:07:00'),(3,7,'2020-07-25',17,5.00,0.50,'11:16:00'),(3,7,'2020-07-25',17,1.00,0.50,'11:57:00'),(3,7,'2020-07-25',21,4.00,0.50,'10:23:00'),(3,7,'2020-07-29',2,3.00,0.50,'18:56:00'),(3,7,'2020-07-29',3,4.00,0.50,'18:30:00'),(3,7,'2020-07-29',5,2.00,0.50,'18:17:00'),(3,7,'2020-07-29',6,2.00,0.50,'17:05:00'),(3,7,'2020-07-29',7,4.00,0.50,'18:19:00'),(3,7,'2020-07-29',7,4.00,0.50,'18:32:00'),(3,7,'2020-07-29',11,1.00,0.50,'17:23:00'),(3,7,'2020-07-29',13,3.00,0.50,'17:37:00'),(3,7,'2020-07-29',19,5.00,0.50,'17:34:00'),(3,7,'2020-08-01',2,2.00,0.50,'09:17:00'),(3,7,'2020-08-01',5,1.00,0.50,'09:42:00'),(3,7,'2020-08-01',7,4.00,0.50,'08:19:00'),(3,7,'2020-08-01',22,4.00,0.50,'09:26:00'),(3,7,'2020-08-05',1,4.00,0.50,'18:34:00'),(3,7,'2020-08-05',1,5.00,0.50,'18:46:00'),(3,7,'2020-08-05',3,3.00,0.50,'17:29:00'),(3,7,'2020-08-05',3,3.00,0.50,'18:07:00'),(3,7,'2020-08-05',4,1.00,0.50,'16:46:00'),(3,7,'2020-08-05',4,2.00,0.50,'17:01:00'),(3,7,'2020-08-05',6,1.00,0.50,'18:03:00'),(3,7,'2020-08-05',7,5.00,0.50,'18:53:00'),(3,7,'2020-08-05',12,2.00,0.50,'18:19:00'),(3,7,'2020-08-05',12,3.00,0.50,'18:23:00'),(3,7,'2020-08-05',15,2.00,0.50,'16:22:00'),(3,7,'2020-08-05',15,3.00,0.50,'17:05:00'),(3,7,'2020-08-05',17,1.00,0.50,'18:38:00'),(3,7,'2020-08-05',21,4.00,0.50,'18:54:00'),(3,7,'2020-08-08',4,3.00,0.50,'10:38:00'),(3,7,'2020-08-08',4,4.00,0.50,'10:58:00'),(3,7,'2020-08-08',5,3.00,0.50,'13:37:00'),(3,7,'2020-08-08',5,3.00,0.50,'13:54:00'),(3,7,'2020-08-08',11,2.00,0.50,'13:20:00'),(3,7,'2020-08-08',11,5.00,0.50,'13:34:00'),(3,7,'2020-08-08',12,2.00,0.50,'09:54:00'),(3,7,'2020-08-08',13,2.00,0.50,'09:38:00'),(3,7,'2020-08-08',13,2.00,0.50,'09:47:00'),(3,7,'2020-08-08',15,3.00,0.50,'13:54:00'),(3,7,'2020-08-08',22,2.00,0.50,'10:04:00'),(3,7,'2020-08-12',1,4.00,0.50,'18:51:00'),(3,7,'2020-08-12',6,1.00,0.50,'18:42:00'),(3,7,'2020-08-12',13,2.00,0.50,'18:53:00'),(3,7,'2020-08-12',14,1.00,0.50,'16:45:00'),(3,7,'2020-08-12',14,3.00,0.50,'16:48:00'),(3,7,'2020-08-12',18,3.00,0.50,'17:19:00'),(3,7,'2020-08-15',4,4.00,0.50,'13:37:00'),(3,7,'2020-08-15',16,3.00,0.50,'12:00:00'),(3,7,'2020-08-15',16,5.00,0.50,'12:59:00'),(3,7,'2020-08-19',1,2.00,0.50,'17:56:00'),(3,7,'2020-08-19',11,5.00,0.50,'17:07:00'),(3,7,'2020-08-19',24,4.00,0.50,'18:30:00'),(3,7,'2020-08-22',2,5.00,0.50,'12:27:00'),(3,7,'2020-08-22',6,4.00,0.50,'12:50:00'),(3,7,'2020-08-22',7,1.00,0.50,'13:36:00'),(3,7,'2020-08-22',7,2.00,0.50,'13:57:00'),(3,7,'2020-08-22',8,4.00,0.50,'08:57:00'),(3,7,'2020-08-22',8,4.00,0.50,'09:27:00'),(3,7,'2020-08-22',10,5.00,0.50,'13:40:00'),(3,7,'2020-08-22',12,2.00,0.50,'09:41:00'),(3,7,'2020-08-26',1,2.00,0.50,'17:32:00'),(3,7,'2020-08-26',5,4.00,0.50,'18:58:00'),(3,7,'2020-08-26',8,2.00,0.50,'17:44:00'),(3,7,'2020-08-26',17,2.00,0.50,'17:58:00'),(3,7,'2020-08-26',22,5.00,0.50,'18:34:00'),(3,7,'2020-08-29',4,5.00,0.50,'11:06:00'),(3,7,'2020-08-29',8,2.00,0.50,'13:19:00'),(3,7,'2020-08-29',8,3.00,0.50,'13:58:00'),(3,7,'2020-08-29',9,5.00,0.50,'12:33:00'),(3,7,'2020-08-29',11,4.00,0.50,'11:44:00'),(3,7,'2020-08-29',13,1.00,0.50,'13:10:00'),(3,7,'2020-08-29',13,3.00,0.50,'13:11:00'),(3,7,'2020-08-29',14,4.00,0.50,'12:02:00'),(3,7,'2020-08-29',14,2.00,0.50,'12:58:00'),(3,7,'2020-09-02',1,3.00,0.50,'18:53:00'),(3,7,'2020-09-02',5,2.00,0.50,'17:16:00'),(3,7,'2020-09-02',7,1.00,0.50,'17:54:00'),(3,7,'2020-09-02',9,4.00,0.50,'18:43:00'),(3,7,'2020-09-02',23,7.00,0.50,'18:14:00'),(3,7,'2020-09-02',26,6.00,0.50,'18:04:00'),(3,7,'2020-09-05',4,5.00,0.50,'11:34:00'),(3,7,'2020-09-05',9,4.00,0.50,'10:01:00'),(3,7,'2020-09-05',10,5.00,0.50,'11:40:00'),(3,7,'2020-09-05',10,3.00,0.50,'12:10:00'),(3,7,'2020-09-09',2,2.00,0.50,'18:59:00'),(3,7,'2020-09-09',3,3.00,0.50,'18:48:00'),(3,7,'2020-09-09',7,4.00,0.50,'16:53:00'),(3,7,'2020-09-09',12,3.00,0.50,'18:47:00'),(3,7,'2020-09-09',20,4.00,0.50,'18:42:00'),(3,7,'2020-09-09',21,7.00,0.50,'16:43:00'),(3,7,'2020-09-12',3,2.00,0.50,'11:24:00'),(3,7,'2020-09-12',6,1.00,0.50,'13:33:00'),(3,7,'2020-09-12',13,2.00,0.50,'10:51:00'),(3,7,'2020-09-12',14,5.00,0.50,'08:34:00'),(3,7,'2020-09-12',14,2.00,0.50,'08:41:00'),(3,7,'2020-09-12',17,5.00,0.50,'11:04:00'),(3,7,'2020-09-16',1,3.00,0.50,'18:31:00'),(3,7,'2020-09-16',6,2.00,0.50,'18:03:00'),(3,7,'2020-09-16',7,3.00,0.50,'17:28:00'),(3,7,'2020-09-16',11,4.00,0.50,'18:52:00'),(3,7,'2020-09-16',22,2.00,0.50,'18:34:00'),(3,7,'2020-09-19',1,2.00,0.50,'09:45:00'),(3,7,'2020-09-19',6,3.00,0.50,'12:39:00'),(3,7,'2020-09-19',10,4.00,0.50,'12:50:00'),(3,7,'2020-09-19',11,5.00,0.50,'11:59:00'),(3,7,'2020-09-19',13,5.00,0.50,'10:59:00'),(3,7,'2020-09-19',13,5.00,0.50,'11:09:00'),(3,7,'2020-09-19',15,3.00,0.50,'10:56:00'),(3,7,'2020-09-19',22,4.00,0.50,'10:24:00'),(3,7,'2020-09-23',1,4.00,0.50,'17:11:00'),(3,7,'2020-09-23',1,5.00,0.50,'18:01:00'),(3,7,'2020-09-23',11,1.00,0.50,'18:37:00'),(3,7,'2020-09-23',16,2.00,0.50,'18:52:00'),(3,7,'2020-09-23',19,4.00,0.50,'18:35:00'),(3,7,'2020-09-26',1,5.00,0.50,'08:51:00'),(3,7,'2020-09-26',14,4.00,0.50,'08:57:00'),(3,7,'2020-09-26',14,3.00,0.50,'08:58:00'),(3,7,'2020-09-26',21,2.00,0.50,'13:53:00'),(3,7,'2020-09-26',23,2.00,0.50,'12:07:00'),(3,7,'2020-09-26',24,5.00,0.50,'10:41:00'),(3,7,'2020-09-26',24,3.00,0.50,'11:08:00'),(3,7,'2020-09-30',1,4.00,0.50,'18:10:00'),(3,7,'2020-09-30',1,3.00,0.50,'18:18:00'),(3,7,'2020-09-30',6,1.00,0.50,'18:01:00'),(3,7,'2020-09-30',11,2.00,0.50,'17:50:00'),(3,7,'2020-09-30',14,2.00,0.50,'17:05:00'),(3,7,'2020-09-30',15,2.00,0.50,'18:49:00'),(4,7,'2019-04-03',3,1.00,4.00,'18:44:00'),(4,7,'2019-04-03',4,1.00,4.00,'18:09:00'),(4,7,'2019-04-03',5,3.00,4.00,'18:54:00'),(4,7,'2019-04-03',6,4.00,4.00,'18:49:00'),(4,7,'2019-04-03',7,5.00,4.00,'17:59:00'),(4,7,'2019-04-03',12,3.00,4.00,'18:35:00'),(4,7,'2019-04-03',16,2.00,4.00,'18:58:00'),(4,7,'2019-04-06',2,5.00,4.00,'09:34:00'),(4,7,'2019-04-06',5,1.00,4.00,'11:51:00'),(4,7,'2019-04-06',12,5.00,4.00,'08:12:00'),(4,7,'2019-04-06',12,5.00,4.00,'08:41:00'),(4,7,'2019-04-06',14,2.00,4.00,'13:16:00'),(4,7,'2019-04-06',14,2.00,4.00,'13:50:00'),(4,7,'2019-04-06',16,5.00,4.00,'13:12:00'),(4,7,'2019-04-06',16,3.00,4.00,'13:34:00'),(4,7,'2019-04-10',4,5.00,4.00,'16:48:00'),(4,7,'2019-04-10',4,3.00,4.00,'17:27:00'),(4,7,'2019-04-10',5,4.00,4.00,'18:53:00'),(4,7,'2019-04-10',5,5.00,4.00,'18:57:00'),(4,7,'2019-04-10',12,4.00,4.00,'16:45:00'),(4,7,'2019-04-10',12,2.00,4.00,'16:58:00'),(4,7,'2019-04-13',2,2.00,4.00,'09:19:00'),(4,7,'2019-04-13',3,4.00,4.00,'10:50:00'),(4,7,'2019-04-13',3,1.00,4.00,'11:33:00'),(4,7,'2019-04-13',4,2.00,4.00,'10:17:00'),(4,7,'2019-04-13',5,5.00,4.00,'11:49:00'),(4,7,'2019-04-13',11,1.00,4.00,'08:42:00'),(4,7,'2019-04-13',11,2.00,4.00,'08:48:00'),(4,7,'2019-04-13',13,4.00,4.00,'10:29:00'),(4,7,'2019-04-13',13,5.00,4.00,'11:03:00'),(4,7,'2019-04-17',1,5.00,3.50,'16:09:00'),(4,7,'2019-04-17',2,2.00,3.50,'18:39:00'),(4,7,'2019-04-17',2,5.00,3.50,'18:43:00'),(4,7,'2019-04-17',4,4.00,3.50,'17:51:00'),(4,7,'2019-04-17',4,4.00,3.50,'18:11:00'),(4,7,'2019-04-17',6,4.00,3.50,'17:29:00'),(4,7,'2019-04-17',7,3.00,3.50,'18:52:00'),(4,7,'2019-04-17',9,3.00,3.50,'17:11:00'),(4,7,'2019-04-17',9,4.00,3.50,'17:45:00'),(4,7,'2019-04-17',10,1.00,3.50,'17:16:00'),(4,7,'2019-04-20',2,4.00,4.00,'13:36:00'),(4,7,'2019-04-20',2,1.00,4.00,'13:44:00'),(4,7,'2019-04-20',5,1.00,4.00,'13:27:00'),(4,7,'2019-04-20',7,4.00,4.00,'09:58:00'),(4,7,'2019-04-20',8,3.00,4.00,'12:54:00'),(4,7,'2019-04-20',11,4.00,4.00,'13:30:00'),(4,7,'2019-04-20',11,2.00,4.00,'13:42:00'),(4,7,'2019-04-20',12,1.00,4.00,'11:51:00'),(4,7,'2019-04-24',1,3.00,4.00,'18:22:00'),(4,7,'2019-04-24',2,4.00,4.00,'18:35:00'),(4,7,'2019-04-24',3,5.00,4.00,'18:39:00'),(4,7,'2019-04-24',4,3.00,4.00,'16:59:00'),(4,7,'2019-04-24',8,5.00,4.00,'18:45:00'),(4,7,'2019-04-24',11,1.00,4.00,'18:15:00'),(4,7,'2019-04-24',13,1.00,4.00,'16:27:00'),(4,7,'2019-04-24',13,2.00,4.00,'17:15:00'),(4,7,'2019-04-24',18,3.00,4.00,'17:37:00'),(4,7,'2019-04-27',1,1.00,3.50,'12:26:00'),(4,7,'2019-04-27',2,5.00,3.50,'13:19:00'),(4,7,'2019-04-27',2,5.00,3.50,'13:54:00'),(4,7,'2019-04-27',4,3.00,3.50,'12:28:00'),(4,7,'2019-04-27',12,3.00,3.50,'13:32:00'),(4,7,'2019-04-27',13,4.00,3.50,'11:43:00'),(4,7,'2019-04-27',13,2.00,3.50,'11:58:00'),(4,7,'2019-04-27',16,3.00,3.50,'10:52:00'),(4,7,'2019-04-27',17,3.00,3.50,'10:46:00'),(4,7,'2019-05-01',1,4.00,4.00,'18:49:00'),(4,7,'2019-05-01',1,4.00,4.00,'18:59:00'),(4,7,'2019-05-01',3,4.00,4.00,'17:10:00'),(4,7,'2019-05-01',4,2.00,4.00,'16:47:00'),(4,7,'2019-05-01',4,5.00,4.00,'17:39:00'),(4,7,'2019-05-01',16,2.00,4.00,'18:57:00'),(4,7,'2019-05-04',2,1.00,4.00,'11:24:00'),(4,7,'2019-05-04',4,1.00,4.00,'10:22:00'),(4,7,'2019-05-04',6,1.00,4.00,'11:01:00'),(4,7,'2019-05-04',6,1.00,4.00,'11:14:00'),(4,7,'2019-05-04',7,4.00,4.00,'11:48:00'),(4,7,'2019-05-04',10,2.00,4.00,'09:16:00'),(4,7,'2019-05-04',10,4.00,4.00,'09:41:00'),(4,7,'2019-05-04',11,1.00,4.00,'10:43:00'),(4,7,'2019-05-04',11,5.00,4.00,'11:05:00'),(4,7,'2019-05-04',13,1.00,4.00,'10:33:00'),(4,7,'2019-05-04',17,4.00,4.00,'13:44:00'),(4,7,'2019-05-08',2,4.00,4.00,'18:10:00'),(4,7,'2019-05-08',2,1.00,4.00,'18:17:00'),(4,7,'2019-05-08',3,1.00,4.00,'17:11:00'),(4,7,'2019-05-08',3,2.00,4.00,'17:23:00'),(4,7,'2019-05-08',4,5.00,4.00,'18:03:00'),(4,7,'2019-05-08',5,1.00,4.00,'16:16:00'),(4,7,'2019-05-08',11,5.00,4.00,'18:09:00'),(4,7,'2019-05-08',12,1.00,4.00,'17:30:00'),(4,7,'2019-05-08',18,1.00,4.00,'18:03:00'),(4,7,'2019-05-08',18,1.00,4.00,'18:06:00'),(4,7,'2019-05-11',6,2.00,4.00,'11:00:00'),(4,7,'2019-05-11',6,2.00,4.00,'11:04:00'),(4,7,'2019-05-11',7,4.00,4.00,'13:51:00'),(4,7,'2019-05-11',8,2.00,4.00,'13:37:00'),(4,7,'2019-05-11',8,5.00,4.00,'13:42:00'),(4,7,'2019-05-11',10,3.00,4.00,'09:19:00'),(4,7,'2019-05-11',11,5.00,4.00,'08:53:00'),(4,7,'2019-05-11',12,2.00,4.00,'09:32:00'),(4,7,'2019-05-11',12,4.00,4.00,'09:40:00'),(4,7,'2019-05-15',1,2.00,4.00,'18:28:00'),(4,7,'2019-05-15',1,2.00,4.00,'18:49:00'),(4,7,'2019-05-15',4,2.00,4.00,'16:54:00'),(4,7,'2019-05-15',4,2.00,4.00,'17:23:00'),(4,7,'2019-05-15',8,2.00,4.00,'18:27:00'),(4,7,'2019-05-15',12,1.00,4.00,'17:06:00'),(4,7,'2019-05-15',12,1.00,4.00,'17:27:00'),(4,7,'2019-05-15',13,1.00,4.00,'18:02:00'),(4,7,'2019-05-18',1,5.00,4.00,'12:56:00'),(4,7,'2019-05-18',2,5.00,4.00,'13:41:00'),(4,7,'2019-05-18',7,4.00,4.00,'10:20:00'),(4,7,'2019-05-18',8,3.00,4.00,'09:23:00'),(4,7,'2019-05-18',10,5.00,4.00,'13:40:00'),(4,7,'2019-05-18',10,1.00,4.00,'13:54:00'),(4,7,'2019-05-18',13,2.00,4.00,'13:18:00'),(4,7,'2019-05-18',17,2.00,4.00,'11:04:00'),(4,7,'2019-05-18',17,3.00,4.00,'11:18:00'),(4,7,'2019-05-22',2,2.00,4.00,'17:04:00'),(4,7,'2019-05-22',4,1.00,4.00,'18:53:00'),(4,7,'2019-05-22',7,4.00,4.00,'17:56:00'),(4,7,'2019-05-22',7,5.00,4.00,'18:24:00'),(4,7,'2019-05-22',10,3.00,4.00,'17:25:00'),(4,7,'2019-05-22',12,1.00,4.00,'17:51:00'),(4,7,'2019-05-22',15,2.00,4.00,'17:43:00'),(4,7,'2019-05-22',15,4.00,4.00,'18:26:00'),(4,7,'2019-05-25',2,2.00,4.00,'13:08:00'),(4,7,'2019-05-25',2,2.00,4.00,'13:31:00'),(4,7,'2019-05-25',8,2.00,4.00,'09:10:00'),(4,7,'2019-05-25',10,2.00,4.00,'12:22:00'),(4,7,'2019-05-25',12,2.00,4.00,'09:59:00'),(4,7,'2019-05-25',17,2.00,4.00,'13:50:00'),(4,7,'2019-05-29',1,1.00,4.00,'17:51:00'),(4,7,'2019-05-29',6,3.00,4.00,'16:56:00'),(4,7,'2019-05-29',6,4.00,4.00,'17:36:00'),(4,7,'2019-05-29',7,2.00,4.00,'18:59:00'),(4,7,'2019-05-29',8,2.00,4.00,'18:38:00'),(4,7,'2019-05-29',12,3.00,4.00,'18:04:00'),(4,7,'2019-05-29',12,2.00,4.00,'18:31:00'),(4,7,'2019-05-29',14,5.00,4.00,'18:51:00'),(4,7,'2019-05-29',14,3.00,4.00,'18:57:00'),(4,7,'2019-05-29',15,3.00,4.00,'18:49:00'),(4,7,'2019-05-29',15,2.00,4.00,'18:58:00'),(4,7,'2019-06-01',3,5.00,4.00,'13:55:00'),(4,7,'2019-06-01',5,4.00,4.00,'13:08:00'),(4,7,'2019-06-01',8,3.00,4.00,'10:45:00'),(4,7,'2019-06-01',9,2.00,4.00,'11:55:00'),(4,7,'2019-06-01',9,4.00,4.00,'12:04:00'),(4,7,'2019-06-01',10,4.00,4.00,'10:42:00'),(4,7,'2019-06-05',4,5.00,4.00,'17:00:00'),(4,7,'2019-06-05',4,2.00,4.00,'17:03:00'),(4,7,'2019-06-05',5,3.00,4.00,'18:16:00'),(4,7,'2019-06-05',7,2.00,4.00,'16:30:00'),(4,7,'2019-06-05',11,1.00,4.00,'18:25:00'),(4,7,'2019-06-05',11,4.00,4.00,'18:50:00'),(4,7,'2019-06-05',12,2.00,4.00,'17:54:00'),(4,7,'2019-06-05',12,2.00,4.00,'18:07:00'),(4,7,'2019-06-05',17,4.00,4.00,'16:58:00'),(4,7,'2019-06-08',3,3.00,4.00,'09:59:00'),(4,7,'2019-06-08',4,3.00,4.00,'12:26:00'),(4,7,'2019-06-08',7,4.00,4.00,'11:10:00'),(4,7,'2019-06-08',9,3.00,4.00,'11:35:00'),(4,7,'2019-06-08',10,2.00,4.00,'09:36:00'),(4,7,'2019-06-08',15,1.00,4.00,'09:18:00'),(4,7,'2019-06-08',15,1.00,4.00,'10:09:00'),(4,7,'2019-06-12',1,5.00,4.00,'17:10:00'),(4,7,'2019-06-12',1,3.00,4.00,'17:35:00'),(4,7,'2019-06-12',3,2.00,4.00,'18:26:00'),(4,7,'2019-06-12',6,3.00,4.00,'18:39:00'),(4,7,'2019-06-12',7,3.00,4.00,'17:12:00'),(4,7,'2019-06-12',10,2.00,4.00,'18:48:00'),(4,7,'2019-06-12',17,4.00,4.00,'18:46:00'),(4,7,'2019-06-12',17,4.00,4.00,'18:47:00'),(4,7,'2019-06-15',1,3.00,4.00,'12:56:00'),(4,7,'2019-06-15',2,2.00,4.00,'09:31:00'),(4,7,'2019-06-15',2,5.00,4.00,'09:59:00'),(4,7,'2019-06-15',4,5.00,4.00,'12:23:00'),(4,7,'2019-06-15',8,1.00,4.00,'13:10:00'),(4,7,'2019-06-15',8,1.00,4.00,'13:54:00'),(4,7,'2019-06-15',9,5.00,4.00,'08:37:00'),(4,7,'2019-06-15',11,3.00,4.00,'12:01:00'),(4,7,'2019-06-15',11,1.00,4.00,'12:39:00'),(4,7,'2019-06-15',16,4.00,4.00,'13:18:00'),(4,7,'2019-06-15',16,1.00,4.00,'13:27:00'),(4,7,'2019-06-19',2,5.00,4.00,'17:57:00'),(4,7,'2019-06-19',2,4.00,4.00,'18:30:00'),(4,7,'2019-06-19',3,4.00,4.00,'18:53:00'),(4,7,'2019-06-19',3,4.00,4.00,'18:59:00'),(4,7,'2019-06-19',9,4.00,4.00,'18:53:00'),(4,7,'2019-06-22',4,3.00,4.00,'10:22:00'),(4,7,'2019-06-22',7,1.00,4.00,'09:07:00'),(4,7,'2019-06-22',7,4.00,4.00,'09:50:00'),(4,7,'2019-06-22',8,2.00,4.00,'10:01:00'),(4,7,'2019-06-22',10,2.00,4.00,'11:14:00'),(4,7,'2019-06-22',11,3.00,4.00,'13:46:00'),(4,7,'2019-06-22',12,2.00,4.00,'09:32:00'),(4,7,'2019-06-22',14,2.00,4.00,'09:30:00'),(4,7,'2019-06-26',2,2.00,4.00,'18:57:00'),(4,7,'2019-06-26',7,4.00,4.00,'17:50:00'),(4,7,'2019-06-26',8,5.00,4.00,'17:25:00'),(4,7,'2019-06-26',10,4.00,4.00,'18:33:00'),(4,7,'2019-06-26',10,4.00,4.00,'18:34:00'),(4,7,'2019-06-26',11,5.00,4.00,'18:44:00'),(4,7,'2019-06-26',11,2.00,4.00,'18:55:00'),(4,7,'2019-06-26',12,3.00,4.00,'18:43:00'),(4,7,'2019-06-29',7,5.00,4.00,'13:19:00'),(4,7,'2019-06-29',10,4.00,4.00,'13:45:00'),(4,7,'2019-06-29',14,5.00,4.00,'13:34:00'),(4,7,'2019-06-29',17,4.00,4.00,'13:52:00'),(4,7,'2019-07-03',6,4.00,4.00,'16:39:00'),(4,7,'2019-07-03',11,5.00,4.00,'18:47:00'),(4,7,'2019-07-03',13,5.00,4.00,'18:27:00'),(4,7,'2019-07-03',14,5.00,4.00,'18:25:00'),(4,7,'2019-07-03',16,3.00,4.00,'17:32:00'),(4,7,'2019-07-06',1,5.00,4.00,'13:39:00'),(4,7,'2019-07-06',2,3.00,4.00,'12:01:00'),(4,7,'2019-07-06',2,5.00,4.00,'12:02:00'),(4,7,'2019-07-06',4,4.00,4.00,'10:14:00'),(4,7,'2019-07-06',15,4.00,4.00,'09:40:00'),(4,7,'2019-07-10',3,3.00,4.00,'17:46:00'),(4,7,'2019-07-10',9,2.00,4.00,'18:13:00'),(4,7,'2019-07-10',10,1.00,4.00,'18:37:00'),(4,7,'2019-07-10',12,3.00,4.00,'17:23:00'),(4,7,'2019-07-10',16,5.00,4.00,'17:55:00'),(4,7,'2019-07-13',5,2.00,3.50,'08:41:00'),(4,7,'2019-07-13',7,2.00,3.50,'11:17:00'),(4,7,'2019-07-13',9,4.00,3.50,'10:33:00'),(4,7,'2019-07-13',10,5.00,3.50,'11:08:00'),(4,7,'2019-07-13',17,4.00,3.50,'13:40:00'),(4,7,'2019-07-17',1,2.00,4.00,'16:24:00'),(4,7,'2019-07-17',1,5.00,4.00,'16:50:00'),(4,7,'2019-07-17',2,1.00,4.00,'18:39:00'),(4,7,'2019-07-17',2,1.00,4.00,'18:48:00'),(4,7,'2019-07-17',5,2.00,4.00,'18:37:00'),(4,7,'2019-07-17',7,4.00,4.00,'16:46:00'),(4,7,'2019-07-17',11,3.00,4.00,'18:53:00'),(4,7,'2019-07-17',14,2.00,4.00,'17:02:00'),(4,7,'2019-07-17',16,2.00,4.00,'16:45:00'),(4,7,'2019-07-17',18,5.00,4.00,'17:56:00'),(4,7,'2019-07-17',18,3.00,4.00,'18:21:00'),(4,7,'2019-07-20',2,5.00,4.00,'12:08:00'),(4,7,'2019-07-20',3,2.00,4.00,'09:56:00'),(4,7,'2019-07-20',9,2.00,4.00,'12:15:00'),(4,7,'2019-07-20',9,1.00,4.00,'12:17:00'),(4,7,'2019-07-24',3,1.00,4.00,'18:38:00'),(4,7,'2019-07-24',5,3.00,4.00,'18:08:00'),(4,7,'2019-07-24',10,4.00,4.00,'17:49:00'),(4,7,'2019-07-24',11,3.00,4.00,'17:27:00'),(4,7,'2019-07-27',4,4.00,4.00,'12:48:00'),(4,7,'2019-07-27',4,3.00,4.00,'13:03:00'),(4,7,'2019-07-27',10,4.00,4.00,'10:00:00'),(4,7,'2019-07-27',11,4.00,4.00,'13:08:00'),(4,7,'2019-07-27',11,4.00,4.00,'13:21:00'),(4,7,'2019-07-31',4,5.00,4.00,'18:24:00'),(4,7,'2019-07-31',7,4.00,4.00,'18:53:00'),(4,7,'2019-07-31',13,2.00,4.00,'18:48:00'),(4,7,'2019-07-31',18,3.00,4.00,'17:21:00'),(4,7,'2019-08-03',3,4.00,4.00,'09:48:00'),(4,7,'2019-08-03',15,1.00,4.00,'11:57:00'),(4,7,'2019-08-07',1,3.00,4.00,'16:34:00'),(4,7,'2019-08-07',15,4.00,4.00,'16:25:00'),(4,7,'2019-08-07',15,5.00,4.00,'16:28:00'),(4,7,'2019-08-07',18,2.00,4.00,'16:29:00'),(4,7,'2019-08-07',18,1.00,4.00,'16:42:00'),(4,7,'2019-08-10',1,5.00,4.00,'10:25:00'),(4,7,'2019-08-10',16,5.00,4.00,'13:47:00'),(4,7,'2019-08-14',2,4.00,4.00,'18:47:00'),(4,7,'2019-08-14',3,4.00,4.00,'18:40:00'),(4,7,'2019-08-14',4,3.00,4.00,'17:37:00'),(4,7,'2019-08-14',11,3.00,4.00,'17:22:00'),(4,7,'2019-08-14',11,1.00,4.00,'17:38:00'),(4,7,'2019-08-14',14,3.00,4.00,'16:53:00'),(4,7,'2019-08-14',16,4.00,4.00,'18:44:00'),(4,7,'2019-08-17',2,1.00,4.00,'13:51:00'),(4,7,'2019-08-17',4,5.00,4.00,'09:22:00'),(4,7,'2019-08-17',10,3.00,4.00,'09:34:00'),(4,7,'2019-08-21',3,1.00,4.00,'17:31:00'),(4,7,'2019-08-21',3,4.00,4.00,'17:34:00'),(4,7,'2019-08-21',5,4.00,4.00,'17:15:00'),(4,7,'2019-08-21',6,3.00,4.00,'18:59:00'),(4,7,'2019-08-21',12,4.00,4.00,'18:37:00'),(4,7,'2019-08-24',2,1.00,4.00,'09:29:00'),(4,7,'2019-08-24',10,4.00,4.00,'12:43:00'),(4,7,'2019-08-24',14,3.00,4.00,'13:30:00'),(4,7,'2019-08-28',3,4.00,4.00,'18:47:00'),(4,7,'2019-08-28',7,4.00,4.00,'17:57:00'),(4,7,'2019-08-28',11,4.00,4.00,'17:02:00'),(4,7,'2019-08-28',12,4.00,4.00,'16:23:00'),(4,7,'2019-08-28',14,1.00,4.00,'18:14:00'),(4,7,'2019-08-31',5,3.00,4.00,'12:42:00'),(4,7,'2019-08-31',5,2.00,4.00,'13:30:00'),(4,7,'2019-09-04',1,4.00,4.00,'17:01:00'),(4,7,'2019-09-04',1,5.00,4.00,'17:27:00'),(4,7,'2019-09-04',4,3.00,4.00,'18:34:00'),(4,7,'2019-09-04',17,3.00,4.00,'17:39:00'),(4,7,'2019-09-07',2,3.00,4.00,'12:42:00'),(4,7,'2019-09-07',5,1.00,4.00,'13:17:00'),(4,7,'2019-09-07',5,2.00,4.00,'13:29:00'),(4,7,'2019-09-07',10,4.00,4.00,'13:50:00'),(4,7,'2019-09-07',14,1.00,4.00,'13:32:00'),(4,7,'2019-09-11',1,4.00,4.00,'16:15:00'),(4,7,'2019-09-11',1,2.00,4.00,'16:44:00'),(4,7,'2019-09-11',2,5.00,4.00,'17:23:00'),(4,7,'2019-09-11',6,2.00,4.00,'16:32:00'),(4,7,'2019-09-11',6,4.00,4.00,'17:39:00'),(4,7,'2019-09-11',8,5.00,4.00,'18:34:00'),(4,7,'2019-09-11',8,1.00,4.00,'18:48:00'),(4,7,'2019-09-11',9,1.00,4.00,'17:40:00'),(4,7,'2019-09-11',16,4.00,4.00,'18:25:00'),(4,7,'2019-09-14',5,2.00,4.00,'11:15:00'),(4,7,'2019-09-14',14,3.00,4.00,'09:43:00'),(4,7,'2019-09-14',17,5.00,4.00,'12:55:00'),(4,7,'2019-09-18',9,5.00,4.00,'16:57:00'),(4,7,'2019-09-18',12,2.00,4.00,'16:51:00'),(4,7,'2019-09-18',17,4.00,4.00,'18:48:00'),(4,7,'2019-09-21',2,5.00,4.00,'09:10:00'),(4,7,'2019-09-21',2,5.00,4.00,'09:44:00'),(4,7,'2019-09-21',3,4.00,4.00,'09:29:00'),(4,7,'2019-09-21',3,3.00,4.00,'09:56:00'),(4,7,'2019-09-21',4,2.00,4.00,'12:53:00'),(4,7,'2019-09-21',5,1.00,4.00,'12:12:00'),(4,7,'2019-09-21',18,3.00,4.00,'10:51:00'),(4,7,'2019-09-28',2,3.00,4.00,'11:09:00'),(4,7,'2019-09-28',2,5.00,4.00,'12:16:00'),(4,7,'2019-09-28',3,4.00,4.00,'13:19:00'),(4,7,'2019-09-28',18,3.00,4.00,'10:08:00'),(4,7,'2019-10-02',1,1.00,4.00,'17:53:00'),(4,7,'2019-10-02',3,3.00,4.00,'16:46:00'),(4,7,'2019-10-02',3,4.00,4.00,'17:01:00'),(4,7,'2019-10-02',6,4.00,4.00,'16:31:00'),(4,7,'2019-10-02',8,3.00,4.00,'18:47:00'),(4,7,'2019-10-02',9,3.00,4.00,'17:03:00'),(4,7,'2019-10-02',11,2.00,4.00,'18:51:00'),(4,7,'2019-10-02',11,5.00,4.00,'18:57:00'),(4,7,'2019-10-05',1,2.00,4.00,'11:37:00'),(4,7,'2019-10-05',5,5.00,4.00,'08:58:00'),(4,7,'2019-10-05',9,2.00,4.00,'11:17:00'),(4,7,'2019-10-05',10,5.00,4.00,'10:40:00'),(4,7,'2019-10-05',10,1.00,4.00,'10:49:00'),(4,7,'2019-10-05',12,2.00,4.00,'13:55:00'),(4,7,'2019-10-05',17,2.00,4.00,'09:22:00'),(4,7,'2019-10-05',17,3.00,4.00,'09:53:00'),(4,7,'2019-10-09',2,2.00,4.00,'18:56:00'),(4,7,'2019-10-09',3,5.00,4.00,'17:44:00'),(4,7,'2019-10-09',6,4.00,4.00,'18:15:00'),(4,7,'2019-10-09',6,1.00,4.00,'18:33:00'),(4,7,'2019-10-09',12,2.00,4.00,'18:09:00'),(4,7,'2019-10-09',13,3.00,4.00,'17:08:00'),(4,7,'2019-10-09',13,1.00,4.00,'17:17:00'),(4,7,'2019-10-09',15,4.00,4.00,'18:50:00'),(4,7,'2019-10-12',4,5.00,4.00,'11:53:00'),(4,7,'2019-10-12',7,4.00,4.00,'10:08:00'),(4,7,'2019-10-12',7,4.00,4.00,'10:58:00'),(4,7,'2019-10-12',8,1.00,4.00,'10:44:00'),(4,7,'2019-10-12',9,4.00,4.00,'13:14:00'),(4,7,'2019-10-12',9,4.00,4.00,'13:53:00'),(4,7,'2019-10-12',10,2.00,4.00,'13:20:00'),(4,7,'2019-10-12',14,5.00,4.00,'09:52:00'),(4,7,'2019-10-16',4,5.00,4.00,'17:58:00'),(4,7,'2019-10-16',4,4.00,4.00,'18:18:00'),(4,7,'2019-10-16',5,2.00,4.00,'18:26:00'),(4,7,'2019-10-16',6,2.00,4.00,'18:24:00'),(4,7,'2019-10-16',14,1.00,4.00,'17:38:00'),(4,7,'2019-10-16',16,5.00,4.00,'16:46:00'),(4,7,'2019-10-19',1,4.00,4.00,'08:54:00'),(4,7,'2019-10-19',1,2.00,4.00,'09:28:00'),(4,7,'2019-10-19',4,3.00,4.00,'13:13:00'),(4,7,'2019-10-19',6,4.00,4.00,'12:43:00'),(4,7,'2019-10-19',6,4.00,4.00,'12:45:00'),(4,7,'2019-10-19',8,5.00,4.00,'13:16:00'),(4,7,'2019-10-19',12,2.00,4.00,'09:46:00'),(4,7,'2019-10-19',12,1.00,4.00,'10:22:00'),(4,7,'2019-10-23',2,2.00,4.00,'18:38:00'),(4,7,'2019-10-23',2,3.00,4.00,'18:51:00'),(4,7,'2019-10-23',4,3.00,4.00,'17:31:00'),(4,7,'2019-10-23',4,3.00,4.00,'18:41:00'),(4,7,'2019-10-23',5,5.00,4.00,'18:22:00'),(4,7,'2019-10-23',10,4.00,4.00,'16:57:00'),(4,7,'2019-10-23',10,1.00,4.00,'17:49:00'),(4,7,'2019-10-23',11,5.00,4.00,'18:23:00'),(4,7,'2019-10-23',11,1.00,4.00,'18:25:00'),(4,7,'2019-10-23',12,4.00,4.00,'17:48:00'),(4,7,'2019-10-23',17,5.00,4.00,'17:58:00'),(4,7,'2019-10-23',17,4.00,4.00,'18:33:00'),(4,7,'2019-10-26',2,1.00,4.00,'11:46:00'),(4,7,'2019-10-26',4,2.00,4.00,'10:28:00'),(4,7,'2019-10-26',12,3.00,4.00,'09:05:00'),(4,7,'2019-10-26',12,5.00,4.00,'10:07:00'),(4,7,'2019-10-26',13,3.00,4.00,'13:57:00'),(4,7,'2019-10-26',16,3.00,4.00,'13:16:00'),(4,7,'2019-10-26',16,5.00,4.00,'13:37:00'),(4,7,'2019-10-26',17,2.00,4.00,'13:06:00'),(4,7,'2019-10-26',18,2.00,4.00,'09:07:00'),(4,7,'2019-10-30',1,5.00,4.00,'18:14:00'),(4,7,'2019-10-30',4,1.00,4.00,'18:10:00'),(4,7,'2019-10-30',4,1.00,4.00,'18:33:00'),(4,7,'2019-10-30',5,5.00,4.00,'16:13:00'),(4,7,'2019-10-30',5,2.00,4.00,'16:37:00'),(4,7,'2019-10-30',6,3.00,4.00,'17:41:00'),(4,7,'2019-10-30',6,2.00,4.00,'18:50:00'),(4,7,'2019-10-30',9,2.00,4.00,'16:33:00'),(4,7,'2019-10-30',9,5.00,4.00,'17:22:00'),(4,7,'2019-10-30',11,2.00,4.00,'18:24:00'),(4,7,'2019-10-30',11,5.00,4.00,'18:26:00'),(4,7,'2019-10-30',17,2.00,4.00,'17:51:00'),(4,7,'2019-11-02',6,5.00,4.00,'11:49:00'),(4,7,'2019-11-02',6,4.00,4.00,'12:03:00'),(4,7,'2019-11-02',7,4.00,4.00,'11:17:00'),(4,7,'2019-11-02',7,1.00,4.00,'12:36:00'),(4,7,'2019-11-02',8,5.00,4.00,'10:29:00'),(4,7,'2019-11-02',9,1.00,4.00,'09:34:00'),(4,7,'2019-11-02',9,5.00,4.00,'10:36:00'),(4,7,'2019-11-02',10,5.00,4.00,'10:39:00'),(4,7,'2019-11-02',10,1.00,4.00,'11:20:00'),(4,7,'2019-11-02',11,5.00,4.00,'10:23:00'),(4,7,'2019-11-02',11,3.00,4.00,'11:20:00'),(4,7,'2019-11-02',16,1.00,4.00,'09:54:00'),(4,7,'2019-11-06',1,2.00,4.00,'18:56:00'),(4,7,'2019-11-06',2,2.00,4.00,'17:53:00'),(4,7,'2019-11-06',2,1.00,4.00,'18:06:00'),(4,7,'2019-11-06',3,1.00,4.00,'18:56:00'),(4,7,'2019-11-06',5,5.00,4.00,'18:19:00'),(4,7,'2019-11-06',5,4.00,4.00,'18:54:00'),(4,7,'2019-11-06',6,3.00,4.00,'17:25:00'),(4,7,'2019-11-06',7,4.00,4.00,'18:33:00'),(4,7,'2019-11-06',7,4.00,4.00,'18:38:00'),(4,7,'2019-11-06',10,1.00,4.00,'18:11:00'),(4,7,'2019-11-06',17,4.00,4.00,'17:06:00'),(4,7,'2019-11-06',18,3.00,4.00,'17:04:00'),(4,7,'2019-11-09',1,5.00,4.00,'11:45:00'),(4,7,'2019-11-09',1,2.00,4.00,'12:28:00'),(4,7,'2019-11-09',5,1.00,4.00,'11:07:00'),(4,7,'2019-11-09',8,1.00,4.00,'13:56:00'),(4,7,'2019-11-09',9,1.00,4.00,'09:07:00'),(4,7,'2019-11-09',9,2.00,4.00,'09:36:00'),(4,7,'2019-11-09',10,2.00,4.00,'11:08:00'),(4,7,'2019-11-09',10,2.00,4.00,'11:27:00'),(4,7,'2019-11-09',12,1.00,4.00,'08:58:00'),(4,7,'2019-11-09',12,2.00,4.00,'09:54:00'),(4,7,'2019-11-09',13,3.00,4.00,'11:59:00'),(4,7,'2019-11-13',4,1.00,4.00,'16:53:00'),(4,7,'2019-11-13',4,2.00,4.00,'17:42:00'),(4,7,'2019-11-13',7,4.00,4.00,'18:05:00'),(4,7,'2019-11-13',8,2.00,4.00,'17:53:00'),(4,7,'2019-11-13',11,3.00,4.00,'18:30:00'),(4,7,'2019-11-13',16,1.00,4.00,'18:47:00'),(4,7,'2019-11-13',17,5.00,4.00,'18:42:00'),(4,7,'2019-11-16',2,3.00,4.00,'13:59:00'),(4,7,'2019-11-16',3,2.00,4.00,'08:42:00'),(4,7,'2019-11-16',9,3.00,4.00,'11:40:00'),(4,7,'2019-11-16',10,4.00,4.00,'13:07:00'),(4,7,'2019-11-16',10,1.00,4.00,'13:32:00'),(4,7,'2019-11-16',11,5.00,4.00,'11:29:00'),(4,7,'2019-11-16',14,1.00,4.00,'12:58:00'),(4,7,'2019-11-16',18,1.00,4.00,'11:25:00'),(4,7,'2019-11-20',2,2.00,4.00,'18:12:00'),(4,7,'2019-11-20',3,1.00,4.00,'16:30:00'),(4,7,'2019-11-20',4,3.00,4.00,'17:19:00'),(4,7,'2019-11-20',4,5.00,4.00,'17:22:00'),(4,7,'2019-11-20',10,2.00,4.00,'17:35:00'),(4,7,'2019-11-20',11,2.00,4.00,'18:43:00'),(4,7,'2019-11-20',11,2.00,4.00,'18:46:00'),(4,7,'2019-11-20',12,5.00,4.00,'16:23:00'),(4,7,'2019-11-20',12,3.00,4.00,'16:37:00'),(4,7,'2019-11-20',14,5.00,4.00,'18:32:00'),(4,7,'2019-11-20',16,1.00,4.00,'18:42:00'),(4,7,'2019-11-20',16,3.00,4.00,'18:46:00'),(4,7,'2019-11-23',5,1.00,4.00,'12:09:00'),(4,7,'2019-11-23',6,4.00,4.00,'13:52:00'),(4,7,'2019-11-23',7,1.00,4.00,'11:12:00'),(4,7,'2019-11-23',11,5.00,4.00,'12:18:00'),(4,7,'2019-11-27',7,2.00,4.00,'17:53:00'),(4,7,'2019-11-27',10,1.00,4.00,'18:13:00'),(4,7,'2019-11-27',12,1.00,4.00,'17:38:00'),(4,7,'2019-11-30',1,3.00,4.00,'13:11:00'),(4,7,'2019-11-30',1,3.00,4.00,'13:52:00'),(4,7,'2019-11-30',2,1.00,4.00,'13:55:00'),(4,7,'2019-11-30',3,5.00,4.00,'09:58:00'),(4,7,'2019-11-30',4,5.00,4.00,'12:43:00'),(4,7,'2019-11-30',4,2.00,4.00,'12:44:00'),(4,7,'2019-11-30',18,3.00,4.00,'09:39:00'),(4,7,'2019-11-30',18,5.00,4.00,'09:46:00'),(4,7,'2019-12-04',2,4.00,4.00,'17:40:00'),(4,7,'2019-12-04',3,3.00,4.00,'18:09:00'),(4,7,'2019-12-04',6,1.00,4.00,'18:57:00'),(4,7,'2019-12-04',9,2.00,4.00,'17:31:00'),(4,7,'2019-12-04',15,5.00,4.00,'16:46:00'),(4,7,'2019-12-04',15,4.00,4.00,'17:38:00'),(4,7,'2019-12-07',2,5.00,4.00,'09:46:00'),(4,7,'2019-12-07',2,4.00,4.00,'09:54:00'),(4,7,'2019-12-07',4,3.00,4.00,'13:36:00'),(4,7,'2019-12-07',7,4.00,4.00,'13:53:00'),(4,7,'2019-12-07',8,1.00,4.00,'09:41:00'),(4,7,'2019-12-07',8,3.00,4.00,'10:01:00'),(4,7,'2019-12-07',15,1.00,4.00,'10:06:00'),(4,7,'2019-12-07',16,5.00,4.00,'08:29:00'),(4,7,'2019-12-07',16,3.00,4.00,'09:12:00'),(4,7,'2019-12-07',17,5.00,4.00,'13:56:00'),(4,7,'2019-12-11',1,1.00,4.00,'18:59:00'),(4,7,'2019-12-11',2,5.00,4.00,'18:14:00'),(4,7,'2019-12-11',3,4.00,4.00,'18:44:00'),(4,7,'2019-12-11',3,5.00,4.00,'18:51:00'),(4,7,'2019-12-11',4,4.00,4.00,'18:56:00'),(4,7,'2019-12-11',6,4.00,4.00,'18:47:00'),(4,7,'2019-12-11',8,5.00,4.00,'18:15:00'),(4,7,'2019-12-11',8,2.00,4.00,'18:17:00'),(4,7,'2019-12-11',12,2.00,4.00,'18:58:00'),(4,7,'2019-12-14',4,3.00,4.00,'08:18:00'),(4,7,'2019-12-14',4,2.00,4.00,'09:13:00'),(4,7,'2019-12-14',6,1.00,4.00,'09:23:00'),(4,7,'2019-12-14',8,2.00,4.00,'09:35:00'),(4,7,'2019-12-14',8,5.00,4.00,'10:17:00'),(4,7,'2019-12-14',9,5.00,4.00,'08:58:00'),(4,7,'2019-12-14',9,3.00,4.00,'09:22:00'),(4,7,'2019-12-14',14,2.00,4.00,'10:56:00'),(4,7,'2019-12-14',15,1.00,4.00,'11:37:00'),(4,7,'2019-12-18',1,4.00,4.00,'17:19:00'),(4,7,'2019-12-18',3,1.00,4.00,'18:18:00'),(4,7,'2019-12-18',4,2.00,4.00,'17:03:00'),(4,7,'2019-12-18',5,5.00,4.00,'18:02:00'),(4,7,'2019-12-18',6,4.00,4.00,'17:06:00'),(4,7,'2019-12-18',7,4.00,4.00,'16:58:00'),(4,7,'2019-12-18',7,5.00,4.00,'18:18:00'),(4,7,'2019-12-18',10,1.00,4.00,'16:17:00'),(4,7,'2019-12-18',16,1.00,4.00,'17:25:00'),(4,7,'2019-12-18',16,4.00,4.00,'18:03:00'),(4,7,'2019-12-21',4,2.00,4.00,'09:29:00'),(4,7,'2019-12-21',4,5.00,4.00,'10:15:00'),(4,7,'2019-12-21',9,3.00,4.00,'11:01:00'),(4,7,'2019-12-21',9,2.00,4.00,'11:18:00'),(4,7,'2019-12-21',10,1.00,4.00,'13:32:00'),(4,7,'2019-12-21',13,2.00,4.00,'12:23:00'),(4,7,'2019-12-21',17,4.00,4.00,'13:51:00'),(4,7,'2019-12-21',18,2.00,4.00,'13:43:00'),(4,7,'2019-12-21',18,2.00,4.00,'13:55:00'),(4,7,'2019-12-25',2,1.00,4.00,'17:07:00'),(4,7,'2019-12-25',3,1.00,4.00,'17:10:00'),(4,7,'2019-12-25',3,5.00,4.00,'17:32:00'),(4,7,'2019-12-25',5,2.00,4.00,'17:10:00'),(4,7,'2019-12-25',8,1.00,4.00,'16:52:00'),(4,7,'2019-12-25',8,2.00,4.00,'16:58:00'),(4,7,'2019-12-25',9,1.00,4.00,'18:49:00'),(4,7,'2019-12-25',10,4.00,4.00,'18:22:00'),(4,7,'2019-12-25',10,3.00,4.00,'18:33:00'),(4,7,'2019-12-28',5,3.00,4.00,'13:25:00'),(4,7,'2019-12-28',5,1.00,4.00,'13:47:00'),(4,7,'2019-12-28',7,1.00,4.00,'08:32:00'),(4,7,'2019-12-28',9,1.00,4.00,'09:16:00'),(4,7,'2019-12-28',10,1.00,4.00,'13:10:00'),(4,7,'2019-12-28',10,1.00,4.00,'13:18:00'),(4,7,'2019-12-28',16,2.00,4.00,'12:11:00'),(4,7,'2019-12-28',17,4.00,4.00,'10:12:00'),(4,7,'2019-12-28',17,5.00,4.00,'10:37:00'),(4,7,'2020-03-04',7,1.00,4.00,'17:47:00'),(4,7,'2020-03-04',7,2.00,4.00,'18:20:00'),(4,7,'2020-03-04',13,2.00,4.00,'18:47:00'),(4,7,'2020-03-07',3,2.00,4.00,'13:31:00'),(4,7,'2020-03-07',10,5.00,4.00,'10:49:00'),(4,7,'2020-03-07',11,4.00,4.00,'13:59:00'),(4,7,'2020-03-07',12,5.00,4.00,'12:50:00'),(4,7,'2020-03-07',12,5.00,4.00,'13:00:00'),(4,7,'2020-03-07',17,4.00,4.00,'13:43:00'),(4,7,'2020-03-07',17,3.00,4.00,'13:59:00'),(4,7,'2020-03-11',4,2.00,4.00,'16:29:00'),(4,7,'2020-03-11',4,4.00,4.00,'16:53:00'),(4,7,'2020-03-11',5,1.00,4.00,'17:35:00'),(4,7,'2020-03-11',6,1.00,4.00,'18:37:00'),(4,7,'2020-03-11',7,4.00,4.00,'18:24:00'),(4,7,'2020-03-11',10,5.00,4.00,'18:06:00'),(4,7,'2020-03-11',10,5.00,4.00,'18:26:00'),(4,7,'2020-03-11',11,4.00,4.00,'18:21:00'),(4,7,'2020-03-11',14,3.00,4.00,'17:55:00'),(4,7,'2020-03-14',2,2.00,4.00,'09:14:00'),(4,7,'2020-03-14',4,4.00,4.00,'13:56:00'),(4,7,'2020-03-14',5,1.00,4.00,'13:38:00'),(4,7,'2020-03-14',5,3.00,4.00,'13:51:00'),(4,7,'2020-03-14',7,4.00,4.00,'12:05:00'),(4,7,'2020-03-14',7,4.00,4.00,'12:14:00'),(4,7,'2020-03-14',10,5.00,4.00,'10:25:00'),(4,7,'2020-03-14',11,4.00,4.00,'13:30:00'),(4,7,'2020-03-14',11,1.00,4.00,'13:46:00'),(4,7,'2020-03-18',1,4.00,4.00,'18:01:00'),(4,7,'2020-03-18',2,1.00,4.00,'16:03:00'),(4,7,'2020-03-18',2,1.00,4.00,'16:44:00'),(4,7,'2020-03-18',4,2.00,4.00,'17:49:00'),(4,7,'2020-03-18',10,3.00,4.00,'18:32:00'),(4,7,'2020-03-18',11,2.00,4.00,'18:38:00'),(4,7,'2020-03-18',13,2.00,4.00,'17:29:00'),(4,7,'2020-03-18',13,5.00,4.00,'18:00:00'),(4,7,'2020-03-21',1,1.00,4.00,'13:57:00'),(4,7,'2020-03-21',2,5.00,4.00,'13:26:00'),(4,7,'2020-03-21',2,2.00,4.00,'13:47:00'),(4,7,'2020-03-21',4,3.00,4.00,'10:58:00'),(4,7,'2020-03-21',4,4.00,4.00,'11:19:00'),(4,7,'2020-03-21',7,1.00,4.00,'11:35:00'),(4,7,'2020-03-21',9,4.00,4.00,'10:05:00'),(4,7,'2020-03-21',11,5.00,4.00,'13:23:00'),(4,7,'2020-03-21',17,5.00,4.00,'12:41:00'),(4,7,'2020-03-25',1,5.00,4.00,'18:51:00'),(4,7,'2020-03-25',3,1.00,4.00,'18:46:00'),(4,7,'2020-03-25',10,2.00,4.00,'17:21:00'),(4,7,'2020-03-25',10,4.00,4.00,'17:23:00'),(4,7,'2020-03-25',13,2.00,4.00,'16:22:00'),(4,7,'2020-03-25',13,4.00,4.00,'17:09:00'),(4,7,'2020-03-25',14,1.00,4.00,'16:17:00'),(4,7,'2020-03-25',14,3.00,4.00,'17:08:00'),(4,7,'2020-03-25',17,5.00,4.00,'16:31:00'),(4,7,'2020-03-25',17,5.00,4.00,'17:05:00'),(4,7,'2020-03-28',2,5.00,3.50,'13:56:00'),(4,7,'2020-03-28',9,1.00,3.50,'09:12:00'),(4,7,'2020-03-28',11,4.00,3.50,'08:20:00'),(4,7,'2020-03-28',11,4.00,3.50,'09:15:00'),(4,7,'2020-03-28',15,5.00,3.50,'09:38:00'),(4,7,'2020-03-28',15,4.00,3.50,'10:11:00'),(4,7,'2020-03-28',16,1.00,3.50,'12:29:00'),(4,7,'2020-03-28',16,3.00,3.50,'12:31:00'),(4,7,'2020-03-28',17,4.00,3.50,'10:46:00'),(4,7,'2020-03-28',17,4.00,3.50,'11:11:00'),(4,7,'2020-03-28',18,1.00,3.50,'09:21:00'),(4,7,'2020-04-01',7,4.00,4.00,'17:35:00'),(4,7,'2020-04-01',12,2.00,4.00,'17:42:00'),(4,7,'2020-04-01',12,4.00,4.00,'17:54:00'),(4,7,'2020-04-01',15,5.00,4.00,'18:20:00'),(4,7,'2020-04-01',15,4.00,4.00,'18:34:00'),(4,7,'2020-04-01',17,4.00,4.00,'17:54:00'),(4,7,'2020-04-01',18,5.00,4.00,'17:58:00'),(4,7,'2020-04-04',2,2.00,4.00,'12:02:00'),(4,7,'2020-04-04',6,5.00,4.00,'10:53:00'),(4,7,'2020-04-04',9,1.00,4.00,'12:51:00'),(4,7,'2020-04-04',12,3.00,4.00,'13:47:00'),(4,7,'2020-04-04',13,4.00,4.00,'12:01:00'),(4,7,'2020-04-04',17,1.00,4.00,'11:32:00'),(4,7,'2020-04-04',17,1.00,4.00,'11:48:00'),(4,7,'2020-04-08',1,2.00,4.00,'18:42:00'),(4,7,'2020-04-08',4,3.00,4.00,'18:55:00'),(4,7,'2020-04-08',5,1.00,4.00,'16:58:00'),(4,7,'2020-04-08',6,4.00,4.00,'18:35:00'),(4,7,'2020-04-08',7,1.00,4.00,'17:26:00'),(4,7,'2020-04-08',8,5.00,4.00,'17:15:00'),(4,7,'2020-04-08',10,5.00,4.00,'18:50:00'),(4,7,'2020-04-08',17,4.00,4.00,'18:57:00'),(4,7,'2020-04-11',3,5.00,4.00,'09:11:00'),(4,7,'2020-04-11',3,3.00,4.00,'09:13:00'),(4,7,'2020-04-11',4,3.00,4.00,'12:17:00'),(4,7,'2020-04-11',4,4.00,4.00,'12:31:00'),(4,7,'2020-04-11',5,2.00,4.00,'09:11:00'),(4,7,'2020-04-11',5,2.00,4.00,'09:24:00'),(4,7,'2020-04-11',10,2.00,4.00,'12:08:00'),(4,7,'2020-04-11',11,2.00,4.00,'12:25:00'),(4,7,'2020-04-11',16,4.00,4.00,'12:15:00'),(4,7,'2020-04-11',16,5.00,4.00,'12:36:00'),(4,7,'2020-04-15',1,2.00,4.00,'18:44:00'),(4,7,'2020-04-15',2,3.00,4.00,'17:25:00'),(4,7,'2020-04-15',2,1.00,4.00,'17:36:00'),(4,7,'2020-04-15',8,5.00,4.00,'17:08:00'),(4,7,'2020-04-15',9,2.00,4.00,'18:25:00'),(4,7,'2020-04-15',9,1.00,4.00,'18:50:00'),(4,7,'2020-04-15',16,2.00,4.00,'16:59:00'),(4,7,'2020-04-15',16,4.00,4.00,'17:17:00'),(4,7,'2020-04-15',17,5.00,4.00,'18:51:00'),(4,7,'2020-04-15',18,2.00,4.00,'18:11:00'),(4,7,'2020-04-18',2,5.00,4.00,'13:39:00'),(4,7,'2020-04-18',3,5.00,4.00,'08:28:00'),(4,7,'2020-04-18',4,2.00,4.00,'09:02:00'),(4,7,'2020-04-18',10,5.00,4.00,'11:53:00'),(4,7,'2020-04-18',10,2.00,4.00,'12:04:00'),(4,7,'2020-04-18',16,5.00,4.00,'12:13:00'),(4,7,'2020-04-18',16,4.00,4.00,'12:27:00'),(4,7,'2020-04-18',17,4.00,4.00,'11:51:00'),(4,7,'2020-04-18',17,4.00,4.00,'13:22:00'),(4,7,'2020-04-22',2,3.00,3.50,'17:08:00'),(4,7,'2020-04-22',2,3.00,3.50,'17:29:00'),(4,7,'2020-04-22',3,5.00,3.50,'17:52:00'),(4,7,'2020-04-22',5,3.00,3.50,'18:55:00'),(4,7,'2020-04-22',7,4.00,3.50,'18:58:00'),(4,7,'2020-04-22',8,1.00,3.50,'18:08:00'),(4,7,'2020-04-22',8,1.00,3.50,'18:29:00'),(4,7,'2020-04-22',9,2.00,3.50,'18:46:00'),(4,7,'2020-04-22',15,5.00,3.50,'17:49:00'),(4,7,'2020-04-22',15,5.00,3.50,'17:57:00'),(4,7,'2020-04-22',16,4.00,3.50,'17:49:00'),(4,7,'2020-04-25',1,2.00,3.50,'11:39:00'),(4,7,'2020-04-25',1,2.00,3.50,'11:46:00'),(4,7,'2020-04-25',2,2.00,3.50,'12:05:00'),(4,7,'2020-04-25',2,3.00,3.50,'13:05:00'),(4,7,'2020-04-25',3,4.00,3.50,'08:45:00'),(4,7,'2020-04-25',3,4.00,3.50,'08:47:00'),(4,7,'2020-04-25',4,3.00,3.50,'10:42:00'),(4,7,'2020-04-25',5,3.00,3.50,'11:04:00'),(4,7,'2020-04-25',5,3.00,3.50,'11:59:00'),(4,7,'2020-04-25',6,4.00,3.50,'13:47:00'),(4,7,'2020-04-25',11,5.00,3.50,'10:54:00'),(4,7,'2020-04-29',2,5.00,4.00,'17:16:00'),(4,7,'2020-04-29',4,4.00,4.00,'18:51:00'),(4,7,'2020-04-29',6,4.00,4.00,'17:17:00'),(4,7,'2020-04-29',6,5.00,4.00,'17:45:00'),(4,7,'2020-04-29',7,2.00,4.00,'17:45:00'),(4,7,'2020-04-29',7,3.00,4.00,'17:46:00'),(4,7,'2020-04-29',12,4.00,4.00,'16:44:00'),(4,7,'2020-05-02',1,2.00,4.00,'12:40:00'),(4,7,'2020-05-02',2,1.00,4.00,'13:12:00'),(4,7,'2020-05-02',11,1.00,4.00,'11:18:00'),(4,7,'2020-05-02',11,4.00,4.00,'12:12:00'),(4,7,'2020-05-02',12,5.00,4.00,'09:07:00'),(4,7,'2020-05-02',13,1.00,4.00,'11:08:00'),(4,7,'2020-05-02',13,3.00,4.00,'11:10:00'),(4,7,'2020-05-06',1,3.00,4.00,'18:55:00'),(4,7,'2020-05-06',1,4.00,4.00,'18:58:00'),(4,7,'2020-05-06',2,3.00,4.00,'18:04:00'),(4,7,'2020-05-06',2,3.00,4.00,'18:15:00'),(4,7,'2020-05-06',3,2.00,4.00,'17:03:00'),(4,7,'2020-05-06',3,3.00,4.00,'17:06:00'),(4,7,'2020-05-06',7,5.00,4.00,'18:29:00'),(4,7,'2020-05-06',8,3.00,4.00,'18:39:00'),(4,7,'2020-05-06',10,4.00,4.00,'17:12:00'),(4,7,'2020-05-09',1,4.00,3.50,'09:04:00'),(4,7,'2020-05-09',4,5.00,3.50,'08:39:00'),(4,7,'2020-05-09',8,1.00,3.50,'12:32:00'),(4,7,'2020-05-09',8,1.00,3.50,'12:33:00'),(4,7,'2020-05-09',9,3.00,3.50,'09:58:00'),(4,7,'2020-05-09',10,5.00,3.50,'13:40:00'),(4,7,'2020-05-09',10,3.00,3.50,'13:44:00'),(4,7,'2020-05-09',12,1.00,3.50,'13:27:00'),(4,7,'2020-05-09',12,4.00,3.50,'13:38:00'),(4,7,'2020-05-13',6,1.00,4.00,'18:12:00'),(4,7,'2020-05-13',17,1.00,4.00,'16:53:00'),(4,7,'2020-05-13',17,1.00,4.00,'17:26:00'),(4,7,'2020-05-16',3,2.00,4.00,'09:59:00'),(4,7,'2020-05-16',6,1.00,4.00,'08:33:00'),(4,7,'2020-05-16',7,2.00,4.00,'10:09:00'),(4,7,'2020-05-16',11,2.00,4.00,'13:58:00'),(4,7,'2020-05-16',12,1.00,4.00,'12:37:00'),(4,7,'2020-05-16',12,2.00,4.00,'12:49:00'),(4,7,'2020-05-16',18,2.00,4.00,'13:19:00'),(4,7,'2020-05-20',1,1.00,4.00,'18:27:00'),(4,7,'2020-05-20',2,2.00,4.00,'17:17:00'),(4,7,'2020-05-20',4,2.00,4.00,'18:35:00'),(4,7,'2020-05-20',4,1.00,4.00,'18:52:00'),(4,7,'2020-05-20',9,5.00,4.00,'16:37:00'),(4,7,'2020-05-20',9,4.00,4.00,'17:23:00'),(4,7,'2020-05-20',13,4.00,4.00,'18:31:00'),(4,7,'2020-05-20',13,1.00,4.00,'18:48:00'),(4,7,'2020-05-20',18,5.00,4.00,'17:21:00'),(4,7,'2020-05-20',18,1.00,4.00,'18:01:00'),(4,7,'2020-05-23',1,5.00,4.00,'13:46:00'),(4,7,'2020-05-23',1,4.00,4.00,'13:49:00'),(4,7,'2020-05-23',3,3.00,4.00,'11:39:00'),(4,7,'2020-05-23',4,2.00,4.00,'11:21:00'),(4,7,'2020-05-23',6,2.00,4.00,'11:08:00'),(4,7,'2020-05-23',12,3.00,4.00,'13:48:00'),(4,7,'2020-05-23',12,3.00,4.00,'13:59:00'),(4,7,'2020-05-27',2,2.00,4.00,'17:37:00'),(4,7,'2020-05-27',3,5.00,4.00,'16:58:00'),(4,7,'2020-05-27',3,3.00,4.00,'17:13:00'),(4,7,'2020-05-27',4,3.00,4.00,'18:55:00'),(4,7,'2020-05-27',4,4.00,4.00,'18:57:00'),(4,7,'2020-05-27',8,2.00,4.00,'18:07:00'),(4,7,'2020-05-27',8,2.00,4.00,'18:10:00'),(4,7,'2020-05-27',12,1.00,4.00,'18:32:00'),(4,7,'2020-05-30',1,5.00,4.00,'13:37:00'),(4,7,'2020-05-30',3,1.00,4.00,'10:16:00'),(4,7,'2020-05-30',3,1.00,4.00,'10:25:00'),(4,7,'2020-05-30',5,1.00,4.00,'13:49:00'),(4,7,'2020-05-30',6,5.00,4.00,'12:01:00'),(4,7,'2020-05-30',7,4.00,4.00,'11:58:00'),(4,7,'2020-05-30',12,5.00,4.00,'12:42:00'),(4,7,'2020-05-30',14,1.00,4.00,'09:41:00'),(4,7,'2020-05-30',17,4.00,4.00,'11:08:00'),(4,7,'2020-05-30',18,2.00,4.00,'10:44:00'),(4,7,'2020-05-30',18,2.00,4.00,'11:01:00'),(4,7,'2020-06-03',5,1.00,4.00,'18:02:00'),(4,7,'2020-06-03',9,2.00,4.00,'17:45:00'),(4,7,'2020-06-03',10,1.00,4.00,'17:15:00'),(4,7,'2020-06-06',8,3.00,4.00,'09:25:00'),(4,7,'2020-06-06',8,3.00,4.00,'10:08:00'),(4,7,'2020-06-06',9,4.00,4.00,'12:15:00'),(4,7,'2020-06-06',10,2.00,4.00,'09:37:00'),(4,7,'2020-06-06',10,1.00,4.00,'10:24:00'),(4,7,'2020-06-06',11,3.00,4.00,'10:03:00'),(4,7,'2020-06-06',17,2.00,4.00,'12:06:00'),(4,7,'2020-06-06',17,3.00,4.00,'12:53:00'),(4,7,'2020-06-10',6,5.00,4.00,'17:21:00'),(4,7,'2020-06-10',6,3.00,4.00,'17:57:00'),(4,7,'2020-06-10',16,4.00,4.00,'16:46:00'),(4,7,'2020-06-10',16,3.00,4.00,'16:54:00'),(4,7,'2020-06-10',17,4.00,4.00,'17:04:00'),(4,7,'2020-06-10',17,4.00,4.00,'17:44:00'),(4,7,'2020-06-10',18,5.00,4.00,'16:36:00'),(4,7,'2020-06-10',18,5.00,4.00,'17:25:00'),(4,7,'2020-06-13',2,4.00,4.00,'13:39:00'),(4,7,'2020-06-13',2,4.00,4.00,'13:58:00'),(4,7,'2020-06-13',4,4.00,4.00,'08:37:00'),(4,7,'2020-06-13',7,4.00,4.00,'09:53:00'),(4,7,'2020-06-13',11,1.00,4.00,'12:20:00'),(4,7,'2020-06-13',16,4.00,4.00,'13:44:00'),(4,7,'2020-06-13',16,1.00,4.00,'13:55:00'),(4,7,'2020-06-13',17,5.00,4.00,'13:32:00'),(4,7,'2020-06-17',1,2.00,4.00,'17:00:00'),(4,7,'2020-06-17',1,2.00,4.00,'17:54:00'),(4,7,'2020-06-17',3,3.00,4.00,'18:44:00'),(4,7,'2020-06-17',7,4.00,4.00,'18:40:00'),(4,7,'2020-06-17',7,3.00,4.00,'18:52:00'),(4,7,'2020-06-17',9,1.00,4.00,'17:42:00'),(4,7,'2020-06-17',11,2.00,4.00,'18:47:00'),(4,7,'2020-06-17',11,3.00,4.00,'18:57:00'),(4,7,'2020-06-17',12,4.00,4.00,'18:27:00'),(4,7,'2020-06-17',15,5.00,4.00,'17:18:00'),(4,7,'2020-06-17',15,2.00,4.00,'17:43:00'),(4,7,'2020-06-20',3,5.00,3.50,'09:20:00'),(4,7,'2020-06-20',4,3.00,3.50,'13:43:00'),(4,7,'2020-06-20',5,5.00,3.50,'13:33:00'),(4,7,'2020-06-20',5,4.00,3.50,'13:55:00'),(4,7,'2020-06-20',7,2.00,3.50,'09:24:00'),(4,7,'2020-06-20',11,2.00,3.50,'09:36:00'),(4,7,'2020-06-20',11,2.00,3.50,'09:41:00'),(4,7,'2020-06-20',17,1.00,3.50,'09:01:00'),(4,7,'2020-06-20',17,3.00,3.50,'10:08:00'),(4,7,'2020-06-24',3,1.00,4.00,'18:33:00'),(4,7,'2020-06-24',7,5.00,4.00,'18:26:00'),(4,7,'2020-06-24',7,4.00,4.00,'18:48:00'),(4,7,'2020-06-24',10,1.00,4.00,'18:53:00'),(4,7,'2020-06-24',11,5.00,4.00,'18:19:00'),(4,7,'2020-06-24',11,4.00,4.00,'18:42:00'),(4,7,'2020-06-27',1,5.00,4.00,'12:05:00'),(4,7,'2020-06-27',1,3.00,4.00,'12:54:00'),(4,7,'2020-06-27',2,4.00,4.00,'09:13:00'),(4,7,'2020-06-27',3,2.00,4.00,'10:24:00'),(4,7,'2020-06-27',4,3.00,4.00,'12:58:00'),(4,7,'2020-06-27',6,3.00,4.00,'13:09:00'),(4,7,'2020-06-27',6,5.00,4.00,'13:32:00'),(4,7,'2020-06-27',12,1.00,4.00,'08:42:00'),(4,7,'2020-06-27',12,4.00,4.00,'08:46:00'),(4,7,'2020-07-01',18,5.00,4.00,'16:35:00'),(4,7,'2020-07-01',18,3.00,4.00,'17:34:00'),(4,7,'2020-07-04',2,5.00,3.50,'12:43:00'),(4,7,'2020-07-04',7,4.00,3.50,'13:15:00'),(4,7,'2020-07-04',8,1.00,3.50,'13:02:00'),(4,7,'2020-07-04',14,1.00,3.50,'09:28:00'),(4,7,'2020-07-04',17,4.00,3.50,'13:31:00'),(4,7,'2020-07-08',2,1.00,4.00,'18:25:00'),(4,7,'2020-07-08',3,3.00,4.00,'18:26:00'),(4,7,'2020-07-08',5,2.00,4.00,'18:56:00'),(4,7,'2020-07-08',6,5.00,4.00,'18:37:00'),(4,7,'2020-07-08',7,3.00,4.00,'16:58:00'),(4,7,'2020-07-08',9,3.00,4.00,'17:12:00'),(4,7,'2020-07-11',1,1.00,4.00,'08:19:00'),(4,7,'2020-07-11',3,4.00,4.00,'08:15:00'),(4,7,'2020-07-11',10,5.00,4.00,'11:04:00'),(4,7,'2020-07-11',10,1.00,4.00,'11:25:00'),(4,7,'2020-07-15',1,2.00,4.00,'18:42:00'),(4,7,'2020-07-15',7,5.00,4.00,'17:57:00'),(4,7,'2020-07-15',7,5.00,4.00,'18:10:00'),(4,7,'2020-07-15',18,5.00,4.00,'17:06:00'),(4,7,'2020-07-18',11,2.00,4.00,'13:45:00'),(4,7,'2020-07-18',13,3.00,4.00,'12:56:00'),(4,7,'2020-07-18',13,2.00,4.00,'13:03:00'),(4,7,'2020-07-22',7,1.00,4.00,'17:56:00'),(4,7,'2020-07-25',1,5.00,4.00,'12:11:00'),(4,7,'2020-07-25',2,4.00,4.00,'13:37:00'),(4,7,'2020-07-25',5,5.00,4.00,'13:57:00'),(4,7,'2020-07-25',7,2.00,4.00,'09:17:00'),(4,7,'2020-07-25',10,4.00,4.00,'11:18:00'),(4,7,'2020-07-25',10,3.00,4.00,'11:28:00'),(4,7,'2020-07-25',14,3.00,4.00,'10:33:00'),(4,7,'2020-07-25',14,1.00,4.00,'11:17:00'),(4,7,'2020-07-25',17,3.00,4.00,'11:33:00'),(4,7,'2020-07-29',2,4.00,4.00,'18:31:00'),(4,7,'2020-07-29',5,2.00,4.00,'18:47:00'),(4,7,'2020-07-29',6,5.00,4.00,'17:40:00'),(4,7,'2020-08-01',2,2.00,4.00,'08:42:00'),(4,7,'2020-08-01',2,2.00,4.00,'09:50:00'),(4,7,'2020-08-01',3,5.00,4.00,'10:27:00'),(4,7,'2020-08-05',3,1.00,4.00,'17:49:00'),(4,7,'2020-08-05',4,1.00,4.00,'16:55:00'),(4,7,'2020-08-05',6,5.00,4.00,'17:45:00'),(4,7,'2020-08-05',17,1.00,4.00,'18:30:00'),(4,7,'2020-08-08',1,1.00,4.00,'13:04:00'),(4,7,'2020-08-08',1,1.00,4.00,'13:05:00'),(4,7,'2020-08-08',4,2.00,4.00,'10:59:00'),(4,7,'2020-08-08',5,4.00,4.00,'13:02:00'),(4,7,'2020-08-08',5,4.00,4.00,'13:24:00'),(4,7,'2020-08-08',10,4.00,4.00,'10:14:00'),(4,7,'2020-08-08',10,1.00,4.00,'10:31:00'),(4,7,'2020-08-08',12,3.00,4.00,'09:54:00'),(4,7,'2020-08-12',3,3.00,4.00,'18:17:00'),(4,7,'2020-08-12',4,5.00,4.00,'18:55:00'),(4,7,'2020-08-12',4,3.00,4.00,'18:57:00'),(4,7,'2020-08-12',7,4.00,4.00,'17:43:00'),(4,7,'2020-08-12',9,2.00,4.00,'16:52:00'),(4,7,'2020-08-12',9,2.00,4.00,'17:16:00'),(4,7,'2020-08-12',18,2.00,4.00,'17:08:00'),(4,7,'2020-08-15',4,2.00,4.00,'13:42:00'),(4,7,'2020-08-15',6,3.00,4.00,'08:48:00'),(4,7,'2020-08-15',11,3.00,4.00,'13:33:00'),(4,7,'2020-08-15',11,1.00,4.00,'13:38:00'),(4,7,'2020-08-15',12,5.00,4.00,'11:35:00'),(4,7,'2020-08-15',13,5.00,4.00,'12:02:00'),(4,7,'2020-08-15',16,2.00,4.00,'12:06:00'),(4,7,'2020-08-15',16,3.00,4.00,'12:57:00'),(4,7,'2020-08-19',1,1.00,4.00,'18:15:00'),(4,7,'2020-08-19',2,5.00,4.00,'18:51:00'),(4,7,'2020-08-19',3,2.00,4.00,'18:53:00'),(4,7,'2020-08-19',3,2.00,4.00,'18:57:00'),(4,7,'2020-08-19',6,4.00,4.00,'18:38:00'),(4,7,'2020-08-19',11,2.00,4.00,'17:20:00'),(4,7,'2020-08-19',11,3.00,4.00,'17:58:00'),(4,7,'2020-08-22',2,2.00,4.00,'11:57:00'),(4,7,'2020-08-22',10,5.00,4.00,'13:54:00'),(4,7,'2020-08-22',14,2.00,4.00,'13:10:00'),(4,7,'2020-08-22',16,1.00,4.00,'13:07:00'),(4,7,'2020-08-26',1,3.00,3.50,'17:23:00'),(4,7,'2020-08-26',5,4.00,3.50,'18:37:00'),(4,7,'2020-08-26',5,5.00,3.50,'18:47:00'),(4,7,'2020-08-26',6,1.00,3.50,'17:21:00'),(4,7,'2020-08-26',8,5.00,3.50,'18:12:00'),(4,7,'2020-08-29',5,5.00,4.00,'08:03:00'),(4,7,'2020-08-29',5,5.00,4.00,'09:05:00'),(4,7,'2020-08-29',6,3.00,4.00,'11:19:00'),(4,7,'2020-08-29',6,5.00,4.00,'11:48:00'),(4,7,'2020-08-29',9,5.00,4.00,'12:28:00'),(4,7,'2020-08-29',13,4.00,4.00,'12:58:00'),(4,7,'2020-08-29',14,1.00,4.00,'12:58:00'),(4,7,'2020-08-29',18,2.00,4.00,'10:34:00'),(4,7,'2020-09-02',2,2.00,4.00,'17:40:00'),(4,7,'2020-09-02',2,2.00,4.00,'18:17:00'),(4,7,'2020-09-02',3,5.00,4.00,'17:49:00'),(4,7,'2020-09-02',7,4.00,4.00,'18:43:00'),(4,7,'2020-09-02',13,1.00,4.00,'18:37:00'),(4,7,'2020-09-05',4,1.00,4.00,'11:06:00'),(4,7,'2020-09-05',6,3.00,4.00,'13:36:00'),(4,7,'2020-09-05',10,5.00,4.00,'12:24:00'),(4,7,'2020-09-05',12,2.00,4.00,'10:26:00'),(4,7,'2020-09-05',17,2.00,4.00,'13:53:00'),(4,7,'2020-09-09',2,3.00,3.50,'18:45:00'),(4,7,'2020-09-09',5,5.00,3.50,'18:42:00'),(4,7,'2020-09-09',5,5.00,3.50,'18:51:00'),(4,7,'2020-09-09',7,2.00,3.50,'16:49:00'),(4,7,'2020-09-09',7,2.00,3.50,'17:39:00'),(4,7,'2020-09-09',11,4.00,3.50,'17:30:00'),(4,7,'2020-09-09',15,3.00,3.50,'18:35:00'),(4,7,'2020-09-12',2,5.00,3.50,'13:52:00'),(4,7,'2020-09-12',3,4.00,3.50,'11:27:00'),(4,7,'2020-09-12',5,3.00,3.50,'10:20:00'),(4,7,'2020-09-12',17,3.00,3.50,'11:14:00'),(4,7,'2020-09-16',7,3.00,4.00,'18:03:00'),(4,7,'2020-09-16',10,3.00,4.00,'16:55:00'),(4,7,'2020-09-16',10,3.00,4.00,'16:56:00'),(4,7,'2020-09-16',17,4.00,4.00,'17:09:00'),(4,7,'2020-09-19',1,4.00,4.00,'09:33:00'),(4,7,'2020-09-19',7,3.00,4.00,'09:32:00'),(4,7,'2020-09-19',9,2.00,4.00,'12:16:00'),(4,7,'2020-09-19',11,1.00,4.00,'11:07:00'),(4,7,'2020-09-19',11,2.00,4.00,'11:56:00'),(4,7,'2020-09-19',13,5.00,4.00,'10:15:00'),(4,7,'2020-09-19',13,4.00,4.00,'11:10:00'),(4,7,'2020-09-19',14,2.00,4.00,'13:35:00'),(4,7,'2020-09-19',15,5.00,4.00,'10:32:00'),(4,7,'2020-09-23',5,5.00,4.00,'17:48:00'),(4,7,'2020-09-23',7,4.00,4.00,'17:33:00'),(4,7,'2020-09-23',8,3.00,4.00,'16:56:00'),(4,7,'2020-09-23',12,2.00,4.00,'18:44:00'),(4,7,'2020-09-26',5,2.00,4.00,'08:46:00'),(4,7,'2020-09-26',10,3.00,4.00,'08:44:00'),(4,7,'2020-09-26',10,2.00,4.00,'08:50:00'),(4,7,'2020-09-26',18,5.00,4.00,'09:26:00'),(4,7,'2020-09-30',4,2.00,4.00,'17:56:00'),(4,7,'2020-09-30',4,2.00,4.00,'18:04:00'),(4,7,'2020-09-30',11,5.00,4.00,'18:02:00'),(4,7,'2020-09-30',12,3.00,4.00,'18:26:00'),(4,7,'2020-09-30',13,2.00,4.00,'17:26:00'),(4,7,'2020-09-30',15,1.00,4.00,'18:55:00'),(4,7,'2020-09-30',15,1.00,4.00,'18:58:00'),(4,7,'2020-09-30',17,2.00,4.00,'16:53:00'),(4,7,'2020-09-30',17,4.00,4.00,'17:40:00'),(4,7,'2020-10-03',2,1.00,4.00,'12:04:00'),(4,7,'2020-10-03',3,1.00,4.00,'10:12:00'),(4,7,'2020-10-03',5,5.00,4.00,'11:04:00'),(4,7,'2020-10-03',10,4.00,4.00,'12:09:00'),(4,7,'2020-10-03',11,3.00,4.00,'11:24:00'),(4,7,'2020-10-03',12,1.00,4.00,'10:00:00'),(4,7,'2020-10-03',12,2.00,4.00,'10:28:00'),(4,7,'2020-10-07',1,2.00,3.50,'17:53:00'),(4,7,'2020-10-07',1,4.00,3.50,'18:11:00'),(4,7,'2020-10-07',3,4.00,3.50,'17:55:00'),(4,7,'2020-10-07',7,2.00,3.50,'16:10:00'),(4,7,'2020-10-07',7,5.00,3.50,'16:45:00'),(4,7,'2020-10-07',15,5.00,3.50,'18:33:00'),(4,7,'2020-10-07',15,4.00,3.50,'18:38:00'),(4,7,'2020-10-10',1,5.00,3.50,'09:06:00'),(4,7,'2020-10-10',1,1.00,3.50,'09:07:00'),(4,7,'2020-10-10',2,4.00,3.50,'09:15:00'),(4,7,'2020-10-10',5,1.00,3.50,'13:20:00'),(4,7,'2020-10-10',5,4.00,3.50,'13:50:00'),(4,7,'2020-10-10',7,5.00,3.50,'08:52:00'),(4,7,'2020-10-10',11,5.00,3.50,'13:37:00'),(4,7,'2020-10-10',11,5.00,3.50,'13:50:00'),(5,8,'2019-04-03',6,1.00,6.50,'17:22:00'),(5,8,'2019-04-03',9,1.00,6.50,'16:40:00'),(5,8,'2019-04-03',9,1.00,6.50,'17:24:00'),(5,8,'2019-04-03',12,2.00,6.50,'18:06:00'),(5,8,'2019-04-03',16,1.00,6.50,'18:07:00'),(5,8,'2019-04-06',1,1.00,6.50,'13:10:00'),(5,8,'2019-04-06',2,1.00,6.50,'08:56:00'),(5,8,'2019-04-06',4,1.00,6.50,'08:44:00'),(5,8,'2019-04-06',11,1.00,6.50,'10:19:00'),(5,8,'2019-04-06',12,4.00,6.50,'10:15:00'),(5,8,'2019-04-06',17,1.00,6.50,'13:33:00'),(5,8,'2019-04-06',17,2.00,6.50,'13:42:00'),(5,8,'2019-04-06',18,4.00,6.50,'13:28:00'),(5,8,'2019-04-06',18,5.00,6.50,'13:35:00'),(5,8,'2019-04-06',21,3.00,6.50,'12:59:00'),(5,8,'2019-04-10',2,1.00,6.50,'18:13:00'),(5,8,'2019-04-10',9,2.00,6.50,'17:08:00'),(5,8,'2019-04-10',9,2.00,6.50,'17:12:00'),(5,8,'2019-04-10',11,1.00,6.50,'17:43:00'),(5,8,'2019-04-10',18,1.00,6.50,'17:09:00'),(5,8,'2019-04-10',20,3.00,6.50,'18:16:00'),(5,8,'2019-04-10',23,8.00,6.50,'17:28:00'),(5,8,'2019-04-10',25,4.00,6.50,'18:39:00'),(5,8,'2019-04-13',1,1.00,6.50,'09:54:00'),(5,8,'2019-04-13',21,3.00,6.50,'11:38:00'),(5,8,'2019-04-13',23,2.00,6.50,'09:59:00'),(5,8,'2019-04-17',4,2.00,6.50,'18:50:00'),(5,8,'2019-04-17',5,2.00,6.50,'16:34:00'),(5,8,'2019-04-17',7,2.00,6.50,'18:28:00'),(5,8,'2019-04-17',9,1.00,6.50,'17:44:00'),(5,8,'2019-04-17',10,2.00,6.50,'16:58:00'),(5,8,'2019-04-17',10,1.00,6.50,'17:07:00'),(5,8,'2019-04-20',1,2.00,6.50,'09:31:00'),(5,8,'2019-04-20',1,3.00,6.50,'10:30:00'),(5,8,'2019-04-20',8,1.00,6.50,'12:46:00'),(5,8,'2019-04-20',8,1.00,6.50,'12:49:00'),(5,8,'2019-04-20',17,3.00,6.50,'13:03:00'),(5,8,'2019-04-20',18,3.00,6.50,'10:09:00'),(5,8,'2019-04-20',23,4.00,6.50,'10:45:00'),(5,8,'2019-04-20',26,2.00,6.50,'08:56:00'),(5,8,'2019-04-24',1,2.00,6.50,'18:33:00'),(5,8,'2019-04-24',1,1.00,6.50,'18:40:00'),(5,8,'2019-04-24',4,1.00,6.50,'17:12:00'),(5,8,'2019-04-24',11,1.00,6.50,'18:09:00'),(5,8,'2019-04-24',12,1.00,6.50,'18:09:00'),(5,8,'2019-04-24',20,3.00,6.50,'18:55:00'),(5,8,'2019-04-24',25,3.00,6.50,'18:46:00'),(5,8,'2019-04-27',7,4.00,6.50,'11:53:00'),(5,8,'2019-04-27',13,2.00,6.50,'10:23:00'),(5,8,'2019-04-27',25,5.00,6.50,'11:22:00'),(5,8,'2019-04-27',26,3.00,6.50,'11:55:00'),(5,8,'2019-05-01',7,2.00,6.50,'18:56:00'),(5,8,'2019-05-01',8,1.00,6.50,'17:01:00'),(5,8,'2019-05-01',9,2.00,6.50,'18:16:00'),(5,8,'2019-05-01',10,2.00,6.50,'17:46:00'),(5,8,'2019-05-01',21,3.00,6.50,'17:22:00'),(5,8,'2019-05-01',21,3.00,6.50,'18:03:00'),(5,8,'2019-05-01',23,5.00,6.50,'16:32:00'),(5,8,'2019-05-01',23,4.00,6.50,'16:59:00'),(5,8,'2019-05-01',24,4.00,6.50,'17:58:00'),(5,8,'2019-05-04',1,1.00,6.50,'13:42:00'),(5,8,'2019-05-04',5,1.00,6.50,'13:29:00'),(5,8,'2019-05-04',9,2.00,6.50,'12:42:00'),(5,8,'2019-05-04',12,2.00,6.50,'10:22:00'),(5,8,'2019-05-04',17,1.00,6.50,'09:39:00'),(5,8,'2019-05-04',18,2.00,6.50,'11:46:00'),(5,8,'2019-05-04',26,5.00,6.50,'10:40:00'),(5,8,'2019-05-08',8,4.00,6.50,'17:03:00'),(5,8,'2019-05-08',8,2.00,6.50,'17:55:00'),(5,8,'2019-05-08',16,2.00,6.50,'18:30:00'),(5,8,'2019-05-08',16,4.00,6.50,'18:54:00'),(5,8,'2019-05-08',20,4.00,6.50,'18:54:00'),(5,8,'2019-05-08',25,5.00,6.50,'17:05:00'),(5,8,'2019-05-11',2,1.00,6.50,'13:27:00'),(5,8,'2019-05-11',7,1.00,6.50,'11:00:00'),(5,8,'2019-05-11',11,1.00,6.50,'11:40:00'),(5,8,'2019-05-11',12,2.00,6.50,'13:59:00'),(5,8,'2019-05-11',20,1.00,6.50,'12:21:00'),(5,8,'2019-05-11',23,2.00,6.50,'10:10:00'),(5,8,'2019-05-11',23,7.00,6.50,'10:39:00'),(5,8,'2019-05-11',24,5.00,6.50,'11:59:00'),(5,8,'2019-05-15',1,1.00,6.50,'18:18:00'),(5,8,'2019-05-15',3,1.00,6.50,'17:05:00'),(5,8,'2019-05-15',5,2.00,6.50,'17:39:00'),(5,8,'2019-05-15',5,1.00,6.50,'18:01:00'),(5,8,'2019-05-15',10,1.00,6.50,'17:19:00'),(5,8,'2019-05-15',12,1.00,6.50,'17:10:00'),(5,8,'2019-05-15',20,5.00,6.50,'16:36:00'),(5,8,'2019-05-15',21,5.00,6.50,'18:36:00'),(5,8,'2019-05-18',2,4.00,6.50,'11:22:00'),(5,8,'2019-05-18',23,1.00,6.50,'13:46:00'),(5,8,'2019-05-18',25,5.00,6.50,'13:38:00'),(5,8,'2019-05-18',25,5.00,6.50,'13:45:00'),(5,8,'2019-05-22',2,2.00,6.50,'18:14:00'),(5,8,'2019-05-22',3,1.00,6.50,'18:12:00'),(5,8,'2019-05-22',8,5.00,6.50,'17:11:00'),(5,8,'2019-05-22',8,1.00,6.50,'17:23:00'),(5,8,'2019-05-22',9,1.00,6.50,'18:01:00'),(5,8,'2019-05-22',9,3.00,6.50,'18:03:00'),(5,8,'2019-05-22',11,4.00,6.50,'17:54:00'),(5,8,'2019-05-22',11,5.00,6.50,'18:27:00'),(5,8,'2019-05-22',24,2.00,6.50,'18:23:00'),(5,8,'2019-05-25',8,2.00,6.50,'11:06:00'),(5,8,'2019-05-25',12,2.00,6.50,'13:48:00'),(5,8,'2019-05-25',16,4.00,6.50,'09:38:00'),(5,8,'2019-05-25',21,2.00,6.50,'10:27:00'),(5,8,'2019-05-25',23,3.00,6.50,'09:28:00'),(5,8,'2019-05-29',3,2.00,6.50,'17:31:00'),(5,8,'2019-05-29',3,1.00,6.50,'17:45:00'),(5,8,'2019-05-29',4,2.00,6.50,'17:04:00'),(5,8,'2019-05-29',4,2.00,6.50,'17:23:00'),(5,8,'2019-05-29',5,2.00,6.50,'18:17:00'),(5,8,'2019-05-29',19,4.00,6.50,'18:50:00'),(5,8,'2019-05-29',19,2.00,6.50,'18:54:00'),(5,8,'2019-05-29',22,3.00,6.50,'16:50:00'),(5,8,'2019-06-01',1,1.00,6.50,'08:50:00'),(5,8,'2019-06-01',1,2.00,6.50,'09:28:00'),(5,8,'2019-06-01',2,1.00,6.50,'09:14:00'),(5,8,'2019-06-01',4,2.00,6.50,'11:19:00'),(5,8,'2019-06-01',16,1.00,6.50,'12:37:00'),(5,8,'2019-06-01',20,4.00,6.50,'13:52:00'),(5,8,'2019-06-05',12,1.00,6.50,'18:47:00'),(5,8,'2019-06-05',23,2.00,6.50,'16:51:00'),(5,8,'2019-06-05',26,3.00,6.50,'18:20:00'),(5,8,'2019-06-08',2,1.00,6.50,'13:06:00'),(5,8,'2019-06-08',6,1.00,6.50,'12:14:00'),(5,8,'2019-06-08',6,4.00,6.50,'12:16:00'),(5,8,'2019-06-08',7,1.00,6.50,'10:28:00'),(5,8,'2019-06-08',14,2.00,6.50,'13:51:00'),(5,8,'2019-06-08',15,4.00,6.50,'11:56:00'),(5,8,'2019-06-08',18,1.00,6.50,'08:41:00'),(5,8,'2019-06-08',18,4.00,6.50,'09:22:00'),(5,8,'2019-06-08',21,2.00,6.50,'12:54:00'),(5,8,'2019-06-08',25,1.00,6.50,'11:13:00'),(5,8,'2019-06-08',25,3.00,6.50,'11:37:00'),(5,8,'2019-06-12',5,2.00,6.50,'16:51:00'),(5,8,'2019-06-12',7,2.00,6.50,'18:57:00'),(5,8,'2019-06-12',20,5.00,6.50,'17:51:00'),(5,8,'2019-06-12',20,5.00,6.50,'18:59:00'),(5,8,'2019-06-12',24,4.00,6.50,'18:46:00'),(5,8,'2019-06-15',1,3.00,6.50,'10:18:00'),(5,8,'2019-06-15',6,4.00,6.50,'11:24:00'),(5,8,'2019-06-15',16,5.00,6.50,'13:06:00'),(5,8,'2019-06-15',16,4.00,6.50,'13:28:00'),(5,8,'2019-06-15',25,2.00,6.50,'11:26:00'),(5,8,'2019-06-19',3,1.00,6.50,'18:55:00'),(5,8,'2019-06-19',9,2.00,6.50,'16:29:00'),(5,8,'2019-06-19',15,2.00,6.50,'17:40:00'),(5,8,'2019-06-19',17,2.00,6.50,'17:39:00'),(5,8,'2019-06-19',20,2.00,6.50,'17:30:00'),(5,8,'2019-06-19',21,4.00,6.50,'17:58:00'),(5,8,'2019-06-22',1,1.00,6.50,'08:54:00'),(5,8,'2019-06-22',2,1.00,6.50,'12:33:00'),(5,8,'2019-06-22',6,2.00,6.50,'13:59:00'),(5,8,'2019-06-22',11,2.00,6.50,'08:34:00'),(5,8,'2019-06-22',17,1.00,6.50,'11:49:00'),(5,8,'2019-06-22',24,4.00,6.50,'11:33:00'),(5,8,'2019-06-22',26,4.00,6.50,'13:14:00'),(5,8,'2019-06-26',4,1.00,6.50,'18:56:00'),(5,8,'2019-06-26',6,1.00,6.50,'17:38:00'),(5,8,'2019-06-26',6,1.00,6.50,'17:42:00'),(5,8,'2019-06-26',7,2.00,6.50,'17:47:00'),(5,8,'2019-06-26',7,1.00,6.50,'18:02:00'),(5,8,'2019-06-26',12,2.00,6.50,'18:59:00'),(5,8,'2019-06-26',16,1.00,6.50,'18:58:00'),(5,8,'2019-06-26',26,4.00,6.50,'18:54:00'),(5,8,'2019-06-26',26,5.00,6.50,'18:55:00'),(5,8,'2019-06-29',1,2.00,6.50,'10:59:00'),(5,8,'2019-06-29',6,1.00,6.50,'09:48:00'),(5,8,'2019-06-29',7,5.00,6.50,'10:01:00'),(5,8,'2019-06-29',7,4.00,6.50,'10:56:00'),(5,8,'2019-06-29',10,2.00,6.50,'09:07:00'),(5,8,'2019-06-29',12,1.00,6.50,'13:37:00'),(5,8,'2019-06-29',13,2.00,6.50,'08:46:00'),(5,8,'2019-06-29',15,2.00,6.50,'13:44:00'),(5,8,'2019-06-29',24,4.00,6.50,'09:35:00'),(5,8,'2019-06-29',25,3.00,6.50,'08:43:00'),(5,8,'2019-07-03',8,3.00,6.50,'18:51:00'),(5,8,'2019-07-03',9,2.00,6.50,'18:22:00'),(5,8,'2019-07-03',12,4.00,6.50,'18:12:00'),(5,8,'2019-07-03',13,2.00,6.50,'18:42:00'),(5,8,'2019-07-03',13,1.00,6.50,'18:46:00'),(5,8,'2019-07-06',2,1.00,6.50,'09:04:00'),(5,8,'2019-07-06',2,5.00,6.50,'09:32:00'),(5,8,'2019-07-06',3,3.00,6.50,'10:27:00'),(5,8,'2019-07-06',3,4.00,6.50,'10:36:00'),(5,8,'2019-07-06',19,4.00,6.50,'09:40:00'),(5,8,'2019-07-06',19,1.00,6.50,'10:31:00'),(5,8,'2019-07-10',1,2.00,6.50,'18:50:00'),(5,8,'2019-07-10',11,4.00,6.50,'16:44:00'),(5,8,'2019-07-10',12,5.00,6.50,'18:12:00'),(5,8,'2019-07-10',26,2.00,6.50,'18:47:00'),(5,8,'2019-07-13',11,2.00,6.50,'12:28:00'),(5,8,'2019-07-13',18,2.00,6.50,'09:59:00'),(5,8,'2019-07-13',23,1.00,6.50,'10:25:00'),(5,8,'2019-07-17',1,3.00,6.50,'18:29:00'),(5,8,'2019-07-17',1,1.00,6.50,'18:43:00'),(5,8,'2019-07-17',4,3.00,6.50,'17:32:00'),(5,8,'2019-07-17',11,5.00,6.50,'17:05:00'),(5,8,'2019-07-17',16,2.00,6.50,'18:55:00'),(5,8,'2019-07-17',17,1.00,6.50,'17:57:00'),(5,8,'2019-07-17',17,1.00,6.50,'18:18:00'),(5,8,'2019-07-17',18,1.00,6.50,'17:19:00'),(5,8,'2019-07-17',21,3.00,6.50,'18:53:00'),(5,8,'2019-07-20',8,4.00,6.50,'12:17:00'),(5,8,'2019-07-20',9,2.00,6.50,'09:02:00'),(5,8,'2019-07-20',12,5.00,6.50,'11:59:00'),(5,8,'2019-07-24',6,1.00,6.50,'18:00:00'),(5,8,'2019-07-27',1,3.00,6.50,'13:31:00'),(5,8,'2019-07-27',1,3.00,6.50,'13:40:00'),(5,8,'2019-07-27',3,4.00,6.50,'13:35:00'),(5,8,'2019-07-27',12,4.00,6.50,'13:59:00'),(5,8,'2019-07-27',16,5.00,6.50,'08:48:00'),(5,8,'2019-07-27',16,1.00,6.50,'09:06:00'),(5,8,'2019-07-31',9,4.00,6.50,'17:57:00'),(5,8,'2019-07-31',19,5.00,6.50,'18:00:00'),(5,8,'2019-07-31',22,6.00,6.50,'17:17:00'),(5,8,'2019-08-03',5,2.00,6.50,'09:24:00'),(5,8,'2019-08-03',5,2.00,6.50,'09:30:00'),(5,8,'2019-08-03',18,4.00,6.50,'10:21:00'),(5,8,'2019-08-03',25,3.00,6.50,'12:46:00'),(5,8,'2019-08-03',25,4.00,6.50,'13:27:00'),(5,8,'2019-08-07',5,5.00,6.50,'17:34:00'),(5,8,'2019-08-07',7,5.00,6.50,'18:59:00'),(5,8,'2019-08-07',8,5.00,6.50,'17:14:00'),(5,8,'2019-08-07',19,1.00,6.50,'18:05:00'),(5,8,'2019-08-07',24,5.00,6.50,'18:38:00'),(5,8,'2019-08-10',7,2.00,6.50,'10:06:00'),(5,8,'2019-08-10',9,2.00,6.50,'09:04:00'),(5,8,'2019-08-10',10,2.00,6.50,'13:48:00'),(5,8,'2019-08-14',10,3.00,6.50,'18:08:00'),(5,8,'2019-08-14',14,2.00,6.50,'18:06:00'),(5,8,'2019-08-14',14,4.00,6.50,'18:44:00'),(5,8,'2019-08-14',16,5.00,6.50,'18:40:00'),(5,8,'2019-08-14',19,3.00,6.50,'17:20:00'),(5,8,'2019-08-14',25,2.00,6.50,'18:28:00'),(5,8,'2019-08-17',9,1.00,6.50,'12:46:00'),(5,8,'2019-08-17',9,5.00,6.50,'13:22:00'),(5,8,'2019-08-17',16,5.00,6.50,'13:10:00'),(5,8,'2019-08-17',16,5.00,6.50,'13:21:00'),(5,8,'2019-08-17',26,4.00,6.50,'13:53:00'),(5,8,'2019-08-21',4,2.00,6.50,'18:42:00'),(5,8,'2019-08-21',8,2.00,6.50,'17:39:00'),(5,8,'2019-08-21',15,4.00,6.50,'18:50:00'),(5,8,'2019-08-21',20,1.00,6.50,'17:42:00'),(5,8,'2019-08-24',4,3.00,6.50,'12:03:00'),(5,8,'2019-08-24',9,2.00,6.50,'11:56:00'),(5,8,'2019-08-24',14,2.00,6.50,'12:59:00'),(5,8,'2019-08-24',14,4.00,6.50,'13:24:00'),(5,8,'2019-08-24',20,2.00,6.50,'10:50:00'),(5,8,'2019-08-28',7,4.00,6.50,'17:03:00'),(5,8,'2019-08-28',9,1.00,6.50,'18:52:00'),(5,8,'2019-08-28',13,3.00,6.50,'16:40:00'),(5,8,'2019-08-28',20,4.00,6.50,'17:48:00'),(5,8,'2019-08-28',22,3.00,6.50,'18:36:00'),(5,8,'2019-08-31',12,1.00,6.50,'10:02:00'),(5,8,'2019-08-31',24,3.00,6.50,'10:36:00'),(5,8,'2019-08-31',26,3.00,6.50,'08:48:00'),(5,8,'2019-09-04',1,2.00,6.50,'18:58:00'),(5,8,'2019-09-04',14,4.00,6.50,'17:06:00'),(5,8,'2019-09-04',16,5.00,6.50,'16:51:00'),(5,8,'2019-09-11',3,1.00,6.50,'18:31:00'),(5,8,'2019-09-11',5,2.00,6.50,'18:37:00'),(5,8,'2019-09-11',16,4.00,6.50,'18:52:00'),(5,8,'2019-09-11',17,5.00,6.50,'17:33:00'),(5,8,'2019-09-14',5,3.00,6.50,'12:18:00'),(5,8,'2019-09-14',6,2.00,6.50,'12:56:00'),(5,8,'2019-09-14',9,2.00,6.50,'12:22:00'),(5,8,'2019-09-14',11,4.00,6.50,'11:20:00'),(5,8,'2019-09-14',12,4.00,6.50,'10:33:00'),(5,8,'2019-09-14',12,5.00,6.50,'10:35:00'),(5,8,'2019-09-14',19,1.00,6.50,'09:54:00'),(5,8,'2019-09-18',3,2.00,6.50,'16:43:00'),(5,8,'2019-09-18',4,2.00,6.50,'17:13:00'),(5,8,'2019-09-18',7,1.00,6.50,'18:26:00'),(5,8,'2019-09-18',8,2.00,6.50,'16:22:00'),(5,8,'2019-09-18',8,2.00,6.50,'17:14:00'),(5,8,'2019-09-18',15,1.00,6.50,'18:14:00'),(5,8,'2019-09-18',18,1.00,6.50,'18:12:00'),(5,8,'2019-09-21',5,2.00,6.50,'10:30:00'),(5,8,'2019-09-21',8,4.00,6.50,'08:18:00'),(5,8,'2019-09-21',8,4.00,6.50,'09:05:00'),(5,8,'2019-09-21',15,1.00,6.50,'11:33:00'),(5,8,'2019-09-21',19,1.00,6.50,'09:01:00'),(5,8,'2019-09-21',24,4.00,6.50,'11:38:00'),(5,8,'2019-09-25',1,5.00,6.50,'18:20:00'),(5,8,'2019-09-25',4,3.00,6.50,'18:09:00'),(5,8,'2019-09-25',5,1.00,6.50,'17:09:00'),(5,8,'2019-09-25',6,2.00,6.50,'18:48:00'),(5,8,'2019-09-25',21,4.00,6.50,'17:34:00'),(5,8,'2019-09-25',23,1.00,6.50,'17:37:00'),(5,8,'2019-09-28',1,1.00,6.50,'10:02:00'),(5,8,'2019-09-28',2,2.00,6.50,'10:50:00'),(5,8,'2019-09-28',6,5.00,6.50,'10:48:00'),(5,8,'2019-09-28',17,1.00,6.50,'09:49:00'),(5,8,'2019-10-02',3,4.00,6.50,'18:31:00'),(5,8,'2019-10-02',3,1.00,6.50,'18:43:00'),(5,8,'2019-10-02',8,1.00,6.50,'18:41:00'),(5,8,'2019-10-02',8,3.00,6.50,'18:44:00'),(5,8,'2019-10-02',11,4.00,6.50,'17:46:00'),(5,8,'2019-10-02',11,5.00,6.50,'17:58:00'),(5,8,'2019-10-02',26,2.00,6.50,'18:10:00'),(5,8,'2019-10-02',26,2.00,6.50,'18:34:00'),(5,8,'2019-10-05',1,1.00,6.50,'08:32:00'),(5,8,'2019-10-05',1,3.00,6.50,'09:03:00'),(5,8,'2019-10-05',4,2.00,6.50,'12:12:00'),(5,8,'2019-10-05',5,4.00,6.50,'13:38:00'),(5,8,'2019-10-05',7,4.00,6.50,'12:29:00'),(5,8,'2019-10-05',7,2.00,6.50,'12:32:00'),(5,8,'2019-10-05',23,3.00,6.50,'13:59:00'),(5,8,'2019-10-09',2,4.00,6.50,'17:57:00'),(5,8,'2019-10-09',5,2.00,6.50,'17:59:00'),(5,8,'2019-10-09',19,5.00,6.50,'17:29:00'),(5,8,'2019-10-09',20,4.00,6.50,'16:40:00'),(5,8,'2019-10-12',3,2.00,6.50,'13:48:00'),(5,8,'2019-10-12',7,2.00,6.50,'10:59:00'),(5,8,'2019-10-12',7,2.00,6.50,'12:03:00'),(5,8,'2019-10-12',20,4.00,6.50,'12:45:00'),(5,8,'2019-10-12',20,4.00,6.50,'13:30:00'),(5,8,'2019-10-12',22,5.00,6.50,'11:49:00'),(5,8,'2019-10-16',1,2.00,6.50,'16:34:00'),(5,8,'2019-10-16',2,2.00,6.50,'16:34:00'),(5,8,'2019-10-16',2,1.00,6.50,'17:25:00'),(5,8,'2019-10-16',3,3.00,6.50,'18:42:00'),(5,8,'2019-10-16',4,1.00,6.50,'18:54:00'),(5,8,'2019-10-16',17,2.00,6.50,'17:08:00'),(5,8,'2019-10-16',18,3.00,6.50,'18:50:00'),(5,8,'2019-10-16',18,3.00,6.50,'18:54:00'),(5,8,'2019-10-16',19,3.00,6.50,'18:42:00'),(5,8,'2019-10-16',22,4.00,6.50,'18:27:00'),(5,8,'2019-10-19',11,5.00,6.50,'10:47:00'),(5,8,'2019-10-19',11,5.00,6.50,'11:21:00'),(5,8,'2019-10-19',12,1.00,6.50,'09:47:00'),(5,8,'2019-10-19',12,3.00,6.50,'10:23:00'),(5,8,'2019-10-19',14,4.00,6.50,'10:25:00'),(5,8,'2019-10-19',21,5.00,6.50,'11:22:00'),(5,8,'2019-10-19',26,3.00,6.50,'08:15:00'),(5,8,'2019-10-23',3,1.00,6.50,'18:44:00'),(5,8,'2019-10-23',5,1.00,6.50,'17:01:00'),(5,8,'2019-10-23',7,2.00,6.50,'18:55:00'),(5,8,'2019-10-23',9,2.00,6.50,'16:38:00'),(5,8,'2019-10-23',11,1.00,6.50,'18:23:00'),(5,8,'2019-10-23',19,3.00,6.50,'18:53:00'),(5,8,'2019-10-23',19,1.00,6.50,'18:54:00'),(5,8,'2019-10-23',25,4.00,6.50,'18:32:00'),(5,8,'2019-10-23',26,1.00,6.50,'18:35:00'),(5,8,'2019-10-26',10,1.00,6.50,'13:49:00'),(5,8,'2019-10-26',11,3.00,6.50,'13:26:00'),(5,8,'2019-10-26',11,5.00,6.50,'13:48:00'),(5,8,'2019-10-26',13,3.00,6.50,'11:51:00'),(5,8,'2019-10-26',15,3.00,6.50,'10:45:00'),(5,8,'2019-10-26',16,1.00,6.50,'13:47:00'),(5,8,'2019-10-26',18,2.00,6.50,'13:56:00'),(5,8,'2019-10-26',21,2.00,6.50,'13:23:00'),(5,8,'2019-10-26',23,5.00,6.50,'09:24:00'),(5,8,'2019-10-30',5,1.00,6.50,'16:24:00'),(5,8,'2019-10-30',5,2.00,6.50,'16:56:00'),(5,8,'2019-10-30',7,2.00,6.50,'18:39:00'),(5,8,'2019-10-30',7,2.00,6.50,'18:44:00'),(5,8,'2019-10-30',13,2.00,6.50,'18:41:00'),(5,8,'2019-10-30',13,1.00,6.50,'18:48:00'),(5,8,'2019-10-30',24,1.00,6.50,'18:49:00'),(5,8,'2019-10-30',25,7.00,6.50,'18:17:00'),(5,8,'2019-10-30',26,2.00,6.50,'18:21:00'),(5,8,'2019-11-02',2,2.00,6.50,'13:43:00'),(5,8,'2019-11-02',9,1.00,6.50,'09:34:00'),(5,8,'2019-11-02',9,1.00,6.50,'09:59:00'),(5,8,'2019-11-02',10,1.00,6.50,'11:09:00'),(5,8,'2019-11-02',13,2.00,6.50,'13:40:00'),(5,8,'2019-11-02',19,3.00,6.50,'12:54:00'),(5,8,'2019-11-02',19,4.00,6.50,'13:42:00'),(5,8,'2019-11-06',5,4.00,6.50,'17:20:00'),(5,8,'2019-11-06',9,2.00,6.50,'18:07:00'),(5,8,'2019-11-06',19,3.00,6.50,'16:29:00'),(5,8,'2019-11-09',8,2.00,6.50,'12:44:00'),(5,8,'2019-11-09',9,2.00,6.50,'08:45:00'),(5,8,'2019-11-09',9,4.00,6.50,'09:04:00'),(5,8,'2019-11-09',19,2.00,6.50,'13:45:00'),(5,8,'2019-11-09',19,4.00,6.50,'13:53:00'),(5,8,'2019-11-09',22,4.00,6.50,'10:18:00'),(5,8,'2019-11-09',26,3.00,6.50,'13:24:00'),(5,8,'2019-11-13',2,1.00,6.50,'17:35:00'),(5,8,'2019-11-13',2,2.00,6.50,'17:56:00'),(5,8,'2019-11-13',14,1.00,6.50,'17:54:00'),(5,8,'2019-11-13',14,2.00,6.50,'18:22:00'),(5,8,'2019-11-13',22,5.00,6.50,'18:40:00'),(5,8,'2019-11-13',24,2.00,6.50,'16:23:00'),(5,8,'2019-11-13',25,4.00,6.50,'17:43:00'),(5,8,'2019-11-16',5,4.00,6.50,'12:58:00'),(5,8,'2019-11-16',8,4.00,6.50,'13:35:00'),(5,8,'2019-11-16',22,1.00,6.50,'13:14:00'),(5,8,'2019-11-20',1,1.00,6.50,'18:57:00'),(5,8,'2019-11-20',1,1.00,6.50,'18:58:00'),(5,8,'2019-11-20',5,5.00,6.50,'17:22:00'),(5,8,'2019-11-20',8,1.00,6.50,'16:05:00'),(5,8,'2019-11-20',11,2.00,6.50,'18:42:00'),(5,8,'2019-11-20',14,2.00,6.50,'17:25:00'),(5,8,'2019-11-20',14,1.00,6.50,'18:20:00'),(5,8,'2019-11-20',15,5.00,6.50,'17:04:00'),(5,8,'2019-11-20',15,1.00,6.50,'17:51:00'),(5,8,'2019-11-20',18,4.00,6.50,'17:56:00'),(5,8,'2019-11-20',25,2.00,6.50,'18:26:00'),(5,8,'2019-11-23',2,2.00,6.50,'11:19:00'),(5,8,'2019-11-23',10,1.00,6.50,'10:35:00'),(5,8,'2019-11-23',12,1.00,6.50,'11:04:00'),(5,8,'2019-11-23',17,2.00,6.50,'11:04:00'),(5,8,'2019-11-23',22,4.00,6.50,'10:49:00'),(5,8,'2019-11-27',8,2.00,6.50,'18:53:00'),(5,8,'2019-11-27',13,4.00,6.50,'18:55:00'),(5,8,'2019-11-27',22,3.00,6.50,'17:46:00'),(5,8,'2019-11-27',24,3.00,6.50,'18:29:00'),(5,8,'2019-11-30',4,1.00,6.50,'12:08:00'),(5,8,'2019-11-30',5,1.00,6.50,'09:07:00'),(5,8,'2019-11-30',6,2.00,6.50,'13:28:00'),(5,8,'2019-11-30',8,1.00,6.50,'09:22:00'),(5,8,'2019-11-30',8,1.00,6.50,'10:17:00'),(5,8,'2019-11-30',23,3.00,6.50,'13:05:00'),(5,8,'2019-12-04',5,1.00,6.50,'17:01:00'),(5,8,'2019-12-04',9,1.00,6.50,'17:38:00'),(5,8,'2019-12-04',10,1.00,6.50,'17:10:00'),(5,8,'2019-12-04',17,2.00,6.50,'16:38:00'),(5,8,'2019-12-04',19,1.00,6.50,'17:09:00'),(5,8,'2019-12-04',24,5.00,6.50,'16:21:00'),(5,8,'2019-12-04',25,6.00,6.50,'16:41:00'),(5,8,'2019-12-04',25,5.00,6.50,'16:56:00'),(5,8,'2019-12-07',4,5.00,6.50,'12:23:00'),(5,8,'2019-12-07',8,1.00,6.50,'13:56:00'),(5,8,'2019-12-07',10,2.00,6.50,'13:44:00'),(5,8,'2019-12-07',10,3.00,6.50,'13:58:00'),(5,8,'2019-12-07',12,5.00,6.50,'11:57:00'),(5,8,'2019-12-07',15,1.00,6.50,'09:19:00'),(5,8,'2019-12-07',21,2.00,6.50,'10:31:00'),(5,8,'2019-12-07',26,4.00,6.50,'13:27:00'),(5,8,'2019-12-11',2,2.00,6.50,'18:37:00'),(5,8,'2019-12-11',2,5.00,6.50,'18:50:00'),(5,8,'2019-12-11',16,1.00,6.50,'17:09:00'),(5,8,'2019-12-11',18,3.00,6.50,'17:20:00'),(5,8,'2019-12-11',18,4.00,6.50,'18:24:00'),(5,8,'2019-12-11',20,1.00,6.50,'16:51:00'),(5,8,'2019-12-11',23,1.00,6.50,'18:09:00'),(5,8,'2019-12-14',1,3.00,6.50,'13:51:00'),(5,8,'2019-12-14',1,1.00,6.50,'13:52:00'),(5,8,'2019-12-14',3,4.00,6.50,'13:37:00'),(5,8,'2019-12-14',7,1.00,6.50,'13:35:00'),(5,8,'2019-12-14',8,4.00,6.50,'08:17:00'),(5,8,'2019-12-14',12,2.00,6.50,'11:44:00'),(5,8,'2019-12-14',14,3.00,6.50,'11:20:00'),(5,8,'2019-12-14',24,3.00,6.50,'09:34:00'),(5,8,'2019-12-18',11,3.00,6.50,'17:28:00'),(5,8,'2019-12-18',11,4.00,6.50,'17:57:00'),(5,8,'2019-12-18',14,4.00,6.50,'18:28:00'),(5,8,'2019-12-18',14,1.00,6.50,'18:35:00'),(5,8,'2019-12-18',16,4.00,6.50,'17:50:00'),(5,8,'2019-12-18',17,1.00,6.50,'16:58:00'),(5,8,'2019-12-18',25,1.00,6.50,'18:49:00'),(5,8,'2019-12-21',3,4.00,6.50,'09:17:00'),(5,8,'2019-12-21',8,4.00,6.50,'12:51:00'),(5,8,'2019-12-21',24,3.00,6.50,'10:12:00'),(5,8,'2019-12-25',14,4.00,6.50,'18:56:00'),(5,8,'2019-12-25',24,3.00,6.50,'17:01:00'),(5,8,'2019-12-25',24,4.00,6.50,'17:22:00'),(5,8,'2019-12-28',6,1.00,6.50,'11:58:00'),(5,8,'2019-12-28',6,2.00,6.50,'13:03:00'),(5,8,'2019-12-28',15,2.00,6.50,'09:51:00'),(5,8,'2019-12-28',15,1.00,6.50,'10:22:00'),(5,8,'2019-12-28',24,2.00,6.50,'13:43:00'),(5,8,'2019-12-28',24,4.00,6.50,'13:51:00'),(5,8,'2019-12-28',26,6.00,6.50,'09:38:00'),(5,8,'2020-03-04',3,1.00,6.50,'17:16:00'),(5,8,'2020-03-04',3,1.00,6.50,'17:26:00'),(5,8,'2020-03-04',4,2.00,6.50,'16:42:00'),(5,8,'2020-03-04',5,2.00,6.50,'17:44:00'),(5,8,'2020-03-04',16,2.00,6.50,'17:08:00'),(5,8,'2020-03-04',19,4.00,6.50,'18:48:00'),(5,8,'2020-03-04',19,3.00,6.50,'18:50:00'),(5,8,'2020-03-04',24,2.00,6.50,'18:32:00'),(5,8,'2020-03-07',2,1.00,6.50,'12:45:00'),(5,8,'2020-03-07',3,4.00,6.50,'11:06:00'),(5,8,'2020-03-07',4,5.00,6.50,'13:40:00'),(5,8,'2020-03-07',4,1.00,6.50,'13:41:00'),(5,8,'2020-03-07',5,1.00,6.50,'09:05:00'),(5,8,'2020-03-07',5,1.00,6.50,'10:03:00'),(5,8,'2020-03-07',9,3.00,6.50,'09:32:00'),(5,8,'2020-03-07',14,1.00,6.50,'12:00:00'),(5,8,'2020-03-11',1,1.00,6.50,'18:43:00'),(5,8,'2020-03-11',3,1.00,6.50,'18:53:00'),(5,8,'2020-03-11',4,1.00,6.50,'18:45:00'),(5,8,'2020-03-11',4,2.00,6.50,'18:54:00'),(5,8,'2020-03-11',5,1.00,6.50,'16:40:00'),(5,8,'2020-03-11',8,1.00,6.50,'18:38:00'),(5,8,'2020-03-11',20,5.00,6.50,'18:50:00'),(5,8,'2020-03-11',24,5.00,6.50,'16:47:00'),(5,8,'2020-03-14',2,1.00,6.50,'12:00:00'),(5,8,'2020-03-14',2,1.00,6.50,'12:41:00'),(5,8,'2020-03-14',7,2.00,6.50,'11:27:00'),(5,8,'2020-03-14',8,2.00,6.50,'13:53:00'),(5,8,'2020-03-14',24,4.00,6.50,'09:16:00'),(5,8,'2020-03-18',3,1.00,6.50,'18:27:00'),(5,8,'2020-03-18',3,2.00,6.50,'18:36:00'),(5,8,'2020-03-18',8,1.00,6.50,'16:53:00'),(5,8,'2020-03-18',8,1.00,6.50,'16:59:00'),(5,8,'2020-03-18',13,4.00,6.50,'17:56:00'),(5,8,'2020-03-18',13,4.00,6.50,'18:33:00'),(5,8,'2020-03-18',22,1.00,6.50,'16:10:00'),(5,8,'2020-03-18',22,2.00,6.50,'16:40:00'),(5,8,'2020-03-18',26,3.00,6.50,'17:09:00'),(5,8,'2020-03-21',8,2.00,6.50,'10:03:00'),(5,8,'2020-03-21',12,2.00,6.50,'11:33:00'),(5,8,'2020-03-21',22,3.00,6.50,'10:01:00'),(5,8,'2020-03-25',9,1.00,6.50,'18:03:00'),(5,8,'2020-03-25',13,1.00,6.50,'18:34:00'),(5,8,'2020-03-25',21,3.00,6.50,'16:17:00'),(5,8,'2020-03-25',21,4.00,6.50,'16:49:00'),(5,8,'2020-03-25',22,3.00,6.50,'18:53:00'),(5,8,'2020-03-25',22,1.00,6.50,'18:57:00'),(5,8,'2020-03-25',23,2.00,6.50,'17:38:00'),(5,8,'2020-03-28',9,2.00,6.50,'10:31:00'),(5,8,'2020-03-28',13,2.00,6.50,'09:40:00'),(5,8,'2020-03-28',20,3.00,6.50,'11:50:00'),(5,8,'2020-03-28',22,2.00,6.50,'09:32:00'),(5,8,'2020-03-28',23,3.00,6.50,'13:59:00'),(5,8,'2020-04-01',16,2.00,6.50,'18:54:00'),(5,8,'2020-04-01',18,4.00,6.50,'18:43:00'),(5,8,'2020-04-04',12,1.00,6.50,'10:18:00'),(5,8,'2020-04-08',1,2.00,6.50,'18:21:00'),(5,8,'2020-04-08',1,1.00,6.50,'18:28:00'),(5,8,'2020-04-08',2,2.00,6.50,'18:59:00'),(5,8,'2020-04-08',3,2.00,6.50,'18:32:00'),(5,8,'2020-04-08',11,3.00,6.50,'18:52:00'),(5,8,'2020-04-08',17,3.00,6.50,'18:16:00'),(5,8,'2020-04-08',18,5.00,6.50,'18:51:00'),(5,8,'2020-04-11',9,4.00,6.50,'10:27:00'),(5,8,'2020-04-11',9,4.00,6.50,'10:28:00'),(5,8,'2020-04-15',5,1.00,6.50,'18:03:00'),(5,8,'2020-04-15',8,1.00,6.50,'18:08:00'),(5,8,'2020-04-15',10,2.00,6.50,'18:40:00'),(5,8,'2020-04-15',10,2.00,6.50,'18:46:00'),(5,8,'2020-04-15',12,2.00,6.50,'18:54:00'),(5,8,'2020-04-15',17,1.00,6.50,'18:49:00'),(5,8,'2020-04-18',4,2.00,6.50,'08:44:00'),(5,8,'2020-04-22',2,3.00,6.50,'17:29:00'),(5,8,'2020-04-22',2,2.00,6.50,'17:31:00'),(5,8,'2020-04-22',3,4.00,6.50,'18:31:00'),(5,8,'2020-04-22',4,3.00,6.50,'18:10:00'),(5,8,'2020-04-22',5,5.00,6.50,'17:35:00'),(5,8,'2020-04-22',12,4.00,6.50,'18:42:00'),(5,8,'2020-04-25',1,2.00,6.50,'10:04:00'),(5,8,'2020-04-25',1,2.00,6.50,'10:14:00'),(5,8,'2020-04-25',12,2.00,6.50,'10:17:00'),(5,8,'2020-04-29',1,3.00,6.50,'17:21:00'),(5,8,'2020-04-29',5,1.00,6.50,'17:46:00'),(5,8,'2020-04-29',6,2.00,6.50,'18:15:00'),(5,8,'2020-04-29',9,1.00,6.50,'16:36:00'),(5,8,'2020-04-29',9,3.00,6.50,'16:51:00'),(5,8,'2020-04-29',11,4.00,6.50,'18:09:00'),(5,8,'2020-04-29',12,2.00,6.50,'18:19:00'),(5,8,'2020-05-02',5,4.00,6.50,'12:11:00'),(5,8,'2020-05-02',7,2.00,6.50,'11:09:00'),(5,8,'2020-05-02',10,4.00,6.50,'13:07:00'),(5,8,'2020-05-02',10,1.00,6.50,'13:46:00'),(5,8,'2020-05-02',14,4.00,6.50,'13:31:00'),(5,8,'2020-05-02',16,2.00,6.50,'11:48:00'),(5,8,'2020-05-06',1,2.00,6.50,'18:34:00'),(5,8,'2020-05-06',1,1.00,6.50,'18:44:00'),(5,8,'2020-05-06',3,1.00,6.50,'18:05:00'),(5,8,'2020-05-06',4,1.00,6.50,'18:53:00'),(5,8,'2020-05-06',8,1.00,6.50,'18:51:00'),(5,8,'2020-05-06',9,2.00,6.50,'18:56:00'),(5,8,'2020-05-06',9,2.00,6.50,'18:59:00'),(5,8,'2020-05-06',10,1.00,6.50,'17:54:00'),(5,8,'2020-05-06',20,4.00,6.50,'16:18:00'),(5,8,'2020-05-06',20,4.00,6.50,'16:54:00'),(5,8,'2020-05-09',4,4.00,6.50,'10:03:00'),(5,8,'2020-05-09',4,3.00,6.50,'10:22:00'),(5,8,'2020-05-09',5,1.00,6.50,'12:39:00'),(5,8,'2020-05-09',6,5.00,6.50,'13:44:00'),(5,8,'2020-05-09',6,2.00,6.50,'13:45:00'),(5,8,'2020-05-09',7,5.00,6.50,'13:58:00'),(5,8,'2020-05-09',9,2.00,6.50,'13:39:00'),(5,8,'2020-05-09',10,2.00,6.50,'09:51:00'),(5,8,'2020-05-09',24,1.00,6.50,'09:02:00'),(5,8,'2020-05-13',2,2.00,6.50,'18:44:00'),(5,8,'2020-05-13',17,2.00,6.50,'17:13:00'),(5,8,'2020-05-13',21,1.00,6.50,'16:56:00'),(5,8,'2020-05-13',21,5.00,6.50,'17:24:00'),(5,8,'2020-05-13',22,2.00,6.50,'18:23:00'),(5,8,'2020-05-13',23,3.00,6.50,'18:47:00'),(5,8,'2020-05-16',1,1.00,6.50,'12:00:00'),(5,8,'2020-05-16',2,1.00,6.50,'09:27:00'),(5,8,'2020-05-16',2,1.00,6.50,'09:37:00'),(5,8,'2020-05-16',5,2.00,6.50,'13:13:00'),(5,8,'2020-05-16',11,2.00,6.50,'10:50:00'),(5,8,'2020-05-16',25,3.00,6.50,'10:42:00'),(5,8,'2020-05-16',25,6.00,6.50,'11:20:00'),(5,8,'2020-05-20',2,2.00,6.50,'18:14:00'),(5,8,'2020-05-20',2,1.00,6.50,'18:27:00'),(5,8,'2020-05-20',5,1.00,6.50,'18:25:00'),(5,8,'2020-05-20',11,2.00,6.50,'17:05:00'),(5,8,'2020-05-20',11,1.00,6.50,'17:39:00'),(5,8,'2020-05-20',12,2.00,6.50,'17:02:00'),(5,8,'2020-05-20',16,1.00,6.50,'18:50:00'),(5,8,'2020-05-20',19,3.00,6.50,'16:51:00'),(5,8,'2020-05-20',26,4.00,6.50,'17:45:00'),(5,8,'2020-05-23',1,2.00,6.50,'10:46:00'),(5,8,'2020-05-23',1,1.00,6.50,'10:55:00'),(5,8,'2020-05-23',3,3.00,6.50,'09:30:00'),(5,8,'2020-05-23',4,1.00,6.50,'13:51:00'),(5,8,'2020-05-23',5,2.00,6.50,'12:58:00'),(5,8,'2020-05-23',8,3.00,6.50,'13:57:00'),(5,8,'2020-05-23',11,2.00,6.50,'10:50:00'),(5,8,'2020-05-23',13,1.00,6.50,'13:12:00'),(5,8,'2020-05-23',23,4.00,6.50,'10:12:00'),(5,8,'2020-05-23',25,2.00,6.50,'12:13:00'),(5,8,'2020-05-27',3,2.00,6.50,'18:54:00'),(5,8,'2020-05-27',13,4.00,6.50,'18:39:00'),(5,8,'2020-05-27',20,4.00,6.50,'18:43:00'),(5,8,'2020-05-30',4,3.00,6.50,'12:05:00'),(5,8,'2020-05-30',4,5.00,6.50,'12:25:00'),(5,8,'2020-05-30',7,1.00,6.50,'09:33:00'),(5,8,'2020-05-30',8,5.00,6.50,'11:20:00'),(5,8,'2020-05-30',8,4.00,6.50,'11:43:00'),(5,8,'2020-05-30',11,4.00,6.50,'08:53:00'),(5,8,'2020-05-30',18,2.00,6.50,'13:40:00'),(5,8,'2020-06-03',2,2.00,6.50,'17:13:00'),(5,8,'2020-06-03',6,2.00,6.50,'16:39:00'),(5,8,'2020-06-03',8,1.00,6.50,'17:18:00'),(5,8,'2020-06-03',9,2.00,6.50,'18:12:00'),(5,8,'2020-06-03',11,1.00,6.50,'17:01:00'),(5,8,'2020-06-03',18,1.00,6.50,'17:00:00'),(5,8,'2020-06-06',1,5.00,6.50,'09:57:00'),(5,8,'2020-06-06',3,4.00,6.50,'13:01:00'),(5,8,'2020-06-06',4,4.00,6.50,'11:40:00'),(5,8,'2020-06-06',5,5.00,6.50,'08:59:00'),(5,8,'2020-06-06',6,1.00,6.50,'08:49:00'),(5,8,'2020-06-06',22,1.00,6.50,'09:12:00'),(5,8,'2020-06-06',24,2.00,6.50,'11:14:00'),(5,8,'2020-06-10',2,2.00,6.50,'17:21:00'),(5,8,'2020-06-10',3,4.00,6.50,'18:40:00'),(5,8,'2020-06-10',3,1.00,6.50,'18:46:00'),(5,8,'2020-06-10',5,3.00,6.50,'17:28:00'),(5,8,'2020-06-10',22,4.00,6.50,'17:30:00'),(5,8,'2020-06-10',23,4.00,6.50,'18:35:00'),(5,8,'2020-06-13',2,4.00,6.50,'12:57:00'),(5,8,'2020-06-13',3,1.00,6.50,'12:14:00'),(5,8,'2020-06-13',10,1.00,6.50,'09:42:00'),(5,8,'2020-06-13',11,4.00,6.50,'10:47:00'),(5,8,'2020-06-13',12,5.00,6.50,'10:25:00'),(5,8,'2020-06-13',18,3.00,6.50,'13:40:00'),(5,8,'2020-06-13',19,4.00,6.50,'11:07:00'),(5,8,'2020-06-17',4,4.00,6.50,'18:46:00'),(5,8,'2020-06-17',7,2.00,6.50,'16:42:00'),(5,8,'2020-06-17',7,1.00,6.50,'16:57:00'),(5,8,'2020-06-17',8,3.00,6.50,'18:18:00'),(5,8,'2020-06-17',9,2.00,6.50,'16:48:00'),(5,8,'2020-06-17',9,3.00,6.50,'17:21:00'),(5,8,'2020-06-17',11,1.00,6.50,'18:02:00'),(5,8,'2020-06-17',11,2.00,6.50,'18:45:00'),(5,8,'2020-06-20',4,4.00,6.50,'09:41:00'),(5,8,'2020-06-20',21,7.00,6.50,'13:56:00'),(5,8,'2020-06-20',26,5.00,6.50,'13:20:00'),(5,8,'2020-06-24',2,4.00,6.50,'16:50:00'),(5,8,'2020-06-24',6,2.00,6.50,'17:38:00'),(5,8,'2020-06-24',16,4.00,6.50,'16:29:00'),(5,8,'2020-06-24',22,4.00,6.50,'17:33:00'),(5,8,'2020-06-24',23,4.00,6.50,'18:40:00'),(5,8,'2020-06-27',1,2.00,6.50,'09:04:00'),(5,8,'2020-06-27',2,3.00,6.50,'12:25:00'),(5,8,'2020-06-27',3,2.00,6.50,'10:53:00'),(5,8,'2020-06-27',3,3.00,6.50,'11:19:00'),(5,8,'2020-06-27',6,2.00,6.50,'12:55:00'),(5,8,'2020-06-27',11,3.00,6.50,'10:21:00'),(5,8,'2020-06-27',18,3.00,6.50,'11:28:00'),(5,8,'2020-06-27',19,2.00,6.50,'10:20:00'),(5,8,'2020-06-27',21,3.00,6.50,'13:54:00'),(5,8,'2020-07-01',12,4.00,6.50,'18:37:00'),(5,8,'2020-07-04',10,5.00,6.50,'10:39:00'),(5,8,'2020-07-04',12,4.00,6.50,'13:52:00'),(5,8,'2020-07-04',12,2.00,6.50,'13:58:00'),(5,8,'2020-07-04',15,2.00,6.50,'09:14:00'),(5,8,'2020-07-04',15,2.00,6.50,'09:21:00'),(5,8,'2020-07-04',17,1.00,6.50,'10:20:00'),(5,8,'2020-07-08',3,3.00,6.50,'18:17:00'),(5,8,'2020-07-08',5,3.00,6.50,'18:56:00'),(5,8,'2020-07-08',9,1.00,6.50,'17:05:00'),(5,8,'2020-07-08',9,2.00,6.50,'17:10:00'),(5,8,'2020-07-08',16,5.00,6.50,'18:29:00'),(5,8,'2020-07-11',12,2.00,6.50,'08:59:00'),(5,8,'2020-07-11',12,2.00,6.50,'09:11:00'),(5,8,'2020-07-15',14,1.00,6.50,'18:11:00'),(5,8,'2020-07-18',3,5.00,6.50,'12:47:00'),(5,8,'2020-07-18',7,2.00,6.50,'12:21:00'),(5,8,'2020-07-18',8,3.00,6.50,'10:23:00'),(5,8,'2020-07-18',10,2.00,6.50,'11:11:00'),(5,8,'2020-07-18',12,4.00,6.50,'11:27:00'),(5,8,'2020-07-25',5,1.00,6.50,'12:28:00'),(5,8,'2020-07-25',8,5.00,6.50,'13:10:00'),(5,8,'2020-07-25',9,3.00,6.50,'13:28:00'),(5,8,'2020-07-25',11,4.00,6.50,'12:58:00'),(5,8,'2020-07-25',11,1.00,6.50,'13:00:00'),(5,8,'2020-07-29',13,1.00,6.50,'17:42:00'),(5,8,'2020-08-01',4,4.00,6.50,'10:48:00'),(5,8,'2020-08-01',4,4.00,6.50,'10:49:00'),(5,8,'2020-08-01',5,1.00,6.50,'08:26:00'),(5,8,'2020-08-01',15,5.00,6.50,'13:44:00'),(5,8,'2020-08-01',21,2.00,6.50,'11:46:00'),(5,8,'2020-08-05',6,4.00,6.50,'18:43:00'),(5,8,'2020-08-05',14,2.00,6.50,'17:59:00'),(5,8,'2020-08-08',2,2.00,6.50,'10:30:00'),(5,8,'2020-08-08',7,3.00,6.50,'11:49:00'),(5,8,'2020-08-08',10,3.00,6.50,'10:49:00'),(5,8,'2020-08-08',17,3.00,6.50,'12:27:00'),(5,8,'2020-08-08',26,5.00,6.50,'11:06:00'),(5,8,'2020-08-12',13,4.00,6.50,'17:33:00'),(5,8,'2020-08-12',23,4.00,6.50,'18:50:00'),(5,8,'2020-08-12',26,5.00,6.50,'18:53:00'),(5,8,'2020-08-15',4,5.00,6.50,'09:21:00'),(5,8,'2020-08-15',5,4.00,6.50,'10:46:00'),(5,8,'2020-08-15',5,2.00,6.50,'11:07:00'),(5,8,'2020-08-15',9,1.00,6.50,'09:46:00'),(5,8,'2020-08-15',14,3.00,6.50,'11:18:00'),(5,8,'2020-08-15',22,5.00,6.50,'09:55:00'),(5,8,'2020-08-15',23,2.00,6.50,'11:45:00'),(5,8,'2020-08-19',5,5.00,6.50,'18:26:00'),(5,8,'2020-08-19',6,4.00,6.50,'17:51:00'),(5,8,'2020-08-19',8,4.00,6.50,'17:50:00'),(5,8,'2020-08-19',15,2.00,6.50,'18:43:00'),(5,8,'2020-08-19',19,2.00,6.50,'16:57:00'),(5,8,'2020-08-19',26,1.00,6.50,'18:05:00'),(5,8,'2020-08-22',2,1.00,6.50,'10:35:00'),(5,8,'2020-08-22',8,2.00,6.50,'08:36:00'),(5,8,'2020-08-22',11,2.00,6.50,'08:40:00'),(5,8,'2020-08-22',11,2.00,6.50,'09:43:00'),(5,8,'2020-08-26',9,4.00,6.50,'17:33:00'),(5,8,'2020-08-26',12,2.00,6.50,'17:12:00'),(5,8,'2020-08-26',25,7.00,6.50,'17:34:00'),(5,8,'2020-08-29',1,2.00,6.50,'13:41:00'),(5,8,'2020-08-29',7,4.00,6.50,'13:47:00'),(5,8,'2020-09-02',1,4.00,6.50,'16:24:00'),(5,8,'2020-09-02',1,3.00,6.50,'16:36:00'),(5,8,'2020-09-02',18,4.00,6.50,'16:41:00'),(5,8,'2020-09-02',18,5.00,6.50,'16:55:00'),(5,8,'2020-09-05',1,2.00,6.50,'13:50:00'),(5,8,'2020-09-05',7,2.00,6.50,'08:37:00'),(5,8,'2020-09-09',5,1.00,6.50,'18:33:00'),(5,8,'2020-09-09',7,4.00,6.50,'18:38:00'),(5,8,'2020-09-09',12,5.00,6.50,'16:16:00'),(5,8,'2020-09-09',13,4.00,6.50,'17:45:00'),(5,8,'2020-09-12',16,2.00,6.50,'13:51:00'),(5,8,'2020-09-16',2,3.00,6.50,'17:43:00'),(5,8,'2020-09-16',5,5.00,6.50,'18:59:00'),(5,8,'2020-09-16',7,5.00,6.50,'18:05:00'),(5,8,'2020-09-16',8,1.00,6.50,'18:32:00'),(5,8,'2020-09-16',8,1.00,6.50,'18:42:00'),(5,8,'2020-09-16',19,2.00,6.50,'18:37:00'),(5,8,'2020-09-16',19,1.00,6.50,'18:58:00'),(5,8,'2020-09-19',10,2.00,6.50,'11:49:00'),(5,8,'2020-09-19',17,4.00,6.50,'13:37:00'),(5,8,'2020-09-19',18,6.00,6.50,'11:11:00'),(5,8,'2020-09-23',1,5.00,6.50,'18:08:00'),(5,8,'2020-09-23',2,1.00,6.50,'17:07:00'),(5,8,'2020-09-23',4,1.00,6.50,'18:02:00'),(5,8,'2020-09-23',6,2.00,6.50,'18:54:00'),(5,8,'2020-09-23',24,3.00,6.50,'17:48:00'),(5,8,'2020-09-26',6,2.00,6.50,'11:54:00'),(5,8,'2020-09-26',12,4.00,6.50,'09:15:00'),(5,8,'2020-09-26',15,1.00,6.50,'13:08:00'),(5,8,'2020-09-26',17,4.00,6.50,'13:38:00'),(5,8,'2020-09-26',18,2.00,6.50,'10:53:00'),(5,8,'2020-09-26',24,2.00,6.50,'11:26:00'),(5,8,'2020-09-30',6,1.00,6.50,'18:04:00'),(5,8,'2020-09-30',26,3.00,6.50,'16:54:00'),(5,8,'2020-10-03',7,1.00,6.50,'13:21:00'),(5,8,'2020-10-03',10,1.00,6.50,'09:56:00'),(5,8,'2020-10-03',12,2.00,6.50,'10:16:00'),(5,8,'2020-10-03',16,1.00,6.50,'10:27:00'),(5,8,'2020-10-03',16,2.00,6.50,'10:44:00'),(5,8,'2020-10-03',23,5.00,6.50,'09:48:00'),(5,8,'2020-10-03',23,2.00,6.50,'09:58:00'),(5,8,'2020-10-03',25,3.00,6.50,'09:09:00'),(5,8,'2020-10-03',25,3.00,6.50,'09:24:00'),(5,8,'2020-10-07',3,4.00,6.50,'16:46:00'),(5,8,'2020-10-07',3,4.00,6.50,'17:12:00'),(5,8,'2020-10-07',11,3.00,6.50,'18:58:00'),(5,8,'2020-10-07',18,2.00,6.50,'17:27:00'),(5,8,'2020-10-07',18,1.00,6.50,'17:42:00'),(5,8,'2020-10-07',23,3.00,6.50,'18:13:00'),(5,8,'2020-10-07',26,2.00,6.50,'18:57:00'),(5,8,'2020-10-10',1,4.00,6.50,'09:07:00'),(5,8,'2020-10-10',2,1.00,6.50,'13:50:00'),(5,8,'2020-10-10',6,5.00,6.50,'12:51:00'),(5,8,'2020-10-10',10,3.00,6.50,'13:41:00'),(5,8,'2020-10-10',13,1.00,6.50,'09:10:00'),(5,8,'2020-10-10',13,1.00,6.50,'09:15:00'),(5,8,'2020-10-10',19,5.00,6.50,'12:20:00'),(7,8,'2019-04-03',9,1.00,18.00,'16:20:00'),(7,8,'2019-04-03',9,2.00,18.00,'17:08:00'),(7,8,'2019-04-03',10,1.00,18.00,'18:13:00'),(7,8,'2019-04-03',11,2.00,18.00,'18:57:00'),(7,8,'2019-04-03',23,1.00,18.00,'17:31:00'),(7,8,'2019-04-03',23,2.00,18.00,'17:35:00'),(7,8,'2019-04-06',14,1.00,18.00,'11:20:00'),(7,8,'2019-04-06',14,3.00,18.00,'12:22:00'),(7,8,'2019-04-06',23,3.00,18.00,'10:11:00'),(7,8,'2019-04-10',2,1.00,18.00,'17:36:00'),(7,8,'2019-04-10',4,2.00,18.00,'18:54:00'),(7,8,'2019-04-10',11,2.00,18.00,'18:42:00'),(7,8,'2019-04-10',12,1.00,18.00,'18:08:00'),(7,8,'2019-04-13',3,1.00,18.00,'12:26:00'),(7,8,'2019-04-13',12,2.00,18.00,'11:32:00'),(7,8,'2019-04-13',14,2.00,18.00,'10:49:00'),(7,8,'2019-04-13',14,1.00,18.00,'11:25:00'),(7,8,'2019-04-17',1,2.00,18.00,'18:52:00'),(7,8,'2019-04-17',6,1.00,18.00,'18:06:00'),(7,8,'2019-04-17',8,1.00,18.00,'16:15:00'),(7,8,'2019-04-17',18,1.00,18.00,'18:54:00'),(7,8,'2019-04-17',22,2.00,18.00,'18:52:00'),(7,8,'2019-04-20',9,1.00,18.00,'08:13:00'),(7,8,'2019-04-20',10,1.00,18.00,'08:43:00'),(7,8,'2019-04-20',15,1.00,18.00,'09:46:00'),(7,8,'2019-04-20',15,1.00,18.00,'10:39:00'),(7,8,'2019-04-20',26,4.00,18.00,'09:09:00'),(7,8,'2019-04-24',1,1.00,18.00,'17:49:00'),(7,8,'2019-04-24',5,1.00,18.00,'17:06:00'),(7,8,'2019-04-24',5,1.00,18.00,'17:14:00'),(7,8,'2019-04-24',6,1.00,18.00,'18:13:00'),(7,8,'2019-04-24',6,1.00,18.00,'18:25:00'),(7,8,'2019-04-24',20,1.00,18.00,'18:48:00'),(7,8,'2019-04-27',3,3.00,18.00,'11:44:00'),(7,8,'2019-04-27',22,3.00,18.00,'09:49:00'),(7,8,'2019-05-01',2,1.00,18.00,'18:18:00'),(7,8,'2019-05-01',3,2.00,18.00,'18:59:00'),(7,8,'2019-05-01',10,1.00,18.00,'17:49:00'),(7,8,'2019-05-01',16,1.00,18.00,'18:19:00'),(7,8,'2019-05-04',2,1.00,18.00,'08:45:00'),(7,8,'2019-05-04',2,3.00,18.00,'09:07:00'),(7,8,'2019-05-04',5,2.00,18.00,'09:08:00'),(7,8,'2019-05-04',9,1.00,18.00,'11:58:00'),(7,8,'2019-05-04',26,1.00,18.00,'10:14:00'),(7,8,'2019-05-08',1,2.00,18.00,'18:25:00'),(7,8,'2019-05-08',1,1.00,18.00,'18:46:00'),(7,8,'2019-05-08',8,3.00,18.00,'18:42:00'),(7,8,'2019-05-08',8,1.00,18.00,'18:43:00'),(7,8,'2019-05-08',24,1.00,18.00,'18:40:00'),(7,8,'2019-05-11',2,1.00,18.00,'10:42:00'),(7,8,'2019-05-11',3,2.00,18.00,'09:22:00'),(7,8,'2019-05-11',3,1.00,18.00,'10:15:00'),(7,8,'2019-05-15',8,1.00,18.00,'18:15:00'),(7,8,'2019-05-15',8,2.00,18.00,'18:17:00'),(7,8,'2019-05-15',21,5.00,18.00,'18:42:00'),(7,8,'2019-05-18',9,1.00,18.00,'12:56:00'),(7,8,'2019-05-18',9,2.00,18.00,'13:36:00'),(7,8,'2019-05-18',11,1.00,18.00,'12:36:00'),(7,8,'2019-05-18',25,3.00,18.00,'13:45:00'),(7,8,'2019-05-18',26,1.00,18.00,'13:53:00'),(7,8,'2019-05-18',26,2.00,18.00,'13:54:00'),(7,8,'2019-05-22',1,1.00,18.00,'16:25:00'),(7,8,'2019-05-22',3,1.00,18.00,'18:40:00'),(7,8,'2019-05-22',13,1.00,18.00,'18:53:00'),(7,8,'2019-05-22',13,1.00,18.00,'18:59:00'),(7,8,'2019-05-22',26,1.00,18.00,'17:29:00'),(7,8,'2019-05-25',4,1.00,18.00,'08:56:00'),(7,8,'2019-05-25',12,1.00,18.00,'13:44:00'),(7,8,'2019-05-25',12,3.00,18.00,'13:53:00'),(7,8,'2019-05-25',21,3.00,18.00,'10:35:00'),(7,8,'2019-05-29',12,3.00,18.00,'17:00:00'),(7,8,'2019-05-29',12,1.00,18.00,'18:09:00'),(7,8,'2019-05-29',20,3.00,18.00,'17:42:00'),(7,8,'2019-05-29',20,4.00,18.00,'18:18:00'),(7,8,'2019-05-29',22,1.00,18.00,'16:28:00'),(7,8,'2019-06-01',8,1.00,18.00,'11:46:00'),(7,8,'2019-06-01',8,3.00,18.00,'12:27:00'),(7,8,'2019-06-01',20,3.00,18.00,'13:55:00'),(7,8,'2019-06-01',23,1.00,18.00,'10:57:00'),(7,8,'2019-06-01',23,3.00,18.00,'11:13:00'),(7,8,'2019-06-05',4,2.00,18.00,'18:52:00'),(7,8,'2019-06-05',11,3.00,18.00,'17:52:00'),(7,8,'2019-06-05',14,1.00,18.00,'18:09:00'),(7,8,'2019-06-05',26,1.00,18.00,'18:14:00'),(7,8,'2019-06-08',2,2.00,18.00,'12:25:00'),(7,8,'2019-06-08',6,1.00,18.00,'10:34:00'),(7,8,'2019-06-08',17,2.00,18.00,'11:57:00'),(7,8,'2019-06-08',17,2.00,18.00,'12:00:00'),(7,8,'2019-06-12',5,1.00,18.00,'17:22:00'),(7,8,'2019-06-12',12,1.00,18.00,'18:27:00'),(7,8,'2019-06-12',12,2.00,18.00,'18:35:00'),(7,8,'2019-06-12',14,1.00,18.00,'18:53:00'),(7,8,'2019-06-12',14,1.00,18.00,'18:54:00'),(7,8,'2019-06-12',26,1.00,18.00,'18:14:00'),(7,8,'2019-06-15',2,2.00,18.00,'12:59:00'),(7,8,'2019-06-15',5,1.00,18.00,'13:16:00'),(7,8,'2019-06-15',9,1.00,18.00,'12:28:00'),(7,8,'2019-06-15',10,1.00,18.00,'13:37:00'),(7,8,'2019-06-15',26,3.00,18.00,'09:40:00'),(7,8,'2019-06-19',6,3.00,18.00,'18:40:00'),(7,8,'2019-06-19',17,2.00,18.00,'17:43:00'),(7,8,'2019-06-19',20,2.00,18.00,'16:37:00'),(7,8,'2019-06-22',3,1.00,18.00,'10:40:00'),(7,8,'2019-06-22',13,1.00,18.00,'11:12:00'),(7,8,'2019-06-22',14,2.00,18.00,'12:39:00'),(7,8,'2019-06-22',15,2.00,18.00,'12:40:00'),(7,8,'2019-06-22',24,1.00,18.00,'11:18:00'),(7,8,'2019-06-26',8,1.00,18.00,'17:33:00'),(7,8,'2019-06-26',12,2.00,18.00,'18:12:00'),(7,8,'2019-06-26',12,1.00,18.00,'18:36:00'),(7,8,'2019-06-26',22,2.00,18.00,'17:33:00'),(7,8,'2019-06-29',2,1.00,18.00,'09:00:00'),(7,8,'2019-06-29',15,1.00,18.00,'13:40:00'),(7,8,'2019-06-29',15,1.00,18.00,'13:41:00'),(7,8,'2019-06-29',24,2.00,18.00,'09:35:00'),(7,8,'2019-06-29',24,4.00,18.00,'10:14:00'),(7,8,'2019-06-29',25,1.00,18.00,'09:40:00'),(7,8,'2019-07-03',1,2.00,18.00,'16:38:00'),(7,8,'2019-07-03',1,2.00,18.00,'17:46:00'),(7,8,'2019-07-03',7,1.00,18.00,'16:40:00'),(7,8,'2019-07-06',3,2.00,18.00,'10:31:00'),(7,8,'2019-07-06',5,3.00,18.00,'10:06:00'),(7,8,'2019-07-10',2,2.00,18.00,'17:54:00'),(7,8,'2019-07-10',9,3.00,18.00,'17:15:00'),(7,8,'2019-07-13',2,1.00,18.00,'12:48:00'),(7,8,'2019-07-13',2,3.00,18.00,'12:52:00'),(7,8,'2019-07-13',11,1.00,18.00,'09:30:00'),(7,8,'2019-07-17',12,3.00,18.00,'18:53:00'),(7,8,'2019-07-20',6,1.00,18.00,'11:23:00'),(7,8,'2019-07-20',8,3.00,18.00,'13:57:00'),(7,8,'2019-07-20',21,1.00,18.00,'12:29:00'),(7,8,'2019-07-20',26,3.00,18.00,'13:05:00'),(7,8,'2019-07-20',26,3.00,18.00,'13:37:00'),(7,8,'2019-07-24',3,1.00,18.00,'18:58:00'),(7,8,'2019-07-24',12,2.00,18.00,'17:45:00'),(7,8,'2019-07-24',25,3.00,18.00,'18:28:00'),(7,8,'2019-07-27',1,2.00,18.00,'08:52:00'),(7,8,'2019-07-27',8,3.00,18.00,'11:03:00'),(7,8,'2019-07-27',20,1.00,18.00,'13:25:00'),(7,8,'2019-07-27',24,3.00,18.00,'09:54:00'),(7,8,'2019-07-31',5,1.00,18.00,'17:11:00'),(7,8,'2019-07-31',11,1.00,18.00,'17:22:00'),(7,8,'2019-07-31',11,2.00,18.00,'18:08:00'),(7,8,'2019-08-03',10,2.00,18.00,'11:38:00'),(7,8,'2019-08-03',12,1.00,18.00,'09:00:00'),(7,8,'2019-08-03',12,1.00,18.00,'09:19:00'),(7,8,'2019-08-03',18,1.00,18.00,'09:31:00'),(7,8,'2019-08-03',23,2.00,18.00,'13:53:00'),(7,8,'2019-08-07',10,2.00,18.00,'17:13:00'),(7,8,'2019-08-07',10,1.00,18.00,'17:26:00'),(7,8,'2019-08-10',8,1.00,18.00,'09:20:00'),(7,8,'2019-08-10',10,1.00,18.00,'13:45:00'),(7,8,'2019-08-10',11,1.00,18.00,'09:23:00'),(7,8,'2019-08-10',14,1.00,18.00,'10:04:00'),(7,8,'2019-08-10',25,1.00,18.00,'12:00:00'),(7,8,'2019-08-14',11,1.00,18.00,'17:16:00'),(7,8,'2019-08-14',13,1.00,18.00,'17:01:00'),(7,8,'2019-08-14',13,2.00,18.00,'17:19:00'),(7,8,'2019-08-14',25,1.00,18.00,'18:53:00'),(7,8,'2019-08-17',4,3.00,18.00,'13:59:00'),(7,8,'2019-08-17',24,3.00,18.00,'12:48:00'),(7,8,'2019-08-21',6,2.00,18.00,'17:18:00'),(7,8,'2019-08-21',9,1.00,18.00,'18:21:00'),(7,8,'2019-08-21',16,2.00,18.00,'16:41:00'),(7,8,'2019-08-24',4,2.00,18.00,'11:13:00'),(7,8,'2019-08-24',4,2.00,18.00,'11:47:00'),(7,8,'2019-08-24',6,1.00,18.00,'12:32:00'),(7,8,'2019-08-24',26,3.00,18.00,'13:57:00'),(7,8,'2019-08-28',1,1.00,18.00,'17:35:00'),(7,8,'2019-08-28',6,1.00,18.00,'17:49:00'),(7,8,'2019-08-28',8,2.00,18.00,'17:45:00'),(7,8,'2019-08-28',12,1.00,18.00,'17:13:00'),(7,8,'2019-08-31',6,1.00,18.00,'12:06:00'),(7,8,'2019-08-31',7,1.00,18.00,'13:25:00'),(7,8,'2019-08-31',7,1.00,18.00,'13:26:00'),(7,8,'2019-08-31',11,1.00,18.00,'12:42:00'),(7,8,'2019-08-31',22,1.00,18.00,'08:59:00'),(7,8,'2019-08-31',24,2.00,18.00,'10:21:00'),(7,8,'2019-09-04',2,1.00,18.00,'17:14:00'),(7,8,'2019-09-04',5,1.00,18.00,'17:13:00'),(7,8,'2019-09-04',5,1.00,18.00,'17:25:00'),(7,8,'2019-09-04',20,2.00,18.00,'18:04:00'),(7,8,'2019-09-07',2,2.00,18.00,'13:42:00'),(7,8,'2019-09-07',2,3.00,18.00,'13:57:00'),(7,8,'2019-09-11',4,2.00,18.00,'18:05:00'),(7,8,'2019-09-11',10,1.00,18.00,'18:47:00'),(7,8,'2019-09-11',25,2.00,18.00,'17:50:00'),(7,8,'2019-09-14',11,3.00,18.00,'09:50:00'),(7,8,'2019-09-14',18,1.00,18.00,'09:08:00'),(7,8,'2019-09-14',21,2.00,18.00,'11:39:00'),(7,8,'2019-09-14',25,5.00,18.00,'13:07:00'),(7,8,'2019-09-18',1,2.00,18.00,'18:38:00'),(7,8,'2019-09-18',3,1.00,18.00,'17:14:00'),(7,8,'2019-09-18',25,4.00,18.00,'16:38:00'),(7,8,'2019-09-21',3,1.00,18.00,'10:12:00'),(7,8,'2019-09-21',3,2.00,18.00,'10:43:00'),(7,8,'2019-09-25',6,2.00,18.00,'18:36:00'),(7,8,'2019-09-25',18,1.00,18.00,'16:51:00'),(7,8,'2019-09-25',25,4.00,18.00,'17:55:00'),(7,8,'2019-09-25',25,2.00,18.00,'18:05:00'),(7,8,'2019-09-28',5,1.00,18.00,'12:53:00'),(7,8,'2019-09-28',8,1.00,18.00,'09:24:00'),(7,8,'2019-09-28',9,1.00,18.00,'09:21:00'),(7,8,'2019-09-28',21,1.00,18.00,'09:19:00'),(7,8,'2019-10-02',7,3.00,18.00,'16:58:00'),(7,8,'2019-10-02',25,4.00,18.00,'17:46:00'),(7,8,'2019-10-02',26,2.00,18.00,'18:29:00'),(7,8,'2019-10-05',5,1.00,18.00,'11:28:00'),(7,8,'2019-10-05',8,2.00,18.00,'13:04:00'),(7,8,'2019-10-05',10,1.00,18.00,'12:27:00'),(7,8,'2019-10-05',25,3.00,18.00,'12:59:00'),(7,8,'2019-10-05',25,3.00,18.00,'13:06:00'),(7,8,'2019-10-09',1,3.00,18.00,'18:17:00'),(7,8,'2019-10-09',14,1.00,18.00,'18:10:00'),(7,8,'2019-10-09',14,1.00,18.00,'18:17:00'),(7,8,'2019-10-12',1,1.00,18.00,'12:57:00'),(7,8,'2019-10-12',1,2.00,18.00,'13:39:00'),(7,8,'2019-10-12',4,2.00,18.00,'12:34:00'),(7,8,'2019-10-12',11,1.00,18.00,'12:50:00'),(7,8,'2019-10-12',20,2.00,18.00,'12:48:00'),(7,8,'2019-10-12',20,2.00,18.00,'13:05:00'),(7,8,'2019-10-16',2,1.00,18.00,'17:32:00'),(7,8,'2019-10-16',8,1.00,18.00,'18:41:00'),(7,8,'2019-10-16',8,1.00,18.00,'18:48:00'),(7,8,'2019-10-16',12,1.00,18.00,'16:42:00'),(7,8,'2019-10-16',12,1.00,18.00,'17:48:00'),(7,8,'2019-10-16',19,1.00,18.00,'18:51:00'),(7,8,'2019-10-16',22,1.00,18.00,'18:29:00'),(7,8,'2019-10-19',3,2.00,18.00,'11:05:00'),(7,8,'2019-10-19',9,2.00,18.00,'11:26:00'),(7,8,'2019-10-19',12,1.00,18.00,'10:40:00'),(7,8,'2019-10-19',23,5.00,18.00,'09:53:00'),(7,8,'2019-10-23',2,3.00,18.00,'17:57:00'),(7,8,'2019-10-23',9,1.00,18.00,'16:52:00'),(7,8,'2019-10-23',9,1.00,18.00,'17:19:00'),(7,8,'2019-10-23',19,1.00,18.00,'18:41:00'),(7,8,'2019-10-23',26,2.00,18.00,'18:29:00'),(7,8,'2019-10-26',2,1.00,18.00,'11:13:00'),(7,8,'2019-10-26',2,1.00,18.00,'11:32:00'),(7,8,'2019-10-26',3,3.00,18.00,'13:37:00'),(7,8,'2019-10-26',4,1.00,18.00,'11:00:00'),(7,8,'2019-10-26',23,2.00,18.00,'09:15:00'),(7,8,'2019-10-30',4,2.00,18.00,'17:57:00'),(7,8,'2019-10-30',9,3.00,18.00,'17:19:00'),(7,8,'2019-10-30',26,2.00,18.00,'18:43:00'),(7,8,'2019-11-02',3,2.00,18.00,'10:35:00'),(7,8,'2019-11-02',5,2.00,18.00,'10:39:00'),(7,8,'2019-11-02',12,2.00,18.00,'09:37:00'),(7,8,'2019-11-02',19,2.00,18.00,'12:54:00'),(7,8,'2019-11-06',3,1.00,18.00,'16:17:00'),(7,8,'2019-11-06',3,1.00,18.00,'16:48:00'),(7,8,'2019-11-06',6,1.00,18.00,'17:22:00'),(7,8,'2019-11-06',6,1.00,18.00,'17:46:00'),(7,8,'2019-11-06',24,3.00,18.00,'18:50:00'),(7,8,'2019-11-09',1,1.00,18.00,'10:05:00'),(7,8,'2019-11-09',6,2.00,18.00,'12:04:00'),(7,8,'2019-11-09',11,1.00,18.00,'11:26:00'),(7,8,'2019-11-09',11,1.00,18.00,'11:41:00'),(7,8,'2019-11-13',1,1.00,18.00,'18:33:00'),(7,8,'2019-11-13',3,1.00,18.00,'18:46:00'),(7,8,'2019-11-13',9,2.00,18.00,'18:36:00'),(7,8,'2019-11-13',25,3.00,18.00,'17:19:00'),(7,8,'2019-11-16',3,3.00,18.00,'10:34:00'),(7,8,'2019-11-16',3,3.00,18.00,'10:58:00'),(7,8,'2019-11-16',8,1.00,18.00,'09:52:00'),(7,8,'2019-11-16',9,2.00,18.00,'08:39:00'),(7,8,'2019-11-16',16,1.00,18.00,'10:11:00'),(7,8,'2019-11-16',19,1.00,18.00,'12:29:00'),(7,8,'2019-11-20',2,3.00,18.00,'17:47:00'),(7,8,'2019-11-20',2,2.00,18.00,'17:58:00'),(7,8,'2019-11-20',4,1.00,18.00,'17:42:00'),(7,8,'2019-11-20',7,1.00,18.00,'18:53:00'),(7,8,'2019-11-20',17,1.00,18.00,'18:52:00'),(7,8,'2019-11-20',19,3.00,18.00,'17:09:00'),(7,8,'2019-11-20',26,4.00,18.00,'18:59:00'),(7,8,'2019-11-23',3,1.00,18.00,'12:40:00'),(7,8,'2019-11-23',3,2.00,18.00,'12:52:00'),(7,8,'2019-11-23',5,3.00,18.00,'09:02:00'),(7,8,'2019-11-23',5,1.00,18.00,'09:27:00'),(7,8,'2019-11-23',7,3.00,18.00,'13:50:00'),(7,8,'2019-11-23',7,2.00,18.00,'13:55:00'),(7,8,'2019-11-23',9,2.00,18.00,'12:22:00'),(7,8,'2019-11-23',22,3.00,18.00,'09:39:00'),(7,8,'2019-11-27',7,2.00,18.00,'18:51:00'),(7,8,'2019-11-27',7,1.00,18.00,'18:52:00'),(7,8,'2019-11-27',9,3.00,18.00,'16:52:00'),(7,8,'2019-11-27',9,2.00,18.00,'17:07:00'),(7,8,'2019-11-27',13,2.00,18.00,'18:52:00'),(7,8,'2019-11-27',15,3.00,18.00,'18:21:00'),(7,8,'2019-11-27',21,2.00,18.00,'16:32:00'),(7,8,'2019-11-30',3,1.00,18.00,'10:44:00'),(7,8,'2019-11-30',4,1.00,18.00,'13:43:00'),(7,8,'2019-11-30',4,1.00,18.00,'13:44:00'),(7,8,'2019-11-30',6,1.00,18.00,'11:05:00'),(7,8,'2019-11-30',12,1.00,18.00,'09:44:00'),(7,8,'2019-11-30',14,2.00,18.00,'12:39:00'),(7,8,'2019-11-30',14,3.00,18.00,'13:31:00'),(7,8,'2019-11-30',23,2.00,18.00,'12:16:00'),(7,8,'2019-11-30',25,3.00,18.00,'13:50:00'),(7,8,'2019-12-04',13,1.00,18.00,'18:36:00'),(7,8,'2019-12-04',13,2.00,18.00,'18:49:00'),(7,8,'2019-12-04',18,2.00,18.00,'18:58:00'),(7,8,'2019-12-07',3,1.00,18.00,'09:12:00'),(7,8,'2019-12-07',3,1.00,18.00,'09:13:00'),(7,8,'2019-12-07',10,2.00,18.00,'12:16:00'),(7,8,'2019-12-07',10,2.00,18.00,'12:40:00'),(7,8,'2019-12-07',26,2.00,18.00,'13:38:00'),(7,8,'2019-12-11',4,2.00,18.00,'16:57:00'),(7,8,'2019-12-11',4,1.00,18.00,'17:12:00'),(7,8,'2019-12-11',18,1.00,18.00,'18:40:00'),(7,8,'2019-12-11',23,4.00,18.00,'18:57:00'),(7,8,'2019-12-14',11,2.00,18.00,'13:15:00'),(7,8,'2019-12-14',12,1.00,18.00,'13:51:00'),(7,8,'2019-12-14',17,2.00,18.00,'10:03:00'),(7,8,'2019-12-14',25,2.00,18.00,'10:49:00'),(7,8,'2019-12-18',1,1.00,18.00,'18:53:00'),(7,8,'2019-12-18',1,2.00,18.00,'18:54:00'),(7,8,'2019-12-18',14,2.00,18.00,'17:59:00'),(7,8,'2019-12-18',17,1.00,18.00,'18:45:00'),(7,8,'2019-12-18',17,3.00,18.00,'18:52:00'),(7,8,'2019-12-18',19,3.00,18.00,'17:25:00'),(7,8,'2019-12-18',22,5.00,18.00,'18:31:00'),(7,8,'2019-12-21',3,1.00,18.00,'12:26:00'),(7,8,'2019-12-21',5,2.00,18.00,'09:58:00'),(7,8,'2019-12-21',5,1.00,18.00,'10:01:00'),(7,8,'2019-12-21',6,2.00,18.00,'13:22:00'),(7,8,'2019-12-21',8,1.00,18.00,'13:21:00'),(7,8,'2019-12-21',11,3.00,18.00,'13:55:00'),(7,8,'2019-12-21',14,1.00,18.00,'13:50:00'),(7,8,'2019-12-21',14,3.00,18.00,'13:59:00'),(7,8,'2019-12-21',18,1.00,18.00,'11:34:00'),(7,8,'2019-12-21',20,2.00,18.00,'11:16:00'),(7,8,'2019-12-25',2,1.00,18.00,'16:37:00'),(7,8,'2019-12-25',2,1.00,18.00,'16:40:00'),(7,8,'2019-12-25',4,1.00,18.00,'18:29:00'),(7,8,'2019-12-25',5,2.00,18.00,'17:30:00'),(7,8,'2019-12-25',10,3.00,18.00,'17:39:00'),(7,8,'2019-12-25',20,4.00,18.00,'18:35:00'),(7,8,'2019-12-25',24,3.00,18.00,'17:41:00'),(7,8,'2019-12-28',1,1.00,18.00,'13:52:00'),(7,8,'2019-12-28',1,2.00,18.00,'13:54:00'),(7,8,'2019-12-28',2,2.00,18.00,'09:28:00'),(7,8,'2019-12-28',3,1.00,18.00,'08:33:00'),(7,8,'2019-12-28',5,1.00,18.00,'13:33:00'),(7,8,'2019-12-28',6,1.00,18.00,'12:47:00'),(7,8,'2019-12-28',7,2.00,18.00,'11:37:00'),(7,8,'2019-12-28',15,3.00,18.00,'10:12:00'),(7,8,'2020-03-04',4,1.00,18.00,'18:03:00'),(7,8,'2020-03-04',4,2.00,18.00,'18:05:00'),(7,8,'2020-03-04',13,2.00,18.00,'18:59:00'),(7,8,'2020-03-04',24,1.00,18.00,'18:35:00'),(7,8,'2020-03-04',24,1.00,18.00,'18:48:00'),(7,8,'2020-03-07',14,3.00,18.00,'13:28:00'),(7,8,'2020-03-07',18,2.00,18.00,'10:48:00'),(7,8,'2020-03-07',22,3.00,18.00,'09:46:00'),(7,8,'2020-03-11',2,1.00,18.00,'17:52:00'),(7,8,'2020-03-11',15,3.00,18.00,'18:20:00'),(7,8,'2020-03-11',15,1.00,18.00,'18:43:00'),(7,8,'2020-03-14',4,3.00,18.00,'12:59:00'),(7,8,'2020-03-14',8,1.00,18.00,'13:46:00'),(7,8,'2020-03-14',9,1.00,18.00,'13:58:00'),(7,8,'2020-03-14',13,1.00,18.00,'08:35:00'),(7,8,'2020-03-14',19,2.00,18.00,'09:37:00'),(7,8,'2020-03-18',1,1.00,18.00,'18:24:00'),(7,8,'2020-03-18',1,1.00,18.00,'18:26:00'),(7,8,'2020-03-18',2,1.00,18.00,'18:47:00'),(7,8,'2020-03-18',7,1.00,18.00,'17:16:00'),(7,8,'2020-03-18',23,4.00,18.00,'16:30:00'),(7,8,'2020-03-21',7,2.00,18.00,'10:15:00'),(7,8,'2020-03-21',10,1.00,18.00,'10:06:00'),(7,8,'2020-03-21',14,2.00,18.00,'12:38:00'),(7,8,'2020-03-21',16,1.00,18.00,'09:43:00'),(7,8,'2020-03-21',20,1.00,18.00,'11:51:00'),(7,8,'2020-03-25',2,1.00,18.00,'17:47:00'),(7,8,'2020-03-25',3,1.00,18.00,'17:25:00'),(7,8,'2020-03-25',8,2.00,18.00,'18:29:00'),(7,8,'2020-03-25',8,2.00,18.00,'18:35:00'),(7,8,'2020-03-28',4,1.00,18.00,'10:22:00'),(7,8,'2020-03-28',6,1.00,18.00,'10:16:00'),(7,8,'2020-03-28',14,2.00,18.00,'08:57:00'),(7,8,'2020-03-28',15,2.00,18.00,'10:56:00'),(7,8,'2020-03-28',22,1.00,18.00,'09:46:00'),(7,8,'2020-04-01',3,3.00,18.00,'18:18:00'),(7,8,'2020-04-01',16,1.00,18.00,'18:46:00'),(7,8,'2020-04-01',16,2.00,18.00,'18:47:00'),(7,8,'2020-04-04',1,1.00,18.00,'10:05:00'),(7,8,'2020-04-04',1,2.00,18.00,'10:45:00'),(7,8,'2020-04-04',3,2.00,18.00,'13:33:00'),(7,8,'2020-04-08',11,1.00,18.00,'18:22:00'),(7,8,'2020-04-08',11,2.00,18.00,'18:42:00'),(7,8,'2020-04-08',16,2.00,18.00,'18:58:00'),(7,8,'2020-04-11',9,1.00,18.00,'10:01:00'),(7,8,'2020-04-11',10,2.00,18.00,'13:17:00'),(7,8,'2020-04-15',11,1.00,18.00,'17:31:00'),(7,8,'2020-04-15',11,1.00,18.00,'18:08:00'),(7,8,'2020-04-15',13,1.00,18.00,'18:45:00'),(7,8,'2020-04-18',11,1.00,18.00,'09:51:00'),(7,8,'2020-04-18',12,1.00,18.00,'08:50:00'),(7,8,'2020-04-18',13,1.00,18.00,'09:42:00'),(7,8,'2020-04-22',2,1.00,18.00,'17:42:00'),(7,8,'2020-04-22',2,2.00,18.00,'18:03:00'),(7,8,'2020-04-22',8,1.00,18.00,'17:01:00'),(7,8,'2020-04-25',17,2.00,18.00,'08:46:00'),(7,8,'2020-04-25',17,2.00,18.00,'09:04:00'),(7,8,'2020-04-29',7,1.00,18.00,'18:05:00'),(7,8,'2020-04-29',18,2.00,18.00,'18:10:00'),(7,8,'2020-04-29',18,2.00,18.00,'18:25:00'),(7,8,'2020-05-02',3,1.00,18.00,'10:25:00'),(7,8,'2020-05-02',3,1.00,18.00,'11:00:00'),(7,8,'2020-05-02',21,6.00,18.00,'11:02:00'),(7,8,'2020-05-02',21,2.00,18.00,'11:26:00'),(7,8,'2020-05-06',5,2.00,18.00,'16:46:00'),(7,8,'2020-05-06',8,2.00,18.00,'16:09:00'),(7,8,'2020-05-06',25,1.00,18.00,'18:27:00'),(7,8,'2020-05-06',25,1.00,18.00,'18:52:00'),(7,8,'2020-05-09',5,3.00,18.00,'13:15:00'),(7,8,'2020-05-09',22,4.00,18.00,'09:17:00'),(7,8,'2020-05-09',24,4.00,18.00,'09:03:00'),(7,8,'2020-05-13',4,1.00,18.00,'17:09:00'),(7,8,'2020-05-13',5,3.00,18.00,'18:16:00'),(7,8,'2020-05-13',5,1.00,18.00,'18:30:00'),(7,8,'2020-05-13',17,1.00,18.00,'18:09:00'),(7,8,'2020-05-13',22,3.00,18.00,'18:43:00'),(7,8,'2020-05-16',2,1.00,18.00,'13:57:00'),(7,8,'2020-05-16',5,2.00,18.00,'11:46:00'),(7,8,'2020-05-16',16,3.00,18.00,'13:49:00'),(7,8,'2020-05-16',22,1.00,18.00,'08:30:00'),(7,8,'2020-05-16',22,3.00,18.00,'09:23:00'),(7,8,'2020-05-20',12,2.00,18.00,'18:56:00'),(7,8,'2020-05-20',16,3.00,18.00,'18:50:00'),(7,8,'2020-05-20',19,2.00,18.00,'17:28:00'),(7,8,'2020-05-27',5,2.00,18.00,'18:44:00'),(7,8,'2020-05-27',17,2.00,18.00,'17:01:00'),(7,8,'2020-05-27',20,2.00,18.00,'18:50:00'),(7,8,'2020-05-30',1,2.00,18.00,'11:06:00'),(7,8,'2020-05-30',8,1.00,18.00,'10:47:00'),(7,8,'2020-05-30',23,2.00,18.00,'09:49:00'),(7,8,'2020-06-03',7,2.00,18.00,'18:00:00'),(7,8,'2020-06-03',7,2.00,18.00,'18:03:00'),(7,8,'2020-06-03',13,1.00,18.00,'17:18:00'),(7,8,'2020-06-03',24,1.00,18.00,'17:36:00'),(7,8,'2020-06-03',24,5.00,18.00,'17:37:00'),(7,8,'2020-06-06',4,1.00,18.00,'09:45:00'),(7,8,'2020-06-06',6,2.00,18.00,'11:23:00'),(7,8,'2020-06-06',24,1.00,18.00,'10:10:00'),(7,8,'2020-06-06',26,4.00,18.00,'13:56:00'),(7,8,'2020-06-10',2,2.00,18.00,'18:38:00'),(7,8,'2020-06-10',2,2.00,18.00,'18:42:00'),(7,8,'2020-06-10',23,4.00,18.00,'18:50:00'),(7,8,'2020-06-13',12,3.00,18.00,'10:36:00'),(7,8,'2020-06-13',12,1.00,18.00,'10:39:00'),(7,8,'2020-06-13',25,5.00,18.00,'10:36:00'),(7,8,'2020-06-17',1,3.00,18.00,'18:22:00'),(7,8,'2020-06-17',1,1.00,18.00,'18:26:00'),(7,8,'2020-06-17',3,1.00,18.00,'16:59:00'),(7,8,'2020-06-17',21,2.00,18.00,'17:54:00'),(7,8,'2020-06-17',22,1.00,18.00,'18:38:00'),(7,8,'2020-06-20',1,1.00,18.00,'11:31:00'),(7,8,'2020-06-20',2,1.00,18.00,'11:00:00'),(7,8,'2020-06-20',5,1.00,18.00,'13:39:00'),(7,8,'2020-06-20',8,1.00,18.00,'12:59:00'),(7,8,'2020-06-20',11,1.00,18.00,'13:35:00'),(7,8,'2020-06-24',2,2.00,18.00,'18:58:00'),(7,8,'2020-06-24',4,2.00,18.00,'18:16:00'),(7,8,'2020-06-24',5,2.00,18.00,'16:52:00'),(7,8,'2020-06-24',14,1.00,18.00,'18:36:00'),(7,8,'2020-06-24',14,1.00,18.00,'18:54:00'),(7,8,'2020-06-24',22,1.00,18.00,'17:15:00'),(7,8,'2020-06-27',8,2.00,18.00,'08:38:00'),(7,8,'2020-06-27',8,3.00,18.00,'09:18:00'),(7,8,'2020-07-01',5,2.00,18.00,'17:25:00'),(7,8,'2020-07-01',12,2.00,18.00,'17:14:00'),(7,8,'2020-07-04',10,1.00,18.00,'10:28:00'),(7,8,'2020-07-04',13,1.00,18.00,'11:07:00'),(7,8,'2020-07-04',13,1.00,18.00,'11:09:00'),(7,8,'2020-07-08',7,1.00,18.00,'18:24:00'),(7,8,'2020-07-08',10,2.00,18.00,'17:44:00'),(7,8,'2020-07-08',12,1.00,18.00,'17:58:00'),(7,8,'2020-07-08',14,1.00,18.00,'17:12:00'),(7,8,'2020-07-11',16,3.00,18.00,'12:09:00'),(7,8,'2020-07-11',16,3.00,18.00,'12:39:00'),(7,8,'2020-07-15',2,1.00,18.00,'18:51:00'),(7,8,'2020-07-15',5,1.00,18.00,'18:37:00'),(7,8,'2020-07-15',14,2.00,18.00,'17:05:00'),(7,8,'2020-07-18',7,2.00,18.00,'10:26:00'),(7,8,'2020-07-18',12,1.00,18.00,'13:03:00'),(7,8,'2020-07-22',6,2.00,18.00,'16:20:00'),(7,8,'2020-07-22',10,1.00,18.00,'17:53:00'),(7,8,'2020-07-22',17,1.00,18.00,'18:52:00'),(7,8,'2020-07-25',2,3.00,18.00,'09:10:00'),(7,8,'2020-07-25',3,1.00,18.00,'13:07:00'),(7,8,'2020-07-25',9,1.00,18.00,'11:33:00'),(7,8,'2020-07-29',4,1.00,18.00,'18:20:00'),(7,8,'2020-07-29',8,1.00,18.00,'17:21:00'),(7,8,'2020-07-29',8,1.00,18.00,'17:43:00'),(7,8,'2020-07-29',16,1.00,18.00,'17:55:00'),(7,8,'2020-08-01',1,1.00,18.00,'12:07:00'),(7,8,'2020-08-01',5,1.00,18.00,'10:01:00'),(7,8,'2020-08-01',12,1.00,18.00,'11:58:00'),(7,8,'2020-08-01',12,1.00,18.00,'12:08:00'),(7,8,'2020-08-05',3,2.00,18.00,'18:51:00'),(7,8,'2020-08-05',6,1.00,18.00,'17:00:00'),(7,8,'2020-08-08',9,2.00,18.00,'13:33:00'),(7,8,'2020-08-08',11,1.00,18.00,'09:57:00'),(7,8,'2020-08-08',13,2.00,18.00,'09:23:00'),(7,8,'2020-08-12',3,3.00,18.00,'18:51:00'),(7,8,'2020-08-12',10,2.00,18.00,'18:55:00'),(7,8,'2020-08-15',7,1.00,18.00,'11:13:00'),(7,8,'2020-08-15',12,2.00,18.00,'12:03:00'),(7,8,'2020-08-19',18,3.00,18.00,'18:42:00'),(7,8,'2020-08-19',24,4.00,18.00,'18:44:00'),(7,8,'2020-08-22',9,1.00,18.00,'10:05:00'),(7,8,'2020-08-22',9,1.00,18.00,'10:12:00'),(7,8,'2020-08-22',11,2.00,18.00,'12:14:00'),(7,8,'2020-08-22',26,1.00,18.00,'10:03:00'),(7,8,'2020-08-26',1,1.00,18.00,'18:14:00'),(7,8,'2020-08-26',2,1.00,18.00,'18:13:00'),(7,8,'2020-08-26',10,2.00,18.00,'18:38:00'),(7,8,'2020-08-26',16,1.00,18.00,'18:56:00'),(7,8,'2020-08-26',19,1.00,18.00,'17:35:00'),(7,8,'2020-08-29',3,2.00,18.00,'13:55:00'),(7,8,'2020-08-29',8,1.00,18.00,'12:05:00'),(7,8,'2020-08-29',8,1.00,18.00,'12:59:00'),(7,8,'2020-08-29',26,1.00,18.00,'11:26:00'),(7,8,'2020-09-02',5,1.00,18.00,'18:22:00'),(7,8,'2020-09-02',16,1.00,18.00,'17:00:00'),(7,8,'2020-09-02',17,1.00,18.00,'18:38:00'),(7,8,'2020-09-02',23,1.00,18.00,'18:16:00'),(7,8,'2020-09-05',2,1.00,18.00,'11:51:00'),(7,8,'2020-09-05',5,1.00,18.00,'12:00:00'),(7,8,'2020-09-05',14,1.00,18.00,'10:47:00'),(7,8,'2020-09-09',3,1.00,18.00,'16:44:00'),(7,8,'2020-09-09',18,2.00,18.00,'18:18:00'),(7,8,'2020-09-09',20,3.00,18.00,'18:36:00'),(7,8,'2020-09-09',22,5.00,18.00,'18:55:00'),(7,8,'2020-09-12',8,2.00,18.00,'11:03:00'),(7,8,'2020-09-12',11,1.00,18.00,'12:05:00'),(7,8,'2020-09-12',11,1.00,18.00,'12:09:00'),(7,8,'2020-09-16',1,1.00,18.00,'18:57:00'),(7,8,'2020-09-16',6,2.00,18.00,'18:38:00'),(7,8,'2020-09-16',10,2.00,18.00,'16:07:00'),(7,8,'2020-09-16',14,2.00,18.00,'18:18:00'),(7,8,'2020-09-19',5,1.00,18.00,'08:48:00'),(7,8,'2020-09-19',5,2.00,18.00,'09:54:00'),(7,8,'2020-09-19',9,2.00,18.00,'13:07:00'),(7,8,'2020-09-23',3,2.00,18.00,'17:41:00'),(7,8,'2020-09-23',7,1.00,18.00,'18:17:00'),(7,8,'2020-09-23',7,2.00,18.00,'18:53:00'),(7,8,'2020-09-23',21,1.00,18.00,'17:55:00'),(7,8,'2020-09-23',21,1.00,18.00,'18:34:00'),(7,8,'2020-09-26',1,1.00,18.00,'10:46:00'),(7,8,'2020-09-26',23,3.00,18.00,'11:38:00'),(7,8,'2020-09-30',9,1.00,18.00,'18:51:00'),(7,8,'2020-09-30',9,1.00,18.00,'18:52:00'),(7,8,'2020-09-30',19,4.00,18.00,'18:59:00'),(7,8,'2020-10-03',2,3.00,18.00,'13:31:00'),(7,8,'2020-10-03',2,2.00,18.00,'13:33:00'),(7,8,'2020-10-03',20,2.00,18.00,'13:47:00'),(7,8,'2020-10-03',23,2.00,18.00,'09:05:00'),(7,8,'2020-10-07',8,1.00,18.00,'18:56:00'),(7,8,'2020-10-07',16,3.00,18.00,'18:52:00'),(7,8,'2020-10-07',24,3.00,18.00,'18:33:00'),(7,8,'2020-10-07',24,3.00,18.00,'18:38:00'),(7,8,'2020-10-10',2,2.00,18.00,'12:49:00'),(7,8,'2020-10-10',2,1.00,18.00,'12:59:00'),(7,8,'2020-10-10',5,2.00,18.00,'12:30:00'),(7,8,'2020-10-10',6,1.00,18.00,'12:38:00'),(7,8,'2020-10-10',26,3.00,18.00,'09:25:00'),(8,8,'2019-04-03',5,1.00,18.00,'18:41:00'),(8,8,'2019-04-03',9,2.00,18.00,'16:17:00'),(8,8,'2019-04-03',10,3.00,18.00,'18:51:00'),(8,8,'2019-04-03',20,2.00,18.00,'18:32:00'),(8,8,'2019-04-03',23,3.00,18.00,'17:41:00'),(8,8,'2019-04-06',8,1.00,18.00,'13:49:00'),(8,8,'2019-04-06',14,3.00,18.00,'11:44:00'),(8,8,'2019-04-06',21,3.00,18.00,'12:55:00'),(8,8,'2019-04-06',21,2.00,18.00,'13:09:00'),(8,8,'2019-04-10',5,1.00,18.00,'17:36:00'),(8,8,'2019-04-10',11,1.00,18.00,'18:45:00'),(8,8,'2019-04-10',11,1.00,18.00,'18:51:00'),(8,8,'2019-04-10',20,2.00,18.00,'18:26:00'),(8,8,'2019-04-10',23,4.00,18.00,'17:38:00'),(8,8,'2019-04-13',3,1.00,18.00,'12:02:00'),(8,8,'2019-04-13',8,1.00,18.00,'09:39:00'),(8,8,'2019-04-13',8,1.00,18.00,'09:59:00'),(8,8,'2019-04-13',12,2.00,18.00,'10:33:00'),(8,8,'2019-04-13',25,2.00,18.00,'09:41:00'),(8,8,'2019-04-17',6,1.00,18.00,'18:31:00'),(8,8,'2019-04-17',8,3.00,18.00,'16:23:00'),(8,8,'2019-04-17',12,2.00,18.00,'17:37:00'),(8,8,'2019-04-17',18,1.00,18.00,'18:28:00'),(8,8,'2019-04-17',25,3.00,18.00,'17:15:00'),(8,8,'2019-04-20',10,1.00,18.00,'08:53:00'),(8,8,'2019-04-20',15,1.00,18.00,'09:40:00'),(8,8,'2019-04-20',15,1.00,18.00,'10:21:00'),(8,8,'2019-04-20',26,1.00,18.00,'08:51:00'),(8,8,'2019-04-20',26,2.00,18.00,'09:13:00'),(8,8,'2019-04-24',2,1.00,18.00,'18:42:00'),(8,8,'2019-04-24',6,1.00,18.00,'17:39:00'),(8,8,'2019-04-24',6,1.00,18.00,'17:41:00'),(8,8,'2019-04-24',19,1.00,18.00,'18:18:00'),(8,8,'2019-04-27',3,1.00,18.00,'11:31:00'),(8,8,'2019-04-27',8,2.00,18.00,'09:24:00'),(8,8,'2019-04-27',10,1.00,18.00,'12:59:00'),(8,8,'2019-04-27',11,2.00,18.00,'12:48:00'),(8,8,'2019-04-27',26,2.00,18.00,'11:51:00'),(8,8,'2019-05-01',2,1.00,18.00,'17:34:00'),(8,8,'2019-05-01',2,1.00,18.00,'17:50:00'),(8,8,'2019-05-01',4,2.00,18.00,'18:43:00'),(8,8,'2019-05-01',4,1.00,18.00,'18:48:00'),(8,8,'2019-05-01',21,1.00,18.00,'18:02:00'),(8,8,'2019-05-01',23,2.00,18.00,'16:36:00'),(8,8,'2019-05-01',24,2.00,18.00,'17:55:00'),(8,8,'2019-05-04',2,1.00,18.00,'09:13:00'),(8,8,'2019-05-04',2,2.00,18.00,'09:46:00'),(8,8,'2019-05-04',6,1.00,18.00,'10:54:00'),(8,8,'2019-05-04',9,1.00,18.00,'12:34:00'),(8,8,'2019-05-04',17,2.00,18.00,'13:46:00'),(8,8,'2019-05-04',20,2.00,18.00,'13:43:00'),(8,8,'2019-05-08',1,1.00,18.00,'18:17:00'),(8,8,'2019-05-08',2,1.00,18.00,'18:49:00'),(8,8,'2019-05-08',13,1.00,18.00,'17:12:00'),(8,8,'2019-05-08',13,1.00,18.00,'17:33:00'),(8,8,'2019-05-08',24,3.00,18.00,'18:54:00'),(8,8,'2019-05-11',3,3.00,18.00,'09:24:00'),(8,8,'2019-05-11',24,2.00,18.00,'10:50:00'),(8,8,'2019-05-11',24,4.00,18.00,'11:41:00'),(8,8,'2019-05-15',3,1.00,18.00,'17:57:00'),(8,8,'2019-05-15',4,2.00,18.00,'18:58:00'),(8,8,'2019-05-15',5,3.00,18.00,'18:52:00'),(8,8,'2019-05-15',22,1.00,18.00,'18:39:00'),(8,8,'2019-05-18',9,3.00,18.00,'13:16:00'),(8,8,'2019-05-18',11,2.00,18.00,'11:50:00'),(8,8,'2019-05-22',2,1.00,18.00,'16:25:00'),(8,8,'2019-05-22',3,2.00,18.00,'18:50:00'),(8,8,'2019-05-22',3,2.00,18.00,'18:55:00'),(8,8,'2019-05-22',24,4.00,18.00,'17:55:00'),(8,8,'2019-05-25',4,2.00,18.00,'09:16:00'),(8,8,'2019-05-25',7,2.00,18.00,'11:08:00'),(8,8,'2019-05-25',12,1.00,18.00,'13:40:00'),(8,8,'2019-05-25',21,1.00,18.00,'10:52:00'),(8,8,'2019-05-29',12,2.00,18.00,'17:15:00'),(8,8,'2019-05-29',12,1.00,18.00,'17:51:00'),(8,8,'2019-05-29',19,5.00,18.00,'18:53:00'),(8,8,'2019-05-29',22,2.00,18.00,'16:26:00'),(8,8,'2019-06-01',14,2.00,18.00,'12:05:00'),(8,8,'2019-06-01',14,2.00,18.00,'12:34:00'),(8,8,'2019-06-01',23,3.00,18.00,'11:06:00'),(8,8,'2019-06-05',14,3.00,18.00,'18:05:00'),(8,8,'2019-06-05',14,2.00,18.00,'18:38:00'),(8,8,'2019-06-08',6,2.00,18.00,'10:42:00'),(8,8,'2019-06-08',6,2.00,18.00,'11:14:00'),(8,8,'2019-06-12',3,2.00,18.00,'18:37:00'),(8,8,'2019-06-12',4,2.00,18.00,'17:58:00'),(8,8,'2019-06-12',5,1.00,18.00,'16:55:00'),(8,8,'2019-06-12',5,1.00,18.00,'18:07:00'),(8,8,'2019-06-12',26,2.00,18.00,'18:13:00'),(8,8,'2019-06-15',1,3.00,18.00,'10:53:00'),(8,8,'2019-06-15',1,2.00,18.00,'11:14:00'),(8,8,'2019-06-15',19,2.00,18.00,'12:40:00'),(8,8,'2019-06-15',19,2.00,18.00,'13:09:00'),(8,8,'2019-06-19',6,2.00,18.00,'18:50:00'),(8,8,'2019-06-19',6,3.00,18.00,'18:55:00'),(8,8,'2019-06-19',20,1.00,18.00,'16:31:00'),(8,8,'2019-06-22',7,1.00,18.00,'10:02:00'),(8,8,'2019-06-22',7,2.00,18.00,'10:05:00'),(8,8,'2019-06-22',12,1.00,18.00,'09:39:00'),(8,8,'2019-06-22',24,3.00,18.00,'12:14:00'),(8,8,'2019-06-26',7,1.00,18.00,'17:47:00'),(8,8,'2019-06-26',7,1.00,18.00,'18:56:00'),(8,8,'2019-06-26',22,3.00,18.00,'17:46:00'),(8,8,'2019-06-29',6,3.00,18.00,'10:23:00'),(8,8,'2019-06-29',6,2.00,18.00,'11:29:00'),(8,8,'2019-06-29',24,3.00,18.00,'09:50:00'),(8,8,'2019-07-03',3,2.00,18.00,'18:05:00'),(8,8,'2019-07-03',3,1.00,18.00,'18:13:00'),(8,8,'2019-07-03',6,2.00,18.00,'18:41:00'),(8,8,'2019-07-06',6,1.00,18.00,'13:48:00'),(8,8,'2019-07-06',10,2.00,18.00,'11:18:00'),(8,8,'2019-07-06',23,2.00,18.00,'13:02:00'),(8,8,'2019-07-10',8,2.00,18.00,'17:37:00'),(8,8,'2019-07-10',8,1.00,18.00,'18:40:00'),(8,8,'2019-07-10',11,1.00,18.00,'18:04:00'),(8,8,'2019-07-13',2,2.00,18.00,'12:20:00'),(8,8,'2019-07-13',2,2.00,18.00,'12:46:00'),(8,8,'2019-07-13',11,1.00,18.00,'09:58:00'),(8,8,'2019-07-13',24,3.00,18.00,'12:31:00'),(8,8,'2019-07-17',4,1.00,18.00,'17:22:00'),(8,8,'2019-07-17',10,1.00,18.00,'18:18:00'),(8,8,'2019-07-17',26,4.00,18.00,'17:16:00'),(8,8,'2019-07-20',2,1.00,18.00,'08:49:00'),(8,8,'2019-07-20',8,3.00,18.00,'13:22:00'),(8,8,'2019-07-20',26,1.00,18.00,'13:43:00'),(8,8,'2019-07-24',3,1.00,18.00,'18:59:00'),(8,8,'2019-07-24',12,2.00,18.00,'17:39:00'),(8,8,'2019-07-24',18,2.00,18.00,'17:00:00'),(8,8,'2019-07-24',18,2.00,18.00,'17:26:00'),(8,8,'2019-07-27',1,2.00,18.00,'09:59:00'),(8,8,'2019-07-27',6,3.00,18.00,'11:24:00'),(8,8,'2019-07-27',17,1.00,18.00,'10:35:00'),(8,8,'2019-08-03',3,2.00,18.00,'13:13:00'),(8,8,'2019-08-03',10,3.00,18.00,'11:39:00'),(8,8,'2019-08-07',2,2.00,18.00,'18:24:00'),(8,8,'2019-08-07',18,1.00,18.00,'18:26:00'),(8,8,'2019-08-10',6,1.00,18.00,'11:17:00'),(8,8,'2019-08-10',8,1.00,18.00,'09:59:00'),(8,8,'2019-08-10',11,1.00,18.00,'09:17:00'),(8,8,'2019-08-10',11,1.00,18.00,'10:07:00'),(8,8,'2019-08-14',4,2.00,18.00,'18:08:00'),(8,8,'2019-08-14',6,1.00,18.00,'17:59:00'),(8,8,'2019-08-14',9,2.00,18.00,'18:08:00'),(8,8,'2019-08-14',25,1.00,18.00,'18:38:00'),(8,8,'2019-08-17',4,1.00,18.00,'13:50:00'),(8,8,'2019-08-17',11,2.00,18.00,'13:57:00'),(8,8,'2019-08-17',14,1.00,18.00,'09:06:00'),(8,8,'2019-08-17',26,3.00,18.00,'13:41:00'),(8,8,'2019-08-21',7,2.00,18.00,'18:05:00'),(8,8,'2019-08-21',16,1.00,18.00,'16:30:00'),(8,8,'2019-08-24',4,1.00,18.00,'11:32:00'),(8,8,'2019-08-24',6,2.00,18.00,'11:50:00'),(8,8,'2019-08-24',20,1.00,18.00,'10:33:00'),(8,8,'2019-08-24',26,2.00,18.00,'13:58:00'),(8,8,'2019-08-28',9,1.00,18.00,'18:39:00'),(8,8,'2019-08-28',11,2.00,18.00,'18:57:00'),(8,8,'2019-08-28',20,4.00,18.00,'18:11:00'),(8,8,'2019-08-28',20,2.00,18.00,'18:25:00'),(8,8,'2019-08-31',6,1.00,18.00,'11:42:00'),(8,8,'2019-08-31',11,3.00,18.00,'12:17:00'),(8,8,'2019-08-31',12,1.00,18.00,'11:16:00'),(8,8,'2019-08-31',26,5.00,18.00,'08:29:00'),(8,8,'2019-09-04',5,1.00,18.00,'17:09:00'),(8,8,'2019-09-04',5,1.00,18.00,'17:52:00'),(8,8,'2019-09-04',6,1.00,18.00,'18:20:00'),(8,8,'2019-09-04',8,1.00,18.00,'18:59:00'),(8,8,'2019-09-04',14,1.00,18.00,'17:18:00'),(8,8,'2019-09-07',3,1.00,18.00,'09:35:00'),(8,8,'2019-09-07',3,1.00,18.00,'09:39:00'),(8,8,'2019-09-07',5,2.00,18.00,'10:30:00'),(8,8,'2019-09-07',8,1.00,18.00,'11:53:00'),(8,8,'2019-09-07',11,2.00,18.00,'13:38:00'),(8,8,'2019-09-07',19,1.00,18.00,'12:13:00'),(8,8,'2019-09-11',8,3.00,18.00,'18:00:00'),(8,8,'2019-09-11',8,2.00,18.00,'18:22:00'),(8,8,'2019-09-14',9,3.00,18.00,'08:26:00'),(8,8,'2019-09-14',9,2.00,18.00,'08:39:00'),(8,8,'2019-09-14',11,1.00,18.00,'09:23:00'),(8,8,'2019-09-18',5,3.00,18.00,'18:29:00'),(8,8,'2019-09-18',15,1.00,18.00,'18:46:00'),(8,8,'2019-09-18',26,2.00,18.00,'18:56:00'),(8,8,'2019-09-21',15,2.00,18.00,'09:34:00'),(8,8,'2019-09-21',15,1.00,18.00,'09:52:00'),(8,8,'2019-09-25',14,2.00,18.00,'17:54:00'),(8,8,'2019-09-25',15,2.00,18.00,'17:43:00'),(8,8,'2019-09-25',18,1.00,18.00,'17:05:00'),(8,8,'2019-09-28',2,1.00,18.00,'10:18:00'),(8,8,'2019-09-28',2,1.00,18.00,'10:45:00'),(8,8,'2019-09-28',5,1.00,18.00,'13:09:00'),(8,8,'2019-09-28',6,2.00,18.00,'11:19:00'),(8,8,'2019-09-28',12,1.00,18.00,'11:27:00'),(8,8,'2019-09-28',19,4.00,18.00,'13:48:00'),(8,8,'2019-10-02',6,2.00,18.00,'18:23:00'),(8,8,'2019-10-02',6,1.00,18.00,'18:28:00'),(8,8,'2019-10-02',7,1.00,18.00,'16:12:00'),(8,8,'2019-10-02',9,1.00,18.00,'16:57:00'),(8,8,'2019-10-05',8,3.00,18.00,'12:40:00'),(8,8,'2019-10-05',8,2.00,18.00,'12:47:00'),(8,8,'2019-10-05',25,2.00,18.00,'13:02:00'),(8,8,'2019-10-09',6,1.00,18.00,'17:44:00'),(8,8,'2019-10-09',14,2.00,18.00,'18:22:00'),(8,8,'2019-10-09',18,1.00,18.00,'16:21:00'),(8,8,'2019-10-09',20,4.00,18.00,'17:09:00'),(8,8,'2019-10-09',20,2.00,18.00,'17:40:00'),(8,8,'2019-10-12',11,3.00,18.00,'13:09:00'),(8,8,'2019-10-12',22,2.00,18.00,'11:09:00'),(8,8,'2019-10-16',8,1.00,18.00,'18:39:00'),(8,8,'2019-10-16',8,1.00,18.00,'18:59:00'),(8,8,'2019-10-16',12,1.00,18.00,'16:40:00'),(8,8,'2019-10-16',12,1.00,18.00,'17:19:00'),(8,8,'2019-10-16',21,1.00,18.00,'18:42:00'),(8,8,'2019-10-19',5,3.00,18.00,'09:18:00'),(8,8,'2019-10-19',5,1.00,18.00,'09:23:00'),(8,8,'2019-10-19',8,2.00,18.00,'09:19:00'),(8,8,'2019-10-19',17,2.00,18.00,'11:23:00'),(8,8,'2019-10-23',2,1.00,18.00,'18:09:00'),(8,8,'2019-10-23',4,1.00,18.00,'18:27:00'),(8,8,'2019-10-23',9,2.00,18.00,'16:57:00'),(8,8,'2019-10-23',13,1.00,18.00,'18:40:00'),(8,8,'2019-10-26',2,2.00,18.00,'10:47:00'),(8,8,'2019-10-26',7,2.00,18.00,'08:43:00'),(8,8,'2019-10-26',12,2.00,18.00,'13:50:00'),(8,8,'2019-10-30',3,2.00,18.00,'18:25:00'),(8,8,'2019-10-30',9,1.00,18.00,'17:23:00'),(8,8,'2019-10-30',26,2.00,18.00,'18:51:00'),(8,8,'2019-11-02',1,1.00,18.00,'12:44:00'),(8,8,'2019-11-02',11,3.00,18.00,'10:17:00'),(8,8,'2019-11-02',11,1.00,18.00,'10:41:00'),(8,8,'2019-11-02',25,2.00,18.00,'08:31:00'),(8,8,'2019-11-06',3,2.00,18.00,'17:11:00'),(8,8,'2019-11-06',5,1.00,18.00,'18:35:00'),(8,8,'2019-11-06',10,1.00,18.00,'18:47:00'),(8,8,'2019-11-06',10,1.00,18.00,'18:55:00'),(8,8,'2019-11-06',19,4.00,18.00,'16:58:00'),(8,8,'2019-11-09',2,1.00,18.00,'13:23:00'),(8,8,'2019-11-09',3,2.00,18.00,'10:45:00'),(8,8,'2019-11-09',9,2.00,18.00,'13:25:00'),(8,8,'2019-11-09',19,3.00,18.00,'13:41:00'),(8,8,'2019-11-13',1,3.00,18.00,'18:40:00'),(8,8,'2019-11-13',22,1.00,18.00,'18:59:00'),(8,8,'2019-11-13',25,2.00,18.00,'17:06:00'),(8,8,'2019-11-16',2,2.00,18.00,'13:48:00'),(8,8,'2019-11-16',3,1.00,18.00,'10:59:00'),(8,8,'2019-11-16',5,3.00,18.00,'12:08:00'),(8,8,'2019-11-16',5,1.00,18.00,'12:53:00'),(8,8,'2019-11-16',6,2.00,18.00,'13:45:00'),(8,8,'2019-11-16',7,1.00,18.00,'08:12:00'),(8,8,'2019-11-16',7,2.00,18.00,'08:51:00'),(8,8,'2019-11-16',13,2.00,18.00,'10:56:00'),(8,8,'2019-11-16',16,1.00,18.00,'10:52:00'),(8,8,'2019-11-16',19,4.00,18.00,'12:35:00'),(8,8,'2019-11-16',23,3.00,18.00,'10:53:00'),(8,8,'2019-11-20',1,2.00,18.00,'16:17:00'),(8,8,'2019-11-20',3,1.00,18.00,'17:27:00'),(8,8,'2019-11-20',11,2.00,18.00,'18:44:00'),(8,8,'2019-11-20',11,1.00,18.00,'18:45:00'),(8,8,'2019-11-20',14,1.00,18.00,'18:08:00'),(8,8,'2019-11-20',17,1.00,18.00,'18:47:00'),(8,8,'2019-11-20',25,3.00,18.00,'18:01:00'),(8,8,'2019-11-20',25,5.00,18.00,'18:42:00'),(8,8,'2019-11-23',3,1.00,18.00,'12:27:00'),(8,8,'2019-11-23',3,2.00,18.00,'12:58:00'),(8,8,'2019-11-23',5,2.00,18.00,'08:58:00'),(8,8,'2019-11-23',7,1.00,18.00,'13:55:00'),(8,8,'2019-11-23',13,2.00,18.00,'11:34:00'),(8,8,'2019-11-23',18,3.00,18.00,'11:09:00'),(8,8,'2019-11-23',18,1.00,18.00,'11:27:00'),(8,8,'2019-11-23',19,2.00,18.00,'09:08:00'),(8,8,'2019-11-23',23,5.00,18.00,'11:26:00'),(8,8,'2019-11-23',23,2.00,18.00,'11:57:00'),(8,8,'2019-11-27',5,1.00,18.00,'17:09:00'),(8,8,'2019-11-27',8,2.00,18.00,'17:44:00'),(8,8,'2019-11-27',9,1.00,18.00,'16:43:00'),(8,8,'2019-11-27',9,2.00,18.00,'16:58:00'),(8,8,'2019-11-27',11,3.00,18.00,'17:57:00'),(8,8,'2019-11-27',11,3.00,18.00,'17:58:00'),(8,8,'2019-11-27',15,1.00,18.00,'18:53:00'),(8,8,'2019-11-30',2,1.00,18.00,'10:31:00'),(8,8,'2019-11-30',2,2.00,18.00,'11:00:00'),(8,8,'2019-11-30',5,2.00,18.00,'09:20:00'),(8,8,'2019-11-30',5,2.00,18.00,'09:36:00'),(8,8,'2019-11-30',12,2.00,18.00,'09:46:00'),(8,8,'2019-11-30',14,3.00,18.00,'13:08:00'),(8,8,'2019-11-30',14,3.00,18.00,'13:37:00'),(8,8,'2019-11-30',24,2.00,18.00,'08:20:00'),(8,8,'2019-12-04',13,2.00,18.00,'18:16:00'),(8,8,'2019-12-04',13,1.00,18.00,'18:59:00'),(8,8,'2019-12-04',24,2.00,18.00,'16:46:00'),(8,8,'2019-12-04',24,1.00,18.00,'17:20:00'),(8,8,'2019-12-04',25,3.00,18.00,'16:20:00'),(8,8,'2019-12-04',25,3.00,18.00,'16:29:00'),(8,8,'2019-12-07',3,2.00,18.00,'09:28:00'),(8,8,'2019-12-07',16,1.00,18.00,'13:36:00'),(8,8,'2019-12-07',26,4.00,18.00,'13:15:00'),(8,8,'2019-12-07',26,1.00,18.00,'13:38:00'),(8,8,'2019-12-11',4,2.00,18.00,'16:36:00'),(8,8,'2019-12-11',4,1.00,18.00,'16:38:00'),(8,8,'2019-12-11',17,1.00,18.00,'18:44:00'),(8,8,'2019-12-11',18,1.00,18.00,'18:55:00'),(8,8,'2019-12-14',1,1.00,18.00,'11:05:00'),(8,8,'2019-12-14',3,2.00,18.00,'08:19:00'),(8,8,'2019-12-14',13,1.00,18.00,'08:54:00'),(8,8,'2019-12-14',23,1.00,18.00,'13:59:00'),(8,8,'2019-12-18',1,2.00,18.00,'18:50:00'),(8,8,'2019-12-18',1,3.00,18.00,'18:52:00'),(8,8,'2019-12-18',5,1.00,18.00,'17:46:00'),(8,8,'2019-12-18',9,1.00,18.00,'17:07:00'),(8,8,'2019-12-18',9,2.00,18.00,'17:51:00'),(8,8,'2019-12-18',17,1.00,18.00,'18:40:00'),(8,8,'2019-12-18',17,1.00,18.00,'18:51:00'),(8,8,'2019-12-18',22,8.00,18.00,'18:15:00'),(8,8,'2019-12-18',22,5.00,18.00,'18:47:00'),(8,8,'2019-12-21',1,1.00,18.00,'10:34:00'),(8,8,'2019-12-21',1,1.00,18.00,'10:39:00'),(8,8,'2019-12-21',3,2.00,18.00,'12:37:00'),(8,8,'2019-12-21',5,1.00,18.00,'09:18:00'),(8,8,'2019-12-21',5,2.00,18.00,'09:58:00'),(8,8,'2019-12-21',11,2.00,18.00,'13:40:00'),(8,8,'2019-12-21',18,3.00,18.00,'11:45:00'),(8,8,'2019-12-21',24,4.00,18.00,'10:33:00'),(8,8,'2019-12-25',4,3.00,18.00,'18:10:00'),(8,8,'2019-12-25',5,1.00,18.00,'16:53:00'),(8,8,'2019-12-25',5,1.00,18.00,'17:03:00'),(8,8,'2019-12-25',12,2.00,18.00,'18:49:00'),(8,8,'2019-12-25',12,2.00,18.00,'18:53:00'),(8,8,'2019-12-25',20,4.00,18.00,'17:40:00'),(8,8,'2019-12-25',20,1.00,18.00,'17:43:00'),(8,8,'2019-12-25',24,6.00,18.00,'17:52:00'),(8,8,'2019-12-28',5,1.00,18.00,'13:22:00'),(8,8,'2019-12-28',5,2.00,18.00,'13:33:00'),(8,8,'2019-12-28',6,1.00,18.00,'13:09:00'),(8,8,'2019-12-28',6,2.00,18.00,'13:11:00'),(8,8,'2019-12-28',7,1.00,18.00,'11:42:00'),(8,8,'2019-12-28',21,5.00,18.00,'09:46:00'),(8,8,'2019-12-28',21,3.00,18.00,'10:01:00'),(8,8,'2019-12-28',24,3.00,18.00,'13:48:00'),(8,8,'2019-12-28',24,5.00,18.00,'13:59:00'),(8,8,'2020-03-04',4,3.00,18.00,'18:08:00'),(8,8,'2020-03-04',19,2.00,18.00,'18:49:00'),(8,8,'2020-03-04',24,1.00,18.00,'18:47:00'),(8,8,'2020-03-07',1,1.00,18.00,'11:37:00'),(8,8,'2020-03-07',18,2.00,18.00,'10:51:00'),(8,8,'2020-03-07',21,3.00,18.00,'10:08:00'),(8,8,'2020-03-07',24,1.00,18.00,'09:47:00'),(8,8,'2020-03-11',8,1.00,18.00,'18:32:00'),(8,8,'2020-03-11',9,1.00,18.00,'17:13:00'),(8,8,'2020-03-11',11,1.00,18.00,'18:43:00'),(8,8,'2020-03-11',22,5.00,18.00,'16:12:00'),(8,8,'2020-03-11',24,2.00,18.00,'16:42:00'),(8,8,'2020-03-11',24,1.00,18.00,'16:50:00'),(8,8,'2020-03-14',8,3.00,18.00,'13:34:00'),(8,8,'2020-03-14',19,3.00,18.00,'08:52:00'),(8,8,'2020-03-18',1,1.00,18.00,'17:53:00'),(8,8,'2020-03-18',7,1.00,18.00,'17:19:00'),(8,8,'2020-03-18',9,2.00,18.00,'18:51:00'),(8,8,'2020-03-18',9,2.00,18.00,'18:57:00'),(8,8,'2020-03-18',22,2.00,18.00,'16:34:00'),(8,8,'2020-03-18',22,3.00,18.00,'16:41:00'),(8,8,'2020-03-21',14,2.00,18.00,'12:25:00'),(8,8,'2020-03-21',14,2.00,18.00,'12:53:00'),(8,8,'2020-03-21',19,3.00,18.00,'10:40:00'),(8,8,'2020-03-21',22,2.00,18.00,'09:28:00'),(8,8,'2020-03-25',5,1.00,18.00,'16:28:00'),(8,8,'2020-03-25',5,1.00,18.00,'17:10:00'),(8,8,'2020-03-25',22,5.00,18.00,'18:56:00'),(8,8,'2020-03-25',23,1.00,18.00,'17:58:00'),(8,8,'2020-03-28',6,2.00,18.00,'10:40:00'),(8,8,'2020-03-28',15,1.00,18.00,'11:31:00'),(8,8,'2020-03-28',23,4.00,18.00,'13:36:00'),(8,8,'2020-04-01',3,2.00,18.00,'18:05:00'),(8,8,'2020-04-01',3,1.00,18.00,'18:25:00'),(8,8,'2020-04-01',5,1.00,18.00,'18:03:00'),(8,8,'2020-04-01',6,1.00,18.00,'18:55:00'),(8,8,'2020-04-04',3,1.00,18.00,'13:07:00'),(8,8,'2020-04-04',3,2.00,18.00,'13:24:00'),(8,8,'2020-04-04',17,1.00,18.00,'13:30:00'),(8,8,'2020-04-04',17,2.00,18.00,'13:50:00'),(8,8,'2020-04-08',11,1.00,18.00,'18:30:00'),(8,8,'2020-04-08',16,1.00,18.00,'18:52:00'),(8,8,'2020-04-08',16,2.00,18.00,'18:56:00'),(8,8,'2020-04-11',7,2.00,18.00,'11:59:00'),(8,8,'2020-04-11',9,1.00,18.00,'09:47:00'),(8,8,'2020-04-11',9,3.00,18.00,'09:57:00'),(8,8,'2020-04-15',11,2.00,18.00,'18:20:00'),(8,8,'2020-04-15',12,1.00,18.00,'16:45:00'),(8,8,'2020-04-15',15,1.00,18.00,'18:31:00'),(8,8,'2020-04-15',15,1.00,18.00,'18:34:00'),(8,8,'2020-04-18',3,1.00,18.00,'09:50:00'),(8,8,'2020-04-18',5,1.00,18.00,'12:15:00'),(8,8,'2020-04-18',13,1.00,18.00,'08:31:00'),(8,8,'2020-04-18',16,1.00,18.00,'13:38:00'),(8,8,'2020-04-22',2,1.00,18.00,'18:44:00'),(8,8,'2020-04-22',5,1.00,18.00,'17:55:00'),(8,8,'2020-04-22',6,1.00,18.00,'18:43:00'),(8,8,'2020-04-22',8,1.00,18.00,'16:59:00'),(8,8,'2020-04-25',17,3.00,18.00,'08:54:00'),(8,8,'2020-04-25',17,1.00,18.00,'09:29:00'),(8,8,'2020-04-29',7,1.00,18.00,'17:18:00'),(8,8,'2020-04-29',7,2.00,18.00,'18:15:00'),(8,8,'2020-04-29',18,1.00,18.00,'18:15:00'),(8,8,'2020-05-02',2,1.00,18.00,'12:06:00'),(8,8,'2020-05-02',2,1.00,18.00,'12:35:00'),(8,8,'2020-05-02',3,1.00,18.00,'11:18:00'),(8,8,'2020-05-02',5,1.00,18.00,'13:59:00'),(8,8,'2020-05-02',16,1.00,18.00,'13:15:00'),(8,8,'2020-05-02',16,1.00,18.00,'13:27:00'),(8,8,'2020-05-06',5,1.00,18.00,'17:07:00'),(8,8,'2020-05-06',8,2.00,18.00,'16:39:00'),(8,8,'2020-05-06',16,2.00,18.00,'18:56:00'),(8,8,'2020-05-06',24,4.00,18.00,'18:08:00'),(8,8,'2020-05-09',2,1.00,18.00,'09:52:00'),(8,8,'2020-05-09',11,2.00,18.00,'12:16:00'),(8,8,'2020-05-09',23,1.00,18.00,'13:49:00'),(8,8,'2020-05-09',24,3.00,18.00,'09:03:00'),(8,8,'2020-05-13',6,1.00,18.00,'17:17:00'),(8,8,'2020-05-13',14,2.00,18.00,'17:22:00'),(8,8,'2020-05-13',21,2.00,18.00,'17:58:00'),(8,8,'2020-05-13',22,1.00,18.00,'18:32:00'),(8,8,'2020-05-16',8,2.00,18.00,'09:11:00'),(8,8,'2020-05-16',11,1.00,18.00,'10:43:00'),(8,8,'2020-05-16',11,1.00,18.00,'11:36:00'),(8,8,'2020-05-16',22,2.00,18.00,'09:06:00'),(8,8,'2020-05-20',12,1.00,18.00,'18:44:00'),(8,8,'2020-05-20',16,1.00,18.00,'18:37:00'),(8,8,'2020-05-20',16,2.00,18.00,'18:59:00'),(8,8,'2020-05-20',22,1.00,18.00,'18:18:00'),(8,8,'2020-05-23',2,1.00,18.00,'12:21:00'),(8,8,'2020-05-23',2,1.00,18.00,'12:36:00'),(8,8,'2020-05-23',4,1.00,18.00,'10:35:00'),(8,8,'2020-05-23',7,1.00,18.00,'09:57:00'),(8,8,'2020-05-23',9,1.00,18.00,'13:19:00'),(8,8,'2020-05-23',12,1.00,18.00,'09:36:00'),(8,8,'2020-05-23',25,2.00,18.00,'12:52:00'),(8,8,'2020-05-27',5,1.00,18.00,'18:19:00'),(8,8,'2020-05-27',5,1.00,18.00,'18:32:00'),(8,8,'2020-05-27',12,1.00,18.00,'18:26:00'),(8,8,'2020-05-27',12,2.00,18.00,'18:34:00'),(8,8,'2020-05-27',24,4.00,18.00,'18:08:00'),(8,8,'2020-05-27',24,1.00,18.00,'18:28:00'),(8,8,'2020-05-30',3,2.00,18.00,'10:10:00'),(8,8,'2020-05-30',8,1.00,18.00,'11:00:00'),(8,8,'2020-05-30',8,1.00,18.00,'11:02:00'),(8,8,'2020-05-30',17,1.00,18.00,'11:47:00'),(8,8,'2020-05-30',23,3.00,18.00,'10:33:00'),(8,8,'2020-06-03',4,1.00,18.00,'18:52:00'),(8,8,'2020-06-03',4,1.00,18.00,'18:56:00'),(8,8,'2020-06-03',20,1.00,18.00,'18:57:00'),(8,8,'2020-06-03',24,3.00,18.00,'17:33:00'),(8,8,'2020-06-06',4,1.00,18.00,'10:01:00'),(8,8,'2020-06-06',6,2.00,18.00,'10:52:00'),(8,8,'2020-06-06',24,3.00,18.00,'10:38:00'),(8,8,'2020-06-10',2,2.00,18.00,'18:46:00'),(8,8,'2020-06-10',2,1.00,18.00,'18:56:00'),(8,8,'2020-06-10',7,1.00,18.00,'17:34:00'),(8,8,'2020-06-13',2,2.00,18.00,'13:16:00'),(8,8,'2020-06-13',2,1.00,18.00,'13:54:00'),(8,8,'2020-06-13',23,2.00,18.00,'13:23:00'),(8,8,'2020-06-17',1,2.00,18.00,'18:41:00'),(8,8,'2020-06-17',3,1.00,18.00,'16:31:00'),(8,8,'2020-06-17',22,1.00,18.00,'18:27:00'),(8,8,'2020-06-20',7,1.00,18.00,'13:09:00'),(8,8,'2020-06-20',9,1.00,18.00,'10:47:00'),(8,8,'2020-06-20',9,1.00,18.00,'11:26:00'),(8,8,'2020-06-20',13,1.00,18.00,'13:29:00'),(8,8,'2020-06-20',20,1.00,18.00,'09:36:00'),(8,8,'2020-06-24',2,1.00,18.00,'18:44:00'),(8,8,'2020-06-24',2,2.00,18.00,'18:45:00'),(8,8,'2020-06-24',18,1.00,18.00,'17:26:00'),(8,8,'2020-06-24',22,1.00,18.00,'18:05:00'),(8,8,'2020-06-24',22,2.00,18.00,'18:06:00'),(8,8,'2020-06-27',7,1.00,18.00,'08:59:00'),(8,8,'2020-06-27',8,1.00,18.00,'08:49:00'),(8,8,'2020-06-27',12,1.00,18.00,'08:40:00'),(8,8,'2020-06-27',21,4.00,18.00,'13:50:00'),(8,8,'2020-06-27',21,1.00,18.00,'13:52:00'),(8,8,'2020-07-01',3,1.00,18.00,'18:08:00'),(8,8,'2020-07-01',13,2.00,18.00,'18:50:00'),(8,8,'2020-07-04',5,2.00,18.00,'13:01:00'),(8,8,'2020-07-08',5,2.00,18.00,'18:46:00'),(8,8,'2020-07-08',10,1.00,18.00,'18:10:00'),(8,8,'2020-07-08',14,1.00,18.00,'17:12:00'),(8,8,'2020-07-11',3,2.00,18.00,'12:42:00'),(8,8,'2020-07-11',12,1.00,18.00,'12:10:00'),(8,8,'2020-07-11',15,1.00,18.00,'13:00:00'),(8,8,'2020-07-11',16,1.00,18.00,'11:50:00'),(8,8,'2020-07-15',1,2.00,18.00,'18:52:00'),(8,8,'2020-07-15',5,2.00,18.00,'17:26:00'),(8,8,'2020-07-15',8,1.00,18.00,'17:31:00'),(8,8,'2020-07-18',2,2.00,18.00,'09:06:00'),(8,8,'2020-07-18',11,2.00,18.00,'11:57:00'),(8,8,'2020-07-18',11,3.00,18.00,'12:14:00'),(8,8,'2020-07-22',5,2.00,18.00,'17:11:00'),(8,8,'2020-07-22',5,1.00,18.00,'17:44:00'),(8,8,'2020-07-22',18,2.00,18.00,'16:39:00'),(8,8,'2020-07-25',13,3.00,18.00,'13:41:00'),(8,8,'2020-07-29',4,2.00,18.00,'18:13:00'),(8,8,'2020-07-29',6,1.00,18.00,'18:17:00'),(8,8,'2020-07-29',8,3.00,18.00,'17:29:00'),(8,8,'2020-08-01',3,1.00,18.00,'13:21:00'),(8,8,'2020-08-01',4,1.00,18.00,'10:09:00'),(8,8,'2020-08-01',7,1.00,18.00,'11:20:00'),(8,8,'2020-08-01',15,1.00,18.00,'13:12:00'),(8,8,'2020-08-05',1,2.00,18.00,'17:21:00'),(8,8,'2020-08-05',10,1.00,18.00,'18:56:00'),(8,8,'2020-08-05',26,4.00,18.00,'18:54:00'),(8,8,'2020-08-08',9,3.00,18.00,'13:33:00'),(8,8,'2020-08-08',9,2.00,18.00,'13:34:00'),(8,8,'2020-08-08',13,2.00,18.00,'10:02:00'),(8,8,'2020-08-08',15,1.00,18.00,'11:41:00'),(8,8,'2020-08-12',1,3.00,18.00,'18:36:00'),(8,8,'2020-08-12',6,2.00,18.00,'18:01:00'),(8,8,'2020-08-12',7,1.00,18.00,'17:47:00'),(8,8,'2020-08-12',21,2.00,18.00,'18:22:00'),(8,8,'2020-08-15',2,1.00,18.00,'12:08:00'),(8,8,'2020-08-15',4,3.00,18.00,'13:08:00'),(8,8,'2020-08-15',15,1.00,18.00,'12:44:00'),(8,8,'2020-08-19',1,2.00,18.00,'18:38:00'),(8,8,'2020-08-19',1,1.00,18.00,'18:39:00'),(8,8,'2020-08-19',2,1.00,18.00,'18:54:00'),(8,8,'2020-08-19',12,2.00,18.00,'18:37:00'),(8,8,'2020-08-19',14,1.00,18.00,'18:46:00'),(8,8,'2020-08-19',26,2.00,18.00,'17:55:00'),(8,8,'2020-08-22',3,1.00,18.00,'13:51:00'),(8,8,'2020-08-22',11,1.00,18.00,'11:45:00'),(8,8,'2020-08-22',11,1.00,18.00,'12:15:00'),(8,8,'2020-08-26',6,3.00,18.00,'18:07:00'),(8,8,'2020-08-26',12,1.00,18.00,'18:47:00'),(8,8,'2020-08-26',15,1.00,18.00,'18:15:00'),(8,8,'2020-08-29',1,2.00,18.00,'10:11:00'),(8,8,'2020-08-29',3,1.00,18.00,'13:57:00'),(8,8,'2020-08-29',4,1.00,18.00,'09:10:00'),(8,8,'2020-09-02',1,2.00,18.00,'17:49:00'),(8,8,'2020-09-02',1,2.00,18.00,'18:00:00'),(8,8,'2020-09-02',20,4.00,18.00,'16:46:00'),(8,8,'2020-09-05',1,1.00,18.00,'11:42:00'),(8,8,'2020-09-05',16,2.00,18.00,'10:02:00'),(8,8,'2020-09-09',4,2.00,18.00,'18:48:00'),(8,8,'2020-09-09',12,2.00,18.00,'18:34:00'),(8,8,'2020-09-09',21,3.00,18.00,'16:37:00'),(8,8,'2020-09-12',8,1.00,18.00,'10:06:00'),(8,8,'2020-09-12',8,2.00,18.00,'11:06:00'),(8,8,'2020-09-16',5,1.00,18.00,'18:01:00'),(8,8,'2020-09-16',5,2.00,18.00,'18:02:00'),(8,8,'2020-09-16',14,2.00,18.00,'18:43:00'),(8,8,'2020-09-16',19,1.00,18.00,'18:44:00'),(8,8,'2020-09-19',2,2.00,18.00,'13:51:00'),(8,8,'2020-09-19',2,2.00,18.00,'13:58:00'),(8,8,'2020-09-23',1,1.00,18.00,'17:48:00'),(8,8,'2020-09-23',1,1.00,18.00,'18:36:00'),(8,8,'2020-09-23',10,1.00,18.00,'17:07:00'),(8,8,'2020-09-23',21,2.00,18.00,'17:49:00'),(8,8,'2020-09-26',4,1.00,18.00,'11:42:00'),(8,8,'2020-09-26',18,1.00,18.00,'13:09:00'),(8,8,'2020-09-26',18,1.00,18.00,'13:24:00'),(8,8,'2020-09-26',21,1.00,18.00,'13:23:00'),(8,8,'2020-09-30',3,1.00,18.00,'16:28:00'),(8,8,'2020-09-30',9,2.00,18.00,'18:59:00'),(8,8,'2020-09-30',11,2.00,18.00,'18:33:00'),(8,8,'2020-09-30',26,2.00,18.00,'16:30:00'),(8,8,'2020-10-03',3,1.00,18.00,'13:50:00'),(8,8,'2020-10-03',4,2.00,18.00,'10:10:00'),(8,8,'2020-10-03',8,1.00,18.00,'09:57:00'),(8,8,'2020-10-03',9,2.00,18.00,'12:47:00'),(8,8,'2020-10-03',12,2.00,18.00,'12:50:00'),(8,8,'2020-10-03',23,1.00,18.00,'09:54:00'),(8,8,'2020-10-07',1,2.00,18.00,'17:59:00'),(8,8,'2020-10-07',2,2.00,18.00,'18:44:00'),(8,8,'2020-10-07',8,2.00,18.00,'18:23:00'),(8,8,'2020-10-07',23,4.00,18.00,'18:08:00'),(8,8,'2020-10-07',24,1.00,18.00,'18:26:00'),(8,8,'2020-10-10',7,1.00,18.00,'13:44:00'),(8,8,'2020-10-10',8,2.00,18.00,'09:26:00'),(8,8,'2020-10-10',9,1.00,18.00,'12:34:00'),(8,8,'2020-10-10',23,5.00,18.00,'12:30:00'),(8,8,'2020-10-10',23,2.00,18.00,'12:54:00'),(16,4,'2019-06-01',1,8.00,0.45,'13:12:00'),(16,4,'2019-06-01',12,4.00,0.50,'12:34:00'),(16,4,'2019-06-01',12,2.00,0.50,'12:41:00'),(16,4,'2019-06-01',17,4.00,0.50,'12:54:00'),(16,4,'2019-06-05',2,5.00,0.50,'17:59:00'),(16,4,'2019-06-05',2,2.00,0.50,'18:09:00'),(16,4,'2019-06-05',11,4.00,0.50,'18:44:00'),(16,4,'2019-06-05',15,1.00,0.50,'17:23:00'),(16,4,'2019-06-05',16,5.00,0.50,'17:56:00'),(16,4,'2019-06-05',16,5.00,0.50,'18:38:00'),(16,4,'2019-06-05',26,4.00,0.50,'18:15:00'),(16,4,'2019-06-05',26,5.00,0.50,'18:32:00'),(16,4,'2019-06-08',6,2.00,0.50,'08:46:00'),(16,4,'2019-06-08',6,5.00,0.50,'09:52:00'),(16,4,'2019-06-08',7,2.00,0.50,'13:07:00'),(16,4,'2019-06-08',9,3.00,0.50,'11:07:00'),(16,4,'2019-06-08',10,20.00,0.40,'10:10:00'),(16,4,'2019-06-08',12,6.00,0.50,'13:51:00'),(16,4,'2019-06-08',16,2.00,0.50,'13:51:00'),(16,4,'2019-06-08',18,6.00,0.50,'09:20:00'),(16,4,'2019-06-08',24,1.00,0.50,'10:37:00'),(16,4,'2019-06-08',24,6.00,0.50,'11:28:00'),(16,4,'2019-06-08',25,2.00,0.50,'10:57:00'),(16,4,'2019-06-08',25,3.00,0.50,'11:10:00'),(16,4,'2019-06-12',1,8.00,0.45,'18:45:00'),(16,4,'2019-06-12',1,6.00,0.50,'18:54:00'),(16,4,'2019-06-12',4,6.00,0.50,'18:52:00'),(16,4,'2019-06-12',5,3.00,0.50,'18:22:00'),(16,4,'2019-06-12',9,1.00,0.50,'18:18:00'),(16,4,'2019-06-12',15,4.00,0.50,'16:21:00'),(16,4,'2019-06-12',18,8.00,0.45,'16:44:00'),(16,4,'2019-06-12',18,6.00,0.50,'17:30:00'),(16,4,'2019-06-12',24,1.00,0.50,'18:33:00'),(16,4,'2019-06-12',26,4.00,0.50,'18:32:00'),(16,4,'2019-06-15',2,3.00,0.50,'08:42:00'),(16,4,'2019-06-15',4,6.00,0.50,'09:22:00'),(16,4,'2019-06-15',5,4.00,0.50,'12:55:00'),(16,4,'2019-06-15',6,1.00,0.50,'10:07:00'),(16,4,'2019-06-15',6,2.00,0.50,'10:35:00'),(16,4,'2019-06-15',7,1.00,0.50,'09:13:00'),(16,4,'2019-06-15',10,20.00,0.40,'10:19:00'),(16,4,'2019-06-15',10,20.00,0.40,'10:26:00'),(16,4,'2019-06-19',1,8.00,0.45,'18:46:00'),(16,4,'2019-06-19',2,1.00,0.50,'18:10:00'),(16,4,'2019-06-19',2,4.00,0.50,'18:14:00'),(16,4,'2019-06-19',4,10.00,0.45,'17:28:00'),(16,4,'2019-06-19',7,1.00,0.50,'18:18:00'),(16,4,'2019-06-19',8,2.00,0.50,'17:33:00'),(16,4,'2019-06-19',9,5.00,0.50,'17:22:00'),(16,4,'2019-06-19',9,5.00,0.50,'18:17:00'),(16,4,'2019-06-19',12,8.00,0.45,'17:51:00'),(16,4,'2019-06-19',12,6.00,0.50,'18:01:00'),(16,4,'2019-06-19',20,2.00,0.50,'16:30:00'),(16,4,'2019-06-19',21,3.00,0.50,'17:32:00'),(16,4,'2019-06-22',4,4.00,0.50,'11:07:00'),(16,4,'2019-06-22',6,3.00,0.50,'12:27:00'),(16,4,'2019-06-22',7,5.00,0.50,'10:11:00'),(16,4,'2019-06-22',9,1.00,0.50,'12:38:00'),(16,4,'2019-06-22',15,2.00,0.50,'10:12:00'),(16,4,'2019-06-22',15,3.00,0.50,'10:25:00'),(16,4,'2019-06-22',20,1.00,0.50,'09:29:00'),(16,4,'2019-06-22',26,7.00,0.50,'13:22:00'),(16,4,'2019-06-22',26,4.00,0.50,'13:23:00'),(16,4,'2019-06-26',1,6.00,0.50,'16:40:00'),(16,4,'2019-06-26',1,8.00,0.45,'16:43:00'),(16,4,'2019-06-26',2,2.00,0.50,'18:22:00'),(16,4,'2019-06-26',3,4.00,0.50,'17:04:00'),(16,4,'2019-06-26',6,3.00,0.50,'17:41:00'),(16,4,'2019-06-26',7,4.00,0.50,'16:49:00'),(16,4,'2019-06-26',7,4.00,0.50,'17:24:00'),(16,4,'2019-06-26',8,2.00,0.50,'18:01:00'),(16,4,'2019-06-26',10,20.00,0.40,'17:09:00'),(16,4,'2019-06-26',10,20.00,0.40,'17:37:00'),(16,4,'2019-06-26',12,6.00,0.50,'18:20:00'),(16,4,'2019-06-26',25,4.00,0.50,'17:08:00'),(16,4,'2019-06-29',2,4.00,0.50,'12:50:00'),(16,4,'2019-06-29',4,10.00,0.45,'09:11:00'),(16,4,'2019-06-29',4,8.00,0.45,'09:44:00'),(16,4,'2019-06-29',5,5.00,0.50,'11:30:00'),(16,4,'2019-06-29',6,5.00,0.50,'09:37:00'),(16,4,'2019-06-29',19,5.00,0.50,'11:06:00'),(16,4,'2019-06-29',25,2.00,0.50,'09:38:00'),(16,4,'2019-07-03',3,8.00,0.45,'18:13:00'),(16,4,'2019-07-03',5,4.00,0.50,'18:13:00'),(16,4,'2019-07-03',17,4.00,0.50,'18:55:00'),(16,4,'2019-07-03',22,3.00,0.50,'17:30:00'),(16,4,'2019-07-06',2,3.00,0.50,'10:16:00'),(16,4,'2019-07-06',6,4.00,0.50,'09:27:00'),(16,4,'2019-07-06',6,3.00,0.50,'09:31:00'),(16,4,'2019-07-06',8,4.00,0.50,'10:45:00'),(16,4,'2019-07-06',14,3.00,0.50,'09:28:00'),(16,4,'2019-07-06',14,4.00,0.50,'09:55:00'),(16,4,'2019-07-06',16,4.00,0.50,'11:12:00'),(16,4,'2019-07-06',18,8.00,0.45,'11:51:00'),(16,4,'2019-07-06',19,2.00,0.50,'09:38:00'),(16,4,'2019-07-10',2,8.00,0.45,'18:58:00'),(16,4,'2019-07-10',9,2.00,0.50,'17:40:00'),(16,4,'2019-07-10',11,10.00,0.50,'18:37:00'),(16,4,'2019-07-10',13,6.00,0.50,'18:28:00'),(16,4,'2019-07-10',16,8.00,0.45,'16:41:00'),(16,4,'2019-07-10',23,3.00,0.50,'18:58:00'),(16,4,'2019-07-10',23,4.00,0.50,'18:59:00'),(16,4,'2019-07-13',2,4.00,0.50,'13:36:00'),(16,4,'2019-07-13',6,6.00,0.50,'11:26:00'),(16,4,'2019-07-13',13,2.00,0.50,'12:25:00'),(16,4,'2019-07-13',23,2.00,0.50,'10:40:00'),(16,4,'2019-07-13',26,5.00,0.50,'12:23:00'),(16,4,'2019-07-17',2,10.00,0.50,'17:34:00'),(16,4,'2019-07-17',6,8.00,0.45,'16:39:00'),(16,4,'2019-07-17',13,2.00,0.50,'17:04:00'),(16,4,'2019-07-17',21,1.00,0.50,'18:19:00'),(16,4,'2019-07-17',26,4.00,0.50,'17:05:00'),(16,4,'2019-07-17',26,4.00,0.50,'17:26:00'),(16,4,'2019-07-20',3,16.00,0.45,'11:16:00'),(16,4,'2019-07-20',4,8.00,0.45,'09:37:00'),(16,4,'2019-07-20',4,16.00,0.45,'09:45:00'),(16,4,'2019-07-20',11,2.00,0.50,'13:21:00'),(16,4,'2019-07-20',21,2.00,0.50,'11:44:00'),(16,4,'2019-07-24',4,8.00,0.45,'17:55:00'),(16,4,'2019-07-24',14,10.00,0.50,'16:42:00'),(16,4,'2019-07-24',16,10.00,0.50,'18:57:00'),(16,4,'2019-07-24',25,3.00,0.50,'18:20:00'),(16,4,'2019-07-27',2,2.00,0.50,'12:57:00'),(16,4,'2019-07-27',6,3.00,0.50,'13:12:00'),(16,4,'2019-07-27',6,2.00,0.50,'13:55:00'),(16,4,'2019-07-27',10,20.00,0.40,'08:45:00'),(16,4,'2019-07-27',13,2.00,0.50,'09:30:00'),(16,4,'2019-07-27',17,1.00,0.50,'10:31:00'),(16,4,'2019-07-27',20,3.00,0.50,'13:40:00'),(16,4,'2019-07-27',24,5.00,0.50,'09:23:00'),(16,4,'2019-07-31',1,8.00,0.45,'18:45:00'),(16,4,'2019-07-31',9,6.00,0.50,'18:57:00'),(16,4,'2019-07-31',11,6.00,0.50,'16:32:00'),(16,4,'2019-07-31',21,3.00,0.50,'17:39:00'),(16,4,'2019-07-31',21,6.00,0.50,'18:41:00'),(16,4,'2019-07-31',22,4.00,0.50,'17:13:00'),(16,4,'2019-08-03',2,10.00,0.50,'13:17:00'),(16,4,'2019-08-03',3,10.00,0.45,'09:59:00'),(16,4,'2019-08-03',7,2.00,0.50,'13:48:00'),(16,4,'2019-08-03',13,4.00,0.50,'13:07:00'),(16,4,'2019-08-03',16,2.00,0.50,'12:39:00'),(16,4,'2019-08-03',25,4.00,0.50,'12:27:00'),(16,4,'2019-08-03',25,4.00,0.50,'12:42:00'),(16,4,'2019-08-07',1,8.00,0.45,'17:55:00'),(16,4,'2019-08-07',13,6.00,0.50,'18:22:00'),(16,4,'2019-08-07',18,16.00,0.45,'17:00:00'),(16,4,'2019-08-07',18,4.00,0.50,'17:51:00'),(16,4,'2019-08-10',1,2.00,0.50,'09:56:00'),(16,4,'2019-08-10',2,3.00,0.50,'09:41:00'),(16,4,'2019-08-10',2,1.00,0.50,'09:52:00'),(16,4,'2019-08-10',4,4.00,0.50,'12:48:00'),(16,4,'2019-08-10',4,4.00,0.50,'13:42:00'),(16,4,'2019-08-10',5,2.00,0.50,'10:16:00'),(16,4,'2019-08-10',5,5.00,0.50,'10:54:00'),(16,4,'2019-08-10',7,4.00,0.50,'09:40:00'),(16,4,'2019-08-10',7,4.00,0.50,'10:12:00'),(16,4,'2019-08-10',25,4.00,0.50,'12:17:00'),(16,4,'2019-08-10',25,1.00,0.50,'12:49:00'),(16,4,'2019-08-14',2,5.00,0.50,'18:01:00'),(16,4,'2019-08-14',3,2.00,0.50,'17:09:00'),(16,4,'2019-08-14',8,3.00,0.50,'17:35:00'),(16,4,'2019-08-14',10,20.00,0.40,'17:11:00'),(16,4,'2019-08-14',26,2.00,0.50,'18:44:00'),(16,4,'2019-08-17',2,8.00,0.45,'09:23:00'),(16,4,'2019-08-17',5,8.00,0.45,'08:38:00'),(16,4,'2019-08-17',12,10.00,0.45,'08:59:00'),(16,4,'2019-08-17',25,4.00,0.50,'11:28:00'),(16,4,'2019-08-17',25,4.00,0.50,'11:55:00'),(16,4,'2019-08-21',5,4.00,0.50,'17:27:00'),(16,4,'2019-08-21',6,2.00,0.50,'18:57:00'),(16,4,'2019-08-21',20,2.00,0.50,'16:46:00'),(16,4,'2019-08-21',26,3.00,0.50,'17:14:00'),(16,4,'2019-08-24',1,8.00,0.45,'13:54:00'),(16,4,'2019-08-24',2,3.00,0.50,'13:30:00'),(16,4,'2019-08-24',3,8.00,0.45,'10:19:00'),(16,4,'2019-08-24',3,8.00,0.45,'10:23:00'),(16,4,'2019-08-24',5,2.00,0.50,'13:48:00'),(16,4,'2019-08-24',9,5.00,0.50,'12:59:00'),(16,4,'2019-08-24',13,3.00,0.50,'11:17:00'),(16,4,'2019-08-24',20,3.00,0.50,'11:00:00'),(16,4,'2019-08-28',2,8.00,0.45,'18:28:00'),(16,4,'2019-08-28',2,2.00,0.50,'18:33:00'),(16,4,'2019-08-28',8,10.00,0.50,'18:28:00'),(16,4,'2019-08-28',22,7.00,0.50,'18:52:00'),(16,4,'2019-08-31',1,10.00,0.45,'13:08:00'),(16,4,'2019-08-31',1,10.00,0.45,'13:22:00'),(16,4,'2019-08-31',3,10.00,0.45,'10:50:00'),(16,4,'2019-08-31',4,10.00,0.45,'09:09:00'),(16,4,'2019-08-31',6,5.00,0.50,'12:57:00'),(16,4,'2019-08-31',9,4.00,0.50,'08:48:00'),(16,4,'2019-09-04',2,3.00,0.50,'17:11:00'),(16,4,'2019-09-04',3,2.00,0.50,'16:55:00'),(16,4,'2019-09-04',5,1.00,0.50,'17:24:00'),(16,4,'2019-09-04',7,5.00,0.50,'18:26:00'),(16,4,'2019-09-04',11,4.00,0.50,'17:08:00'),(16,4,'2019-09-04',11,4.00,0.50,'17:41:00'),(16,4,'2019-09-04',12,6.00,0.50,'18:56:00'),(16,4,'2019-09-07',3,16.00,0.45,'11:46:00'),(16,4,'2019-09-07',17,4.00,0.50,'11:15:00'),(16,4,'2019-09-07',19,1.00,0.50,'11:50:00'),(16,4,'2019-09-07',23,4.00,0.50,'12:05:00'),(16,4,'2019-09-11',1,6.00,0.50,'18:11:00'),(16,4,'2019-09-11',4,8.00,0.45,'18:54:00'),(16,4,'2019-09-11',5,2.00,0.50,'18:57:00'),(16,4,'2019-09-11',11,1.00,0.50,'17:59:00'),(16,4,'2019-09-11',13,3.00,0.50,'17:48:00'),(16,4,'2019-09-11',20,5.00,0.50,'18:37:00'),(16,4,'2019-09-11',20,4.00,0.50,'18:39:00'),(16,4,'2019-09-14',2,2.00,0.50,'11:30:00'),(16,4,'2019-09-14',4,12.00,0.50,'09:08:00'),(16,4,'2019-09-14',8,6.00,0.50,'11:02:00'),(16,4,'2019-09-14',9,4.00,0.50,'10:04:00'),(16,4,'2019-09-14',19,3.00,0.50,'10:15:00'),(16,4,'2019-09-18',9,6.00,0.50,'16:54:00'),(16,4,'2019-09-18',14,2.00,0.50,'18:43:00'),(16,4,'2019-09-18',14,6.00,0.50,'18:46:00'),(16,4,'2019-09-18',16,4.00,0.50,'18:10:00'),(16,4,'2019-09-18',21,2.00,0.50,'17:57:00'),(16,4,'2019-09-18',26,4.00,0.50,'18:56:00'),(16,4,'2019-09-21',1,2.00,0.50,'11:57:00'),(16,4,'2019-09-21',2,3.00,0.50,'08:45:00'),(16,4,'2019-09-21',2,1.00,0.50,'09:14:00'),(16,4,'2019-09-21',3,10.00,0.45,'09:18:00'),(16,4,'2019-09-21',22,4.00,0.50,'13:35:00'),(16,4,'2019-09-21',22,2.00,0.50,'13:41:00'),(16,4,'2019-09-25',4,2.00,0.50,'17:39:00'),(16,4,'2019-09-25',10,20.00,0.40,'18:16:00'),(16,4,'2019-09-25',12,2.00,0.50,'17:51:00'),(16,4,'2019-09-25',13,1.00,0.50,'17:57:00'),(16,4,'2019-09-28',4,10.00,0.45,'13:17:00'),(16,4,'2019-09-28',14,5.00,0.50,'10:19:00'),(16,4,'2019-09-28',14,4.00,0.50,'10:48:00'),(16,4,'2019-09-28',15,1.00,0.50,'08:53:00'),(16,4,'2019-09-28',20,4.00,0.50,'12:52:00'),(16,4,'2020-06-03',2,4.00,0.50,'18:44:00'),(16,4,'2020-06-03',2,2.00,0.50,'18:59:00'),(16,4,'2020-06-03',3,10.00,0.45,'17:56:00'),(16,4,'2020-06-03',3,4.00,0.50,'18:44:00'),(16,4,'2020-06-03',5,4.00,0.50,'18:47:00'),(16,4,'2020-06-03',18,2.00,0.50,'18:34:00'),(16,4,'2020-06-03',18,6.00,0.50,'18:42:00'),(16,4,'2020-06-03',22,4.00,0.50,'18:17:00'),(16,4,'2020-06-06',1,2.00,0.50,'11:07:00'),(16,4,'2020-06-06',3,2.00,0.50,'09:16:00'),(16,4,'2020-06-06',4,6.00,0.50,'12:03:00'),(16,4,'2020-06-06',4,6.00,0.50,'12:16:00'),(16,4,'2020-06-06',5,3.00,0.50,'10:13:00'),(16,4,'2020-06-06',6,5.00,0.50,'13:07:00'),(16,4,'2020-06-06',10,20.00,0.40,'13:53:00'),(16,4,'2020-06-06',26,3.00,0.50,'13:49:00'),(16,4,'2020-06-10',4,4.00,0.50,'18:44:00'),(16,4,'2020-06-10',4,4.00,0.50,'18:58:00'),(16,4,'2020-06-10',5,5.00,0.50,'18:10:00'),(16,4,'2020-06-10',7,2.00,0.50,'18:46:00'),(16,4,'2020-06-10',9,1.00,0.50,'17:33:00'),(16,4,'2020-06-10',9,3.00,0.50,'17:41:00'),(16,4,'2020-06-10',16,3.00,0.50,'18:54:00'),(16,4,'2020-06-10',22,2.00,0.50,'17:10:00'),(16,4,'2020-06-10',22,2.00,0.50,'17:33:00'),(16,4,'2020-06-10',23,3.00,0.50,'18:25:00'),(16,4,'2020-06-10',23,5.00,0.50,'18:39:00'),(16,4,'2020-06-13',3,6.00,0.50,'09:33:00'),(16,4,'2020-06-13',6,5.00,0.50,'11:52:00'),(16,4,'2020-06-13',7,3.00,0.50,'11:48:00'),(16,4,'2020-06-13',10,20.00,0.40,'13:02:00'),(16,4,'2020-06-13',15,1.00,0.50,'08:55:00'),(16,4,'2020-06-13',19,4.00,0.50,'10:56:00'),(16,4,'2020-06-13',25,4.00,0.50,'10:30:00'),(16,4,'2020-06-17',3,6.00,0.50,'17:39:00'),(16,4,'2020-06-17',3,10.00,0.45,'17:58:00'),(16,4,'2020-06-17',4,8.00,0.45,'17:10:00'),(16,4,'2020-06-17',4,2.00,0.50,'17:56:00'),(16,4,'2020-06-17',6,3.00,0.50,'18:37:00'),(16,4,'2020-06-17',6,5.00,0.50,'18:40:00'),(16,4,'2020-06-17',9,1.00,0.50,'18:55:00'),(16,4,'2020-06-17',9,4.00,0.50,'18:58:00'),(16,4,'2020-06-17',15,1.00,0.50,'17:36:00'),(16,4,'2020-06-20',2,4.00,0.50,'08:09:00'),(16,4,'2020-06-20',2,5.00,0.50,'08:14:00'),(16,4,'2020-06-20',10,20.00,0.40,'09:22:00'),(16,4,'2020-06-20',12,10.00,0.45,'08:53:00'),(16,4,'2020-06-20',13,3.00,0.50,'13:12:00'),(16,4,'2020-06-20',13,5.00,0.50,'13:39:00'),(16,4,'2020-06-20',17,4.00,0.50,'11:24:00'),(16,4,'2020-06-20',21,4.00,0.50,'13:49:00'),(16,4,'2020-06-24',3,8.00,0.45,'17:55:00'),(16,4,'2020-06-24',4,10.00,0.45,'18:30:00'),(16,4,'2020-06-24',4,10.00,0.45,'18:58:00'),(16,4,'2020-06-24',5,2.00,0.50,'16:31:00'),(16,4,'2020-06-24',10,20.00,0.40,'17:16:00'),(16,4,'2020-06-24',10,20.00,0.40,'17:37:00'),(16,4,'2020-06-24',15,2.00,0.50,'17:18:00'),(16,4,'2020-06-24',17,4.00,0.50,'17:51:00'),(16,4,'2020-06-24',23,4.00,0.50,'18:34:00'),(16,4,'2020-06-27',4,8.00,0.45,'11:53:00'),(16,4,'2020-06-27',4,8.00,0.45,'11:58:00'),(16,4,'2020-06-27',8,3.00,0.50,'11:13:00'),(16,4,'2020-06-27',18,8.00,0.45,'13:35:00'),(16,4,'2020-06-27',18,8.00,0.45,'13:39:00'),(16,4,'2020-06-27',25,3.00,0.50,'08:46:00'),(16,4,'2020-07-01',5,4.00,0.50,'18:41:00'),(16,4,'2020-07-01',16,8.00,0.45,'18:29:00'),(16,4,'2020-07-01',20,3.00,0.50,'16:47:00'),(16,4,'2020-07-01',20,5.00,0.50,'17:31:00'),(16,4,'2020-07-01',25,6.00,0.50,'18:23:00'),(16,4,'2020-07-04',1,16.00,0.45,'09:13:00'),(16,4,'2020-07-04',1,12.00,0.50,'10:11:00'),(16,4,'2020-07-04',8,2.00,0.50,'13:53:00'),(16,4,'2020-07-04',11,10.00,0.50,'11:11:00'),(16,4,'2020-07-04',11,2.00,0.50,'11:20:00'),(16,4,'2020-07-04',17,6.00,0.50,'09:46:00'),(16,4,'2020-07-04',26,5.00,0.50,'12:16:00'),(16,4,'2020-07-08',2,4.00,0.50,'17:58:00'),(16,4,'2020-07-08',6,2.00,0.50,'17:01:00'),(16,4,'2020-07-08',7,2.00,0.50,'16:31:00'),(16,4,'2020-07-08',12,4.00,0.50,'17:09:00'),(16,4,'2020-07-08',22,3.00,0.50,'18:24:00'),(16,4,'2020-07-08',22,1.00,0.50,'18:38:00'),(16,4,'2020-07-11',4,12.00,0.50,'10:55:00'),(16,4,'2020-07-11',4,16.00,0.45,'11:02:00'),(16,4,'2020-07-11',6,8.00,0.45,'09:11:00'),(16,4,'2020-07-11',13,10.00,0.50,'10:08:00'),(16,4,'2020-07-11',14,10.00,0.50,'11:08:00'),(16,4,'2020-07-15',4,10.00,0.45,'18:57:00'),(16,4,'2020-07-15',4,6.00,0.50,'18:59:00'),(16,4,'2020-07-15',10,20.00,0.40,'18:20:00'),(16,4,'2020-07-15',10,20.00,0.40,'18:23:00'),(16,4,'2020-07-15',16,2.00,0.50,'17:40:00'),(16,4,'2020-07-15',18,10.00,0.45,'18:46:00'),(16,4,'2020-07-18',15,2.00,0.50,'13:54:00'),(16,4,'2020-07-18',15,2.00,0.50,'13:59:00'),(16,4,'2020-07-18',18,8.00,0.45,'10:17:00'),(16,4,'2020-07-18',22,2.00,0.50,'10:51:00'),(16,4,'2020-07-22',1,10.00,0.45,'17:21:00'),(16,4,'2020-07-22',1,8.00,0.45,'17:58:00'),(16,4,'2020-07-22',3,10.00,0.45,'18:43:00'),(16,4,'2020-07-22',6,3.00,0.50,'17:13:00'),(16,4,'2020-07-22',6,2.00,0.50,'18:19:00'),(16,4,'2020-07-22',12,8.00,0.45,'18:22:00'),(16,4,'2020-07-22',24,2.00,0.50,'17:19:00'),(16,4,'2020-07-22',25,5.00,0.50,'18:55:00'),(16,4,'2020-07-22',25,3.00,0.50,'18:56:00'),(16,4,'2020-07-25',1,8.00,0.45,'09:47:00'),(16,4,'2020-07-25',2,2.00,0.50,'09:32:00'),(16,4,'2020-07-25',4,10.00,0.45,'12:41:00'),(16,4,'2020-07-25',4,6.00,0.50,'13:16:00'),(16,4,'2020-07-25',7,3.00,0.50,'09:33:00'),(16,4,'2020-07-25',9,1.00,0.50,'11:54:00'),(16,4,'2020-07-25',13,1.00,0.50,'12:43:00'),(16,4,'2020-07-25',19,3.00,0.50,'12:13:00'),(16,4,'2020-07-25',21,4.00,0.50,'11:14:00'),(16,4,'2020-07-29',1,2.00,0.50,'16:42:00'),(16,4,'2020-07-29',8,3.00,0.50,'16:56:00'),(16,4,'2020-07-29',8,4.00,0.50,'17:34:00'),(16,4,'2020-07-29',9,4.00,0.50,'18:55:00'),(16,4,'2020-07-29',10,20.00,0.40,'18:56:00'),(16,4,'2020-07-29',12,2.00,0.50,'18:37:00'),(16,4,'2020-07-29',24,5.00,0.50,'16:39:00'),(16,4,'2020-08-01',2,6.00,0.50,'10:08:00'),(16,4,'2020-08-01',8,2.00,0.50,'09:10:00'),(16,4,'2020-08-01',11,2.00,0.50,'13:02:00'),(16,4,'2020-08-01',26,4.00,0.50,'12:45:00'),(16,4,'2020-08-05',1,8.00,0.45,'17:10:00'),(16,4,'2020-08-05',1,4.00,0.50,'17:13:00'),(16,4,'2020-08-05',5,1.00,0.50,'17:57:00'),(16,4,'2020-08-05',5,4.00,0.50,'18:04:00'),(16,4,'2020-08-05',15,5.00,0.50,'16:27:00'),(16,4,'2020-08-05',18,10.00,0.45,'17:33:00'),(16,4,'2020-08-05',18,8.00,0.45,'17:56:00'),(16,4,'2020-08-05',21,2.00,0.50,'18:52:00'),(16,4,'2020-08-08',2,5.00,0.50,'13:26:00'),(16,4,'2020-08-08',4,4.00,0.50,'10:50:00'),(16,4,'2020-08-08',6,5.00,0.50,'10:55:00'),(16,4,'2020-08-08',10,20.00,0.40,'09:35:00'),(16,4,'2020-08-08',16,2.00,0.50,'12:26:00'),(16,4,'2020-08-08',16,4.00,0.50,'12:42:00'),(16,4,'2020-08-08',17,1.00,0.50,'08:49:00'),(16,4,'2020-08-08',23,2.00,0.50,'13:39:00'),(16,4,'2020-08-12',4,10.00,0.45,'17:26:00'),(16,4,'2020-08-12',5,3.00,0.50,'17:36:00'),(16,4,'2020-08-12',5,4.00,0.50,'18:19:00'),(16,4,'2020-08-12',6,1.00,0.50,'18:32:00'),(16,4,'2020-08-12',7,1.00,0.50,'16:48:00'),(16,4,'2020-08-12',7,1.00,0.50,'17:33:00'),(16,4,'2020-08-12',8,5.00,0.50,'17:27:00'),(16,4,'2020-08-12',8,1.00,0.50,'17:35:00'),(16,4,'2020-08-12',9,4.00,0.50,'18:54:00'),(16,4,'2020-08-12',18,6.00,0.50,'18:15:00'),(16,4,'2020-08-12',26,4.00,0.50,'18:33:00'),(16,4,'2020-08-12',26,5.00,0.50,'18:44:00'),(16,4,'2020-08-15',3,10.00,0.45,'08:51:00'),(16,4,'2020-08-15',4,2.00,0.50,'13:14:00'),(16,4,'2020-08-15',10,20.00,0.40,'12:35:00'),(16,4,'2020-08-15',12,8.00,0.45,'09:35:00'),(16,4,'2020-08-15',12,10.00,0.45,'09:59:00'),(16,4,'2020-08-15',19,3.00,0.50,'13:30:00'),(16,4,'2020-08-15',22,3.00,0.50,'09:36:00'),(16,4,'2020-08-19',5,5.00,0.50,'16:45:00'),(16,4,'2020-08-19',5,1.00,0.50,'17:51:00'),(16,4,'2020-08-19',9,4.00,0.50,'17:07:00'),(16,4,'2020-08-19',10,20.00,0.40,'16:27:00'),(16,4,'2020-08-19',10,20.00,0.40,'17:17:00'),(16,4,'2020-08-19',14,4.00,0.50,'16:52:00'),(16,4,'2020-08-19',15,3.00,0.50,'18:22:00'),(16,4,'2020-08-19',15,5.00,0.50,'18:46:00'),(16,4,'2020-08-19',18,4.00,0.50,'16:51:00'),(16,4,'2020-08-19',26,2.00,0.50,'17:43:00'),(16,4,'2020-08-22',2,6.00,0.50,'11:19:00'),(16,4,'2020-08-22',2,8.00,0.45,'12:07:00'),(16,4,'2020-08-22',5,8.00,0.45,'11:45:00'),(16,4,'2020-08-22',8,8.00,0.45,'08:08:00'),(16,4,'2020-08-22',9,4.00,0.50,'13:49:00'),(16,4,'2020-08-22',25,4.00,0.50,'11:31:00'),(16,4,'2020-08-22',26,4.00,0.50,'10:09:00'),(16,4,'2020-08-26',5,4.00,0.50,'18:19:00'),(16,4,'2020-08-26',8,8.00,0.45,'18:24:00'),(16,4,'2020-08-26',11,8.00,0.45,'18:18:00'),(16,4,'2020-08-26',12,8.00,0.45,'18:01:00'),(16,4,'2020-08-26',12,16.00,0.45,'18:44:00'),(16,4,'2020-08-26',22,3.00,0.50,'18:40:00'),(16,4,'2020-08-29',1,12.00,0.50,'13:57:00'),(16,4,'2020-08-29',4,4.00,0.50,'11:35:00'),(16,4,'2020-08-29',18,4.00,0.50,'11:41:00'),(16,4,'2020-09-02',1,6.00,0.50,'18:57:00'),(16,4,'2020-09-02',3,8.00,0.45,'17:37:00'),(16,4,'2020-09-02',12,6.00,0.50,'18:03:00'),(16,4,'2020-09-02',18,2.00,0.50,'17:45:00'),(16,4,'2020-09-02',18,2.00,0.50,'17:51:00'),(16,4,'2020-09-05',4,10.00,0.45,'13:11:00'),(16,4,'2020-09-05',5,3.00,0.50,'12:49:00'),(16,4,'2020-09-05',6,4.00,0.50,'10:44:00'),(16,4,'2020-09-05',7,3.00,0.50,'09:32:00'),(16,4,'2020-09-05',9,3.00,0.50,'13:49:00'),(16,4,'2020-09-05',11,4.00,0.50,'10:03:00'),(16,4,'2020-09-05',18,4.00,0.50,'09:01:00'),(16,4,'2020-09-05',25,4.00,0.50,'11:08:00'),(16,4,'2020-09-09',2,4.00,0.50,'18:48:00'),(16,4,'2020-09-09',3,2.00,0.50,'18:12:00'),(16,4,'2020-09-09',7,3.00,0.50,'18:48:00'),(16,4,'2020-09-09',7,5.00,0.50,'18:56:00'),(16,4,'2020-09-09',9,1.00,0.50,'17:51:00'),(16,4,'2020-09-09',10,20.00,0.40,'18:42:00'),(16,4,'2020-09-09',11,4.00,0.50,'18:55:00'),(16,4,'2020-09-09',14,4.00,0.50,'18:38:00'),(16,4,'2020-09-09',14,5.00,0.50,'18:39:00'),(16,4,'2020-09-12',4,4.00,0.50,'09:39:00'),(16,4,'2020-09-12',7,2.00,0.50,'11:37:00'),(16,4,'2020-09-16',4,10.00,0.45,'16:59:00'),(16,4,'2020-09-16',17,2.00,0.50,'16:42:00'),(16,4,'2020-09-16',17,4.00,0.50,'16:57:00'),(16,4,'2020-09-19',11,6.00,0.50,'11:25:00'),(16,4,'2020-09-19',16,10.00,0.50,'09:06:00'),(16,4,'2020-09-23',1,4.00,0.50,'17:19:00'),(16,4,'2020-09-23',10,20.00,0.40,'18:29:00'),(16,4,'2020-09-23',12,8.00,0.45,'16:54:00'),(16,4,'2020-09-23',14,5.00,0.50,'17:52:00'),(16,4,'2020-09-23',14,4.00,0.50,'18:37:00'),(16,4,'2020-09-26',3,2.00,0.50,'08:50:00'),(16,4,'2020-09-26',4,10.00,0.45,'11:54:00'),(16,4,'2020-09-26',5,1.00,0.50,'10:48:00'),(16,4,'2020-09-26',6,1.00,0.50,'13:39:00'),(16,4,'2020-09-26',8,3.00,0.50,'11:37:00'),(16,4,'2020-09-26',15,2.00,0.50,'09:55:00'),(16,4,'2020-09-26',24,4.00,0.50,'11:10:00'),(16,4,'2020-09-30',4,8.00,0.45,'18:45:00'),(16,4,'2020-09-30',4,2.00,0.50,'18:48:00'),(16,4,'2020-09-30',11,1.00,0.50,'16:30:00'),(16,4,'2020-09-30',16,5.00,0.50,'18:25:00'),(16,4,'2020-09-30',18,6.00,0.50,'18:28:00'),(16,4,'2020-09-30',18,4.00,0.50,'18:50:00');
/*!40000 ALTER TABLE `customer_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `market_date_info`
--

DROP TABLE IF EXISTS `market_date_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `market_date_info` (
  `market_date` date NOT NULL,
  `market_day` varchar(45) DEFAULT NULL,
  `market_week` varchar(45) DEFAULT NULL,
  `market_year` varchar(45) DEFAULT NULL,
  `market_start_time` varchar(45) DEFAULT NULL,
  `market_end_time` varchar(45) DEFAULT NULL,
  `special_notes` blob,
  `market_season` varchar(45) DEFAULT NULL,
  `market_min_temp` varchar(200) DEFAULT NULL,
  `market_max_temp` varchar(45) DEFAULT NULL,
  `market_rain_flag` int(11) DEFAULT NULL,
  `market_snow_flag` int(11) DEFAULT NULL,
  PRIMARY KEY (`market_date`),
  UNIQUE KEY `market_date_UNIQUE` (`market_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `market_date_info`
--

LOCK TABLES `market_date_info` WRITE;
/*!40000 ALTER TABLE `market_date_info` DISABLE KEYS */;
INSERT INTO `market_date_info` VALUES ('2019-03-02','Saturday','9','2019','8:00 AM','2:00 PM',NULL,'Spring','34','42',0,0),('2019-03-09','Saturday','10','2019','9:00 AM','2:00 PM',NULL,'Spring','28','32',0,1),('2019-03-13','Wednesday','11','2019','4:00 PM','7:00 PM',NULL,'Spring','52','60',0,0),('2019-03-16','Saturday','11','2019','8:00 AM','2:00 PM',NULL,'Spring','33','45',0,0),('2019-03-20','Wednesday','12','2019','4:00 PM','7:00 PM',NULL,'Spring','43','51',1,0),('2019-03-23','Saturday','12','2019','8:00 AM','2:00 PM',NULL,'Spring','40','46',1,0),('2019-03-27','Wednesday','13','2019','4:00 PM','7:00 PM',NULL,'Spring','55','62',0,0),('2019-03-30','Saturday','13','2019','8:00 AM','2:00 PM',NULL,'Spring','39','55',1,0),('2019-04-03','Wednesday','14','2019','4:00 PM','7:00 PM',NULL,'Spring','33','47',0,0),('2019-04-06','Saturday','14','2019','8:00 AM','2:00 PM',NULL,'Spring','50','65',0,0),('2019-04-10','Wednesday','15','2019','4:00 PM','7:00 PM',NULL,'Spring','57','65',0,0),('2019-04-13','Saturday','15','2019','8:00 AM','2:00 PM',NULL,'Spring','48','55',0,0),('2019-04-17','Wednesday','16','2019','4:00 PM','7:00 PM',NULL,'Spring','50','58',0,0),('2019-04-20','Saturday','16','2019','8:00 AM','2:00 PM',NULL,'Spring','49','60',0,0),('2019-04-24','Wednesday','17','2019','4:00 PM','7:00 PM',NULL,'Spring','51','59',0,0),('2019-04-27','Saturday','17','2019','8:00 AM','2:00 PM',NULL,'Spring','51','68',0,0),('2019-05-01','Wednesday','18','2019','4:00 PM','7:00 PM',NULL,'Spring','53','59',0,0),('2019-05-04','Saturday','18','2019','8:00 AM','2:00 PM',NULL,'Spring','54','64',0,0),('2019-05-08','Wednesday','19','2019','4:00 PM','7:00 PM',NULL,'Spring',NULL,NULL,0,0),('2019-05-11','Saturday','19','2019','8:00 AM','2:00 PM',NULL,'Spring',NULL,NULL,0,0),('2019-05-15','Wednesday','20','2019','4:00 PM','7:00 PM',NULL,'Spring',NULL,NULL,0,0),('2019-05-18','Saturday','20','2019','8:00 AM','2:00 PM',NULL,'Spring',NULL,NULL,0,0),('2019-05-22','Wednesday','21','2019','4:00 PM','7:00 PM',NULL,'Spring',NULL,NULL,0,0),('2019-05-25','Saturday','21','2019','8:00 AM','2:00 PM',NULL,'Spring',NULL,NULL,0,0),('2019-05-29','Wednesday','22','2019','4:00 PM','7:00 PM',NULL,'Spring',NULL,NULL,0,0),('2019-06-01','Saturday','22','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall','49','69',0,0),('2019-06-05','Wednesday','23','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall','71','82',0,0),('2019-06-08','Saturday','23','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall','57','76',0,0),('2019-06-12','Wednesday','24','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall','73','82',0,0),('2019-06-15','Saturday','24','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall','56','64',0,0),('2019-06-19','Wednesday','25','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall','68','76',0,0),('2019-06-22','Saturday','25','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall','65','80',0,0),('2019-06-26','Wednesday','26','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall','74','85',0,0),('2019-06-29','Saturday','26','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall','72','79',0,0),('2019-07-03','Wednesday','27','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall','70','89',0,0),('2019-07-06','Saturday','27','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall','67','78',0,0),('2019-07-10','Wednesday','28','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall','77','90',0,0),('2019-07-13','Saturday','28','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall','65','81',0,0),('2019-07-17','Wednesday','29','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-07-20','Saturday','29','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-07-24','Wednesday','30','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-07-27','Saturday','30','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-07-31','Wednesday','31','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,1,0),('2019-08-03','Saturday','31','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-08-07','Wednesday','32','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-08-10','Saturday','32','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-08-14','Wednesday','33','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-08-17','Saturday','33','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-08-21','Wednesday','34','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-08-24','Saturday','34','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-08-28','Wednesday','35','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-08-31','Saturday','35','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-09-04','Wednesday','36','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-09-07','Saturday','36','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-09-11','Wednesday','37','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-09-14','Saturday','37','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-09-18','Wednesday','38','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-09-21','Saturday','38','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,1,0),('2019-09-25','Wednesday','39','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-09-28','Saturday','39','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-10-02','Wednesday','40','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-10-05','Saturday','40','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-10-09','Wednesday','41','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-10-12','Saturday','41','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-10-16','Wednesday','42','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-10-19','Saturday','42','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,1,0),('2019-10-23','Wednesday','43','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-10-26','Saturday','43','2019','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-10-30','Wednesday','44','2019','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2019-11-02','Saturday','44','2019','8:00 AM','2:00 PM',NULL,'Late Fall/Holiday',NULL,NULL,0,0),('2019-11-06','Wednesday','45','2019','4:00 PM','7:00 PM',NULL,'Late Fall/Holiday',NULL,NULL,0,0),('2019-11-09','Saturday','45','2019','8:00 AM','2:00 PM',NULL,'Late Fall/Holiday',NULL,NULL,0,0),('2019-11-13','Wednesday','46','2019','4:00 PM','7:00 PM',NULL,'Late Fall/Holiday',NULL,NULL,0,0),('2019-11-16','Saturday','46','2019','8:00 AM','2:00 PM',NULL,'Late Fall/Holiday',NULL,NULL,0,0),('2019-11-20','Wednesday','47','2019','4:00 PM','7:00 PM',NULL,'Late Fall/Holiday',NULL,NULL,0,0),('2019-11-23','Saturday','47','2019','8:00 AM','2:00 PM',NULL,'Late Fall/Holiday',NULL,NULL,0,0),('2019-11-27','Wednesday','48','2019','4:00 PM','7:00 PM',NULL,'Late Fall/Holiday',NULL,NULL,0,0),('2019-11-30','Saturday','48','2019','8:00 AM','2:00 PM',NULL,'Late Fall/Holiday',NULL,NULL,0,0),('2019-12-04','Wednesday','49','2019','4:00 PM','7:00 PM',NULL,'Late Fall/Holiday',NULL,NULL,1,0),('2019-12-07','Saturday','49','2019','8:00 AM','2:00 PM',NULL,'Late Fall/Holiday',NULL,NULL,0,0),('2019-12-11','Wednesday','50','2019','4:00 PM','7:00 PM',NULL,'Late Fall/Holiday',NULL,NULL,1,0),('2019-12-14','Saturday','50','2019','8:00 AM','2:00 PM',NULL,'Late Fall/Holiday',NULL,NULL,0,0),('2019-12-18','Wednesday','51','2019','4:00 PM','7:00 PM',NULL,'Late Fall/Holiday',NULL,NULL,0,0),('2019-12-21','Saturday','51','2019','8:00 AM','2:00 PM',NULL,'Late Fall/Holiday',NULL,NULL,0,0),('2019-12-25','Wednesday','52','2019','4:00 PM','7:00 PM',NULL,'Late Fall/Holiday',NULL,NULL,0,0),('2019-12-28','Saturday','52','2019','8:00 AM','2:00 PM',NULL,'Late Fall/Holiday',NULL,NULL,0,0),('2020-03-04','Wednesday','10','2020','4:00 PM','7:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-03-07','Saturday','10','2020','8:00 AM','2:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-03-11','Wednesday','11','2020','4:00 PM','7:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-03-14','Saturday','11','2020','8:00 AM','2:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-03-18','Wednesday','12','2020','4:00 PM','7:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-03-21','Saturday','12','2020','8:00 AM','2:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-03-25','Wednesday','13','2020','4:00 PM','7:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-03-28','Saturday','13','2020','8:00 AM','2:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-04-01','Wednesday','14','2020','4:00 PM','7:00 PM',NULL,'Spring',NULL,NULL,1,0),('2020-04-04','Saturday','14','2020','8:00 AM','2:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-04-08','Wednesday','15','2020','4:00 PM','7:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-04-11','Saturday','15','2020','8:00 AM','2:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-04-15','Wednesday','16','2020','4:00 PM','7:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-04-18','Saturday','16','2020','8:00 AM','2:00 PM',NULL,'Spring',NULL,NULL,1,0),('2020-04-22','Wednesday','17','2020','4:00 PM','7:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-04-25','Saturday','17','2020','8:00 AM','2:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-04-29','Wednesday','18','2020','4:00 PM','7:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-05-02','Saturday','18','2020','8:00 AM','2:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-05-06','Wednesday','19','2020','4:00 PM','7:00 PM',NULL,'Spring',NULL,NULL,1,0),('2020-05-09','Saturday','19','2020','8:00 AM','2:00 PM',NULL,'Spring',NULL,NULL,1,0),('2020-05-13','Wednesday','20','2020','4:00 PM','7:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-05-16','Saturday','20','2020','8:00 AM','2:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-05-20','Wednesday','21','2020','4:00 PM','7:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-05-23','Saturday','21','2020','8:00 AM','2:00 PM',NULL,'Spring',NULL,NULL,1,0),('2020-05-27','Wednesday','22','2020','4:00 PM','7:00 PM',NULL,'Spring',NULL,NULL,1,0),('2020-05-30','Saturday','22','2020','8:00 AM','2:00 PM',NULL,'Spring',NULL,NULL,0,0),('2020-06-03','Wednesday','23','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-06-06','Saturday','23','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-06-10','Wednesday','24','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-06-13','Saturday','24','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-06-17','Wednesday','25','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-06-20','Saturday','25','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-06-24','Wednesday','26','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-06-27','Saturday','26','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-07-01','Wednesday','27','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-07-04','Saturday','27','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-07-08','Wednesday','28','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,1,0),('2020-07-11','Saturday','28','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,1,0),('2020-07-15','Wednesday','29','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-07-18','Saturday','29','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-07-22','Wednesday','30','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-07-25','Saturday','30','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-07-29','Wednesday','31','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-08-01','Saturday','31','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-08-05','Wednesday','32','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-08-08','Saturday','32','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-08-12','Wednesday','33','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-08-15','Saturday','33','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-08-19','Wednesday','34','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-08-22','Saturday','34','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-08-26','Wednesday','35','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-08-29','Saturday','35','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-09-02','Wednesday','36','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-09-05','Saturday','36','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-09-09','Wednesday','37','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-09-12','Saturday','37','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-09-16','Wednesday','38','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-09-19','Saturday','38','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-09-23','Wednesday','39','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-09-26','Saturday','39','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-09-30','Wednesday','40','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,1,0),('2020-10-03','Saturday','40','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-10-07','Wednesday','41','2020','4:00 PM','7:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0),('2020-10-10','Saturday','41','2020','8:00 AM','2:00 PM',NULL,'Summer/Early Fall',NULL,NULL,0,0);
/*!40000 ALTER TABLE `market_date_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product`
--

DROP TABLE IF EXISTS `product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `product` (
  `product_id` int(11) NOT NULL,
  `product_name` varchar(45) DEFAULT NULL,
  `product_size` varchar(45) DEFAULT NULL,
  `product_category_id` int(11) NOT NULL,
  `product_qty_type` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`product_id`,`product_category_id`),
  KEY `fk_product_product_category1_idx` (`product_category_id`),
  CONSTRAINT `fk_product_product_category1` FOREIGN KEY (`product_category_id`) REFERENCES `product_category` (`product_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product`
--

LOCK TABLES `product` WRITE;
/*!40000 ALTER TABLE `product` DISABLE KEYS */;
INSERT INTO `product` VALUES (1,'Habanero Peppers - Organic','medium',1,'lbs'),(2,'Jalapeno Peppers - Organic','small',1,'lbs'),(3,'Poblano Peppers - Organic','large',1,'unit'),(4,'Banana Peppers - Jar','8 oz',3,'unit'),(5,'Whole Wheat Bread','1.5 lbs',3,'unit'),(6,'Cut Zinnias Bouquet','medium',5,'unit'),(7,'Apple Pie','10\"',3,'unit'),(8,'Cherry Pie','10\"',3,'unit'),(9,'Sweet Potatoes','medium',1,'lbs'),(10,'Eggs','1 dozen',6,'unit'),(11,'Pork Chops','1 lb',6,'lbs'),(12,'Baby Salad Lettuce Mix - Bag','1/2 lb',1,'unit'),(13,'Baby Salad Lettuce Mix','1 lb',1,'lbs'),(14,'Red Potatoes',NULL,1,NULL),(15,'Red Potatoes - Small',' ',1,NULL),(16,'Sweet Corn','Ear',1,'unit'),(17,'Carrots','sold by weight',1,'lbs'),(18,'Carrots - Organic','bunch',1,'unit'),(19,'Farmer\'s Market Resuable Shopping Bag','medium',7,'unit'),(20,'Homemade Beeswax Candles','6\"\"',7,'unit'),(21,'Organic Cherry Tomatoes','pint',1,'unit'),(22,'Roma Tomatoes','medium',1,'lbs'),(23,'Maple Syrup - Jar','8 oz',2,'unit');
/*!40000 ALTER TABLE `product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_category`
--

DROP TABLE IF EXISTS `product_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_category` (
  `product_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_category_name` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`product_category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_category`
--

LOCK TABLES `product_category` WRITE;
/*!40000 ALTER TABLE `product_category` DISABLE KEYS */;
INSERT INTO `product_category` VALUES (1,'Fresh Fruits & Vegetables'),(2,'Packaged Pantry Goods'),(3,'Packaged Prepared Food'),(4,'Freshly Prepared Food'),(5,'Plants & Flowers'),(6,'Eggs & Meat (Fresh or Frozen)'),(7,'Non-Edible Products');
/*!40000 ALTER TABLE `product_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vendor`
--

DROP TABLE IF EXISTS `vendor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `vendor` (
  `vendor_id` int(11) NOT NULL AUTO_INCREMENT,
  `vendor_name` varchar(45) NOT NULL,
  `vendor_type` varchar(45) NOT NULL,
  `vendor_owner_first_name` varchar(45) NOT NULL,
  `vendor_owner_last_name` varchar(45) NOT NULL,
  PRIMARY KEY (`vendor_id`),
  UNIQUE KEY `vendor_id_UNIQUE` (`vendor_id`),
  UNIQUE KEY `vendor_name_UNIQUE` (`vendor_name`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vendor`
--

LOCK TABLES `vendor` WRITE;
/*!40000 ALTER TABLE `vendor` DISABLE KEYS */;
INSERT INTO `vendor` VALUES (1,'Chris\'s Sustainable Eggs & Meats','Eggs & Meats','Chris','Sylvan'),(2,'Hernández Salsa & Veggies','Fresh Variety: Veggies & More','Maria','Hernández'),(3,'Mountain View Vegetables','Fresh Variety: Veggies & More','Joseph','Yoder'),(4,'Fields of Corn','Fresh Focused','Samuel','Smith'),(5,'Seashell Clay Shop','Arts & Jewelry','Karen','Soula'),(6,'Mother\'s Garlic & Greens','Fresh Variety: Veggies & More','Vera','Gordon'),(7,'Marco\'s Peppers','Fresh Focused','Marco','Bokashi'),(8,'Annie\'s Pies','Prepared Foods','Annie','Aquinas'),(9,'Mediterranean Bakery','Prepared Foods','Kani','Hardi');
/*!40000 ALTER TABLE `vendor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vendor_booth_assignments`
--

DROP TABLE IF EXISTS `vendor_booth_assignments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `vendor_booth_assignments` (
  `vendor_id` int(11) NOT NULL,
  `booth_number` int(11) NOT NULL,
  `market_date` date NOT NULL,
  PRIMARY KEY (`vendor_id`,`booth_number`,`market_date`),
  KEY `market_date_fk_idx` (`market_date`),
  KEY `booth_number_fk_idx` (`booth_number`),
  CONSTRAINT `booth_number_fk` FOREIGN KEY (`booth_number`) REFERENCES `booth` (`booth_number`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `market_date_fk` FOREIGN KEY (`market_date`) REFERENCES `market_date_info` (`market_date`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `vendor_id_fk` FOREIGN KEY (`vendor_id`) REFERENCES `vendor` (`vendor_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vendor_booth_assignments`
--

LOCK TABLES `vendor_booth_assignments` WRITE;
/*!40000 ALTER TABLE `vendor_booth_assignments` DISABLE KEYS */;
INSERT INTO `vendor_booth_assignments` VALUES (1,2,'2019-04-03'),(3,1,'2019-04-03'),(4,7,'2019-04-03'),(7,11,'2019-04-03'),(8,6,'2019-04-03'),(9,8,'2019-04-03'),(1,2,'2019-04-06'),(3,1,'2019-04-06'),(4,7,'2019-04-06'),(7,11,'2019-04-06'),(8,6,'2019-04-06'),(9,8,'2019-04-06'),(1,7,'2019-04-10'),(3,1,'2019-04-10'),(4,2,'2019-04-10'),(7,11,'2019-04-10'),(8,6,'2019-04-10'),(9,8,'2019-04-10'),(1,2,'2019-04-13'),(3,1,'2019-04-13'),(4,7,'2019-04-13'),(7,11,'2019-04-13'),(8,6,'2019-04-13'),(9,8,'2019-04-13'),(1,2,'2019-04-17'),(3,1,'2019-04-17'),(4,7,'2019-04-17'),(7,11,'2019-04-17'),(8,6,'2019-04-17'),(9,8,'2019-04-17'),(1,2,'2019-04-20'),(3,1,'2019-04-20'),(4,7,'2019-04-20'),(7,11,'2019-04-20'),(8,6,'2019-04-20'),(9,8,'2019-04-20'),(1,2,'2019-04-24'),(3,1,'2019-04-24'),(4,7,'2019-04-24'),(7,11,'2019-04-24'),(8,6,'2019-04-24'),(9,8,'2019-04-24'),(1,2,'2019-04-27'),(3,1,'2019-04-27'),(4,7,'2019-04-27'),(7,11,'2019-04-27'),(8,6,'2019-04-27'),(9,8,'2019-04-27'),(1,2,'2019-05-01'),(3,1,'2019-05-01'),(4,7,'2019-05-01'),(7,11,'2019-05-01'),(8,6,'2019-05-01'),(9,8,'2019-05-01'),(1,2,'2019-05-04'),(3,1,'2019-05-04'),(4,7,'2019-05-04'),(7,11,'2019-05-04'),(8,6,'2019-05-04'),(9,8,'2019-05-04'),(1,2,'2019-05-08'),(3,1,'2019-05-08'),(4,7,'2019-05-08'),(7,11,'2019-05-08'),(8,6,'2019-05-08'),(9,8,'2019-05-08'),(1,2,'2019-05-11'),(3,1,'2019-05-11'),(4,7,'2019-05-11'),(7,11,'2019-05-11'),(8,6,'2019-05-11'),(9,8,'2019-05-11'),(1,2,'2019-05-15'),(3,1,'2019-05-15'),(4,7,'2019-05-15'),(7,11,'2019-05-15'),(8,6,'2019-05-15'),(9,8,'2019-05-15'),(1,2,'2019-05-18'),(3,1,'2019-05-18'),(4,7,'2019-05-18'),(7,11,'2019-05-18'),(8,6,'2019-05-18'),(9,8,'2019-05-18'),(1,2,'2019-05-22'),(3,1,'2019-05-22'),(4,7,'2019-05-22'),(7,11,'2019-05-22'),(8,6,'2019-05-22'),(9,8,'2019-05-22'),(1,2,'2019-05-25'),(3,1,'2019-05-25'),(4,7,'2019-05-25'),(7,11,'2019-05-25'),(8,6,'2019-05-25'),(9,8,'2019-05-25'),(1,2,'2019-05-29'),(3,1,'2019-05-29'),(4,7,'2019-05-29'),(7,11,'2019-05-29'),(8,6,'2019-05-29'),(9,8,'2019-05-29'),(1,2,'2019-06-01'),(3,1,'2019-06-01'),(4,7,'2019-06-01'),(4,11,'2019-06-01'),(7,11,'2019-06-01'),(8,6,'2019-06-01'),(9,8,'2019-06-01'),(1,2,'2019-06-05'),(3,1,'2019-06-05'),(4,7,'2019-06-05'),(4,11,'2019-06-05'),(7,11,'2019-06-05'),(8,6,'2019-06-05'),(9,8,'2019-06-05'),(1,2,'2019-06-08'),(3,1,'2019-06-08'),(4,7,'2019-06-08'),(4,11,'2019-06-08'),(7,11,'2019-06-08'),(8,6,'2019-06-08'),(9,8,'2019-06-08'),(1,2,'2019-06-12'),(3,1,'2019-06-12'),(4,7,'2019-06-12'),(4,11,'2019-06-12'),(7,11,'2019-06-12'),(8,6,'2019-06-12'),(9,8,'2019-06-12'),(1,2,'2019-06-15'),(3,1,'2019-06-15'),(4,7,'2019-06-15'),(4,11,'2019-06-15'),(7,11,'2019-06-15'),(8,6,'2019-06-15'),(9,8,'2019-06-15'),(1,2,'2019-06-19'),(3,1,'2019-06-19'),(4,7,'2019-06-19'),(4,11,'2019-06-19'),(7,11,'2019-06-19'),(8,6,'2019-06-19'),(9,8,'2019-06-19'),(1,2,'2019-06-22'),(3,1,'2019-06-22'),(4,7,'2019-06-22'),(4,11,'2019-06-22'),(7,11,'2019-06-22'),(8,6,'2019-06-22'),(9,8,'2019-06-22'),(1,2,'2019-06-26'),(3,1,'2019-06-26'),(4,7,'2019-06-26'),(4,11,'2019-06-26'),(7,11,'2019-06-26'),(8,6,'2019-06-26'),(9,8,'2019-06-26'),(1,2,'2019-06-29'),(3,1,'2019-06-29'),(4,7,'2019-06-29'),(4,11,'2019-06-29'),(7,11,'2019-06-29'),(8,6,'2019-06-29'),(9,8,'2019-06-29'),(1,2,'2019-07-03'),(3,1,'2019-07-03'),(4,7,'2019-07-03'),(4,11,'2019-07-03'),(7,11,'2019-07-03'),(8,10,'2019-07-03'),(9,8,'2019-07-03'),(1,2,'2019-07-06'),(3,1,'2019-07-06'),(4,7,'2019-07-06'),(4,11,'2019-07-06'),(7,11,'2019-07-06'),(8,10,'2019-07-06'),(9,8,'2019-07-06'),(1,2,'2019-07-10'),(3,1,'2019-07-10'),(4,7,'2019-07-10'),(4,11,'2019-07-10'),(7,11,'2019-07-10'),(8,10,'2019-07-10'),(9,8,'2019-07-10'),(1,2,'2019-07-13'),(3,1,'2019-07-13'),(4,7,'2019-07-13'),(4,11,'2019-07-13'),(7,11,'2019-07-13'),(8,10,'2019-07-13'),(9,8,'2019-07-13'),(1,2,'2019-07-17'),(3,1,'2019-07-17'),(4,7,'2019-07-17'),(4,11,'2019-07-17'),(7,11,'2019-07-17'),(8,10,'2019-07-17'),(9,8,'2019-07-17'),(1,2,'2019-07-20'),(3,1,'2019-07-20'),(4,7,'2019-07-20'),(4,11,'2019-07-20'),(7,11,'2019-07-20'),(8,10,'2019-07-20'),(9,8,'2019-07-20'),(1,2,'2019-07-24'),(3,1,'2019-07-24'),(4,7,'2019-07-24'),(4,11,'2019-07-24'),(7,11,'2019-07-24'),(8,10,'2019-07-24'),(9,8,'2019-07-24'),(1,2,'2019-07-27'),(3,1,'2019-07-27'),(4,7,'2019-07-27'),(4,11,'2019-07-27'),(7,11,'2019-07-27'),(8,10,'2019-07-27'),(9,8,'2019-07-27'),(1,2,'2019-07-31'),(3,1,'2019-07-31'),(4,7,'2019-07-31'),(4,11,'2019-07-31'),(7,11,'2019-07-31'),(8,10,'2019-07-31'),(9,8,'2019-07-31'),(1,2,'2019-08-03'),(3,1,'2019-08-03'),(4,7,'2019-08-03'),(4,11,'2019-08-03'),(7,11,'2019-08-03'),(8,10,'2019-08-03'),(9,8,'2019-08-03'),(1,2,'2019-08-07'),(3,1,'2019-08-07'),(4,7,'2019-08-07'),(4,11,'2019-08-07'),(7,11,'2019-08-07'),(8,10,'2019-08-07'),(9,8,'2019-08-07'),(1,2,'2019-08-10'),(3,1,'2019-08-10'),(4,7,'2019-08-10'),(4,11,'2019-08-10'),(7,11,'2019-08-10'),(8,10,'2019-08-10'),(9,8,'2019-08-10'),(1,2,'2019-08-14'),(3,1,'2019-08-14'),(4,7,'2019-08-14'),(4,11,'2019-08-14'),(7,11,'2019-08-14'),(8,10,'2019-08-14'),(9,8,'2019-08-14'),(1,2,'2019-08-17'),(3,1,'2019-08-17'),(4,7,'2019-08-17'),(4,11,'2019-08-17'),(7,11,'2019-08-17'),(8,10,'2019-08-17'),(9,8,'2019-08-17'),(1,2,'2019-08-21'),(3,1,'2019-08-21'),(4,7,'2019-08-21'),(4,11,'2019-08-21'),(7,11,'2019-08-21'),(8,10,'2019-08-21'),(9,8,'2019-08-21'),(1,2,'2019-08-24'),(3,1,'2019-08-24'),(4,7,'2019-08-24'),(4,11,'2019-08-24'),(7,11,'2019-08-24'),(8,10,'2019-08-24'),(9,8,'2019-08-24'),(1,2,'2019-08-28'),(3,1,'2019-08-28'),(4,7,'2019-08-28'),(4,11,'2019-08-28'),(7,11,'2019-08-28'),(8,10,'2019-08-28'),(9,8,'2019-08-28'),(1,2,'2019-08-31'),(3,1,'2019-08-31'),(4,7,'2019-08-31'),(4,11,'2019-08-31'),(7,11,'2019-08-31'),(8,10,'2019-08-31'),(9,8,'2019-08-31'),(1,2,'2019-09-04'),(3,1,'2019-09-04'),(4,7,'2019-09-04'),(4,11,'2019-09-04'),(7,11,'2019-09-04'),(8,10,'2019-09-04'),(9,8,'2019-09-04'),(1,2,'2019-09-07'),(3,1,'2019-09-07'),(4,7,'2019-09-07'),(4,11,'2019-09-07'),(7,11,'2019-09-07'),(8,10,'2019-09-07'),(9,8,'2019-09-07'),(1,2,'2019-09-11'),(3,1,'2019-09-11'),(4,7,'2019-09-11'),(4,11,'2019-09-11'),(7,11,'2019-09-11'),(8,10,'2019-09-11'),(9,8,'2019-09-11'),(1,2,'2019-09-14'),(3,1,'2019-09-14'),(4,7,'2019-09-14'),(4,11,'2019-09-14'),(7,11,'2019-09-14'),(8,10,'2019-09-14'),(9,8,'2019-09-14'),(1,2,'2019-09-18'),(3,1,'2019-09-18'),(4,7,'2019-09-18'),(4,11,'2019-09-18'),(7,11,'2019-09-18'),(8,10,'2019-09-18'),(9,8,'2019-09-18'),(1,2,'2019-09-21'),(3,1,'2019-09-21'),(4,7,'2019-09-21'),(4,11,'2019-09-21'),(7,11,'2019-09-21'),(8,10,'2019-09-21'),(9,8,'2019-09-21'),(1,2,'2019-09-25'),(3,1,'2019-09-25'),(4,7,'2019-09-25'),(4,11,'2019-09-25'),(7,11,'2019-09-25'),(8,10,'2019-09-25'),(9,8,'2019-09-25'),(1,2,'2019-09-28'),(3,1,'2019-09-28'),(4,7,'2019-09-28'),(4,11,'2019-09-28'),(7,11,'2019-09-28'),(8,10,'2019-09-28'),(9,8,'2019-09-28'),(1,2,'2019-10-02'),(3,1,'2019-10-02'),(4,7,'2019-10-02'),(7,11,'2019-10-02'),(8,6,'2019-10-02'),(9,8,'2019-10-02'),(1,2,'2019-10-05'),(3,1,'2019-10-05'),(4,7,'2019-10-05'),(7,11,'2019-10-05'),(8,6,'2019-10-05'),(9,8,'2019-10-05'),(1,2,'2019-10-09'),(3,1,'2019-10-09'),(4,7,'2019-10-09'),(7,11,'2019-10-09'),(8,6,'2019-10-09'),(9,8,'2019-10-09'),(1,2,'2019-10-12'),(3,1,'2019-10-12'),(4,7,'2019-10-12'),(7,11,'2019-10-12'),(8,6,'2019-10-12'),(9,8,'2019-10-12'),(1,2,'2019-10-16'),(3,1,'2019-10-16'),(4,7,'2019-10-16'),(7,11,'2019-10-16'),(8,6,'2019-10-16'),(9,8,'2019-10-16'),(1,2,'2019-10-19'),(3,1,'2019-10-19'),(4,7,'2019-10-19'),(7,11,'2019-10-19'),(8,6,'2019-10-19'),(9,8,'2019-10-19'),(1,2,'2019-10-23'),(3,1,'2019-10-23'),(4,7,'2019-10-23'),(7,11,'2019-10-23'),(8,6,'2019-10-23'),(9,8,'2019-10-23'),(1,2,'2019-10-26'),(3,1,'2019-10-26'),(4,7,'2019-10-26'),(7,11,'2019-10-26'),(8,6,'2019-10-26'),(9,8,'2019-10-26'),(1,2,'2019-10-30'),(3,1,'2019-10-30'),(4,7,'2019-10-30'),(7,11,'2019-10-30'),(8,6,'2019-10-30'),(9,8,'2019-10-30'),(1,2,'2019-11-02'),(3,1,'2019-11-02'),(4,7,'2019-11-02'),(7,11,'2019-11-02'),(8,6,'2019-11-02'),(9,8,'2019-11-02'),(1,2,'2019-11-06'),(3,1,'2019-11-06'),(4,7,'2019-11-06'),(7,11,'2019-11-06'),(8,6,'2019-11-06'),(9,8,'2019-11-06'),(1,2,'2019-11-09'),(3,1,'2019-11-09'),(4,7,'2019-11-09'),(7,11,'2019-11-09'),(8,6,'2019-11-09'),(9,8,'2019-11-09'),(1,2,'2019-11-13'),(3,1,'2019-11-13'),(4,7,'2019-11-13'),(7,11,'2019-11-13'),(8,6,'2019-11-13'),(9,8,'2019-11-13'),(1,2,'2019-11-16'),(3,1,'2019-11-16'),(4,7,'2019-11-16'),(7,11,'2019-11-16'),(8,6,'2019-11-16'),(9,8,'2019-11-16'),(1,2,'2019-11-20'),(3,1,'2019-11-20'),(4,7,'2019-11-20'),(7,11,'2019-11-20'),(8,6,'2019-11-20'),(9,8,'2019-11-20'),(1,2,'2019-11-23'),(3,1,'2019-11-23'),(4,7,'2019-11-23'),(7,11,'2019-11-23'),(8,6,'2019-11-23'),(9,8,'2019-11-23'),(1,2,'2019-11-27'),(3,1,'2019-11-27'),(4,7,'2019-11-27'),(7,11,'2019-11-27'),(8,6,'2019-11-27'),(9,8,'2019-11-27'),(1,2,'2019-11-30'),(3,1,'2019-11-30'),(4,7,'2019-11-30'),(7,11,'2019-11-30'),(8,6,'2019-11-30'),(9,8,'2019-11-30'),(1,2,'2019-12-04'),(3,1,'2019-12-04'),(4,7,'2019-12-04'),(7,11,'2019-12-04'),(8,6,'2019-12-04'),(9,8,'2019-12-04'),(1,2,'2019-12-07'),(3,1,'2019-12-07'),(4,7,'2019-12-07'),(7,11,'2019-12-07'),(8,6,'2019-12-07'),(9,8,'2019-12-07'),(1,2,'2019-12-11'),(3,1,'2019-12-11'),(4,7,'2019-12-11'),(7,11,'2019-12-11'),(8,6,'2019-12-11'),(9,8,'2019-12-11'),(1,2,'2019-12-14'),(3,1,'2019-12-14'),(4,7,'2019-12-14'),(7,11,'2019-12-14'),(8,6,'2019-12-14'),(9,8,'2019-12-14'),(1,2,'2019-12-18'),(3,1,'2019-12-18'),(4,7,'2019-12-18'),(7,11,'2019-12-18'),(8,6,'2019-12-18'),(9,8,'2019-12-18'),(1,2,'2019-12-21'),(3,1,'2019-12-21'),(4,7,'2019-12-21'),(7,11,'2019-12-21'),(8,6,'2019-12-21'),(9,8,'2019-12-21'),(1,2,'2019-12-25'),(3,1,'2019-12-25'),(4,7,'2019-12-25'),(7,11,'2019-12-25'),(8,6,'2019-12-25'),(9,8,'2019-12-25'),(1,2,'2019-12-28'),(3,1,'2019-12-28'),(4,7,'2019-12-28'),(7,11,'2019-12-28'),(8,6,'2019-12-28'),(9,8,'2019-12-28'),(1,2,'2020-03-04'),(3,1,'2020-03-04'),(4,7,'2020-03-04'),(7,11,'2020-03-04'),(8,6,'2020-03-04'),(9,8,'2020-03-04'),(1,2,'2020-03-07'),(3,1,'2020-03-07'),(4,7,'2020-03-07'),(7,11,'2020-03-07'),(8,6,'2020-03-07'),(9,8,'2020-03-07'),(1,2,'2020-03-11'),(3,1,'2020-03-11'),(4,7,'2020-03-11'),(7,11,'2020-03-11'),(8,6,'2020-03-11'),(9,8,'2020-03-11'),(1,2,'2020-03-14'),(3,1,'2020-03-14'),(4,7,'2020-03-14'),(7,11,'2020-03-14'),(8,6,'2020-03-14'),(9,8,'2020-03-14'),(1,2,'2020-03-18'),(3,1,'2020-03-18'),(4,7,'2020-03-18'),(7,11,'2020-03-18'),(8,6,'2020-03-18'),(9,8,'2020-03-18'),(1,2,'2020-03-21'),(3,1,'2020-03-21'),(4,7,'2020-03-21'),(7,11,'2020-03-21'),(8,6,'2020-03-21'),(9,8,'2020-03-21'),(1,2,'2020-03-25'),(3,1,'2020-03-25'),(4,7,'2020-03-25'),(7,11,'2020-03-25'),(8,6,'2020-03-25'),(9,8,'2020-03-25'),(1,2,'2020-03-28'),(3,1,'2020-03-28'),(4,7,'2020-03-28'),(7,11,'2020-03-28'),(8,6,'2020-03-28'),(9,8,'2020-03-28'),(1,2,'2020-04-01'),(3,1,'2020-04-01'),(4,7,'2020-04-01'),(7,11,'2020-04-01'),(8,6,'2020-04-01'),(9,8,'2020-04-01'),(1,2,'2020-04-04'),(3,1,'2020-04-04'),(4,7,'2020-04-04'),(7,11,'2020-04-04'),(8,6,'2020-04-04'),(9,8,'2020-04-04'),(1,2,'2020-04-08'),(3,1,'2020-04-08'),(4,7,'2020-04-08'),(7,11,'2020-04-08'),(8,6,'2020-04-08'),(9,8,'2020-04-08'),(1,2,'2020-04-11'),(3,1,'2020-04-11'),(4,7,'2020-04-11'),(7,11,'2020-04-11'),(8,6,'2020-04-11'),(9,8,'2020-04-11'),(1,2,'2020-04-15'),(3,1,'2020-04-15'),(4,7,'2020-04-15'),(7,11,'2020-04-15'),(8,6,'2020-04-15'),(9,8,'2020-04-15'),(1,2,'2020-04-18'),(3,1,'2020-04-18'),(4,7,'2020-04-18'),(7,11,'2020-04-18'),(8,6,'2020-04-18'),(9,8,'2020-04-18'),(1,2,'2020-04-22'),(3,1,'2020-04-22'),(4,7,'2020-04-22'),(7,11,'2020-04-22'),(8,6,'2020-04-22'),(9,8,'2020-04-22'),(1,2,'2020-04-25'),(3,1,'2020-04-25'),(4,7,'2020-04-25'),(7,11,'2020-04-25'),(8,6,'2020-04-25'),(9,8,'2020-04-25'),(1,2,'2020-04-29'),(3,1,'2020-04-29'),(4,7,'2020-04-29'),(7,11,'2020-04-29'),(8,6,'2020-04-29'),(9,8,'2020-04-29'),(1,2,'2020-05-02'),(3,1,'2020-05-02'),(4,7,'2020-05-02'),(7,11,'2020-05-02'),(8,6,'2020-05-02'),(9,8,'2020-05-02'),(1,2,'2020-05-06'),(3,1,'2020-05-06'),(4,7,'2020-05-06'),(7,11,'2020-05-06'),(8,6,'2020-05-06'),(9,8,'2020-05-06'),(1,2,'2020-05-09'),(3,1,'2020-05-09'),(4,7,'2020-05-09'),(7,11,'2020-05-09'),(8,6,'2020-05-09'),(9,8,'2020-05-09'),(1,2,'2020-05-13'),(3,1,'2020-05-13'),(4,7,'2020-05-13'),(7,11,'2020-05-13'),(8,6,'2020-05-13'),(9,8,'2020-05-13'),(1,2,'2020-05-16'),(3,1,'2020-05-16'),(4,7,'2020-05-16'),(7,11,'2020-05-16'),(8,6,'2020-05-16'),(9,8,'2020-05-16'),(1,2,'2020-05-20'),(3,1,'2020-05-20'),(4,7,'2020-05-20'),(7,11,'2020-05-20'),(8,6,'2020-05-20'),(9,8,'2020-05-20'),(1,2,'2020-05-23'),(3,1,'2020-05-23'),(4,7,'2020-05-23'),(7,11,'2020-05-23'),(8,6,'2020-05-23'),(9,8,'2020-05-23'),(1,2,'2020-05-27'),(3,1,'2020-05-27'),(4,7,'2020-05-27'),(7,11,'2020-05-27'),(8,6,'2020-05-27'),(9,8,'2020-05-27'),(1,2,'2020-05-30'),(3,1,'2020-05-30'),(4,7,'2020-05-30'),(7,11,'2020-05-30'),(8,6,'2020-05-30'),(9,8,'2020-05-30'),(1,2,'2020-06-03'),(3,1,'2020-06-03'),(4,7,'2020-06-03'),(4,11,'2020-06-03'),(7,11,'2020-06-03'),(8,6,'2020-06-03'),(9,8,'2020-06-03'),(1,2,'2020-06-06'),(3,1,'2020-06-06'),(4,7,'2020-06-06'),(4,11,'2020-06-06'),(7,11,'2020-06-06'),(8,6,'2020-06-06'),(9,8,'2020-06-06'),(1,2,'2020-06-10'),(3,1,'2020-06-10'),(4,7,'2020-06-10'),(4,11,'2020-06-10'),(7,11,'2020-06-10'),(8,6,'2020-06-10'),(9,8,'2020-06-10'),(1,2,'2020-06-13'),(3,1,'2020-06-13'),(4,7,'2020-06-13'),(4,11,'2020-06-13'),(7,11,'2020-06-13'),(8,6,'2020-06-13'),(9,8,'2020-06-13'),(1,2,'2020-06-17'),(3,1,'2020-06-17'),(4,7,'2020-06-17'),(4,11,'2020-06-17'),(7,11,'2020-06-17'),(8,6,'2020-06-17'),(9,8,'2020-06-17'),(1,2,'2020-06-20'),(3,1,'2020-06-20'),(4,7,'2020-06-20'),(4,11,'2020-06-20'),(7,11,'2020-06-20'),(8,6,'2020-06-20'),(9,8,'2020-06-20'),(1,2,'2020-06-24'),(3,1,'2020-06-24'),(4,7,'2020-06-24'),(4,11,'2020-06-24'),(7,11,'2020-06-24'),(8,6,'2020-06-24'),(9,8,'2020-06-24'),(1,2,'2020-06-27'),(3,1,'2020-06-27'),(4,7,'2020-06-27'),(4,11,'2020-06-27'),(7,11,'2020-06-27'),(8,6,'2020-06-27'),(9,8,'2020-06-27'),(1,2,'2020-07-01'),(3,1,'2020-07-01'),(4,7,'2020-07-01'),(4,11,'2020-07-01'),(7,11,'2020-07-01'),(8,10,'2020-07-01'),(9,8,'2020-07-01'),(1,2,'2020-07-04'),(3,1,'2020-07-04'),(4,7,'2020-07-04'),(4,11,'2020-07-04'),(7,11,'2020-07-04'),(8,10,'2020-07-04'),(9,8,'2020-07-04'),(1,2,'2020-07-08'),(3,1,'2020-07-08'),(4,7,'2020-07-08'),(4,11,'2020-07-08'),(7,11,'2020-07-08'),(8,10,'2020-07-08'),(9,8,'2020-07-08'),(1,2,'2020-07-11'),(3,1,'2020-07-11'),(4,7,'2020-07-11'),(4,11,'2020-07-11'),(7,11,'2020-07-11'),(8,10,'2020-07-11'),(9,8,'2020-07-11'),(1,2,'2020-07-15'),(3,1,'2020-07-15'),(4,7,'2020-07-15'),(4,11,'2020-07-15'),(7,11,'2020-07-15'),(8,10,'2020-07-15'),(9,8,'2020-07-15'),(1,2,'2020-07-18'),(3,1,'2020-07-18'),(4,7,'2020-07-18'),(4,11,'2020-07-18'),(7,11,'2020-07-18'),(8,10,'2020-07-18'),(9,8,'2020-07-18'),(1,2,'2020-07-22'),(3,1,'2020-07-22'),(4,7,'2020-07-22'),(4,11,'2020-07-22'),(7,11,'2020-07-22'),(8,10,'2020-07-22'),(9,8,'2020-07-22'),(1,2,'2020-07-25'),(3,1,'2020-07-25'),(4,7,'2020-07-25'),(4,11,'2020-07-25'),(7,11,'2020-07-25'),(8,10,'2020-07-25'),(9,8,'2020-07-25'),(1,2,'2020-07-29'),(3,1,'2020-07-29'),(4,7,'2020-07-29'),(4,11,'2020-07-29'),(7,11,'2020-07-29'),(8,10,'2020-07-29'),(9,8,'2020-07-29'),(1,2,'2020-08-01'),(3,1,'2020-08-01'),(4,7,'2020-08-01'),(4,11,'2020-08-01'),(7,11,'2020-08-01'),(8,10,'2020-08-01'),(9,8,'2020-08-01'),(1,2,'2020-08-05'),(3,1,'2020-08-05'),(4,7,'2020-08-05'),(4,11,'2020-08-05'),(7,11,'2020-08-05'),(8,10,'2020-08-05'),(9,8,'2020-08-05'),(1,2,'2020-08-08'),(3,1,'2020-08-08'),(4,7,'2020-08-08'),(4,11,'2020-08-08'),(7,11,'2020-08-08'),(8,10,'2020-08-08'),(9,8,'2020-08-08'),(1,2,'2020-08-12'),(3,1,'2020-08-12'),(4,7,'2020-08-12'),(4,11,'2020-08-12'),(7,11,'2020-08-12'),(8,10,'2020-08-12'),(9,8,'2020-08-12'),(1,2,'2020-08-15'),(3,1,'2020-08-15'),(4,7,'2020-08-15'),(4,11,'2020-08-15'),(7,11,'2020-08-15'),(8,10,'2020-08-15'),(9,8,'2020-08-15'),(1,2,'2020-08-19'),(3,1,'2020-08-19'),(4,7,'2020-08-19'),(4,11,'2020-08-19'),(7,11,'2020-08-19'),(8,10,'2020-08-19'),(9,8,'2020-08-19'),(1,2,'2020-08-22'),(3,1,'2020-08-22'),(4,7,'2020-08-22'),(4,11,'2020-08-22'),(7,11,'2020-08-22'),(8,10,'2020-08-22'),(9,8,'2020-08-22'),(1,2,'2020-08-26'),(3,1,'2020-08-26'),(4,7,'2020-08-26'),(4,11,'2020-08-26'),(7,11,'2020-08-26'),(8,10,'2020-08-26'),(9,8,'2020-08-26'),(1,2,'2020-08-29'),(3,1,'2020-08-29'),(4,7,'2020-08-29'),(4,11,'2020-08-29'),(7,11,'2020-08-29'),(8,10,'2020-08-29'),(9,8,'2020-08-29'),(1,2,'2020-09-02'),(3,1,'2020-09-02'),(4,7,'2020-09-02'),(4,11,'2020-09-02'),(7,11,'2020-09-02'),(8,10,'2020-09-02'),(9,8,'2020-09-02'),(1,2,'2020-09-05'),(3,1,'2020-09-05'),(4,7,'2020-09-05'),(4,11,'2020-09-05'),(7,11,'2020-09-05'),(8,10,'2020-09-05'),(9,8,'2020-09-05'),(1,2,'2020-09-09'),(3,1,'2020-09-09'),(4,7,'2020-09-09'),(4,11,'2020-09-09'),(7,11,'2020-09-09'),(8,10,'2020-09-09'),(9,8,'2020-09-09'),(1,2,'2020-09-12'),(3,1,'2020-09-12'),(4,7,'2020-09-12'),(4,11,'2020-09-12'),(7,11,'2020-09-12'),(8,10,'2020-09-12'),(9,8,'2020-09-12'),(1,2,'2020-09-16'),(3,1,'2020-09-16'),(4,7,'2020-09-16'),(4,11,'2020-09-16'),(7,11,'2020-09-16'),(8,10,'2020-09-16'),(9,8,'2020-09-16'),(1,2,'2020-09-19'),(3,1,'2020-09-19'),(4,7,'2020-09-19'),(4,11,'2020-09-19'),(7,11,'2020-09-19'),(8,10,'2020-09-19'),(9,8,'2020-09-19'),(1,2,'2020-09-23'),(3,1,'2020-09-23'),(4,7,'2020-09-23'),(4,11,'2020-09-23'),(7,11,'2020-09-23'),(8,10,'2020-09-23'),(9,8,'2020-09-23'),(1,2,'2020-09-26'),(3,1,'2020-09-26'),(4,7,'2020-09-26'),(4,11,'2020-09-26'),(7,11,'2020-09-26'),(8,10,'2020-09-26'),(9,8,'2020-09-26'),(1,2,'2020-09-30'),(3,1,'2020-09-30'),(4,7,'2020-09-30'),(4,11,'2020-09-30'),(7,11,'2020-09-30'),(8,10,'2020-09-30'),(9,8,'2020-09-30'),(1,2,'2020-10-03'),(3,1,'2020-10-03'),(4,7,'2020-10-03'),(7,11,'2020-10-03'),(8,6,'2020-10-03'),(9,8,'2020-10-03'),(1,2,'2020-10-07'),(3,1,'2020-10-07'),(4,7,'2020-10-07'),(7,11,'2020-10-07'),(8,6,'2020-10-07'),(9,8,'2020-10-07'),(1,2,'2020-10-10'),(3,1,'2020-10-10'),(7,11,'2020-10-10'),(8,7,'2020-10-10'),(9,8,'2020-10-10');
/*!40000 ALTER TABLE `vendor_booth_assignments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vendor_inventory`
--

DROP TABLE IF EXISTS `vendor_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `vendor_inventory` (
  `market_date` date NOT NULL,
  `quantity` decimal(16,2) DEFAULT NULL,
  `vendor_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `original_price` decimal(16,2) DEFAULT NULL,
  PRIMARY KEY (`product_id`,`vendor_id`,`market_date`),
  KEY `fk_vendor_inventory_vendor1_idx` (`vendor_id`),
  KEY `fk_vendor_inventory_product1_idx` (`product_id`),
  CONSTRAINT `fk_vendor_inventory_product1` FOREIGN KEY (`product_id`) REFERENCES `product` (`product_id`),
  CONSTRAINT `fk_vendor_inventory_vendor1` FOREIGN KEY (`vendor_id`) REFERENCES `vendor` (`vendor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vendor_inventory`
--

LOCK TABLES `vendor_inventory` WRITE;
/*!40000 ALTER TABLE `vendor_inventory` DISABLE KEYS */;
INSERT INTO `vendor_inventory` VALUES ('2019-07-03',7.38,7,1,6.99),('2019-07-06',10.96,7,1,6.99),('2019-07-10',13.08,7,1,6.99),('2019-07-13',10.22,7,1,6.99),('2019-07-17',10.59,7,1,6.99),('2019-07-20',9.04,7,1,6.99),('2019-07-24',10.66,7,1,6.99),('2019-07-27',6.76,7,1,6.99),('2019-07-31',11.23,7,1,6.99),('2019-08-03',10.72,7,1,6.99),('2019-08-07',6.98,7,1,6.99),('2019-08-10',10.73,7,1,6.99),('2019-08-14',10.63,7,1,6.99),('2019-08-17',7.88,7,1,6.99),('2019-08-21',7.84,7,1,6.99),('2019-08-24',10.58,7,1,6.99),('2019-08-28',9.34,7,1,6.99),('2019-08-31',7.40,7,1,6.99),('2019-09-04',10.13,7,1,6.99),('2019-09-07',11.44,7,1,6.99),('2019-09-11',8.84,7,1,6.99),('2019-09-14',10.32,7,1,6.99),('2019-09-18',12.73,7,1,6.99),('2019-09-21',8.63,7,1,6.99),('2019-09-25',6.29,7,1,6.99),('2019-09-28',9.54,7,1,6.99),('2020-07-01',11.92,7,1,6.99),('2020-07-04',10.08,7,1,6.99),('2020-07-08',11.85,7,1,6.99),('2020-07-11',10.08,7,1,6.99),('2020-07-15',10.01,7,1,6.99),('2020-07-18',8.15,7,1,6.99),('2020-07-22',8.52,7,1,6.99),('2020-07-25',10.29,7,1,6.99),('2020-07-29',8.52,7,1,6.99),('2020-08-01',8.66,7,1,6.99),('2020-08-05',15.49,7,1,6.99),('2020-08-08',9.19,7,1,6.99),('2020-08-12',10.51,7,1,6.99),('2020-08-15',12.70,7,1,6.99),('2020-08-19',10.28,7,1,6.99),('2020-08-22',10.86,7,1,6.99),('2020-08-26',12.34,7,1,6.99),('2020-08-29',9.38,7,1,6.99),('2020-09-02',14.23,7,1,6.99),('2020-09-05',9.38,7,1,6.99),('2020-09-09',10.75,7,1,6.99),('2020-09-12',10.84,7,1,6.99),('2020-09-16',10.11,7,1,6.99),('2020-09-19',10.04,7,1,6.99),('2020-09-23',10.19,7,1,6.99),('2020-09-26',9.88,7,1,6.99),('2020-09-30',13.76,7,1,6.99),('2019-07-03',33.63,7,2,3.49),('2019-07-06',24.56,7,2,3.49),('2019-07-10',28.83,7,2,3.49),('2019-07-13',29.17,7,2,3.49),('2019-07-17',29.89,7,2,3.49),('2019-07-20',28.31,7,2,3.49),('2019-07-24',30.48,7,2,3.49),('2019-07-27',26.65,7,2,3.49),('2019-07-31',29.87,7,2,3.49),('2019-08-03',32.23,7,2,3.49),('2019-08-07',29.28,7,2,3.49),('2019-08-10',27.18,7,2,3.49),('2019-08-14',33.35,7,2,3.49),('2019-08-17',25.58,7,2,3.49),('2019-08-21',32.02,7,2,3.49),('2019-08-24',17.29,7,2,3.49),('2019-08-28',26.20,7,2,3.49),('2019-08-31',27.87,7,2,3.49),('2019-09-04',35.86,7,2,3.49),('2019-09-07',31.11,7,2,3.49),('2019-09-11',24.44,7,2,3.49),('2019-09-14',24.16,7,2,3.49),('2019-09-18',29.34,7,2,3.49),('2019-09-21',28.40,7,2,3.49),('2019-09-25',33.72,7,2,3.49),('2019-09-28',28.91,7,2,3.49),('2020-07-01',24.17,7,2,3.49),('2020-07-04',31.82,7,2,3.49),('2020-07-08',28.19,7,2,3.49),('2020-07-11',28.49,7,2,3.49),('2020-07-15',29.75,7,2,3.49),('2020-07-18',36.98,7,2,3.49),('2020-07-22',31.27,7,2,3.49),('2020-07-25',32.90,7,2,3.49),('2020-07-29',34.13,7,2,3.49),('2020-08-01',24.15,7,2,3.49),('2020-08-05',36.52,7,2,3.49),('2020-08-08',34.16,7,2,3.49),('2020-08-12',26.15,7,2,3.49),('2020-08-15',28.51,7,2,3.49),('2020-08-19',26.48,7,2,3.49),('2020-08-22',32.86,7,2,3.49),('2020-08-26',30.95,7,2,3.49),('2020-08-29',28.01,7,2,3.49),('2020-09-02',32.06,7,2,3.49),('2020-09-05',30.06,7,2,3.49),('2020-09-09',28.66,7,2,3.49),('2020-09-12',29.90,7,2,3.49),('2020-09-16',31.59,7,2,3.49),('2020-09-19',29.00,7,2,3.49),('2020-09-23',22.03,7,2,3.49),('2020-09-26',30.16,7,2,3.49),('2020-09-30',28.95,7,2,3.49),('2019-07-03',70.00,7,3,0.50),('2019-07-06',70.00,7,3,0.50),('2019-07-10',60.00,7,3,0.50),('2019-07-13',80.00,7,3,0.50),('2019-07-17',60.00,7,3,0.50),('2019-07-20',70.00,7,3,0.50),('2019-07-24',70.00,7,3,0.50),('2019-07-27',70.00,7,3,0.50),('2019-07-31',80.00,7,3,0.50),('2019-08-03',50.00,7,3,0.50),('2019-08-07',70.00,7,3,0.50),('2019-08-10',70.00,7,3,0.50),('2019-08-14',80.00,7,3,0.50),('2019-08-17',50.00,7,3,0.50),('2019-08-21',50.00,7,3,0.50),('2019-08-24',60.00,7,3,0.50),('2019-08-28',80.00,7,3,0.50),('2019-08-31',80.00,7,3,0.50),('2019-09-04',80.00,7,3,0.50),('2019-09-07',50.00,7,3,0.50),('2019-09-11',60.00,7,3,0.50),('2019-09-14',60.00,7,3,0.50),('2019-09-18',50.00,7,3,0.50),('2019-09-21',80.00,7,3,0.50),('2019-09-25',80.00,7,3,0.50),('2019-09-28',70.00,7,3,0.50),('2020-07-01',60.00,7,3,0.50),('2020-07-04',60.00,7,3,0.50),('2020-07-08',50.00,7,3,0.50),('2020-07-11',60.00,7,3,0.50),('2020-07-15',80.00,7,3,0.50),('2020-07-18',80.00,7,3,0.50),('2020-07-22',60.00,7,3,0.50),('2020-07-25',60.00,7,3,0.50),('2020-07-29',70.00,7,3,0.50),('2020-08-01',70.00,7,3,0.50),('2020-08-05',70.00,7,3,0.50),('2020-08-08',60.00,7,3,0.50),('2020-08-12',70.00,7,3,0.50),('2020-08-15',60.00,7,3,0.50),('2020-08-19',70.00,7,3,0.50),('2020-08-22',60.00,7,3,0.50),('2020-08-26',60.00,7,3,0.50),('2020-08-29',80.00,7,3,0.50),('2020-09-02',50.00,7,3,0.50),('2020-09-05',50.00,7,3,0.50),('2020-09-09',60.00,7,3,0.50),('2020-09-12',80.00,7,3,0.50),('2020-09-16',60.00,7,3,0.50),('2020-09-19',70.00,7,3,0.50),('2020-09-23',50.00,7,3,0.50),('2020-09-26',70.00,7,3,0.50),('2020-09-30',60.00,7,3,0.50),('2019-04-03',40.00,7,4,4.00),('2019-04-06',40.00,7,4,4.00),('2019-04-10',30.00,7,4,4.00),('2019-04-13',30.00,7,4,4.00),('2019-04-17',40.00,7,4,4.00),('2019-04-20',40.00,7,4,4.00),('2019-04-24',40.00,7,4,4.00),('2019-04-27',30.00,7,4,4.00),('2019-05-01',40.00,7,4,4.00),('2019-05-04',30.00,7,4,4.00),('2019-05-08',40.00,7,4,4.00),('2019-05-11',40.00,7,4,4.00),('2019-05-15',30.00,7,4,4.00),('2019-05-18',30.00,7,4,4.00),('2019-05-22',40.00,7,4,4.00),('2019-05-25',30.00,7,4,4.00),('2019-05-29',40.00,7,4,4.00),('2019-06-01',30.00,7,4,4.00),('2019-06-05',40.00,7,4,4.00),('2019-06-08',30.00,7,4,4.00),('2019-06-12',30.00,7,4,4.00),('2019-06-15',40.00,7,4,4.00),('2019-06-19',40.00,7,4,4.00),('2019-06-22',40.00,7,4,4.00),('2019-06-26',40.00,7,4,4.00),('2019-06-29',30.00,7,4,4.00),('2019-07-03',40.00,7,4,4.00),('2019-07-06',30.00,7,4,4.00),('2019-07-10',30.00,7,4,4.00),('2019-07-13',40.00,7,4,4.00),('2019-07-17',40.00,7,4,4.00),('2019-07-20',40.00,7,4,4.00),('2019-07-24',40.00,7,4,4.00),('2019-07-27',30.00,7,4,4.00),('2019-07-31',30.00,7,4,4.00),('2019-08-03',40.00,7,4,4.00),('2019-08-07',40.00,7,4,4.00),('2019-08-10',40.00,7,4,4.00),('2019-08-14',30.00,7,4,4.00),('2019-08-17',40.00,7,4,4.00),('2019-08-21',40.00,7,4,4.00),('2019-08-24',40.00,7,4,4.00),('2019-08-28',30.00,7,4,4.00),('2019-08-31',40.00,7,4,4.00),('2019-09-04',40.00,7,4,4.00),('2019-09-07',40.00,7,4,4.00),('2019-09-11',40.00,7,4,4.00),('2019-09-14',30.00,7,4,4.00),('2019-09-18',40.00,7,4,4.00),('2019-09-21',40.00,7,4,4.00),('2019-09-25',40.00,7,4,4.00),('2019-09-28',30.00,7,4,4.00),('2019-10-02',30.00,7,4,4.00),('2019-10-05',40.00,7,4,4.00),('2019-10-09',40.00,7,4,4.00),('2019-10-12',40.00,7,4,4.00),('2019-10-16',30.00,7,4,4.00),('2019-10-19',30.00,7,4,4.00),('2019-10-23',40.00,7,4,4.00),('2019-10-26',40.00,7,4,4.00),('2019-10-30',40.00,7,4,4.00),('2019-11-02',40.00,7,4,4.00),('2019-11-06',40.00,7,4,4.00),('2019-11-09',40.00,7,4,4.00),('2019-11-13',30.00,7,4,4.00),('2019-11-16',40.00,7,4,4.00),('2019-11-20',40.00,7,4,4.00),('2019-11-23',40.00,7,4,4.00),('2019-11-27',30.00,7,4,4.00),('2019-11-30',40.00,7,4,4.00),('2019-12-04',30.00,7,4,4.00),('2019-12-07',40.00,7,4,4.00),('2019-12-11',40.00,7,4,4.00),('2019-12-14',40.00,7,4,4.00),('2019-12-18',40.00,7,4,4.00),('2019-12-21',30.00,7,4,4.00),('2019-12-25',30.00,7,4,4.00),('2019-12-28',40.00,7,4,4.00),('2020-03-04',30.00,7,4,4.00),('2020-03-07',40.00,7,4,4.00),('2020-03-11',40.00,7,4,4.00),('2020-03-14',30.00,7,4,4.00),('2020-03-18',40.00,7,4,4.00),('2020-03-21',40.00,7,4,4.00),('2020-03-25',40.00,7,4,4.00),('2020-03-28',40.00,7,4,4.00),('2020-04-01',40.00,7,4,4.00),('2020-04-04',40.00,7,4,4.00),('2020-04-08',30.00,7,4,4.00),('2020-04-11',40.00,7,4,4.00),('2020-04-15',40.00,7,4,4.00),('2020-04-18',40.00,7,4,4.00),('2020-04-22',40.00,7,4,4.00),('2020-04-25',40.00,7,4,4.00),('2020-04-29',40.00,7,4,4.00),('2020-05-02',30.00,7,4,4.00),('2020-05-06',40.00,7,4,4.00),('2020-05-09',30.00,7,4,4.00),('2020-05-13',30.00,7,4,4.00),('2020-05-16',30.00,7,4,4.00),('2020-05-20',40.00,7,4,4.00),('2020-05-23',40.00,7,4,4.00),('2020-05-27',40.00,7,4,4.00),('2020-05-30',40.00,7,4,4.00),('2020-06-03',40.00,7,4,4.00),('2020-06-06',40.00,7,4,4.00),('2020-06-10',40.00,7,4,4.00),('2020-06-13',40.00,7,4,4.00),('2020-06-17',40.00,7,4,4.00),('2020-06-20',30.00,7,4,4.00),('2020-06-24',40.00,7,4,4.00),('2020-06-27',40.00,7,4,4.00),('2020-07-01',40.00,7,4,4.00),('2020-07-04',40.00,7,4,4.00),('2020-07-08',30.00,7,4,4.00),('2020-07-11',40.00,7,4,4.00),('2020-07-15',40.00,7,4,4.00),('2020-07-18',30.00,7,4,4.00),('2020-07-22',40.00,7,4,4.00),('2020-07-25',40.00,7,4,4.00),('2020-07-29',40.00,7,4,4.00),('2020-08-01',30.00,7,4,4.00),('2020-08-05',40.00,7,4,4.00),('2020-08-08',40.00,7,4,4.00),('2020-08-12',40.00,7,4,4.00),('2020-08-15',40.00,7,4,4.00),('2020-08-19',40.00,7,4,4.00),('2020-08-22',40.00,7,4,4.00),('2020-08-26',30.00,7,4,4.00),('2020-08-29',40.00,7,4,4.00),('2020-09-02',40.00,7,4,4.00),('2020-09-05',40.00,7,4,4.00),('2020-09-09',40.00,7,4,4.00),('2020-09-12',30.00,7,4,4.00),('2020-09-16',30.00,7,4,4.00),('2020-09-19',40.00,7,4,4.00),('2020-09-23',30.00,7,4,4.00),('2020-09-26',40.00,7,4,4.00),('2020-09-30',30.00,7,4,4.00),('2020-10-03',40.00,7,4,4.00),('2020-10-07',30.00,7,4,4.00),('2020-10-10',30.00,7,4,4.00),('2019-04-03',16.00,8,5,6.50),('2019-04-06',23.00,8,5,6.50),('2019-04-10',23.00,8,5,6.50),('2019-04-13',25.00,8,5,6.50),('2019-04-17',22.00,8,5,6.50),('2019-04-20',24.00,8,5,6.50),('2019-04-24',18.00,8,5,6.50),('2019-04-27',18.00,8,5,6.50),('2019-05-01',25.00,8,5,6.50),('2019-05-04',21.00,8,5,6.50),('2019-05-08',24.00,8,5,6.50),('2019-05-11',17.00,8,5,6.50),('2019-05-15',16.00,8,5,6.50),('2019-05-18',18.00,8,5,6.50),('2019-05-22',25.00,8,5,6.50),('2019-05-25',16.00,8,5,6.50),('2019-05-29',18.00,8,5,6.50),('2019-06-01',17.00,8,5,6.50),('2019-06-05',16.00,8,5,6.50),('2019-06-08',22.00,8,5,6.50),('2019-06-12',17.00,8,5,6.50),('2019-06-15',19.00,8,5,6.50),('2019-06-19',16.00,8,5,6.50),('2019-06-22',21.00,8,5,6.50),('2019-06-26',18.00,8,5,6.50),('2019-06-29',25.00,8,5,6.50),('2019-07-03',24.00,8,5,6.50),('2019-07-06',19.00,8,5,6.50),('2019-07-10',16.00,8,5,6.50),('2019-07-13',17.00,8,5,6.50),('2019-07-17',23.00,8,5,6.50),('2019-07-20',18.00,8,5,6.50),('2019-07-24',25.00,8,5,6.50),('2019-07-27',21.00,8,5,6.50),('2019-07-31',20.00,8,5,6.50),('2019-08-03',18.00,8,5,6.50),('2019-08-07',20.00,8,5,6.50),('2019-08-10',21.00,8,5,6.50),('2019-08-14',18.00,8,5,6.50),('2019-08-17',20.00,8,5,6.50),('2019-08-21',17.00,8,5,6.50),('2019-08-24',19.00,8,5,6.50),('2019-08-28',24.00,8,5,6.50),('2019-08-31',20.00,8,5,6.50),('2019-09-04',21.00,8,5,6.50),('2019-09-07',25.00,8,5,6.50),('2019-09-11',25.00,8,5,6.50),('2019-09-14',21.00,8,5,6.50),('2019-09-18',16.00,8,5,6.50),('2019-09-21',18.00,8,5,6.50),('2019-09-25',23.00,8,5,6.50),('2019-09-28',21.00,8,5,6.50),('2019-10-02',21.00,8,5,6.50),('2019-10-05',19.00,8,5,6.50),('2019-10-09',25.00,8,5,6.50),('2019-10-12',17.00,8,5,6.50),('2019-10-16',23.00,8,5,6.50),('2019-10-19',25.00,8,5,6.50),('2019-10-23',19.00,8,5,6.50),('2019-10-26',24.00,8,5,6.50),('2019-10-30',18.00,8,5,6.50),('2019-11-02',18.00,8,5,6.50),('2019-11-06',15.00,8,5,6.50),('2019-11-09',21.00,8,5,6.50),('2019-11-13',16.00,8,5,6.50),('2019-11-16',21.00,8,5,6.50),('2019-11-20',25.00,8,5,6.50),('2019-11-23',22.00,8,5,6.50),('2019-11-27',17.00,8,5,6.50),('2019-11-30',15.00,8,5,6.50),('2019-12-04',20.00,8,5,6.50),('2019-12-07',22.00,8,5,6.50),('2019-12-11',16.00,8,5,6.50),('2019-12-14',21.00,8,5,6.50),('2019-12-18',19.00,8,5,6.50),('2019-12-21',19.00,8,5,6.50),('2019-12-25',18.00,8,5,6.50),('2019-12-28',17.00,8,5,6.50),('2020-03-04',15.00,8,5,6.50),('2020-03-07',17.00,8,5,6.50),('2020-03-11',16.00,8,5,6.50),('2020-03-14',22.00,8,5,6.50),('2020-03-18',20.00,8,5,6.50),('2020-03-21',15.00,8,5,6.50),('2020-03-25',25.00,8,5,6.50),('2020-03-28',22.00,8,5,6.50),('2020-04-01',22.00,8,5,6.50),('2020-04-04',16.00,8,5,6.50),('2020-04-08',24.00,8,5,6.50),('2020-04-11',19.00,8,5,6.50),('2020-04-15',23.00,8,5,6.50),('2020-04-18',25.00,8,5,6.50),('2020-04-22',22.00,8,5,6.50),('2020-04-25',22.00,8,5,6.50),('2020-04-29',24.00,8,5,6.50),('2020-05-02',18.00,8,5,6.50),('2020-05-06',22.00,8,5,6.50),('2020-05-09',25.00,8,5,6.50),('2020-05-13',15.00,8,5,6.50),('2020-05-16',17.00,8,5,6.50),('2020-05-20',16.00,8,5,6.50),('2020-05-23',20.00,8,5,6.50),('2020-05-27',18.00,8,5,6.50),('2020-05-30',24.00,8,5,6.50),('2020-06-03',15.00,8,5,6.50),('2020-06-06',24.00,8,5,6.50),('2020-06-10',21.00,8,5,6.50),('2020-06-13',22.00,8,5,6.50),('2020-06-17',21.00,8,5,6.50),('2020-06-20',15.00,8,5,6.50),('2020-06-24',22.00,8,5,6.50),('2020-06-27',23.00,8,5,6.50),('2020-07-01',16.00,8,5,6.50),('2020-07-04',24.00,8,5,6.50),('2020-07-08',19.00,8,5,6.50),('2020-07-11',21.00,8,5,6.50),('2020-07-15',16.00,8,5,6.50),('2020-07-18',22.00,8,5,6.50),('2020-07-22',23.00,8,5,6.50),('2020-07-25',15.00,8,5,6.50),('2020-07-29',18.00,8,5,6.50),('2020-08-01',21.00,8,5,6.50),('2020-08-05',23.00,8,5,6.50),('2020-08-08',16.00,8,5,6.50),('2020-08-12',21.00,8,5,6.50),('2020-08-15',21.00,8,5,6.50),('2020-08-19',17.00,8,5,6.50),('2020-08-22',19.00,8,5,6.50),('2020-08-26',25.00,8,5,6.50),('2020-08-29',20.00,8,5,6.50),('2020-09-02',21.00,8,5,6.50),('2020-09-05',15.00,8,5,6.50),('2020-09-09',18.00,8,5,6.50),('2020-09-12',24.00,8,5,6.50),('2020-09-16',17.00,8,5,6.50),('2020-09-19',25.00,8,5,6.50),('2020-09-23',21.00,8,5,6.50),('2020-09-26',15.00,8,5,6.50),('2020-09-30',25.00,8,5,6.50),('2020-10-03',22.00,8,5,6.50),('2020-10-07',20.00,8,5,6.50),('2020-10-10',20.00,8,5,6.50),('2019-04-03',8.00,8,7,18.00),('2019-04-06',8.00,8,7,18.00),('2019-04-10',6.00,8,7,18.00),('2019-04-13',6.00,8,7,18.00),('2019-04-17',7.00,8,7,18.00),('2019-04-20',8.00,8,7,18.00),('2019-04-24',6.00,8,7,18.00),('2019-04-27',6.00,8,7,18.00),('2019-05-01',5.00,8,7,18.00),('2019-05-04',8.00,8,7,18.00),('2019-05-08',8.00,8,7,18.00),('2019-05-11',6.00,8,7,18.00),('2019-05-15',8.00,8,7,18.00),('2019-05-18',9.00,8,7,18.00),('2019-05-22',5.00,8,7,18.00),('2019-05-25',8.00,8,7,18.00),('2019-05-29',10.00,8,7,18.00),('2019-06-01',10.00,8,7,18.00),('2019-06-05',7.00,8,7,18.00),('2019-06-08',10.00,8,7,18.00),('2019-06-12',7.00,8,7,18.00),('2019-06-15',9.00,8,7,18.00),('2019-06-19',7.00,8,7,18.00),('2019-06-22',7.00,8,7,18.00),('2019-06-26',6.00,8,7,18.00),('2019-06-29',8.00,8,7,18.00),('2019-07-03',7.00,8,7,18.00),('2019-07-06',8.00,8,7,18.00),('2019-07-10',7.00,8,7,18.00),('2019-07-13',5.00,8,7,18.00),('2019-07-17',9.00,8,7,18.00),('2019-07-20',10.00,8,7,18.00),('2019-07-24',6.00,8,7,18.00),('2019-07-27',9.00,8,7,18.00),('2019-07-31',5.00,8,7,18.00),('2019-08-03',8.00,8,7,18.00),('2019-08-07',5.00,8,7,18.00),('2019-08-10',5.00,8,7,18.00),('2019-08-14',5.00,8,7,18.00),('2019-08-17',6.00,8,7,18.00),('2019-08-21',5.00,8,7,18.00),('2019-08-24',9.00,8,7,18.00),('2019-08-28',8.00,8,7,18.00),('2019-08-31',6.00,8,7,18.00),('2019-09-04',9.00,8,7,18.00),('2019-09-07',5.00,8,7,18.00),('2019-09-11',5.00,8,7,18.00),('2019-09-14',10.00,8,7,18.00),('2019-09-18',9.00,8,7,18.00),('2019-09-21',10.00,8,7,18.00),('2019-09-25',9.00,8,7,18.00),('2019-09-28',10.00,8,7,18.00),('2019-10-02',8.00,8,7,18.00),('2019-10-05',9.00,8,7,18.00),('2019-10-09',5.00,8,7,18.00),('2019-10-12',9.00,8,7,18.00),('2019-10-16',7.00,8,7,18.00),('2019-10-19',10.00,8,7,18.00),('2019-10-23',7.00,8,7,18.00),('2019-10-26',8.00,8,7,18.00),('2019-10-30',7.00,8,7,18.00),('2019-11-02',8.00,8,7,18.00),('2019-11-06',7.00,8,7,18.00),('2019-11-09',5.00,8,7,18.00),('2019-11-13',9.00,8,7,18.00),('2019-11-16',15.00,8,7,18.00),('2019-11-20',24.00,8,7,18.00),('2019-11-23',20.00,8,7,18.00),('2019-11-27',15.00,8,7,18.00),('2019-11-30',25.00,8,7,18.00),('2019-12-04',5.00,8,7,18.00),('2019-12-07',9.00,8,7,18.00),('2019-12-11',8.00,8,7,18.00),('2019-12-14',7.00,8,7,18.00),('2019-12-18',28.00,8,7,18.00),('2019-12-21',17.00,8,7,18.00),('2019-12-25',15.00,8,7,18.00),('2019-12-28',23.00,8,7,18.00),('2020-03-04',6.00,8,7,18.00),('2020-03-07',8.00,8,7,18.00),('2020-03-11',5.00,8,7,18.00),('2020-03-14',8.00,8,7,18.00),('2020-03-18',8.00,8,7,18.00),('2020-03-21',7.00,8,7,18.00),('2020-03-25',6.00,8,7,18.00),('2020-03-28',7.00,8,7,18.00),('2020-04-01',9.00,8,7,18.00),('2020-04-04',9.00,8,7,18.00),('2020-04-08',9.00,8,7,18.00),('2020-04-11',6.00,8,7,18.00),('2020-04-15',6.00,8,7,18.00),('2020-04-18',5.00,8,7,18.00),('2020-04-22',10.00,8,7,18.00),('2020-04-25',7.00,8,7,18.00),('2020-04-29',8.00,8,7,18.00),('2020-05-02',9.00,8,7,18.00),('2020-05-06',5.00,8,7,18.00),('2020-05-09',10.00,8,7,18.00),('2020-05-13',9.00,8,7,18.00),('2020-05-16',9.00,8,7,18.00),('2020-05-20',7.00,8,7,18.00),('2020-05-23',9.00,8,7,18.00),('2020-05-27',6.00,8,7,18.00),('2020-05-30',5.00,8,7,18.00),('2020-06-03',10.00,8,7,18.00),('2020-06-06',7.00,8,7,18.00),('2020-06-10',9.00,8,7,18.00),('2020-06-13',9.00,8,7,18.00),('2020-06-17',7.00,8,7,18.00),('2020-06-20',5.00,8,7,18.00),('2020-06-24',9.00,8,7,18.00),('2020-06-27',10.00,8,7,18.00),('2020-07-01',7.00,8,7,18.00),('2020-07-04',5.00,8,7,18.00),('2020-07-08',7.00,8,7,18.00),('2020-07-11',6.00,8,7,18.00),('2020-07-15',6.00,8,7,18.00),('2020-07-18',10.00,8,7,18.00),('2020-07-22',5.00,8,7,18.00),('2020-07-25',9.00,8,7,18.00),('2020-07-29',5.00,8,7,18.00),('2020-08-01',9.00,8,7,18.00),('2020-08-05',6.00,8,7,18.00),('2020-08-08',6.00,8,7,18.00),('2020-08-12',8.00,8,7,18.00),('2020-08-15',6.00,8,7,18.00),('2020-08-19',7.00,8,7,18.00),('2020-08-22',5.00,8,7,18.00),('2020-08-26',6.00,8,7,18.00),('2020-08-29',9.00,8,7,18.00),('2020-09-02',6.00,8,7,18.00),('2020-09-05',6.00,8,7,18.00),('2020-09-09',10.00,8,7,18.00),('2020-09-12',5.00,8,7,18.00),('2020-09-16',7.00,8,7,18.00),('2020-09-19',8.00,8,7,18.00),('2020-09-23',10.00,8,7,18.00),('2020-09-26',10.00,8,7,18.00),('2020-09-30',7.00,8,7,18.00),('2020-10-03',9.00,8,7,18.00),('2020-10-07',10.00,8,7,18.00),('2020-10-10',10.00,8,7,18.00),('2019-04-03',10.00,8,8,18.00),('2019-04-06',8.00,8,8,18.00),('2019-04-10',8.00,8,8,18.00),('2019-04-13',7.00,8,8,18.00),('2019-04-17',10.00,8,8,18.00),('2019-04-20',5.00,8,8,18.00),('2019-04-24',5.00,8,8,18.00),('2019-04-27',8.00,8,8,18.00),('2019-05-01',9.00,8,8,18.00),('2019-05-04',9.00,8,8,18.00),('2019-05-08',7.00,8,8,18.00),('2019-05-11',8.00,8,8,18.00),('2019-05-15',7.00,8,8,18.00),('2019-05-18',5.00,8,8,18.00),('2019-05-22',10.00,8,8,18.00),('2019-05-25',6.00,8,8,18.00),('2019-05-29',10.00,8,8,18.00),('2019-06-01',7.00,8,8,18.00),('2019-06-05',5.00,8,8,18.00),('2019-06-08',6.00,8,8,18.00),('2019-06-12',9.00,8,8,18.00),('2019-06-15',10.00,8,8,18.00),('2019-06-19',6.00,8,8,18.00),('2019-06-22',9.00,8,8,18.00),('2019-06-26',5.00,8,8,18.00),('2019-06-29',8.00,8,8,18.00),('2019-07-03',5.00,8,8,18.00),('2019-07-06',5.00,8,8,18.00),('2019-07-10',8.00,8,8,18.00),('2019-07-13',8.00,8,8,18.00),('2019-07-17',7.00,8,8,18.00),('2019-07-20',5.00,8,8,18.00),('2019-07-24',8.00,8,8,18.00),('2019-07-27',6.00,8,8,18.00),('2019-07-31',5.00,8,8,18.00),('2019-08-03',5.00,8,8,18.00),('2019-08-07',5.00,8,8,18.00),('2019-08-10',10.00,8,8,18.00),('2019-08-14',6.00,8,8,18.00),('2019-08-17',9.00,8,8,18.00),('2019-08-21',9.00,8,8,18.00),('2019-08-24',5.00,8,8,18.00),('2019-08-28',8.00,8,8,18.00),('2019-08-31',10.00,8,8,18.00),('2019-09-04',6.00,8,8,18.00),('2019-09-07',8.00,8,8,18.00),('2019-09-11',5.00,8,8,18.00),('2019-09-14',6.00,8,8,18.00),('2019-09-18',6.00,8,8,18.00),('2019-09-21',5.00,8,8,18.00),('2019-09-25',5.00,8,8,18.00),('2019-09-28',10.00,8,8,18.00),('2019-10-02',5.00,8,8,18.00),('2019-10-05',7.00,8,8,18.00),('2019-10-09',9.00,8,8,18.00),('2019-10-12',5.00,8,8,18.00),('2019-10-16',5.00,8,8,18.00),('2019-10-19',8.00,8,8,18.00),('2019-10-23',5.00,8,8,18.00),('2019-10-26',6.00,8,8,18.00),('2019-10-30',5.00,8,8,18.00),('2019-11-02',7.00,8,8,18.00),('2019-11-06',9.00,8,8,18.00),('2019-11-09',8.00,8,8,18.00),('2019-11-13',7.00,8,8,18.00),('2019-11-16',23.00,8,8,18.00),('2019-11-20',23.00,8,8,18.00),('2019-11-23',26.00,8,8,18.00),('2019-11-27',15.00,8,8,18.00),('2019-11-30',20.00,8,8,18.00),('2019-12-04',10.00,8,8,18.00),('2019-12-07',7.00,8,8,18.00),('2019-12-11',5.00,8,8,18.00),('2019-12-14',5.00,8,8,18.00),('2019-12-18',27.00,8,8,18.00),('2019-12-21',20.00,8,8,18.00),('2019-12-25',19.00,8,8,18.00),('2019-12-28',26.00,8,8,18.00),('2020-03-04',5.00,8,8,18.00),('2020-03-07',6.00,8,8,18.00),('2020-03-11',9.00,8,8,18.00),('2020-03-14',6.00,8,8,18.00),('2020-03-18',10.00,8,8,18.00),('2020-03-21',8.00,8,8,18.00),('2020-03-25',7.00,8,8,18.00),('2020-03-28',9.00,8,8,18.00),('2020-04-01',5.00,8,8,18.00),('2020-04-04',9.00,8,8,18.00),('2020-04-08',7.00,8,8,18.00),('2020-04-11',6.00,8,8,18.00),('2020-04-15',6.00,8,8,18.00),('2020-04-18',5.00,8,8,18.00),('2020-04-22',8.00,8,8,18.00),('2020-04-25',6.00,8,8,18.00),('2020-04-29',10.00,8,8,18.00),('2020-05-02',6.00,8,8,18.00),('2020-05-06',10.00,8,8,18.00),('2020-05-09',6.00,8,8,18.00),('2020-05-13',5.00,8,8,18.00),('2020-05-16',6.00,8,8,18.00),('2020-05-20',5.00,8,8,18.00),('2020-05-23',8.00,8,8,18.00),('2020-05-27',9.00,8,8,18.00),('2020-05-30',9.00,8,8,18.00),('2020-06-03',5.00,8,8,18.00),('2020-06-06',6.00,8,8,18.00),('2020-06-10',5.00,8,8,18.00),('2020-06-13',7.00,8,8,18.00),('2020-06-17',5.00,8,8,18.00),('2020-06-20',5.00,8,8,18.00),('2020-06-24',7.00,8,8,18.00),('2020-06-27',7.00,8,8,18.00),('2020-07-01',6.00,8,8,18.00),('2020-07-04',8.00,8,8,18.00),('2020-07-08',5.00,8,8,18.00),('2020-07-11',5.00,8,8,18.00),('2020-07-15',9.00,8,8,18.00),('2020-07-18',7.00,8,8,18.00),('2020-07-22',5.00,8,8,18.00),('2020-07-25',10.00,8,8,18.00),('2020-07-29',10.00,8,8,18.00),('2020-08-01',7.00,8,8,18.00),('2020-08-05',7.00,8,8,18.00),('2020-08-08',9.00,8,8,18.00),('2020-08-12',8.00,8,8,18.00),('2020-08-15',6.00,8,8,18.00),('2020-08-19',9.00,8,8,18.00),('2020-08-22',5.00,8,8,18.00),('2020-08-26',6.00,8,8,18.00),('2020-08-29',10.00,8,8,18.00),('2020-09-02',10.00,8,8,18.00),('2020-09-05',8.00,8,8,18.00),('2020-09-09',10.00,8,8,18.00),('2020-09-12',9.00,8,8,18.00),('2020-09-16',6.00,8,8,18.00),('2020-09-19',7.00,8,8,18.00),('2020-09-23',5.00,8,8,18.00),('2020-09-26',5.00,8,8,18.00),('2020-09-30',7.00,8,8,18.00),('2020-10-03',9.00,8,8,18.00),('2020-10-07',10.00,8,8,18.00),('2020-10-10',10.00,8,8,18.00),('2019-06-01',120.00,4,16,0.50),('2019-06-05',140.00,4,16,0.50),('2019-06-08',100.00,4,16,0.50),('2019-06-12',120.00,4,16,0.50),('2019-06-15',140.00,4,16,0.50),('2019-06-19',120.00,4,16,0.50),('2019-06-22',120.00,4,16,0.50),('2019-06-26',140.00,4,16,0.50),('2019-06-29',100.00,4,16,0.50),('2019-07-03',300.00,4,16,0.50),('2019-07-06',200.00,4,16,0.50),('2019-07-10',300.00,4,16,0.50),('2019-07-13',250.00,4,16,0.50),('2019-07-17',300.00,4,16,0.50),('2019-07-20',300.00,4,16,0.50),('2019-07-24',250.00,4,16,0.50),('2019-07-27',250.00,4,16,0.50),('2019-07-31',250.00,4,16,0.50),('2019-08-03',300.00,4,16,0.50),('2019-08-07',300.00,4,16,0.50),('2019-08-10',250.00,4,16,0.50),('2019-08-14',200.00,4,16,0.50),('2019-08-17',300.00,4,16,0.50),('2019-08-21',250.00,4,16,0.50),('2019-08-24',250.00,4,16,0.50),('2019-08-28',250.00,4,16,0.50),('2019-08-31',300.00,4,16,0.50),('2019-09-04',120.00,4,16,0.50),('2019-09-07',120.00,4,16,0.50),('2019-09-11',140.00,4,16,0.50),('2019-09-14',120.00,4,16,0.50),('2019-09-18',120.00,4,16,0.50),('2019-09-21',120.00,4,16,0.50),('2019-09-25',100.00,4,16,0.50),('2019-09-28',140.00,4,16,0.50),('2020-06-03',120.00,4,16,0.50),('2020-06-06',140.00,4,16,0.50),('2020-06-10',140.00,4,16,0.50),('2020-06-13',120.00,4,16,0.50),('2020-06-17',120.00,4,16,0.50),('2020-06-20',140.00,4,16,0.50),('2020-06-24',140.00,4,16,0.50),('2020-06-27',120.00,4,16,0.50),('2020-07-01',300.00,4,16,0.50),('2020-07-04',250.00,4,16,0.50),('2020-07-08',250.00,4,16,0.50),('2020-07-11',300.00,4,16,0.50),('2020-07-15',300.00,4,16,0.50),('2020-07-18',250.00,4,16,0.50),('2020-07-22',250.00,4,16,0.50),('2020-07-25',200.00,4,16,0.50),('2020-07-29',250.00,4,16,0.50),('2020-08-01',250.00,4,16,0.50),('2020-08-05',250.00,4,16,0.50),('2020-08-08',200.00,4,16,0.50),('2020-08-12',300.00,4,16,0.50),('2020-08-15',200.00,4,16,0.50),('2020-08-19',250.00,4,16,0.50),('2020-08-22',250.00,4,16,0.50),('2020-08-26',300.00,4,16,0.50),('2020-08-29',200.00,4,16,0.50),('2020-09-02',140.00,4,16,0.50),('2020-09-05',140.00,4,16,0.50),('2020-09-09',120.00,4,16,0.50),('2020-09-12',140.00,4,16,0.50),('2020-09-16',140.00,4,16,0.50),('2020-09-19',140.00,4,16,0.50),('2020-09-23',100.00,4,16,0.50),('2020-09-26',120.00,4,16,0.50),('2020-09-30',140.00,4,16,0.50);
/*!40000 ALTER TABLE `vendor_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `zip_data`
--

DROP TABLE IF EXISTS `zip_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `zip_data` (
  `zip_code_5` char(5) NOT NULL,
  `median_household_income` float DEFAULT NULL,
  `percent_high_income` float DEFAULT NULL,
  `percent_under_18` float DEFAULT NULL,
  `percent_over_65` float DEFAULT NULL,
  `people_per_sq_mile` float DEFAULT NULL,
  `latitude` float DEFAULT NULL,
  `longitude` float DEFAULT NULL,
  PRIMARY KEY (`zip_code_5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `zip_data`
--

LOCK TABLES `zip_data` WRITE;
/*!40000 ALTER TABLE `zip_data` DISABLE KEYS */;
INSERT INTO `zip_data` VALUES ('22801',53042,0.05,0.16,0.11,1279.6,38.427,-78.882),('22802',48746,0.028,0.23,0.14,321.2,38.478,-78.863),('22821',65417,0.053,0.25,0.17,66.3,38.437,-78.99);
/*!40000 ALTER TABLE `zip_data` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2021-06-28  1:06:00
