-- Najpierw utwórz tabelę reprezentującą sekwencję e-maili każdego klienta.

CREATE TEMP TABLE customer_email_sequences AS (
  SELECT
    customer_id,
    ARRAY_AGG(email_subject ORDER BY sent_date) AS email_sequence
  FROM emails
  GROUP BY 1
);

-- Następnie ustal trzy najczęściej występujące sekwencje e-maili.

CREATE TEMP TABLE top_email_sequences AS (
  SELECT
    email_sequence,
    COUNT(1) AS occurrences
  FROM customer_email_sequences
  GROUP BY 1
  ORDER BY 2 DESC
  LIMIT 3
);
SELECT email_sequence FROM top_email_sequences;

-- Teraz sprawdź, które z tych tablic są nadzbiorami innych tablic. W tym celu warto ponumerować wiersze.

ALTER TABLE top_email_sequences ADD COLUMN id SERIAL PRIMARY KEY;

-- Następnie wykonaj złączenie krzyżowe tabeli z nią samą. 
-- Użyj operatora @>, aby sprawdzić, czy tablica zawierająca sekwencję e-maili zawiera inną taką tablicę.

SELECT
  super_email_seq.id AS superset_id,
  sub_email_seq.id AS subset_id
FROM top_email_sequences AS super_email_seq
CROSS JOIN top_email_sequences AS sub_email_seq
WHERE super_email_seq.email_sequence @> sub_email_seq.email_sequence
AND super_email_seq.id != sub_email_seq.id;
