-- Wczytaj bazę sqlda.

$ psql sqlda

-- Wyświetl pola dostępne w tabeli sales.

sqlda=# \d

-- Użyj złączenia wewnętrznego na podstawie kolumn product_id z tabel product_names i sales. Z wyników tego złączenia wewnętrznego
-- pobierz kolumny model, customer_id, sales_transaction_date, sales_amount, channel i dealership_id; zapisz je w odrębnej tabeli product_sales.

sqlda=# SELECT model, customer_id, sales_transaction_date, sales_amount, channel, dealership_id INTO products_sales FROM sales INNER JOIN product_names ON sales.product_id=product_names.product_id;

-- Przyjrzyj się pierwszym pięciu wierszom nowej tabeli, używając poniższej kwerendy.

sqlda=# SELECT * FROM products_sales LIMIT 5;

-- Pobierz z tabeli products_sales wszystkie informacje na temat skuterów Bat i uporządkuj je w tabeli sales_transaction_date rosnąco według dat.

sqlda=# SELECT * FROM products_sales WHERE model='Bat' ORDER BY sales_transaction_date;

-- Zlicz dostępne rekordy, używając następującej kwerendy.

sqlda=# SELECT COUNT(model) FROM products_sales WHERE model='Bat';

-- Określ ostatnią datę sprzedaży skutera Bat. W tym celu wybierz wartość maksymalną (za pomocą funkcji MAX) z pola sales_transaction_date.

sqlda=# SELECT MAX(sales_transaction_date) FROM products_sales WHERE model='Bat';

-- Pobierz dzienny poziom sprzedaży skuterów Bat i zapisz go w nowej tabeli, bat_sales, aby potwierdzić informacje uzyskane od 
-- działu sprzedażowego, od którego dowiedziałeś się, że po pierwszych dwóch tygodniach sprzedaż spadła o 20%.
 
sqlda=# SELECT * INTO bat_sales FROM products_sales WHERE model='Bat' ORDER BY sales_transaction_date;

-- Usuń informacje o godzinie, aby umożliwić analizowanie transakcji według dat (na tym etapie godzina sprzedaży nie jest 
-- istotna). W tym celu uruchom poniższą kwerendę, w której pole sales_transaction_date jest przekazywane do funkcji
-- DATE, co powoduje pozostawienie w kolumnie tylko informacji o dniu, miesiącu i roku.

sqlda=# UPDATE bat_sales SET sales_transaction_date=DATE(sales_transaction_date);

-- Wyświetl pięć pierwszych rekordów z tabeli bat_sales uporządkowanych według daty sprzedaży (sales_transaction_date).

sqlda=# SELECT * FROM bat_sales ORDER BY sales_transaction_date LIMIT 5;

-- Utwórz nową tabelę, bat_sales_daily, zawierającą daty sprzedaży i dzienną liczbę transakcji.

sqlda=# SELECT sales_transaction_date, COUNT(sales_transaction_date) INTO bat_sales_daily FROM bat_sales GROUP BY sales_transaction_date ORDER BY sales_transaction_date;

-- Sprawdź pierwsze 22 rekordy (reprezentujące nieco ponad trzy tygodnie), ponieważ 
-- zgodnie z doniesieniami sprzedaż spadła po około dwóch pierwszych tygodniach.

sqlda=# SELECT * FROM bat_sales_daily LIMIT 22;