-- Wczytaj przygotowane funkcje do bazy danych smalljoins, używając pliku Funkcje.sql.

$ psql smalljoins < Functions.sql

-- Nawiąż połączenie z bazą danych smalljoins.

$ psql smalljoins

-- Po wczytaniu definicji funkcji pobierz ich listę za pomocą polecenia \df.

smalljoins=# \df

-- Najpierw przyjrzyj się aktualnemu stanowi tabeli products.

smalljoins=# SELECT * FROM products;

-- Aby wyświetlić informacje o zamówieniach, możesz użyć następującej kwerendy.

smalljoins=# SELECT * FROM order_info;

-- Wstaw nowe zamówienie, używając funkcji insert_order z argumentami customer_id 4, product_code MON636 i qty 10.

smalljoins=# SELECT insert_order(4, 'MON636', 10);

-- Przejrzyj dane z tabeli order_info.

smalljoins=# SELECT * FROM order_info;

-- Zaktualizuj tabelę products, aby uwzględnić ostatnią sprzedaż 10 sztuk produktu Red Herring. Użyj do tego funkcji update_stock.

smalljoins=# SELECT update_stock();

-- Przyjrzyj się tabeli products. Zwróć uwagę na zaktualizowaną liczbę sztuk produktu Red Herring.

smalljoins=# SELECT * FROM products;

-- Usuń (za pomocą polecenia DROP) wcześniejszą wersję funkcji update_stock.

smalljoins=# DROP FUNCTION update_stock;

-- Utwórz nową funkcję update_stock, która zwraca wyzwalacz.

smalljoins=# CREATE FUNCTION update_stock() RETURNS TRIGGER AS $stock_trigger$
smalljoins$# DECLARE stock_qty integer;
smalljoins$# BEGIN
smalljoins$# stock_qty := get_stock(NEW.product_code) – NEW.qty;
smalljoins$# UPDATE products SET stock=stock_qty WHERE product_code=NEW.product_code;
smalljoins$# RETURN NEW;
smalljoins$# END; $stock_trigger$
smalljoins-# LANGUAGE PLPGSQL; 

-- Utwórz wyzwalacz.

smalljoins=# CREATE TRIGGER update_trigger
smalljoins-# AFTER INSERT ON order_info
smalljoins-# FOR EACH ROW
smalljoins-# EXECUTE PROCEDURE update_stock();

-- Po utworzeniu nowego wyzwalacza pora go przetestować. Wywołaj funkcję insert_order, aby wstawić nowy rekord do tabeli order_info.

smalljoins=# SELECT insert_order(4, 'MON123', 2);

-- Przyjrzyj się rekordom z tabeli order_info.

smalljoins=# SELECT * FROM order_info;

-- Teraz wyświetl rekordy z tabeli products.

smalljoins=# SELECT * FROM products;
