-- Wczytaj bazę danych sqlda.

$ psql sqlda

-- Najpierw przyjrzyj się tabeli emails, aby zobaczyć, jakie informacje są dostępne. Pobierz pierwszych pięć wierszy z tej tabeli.

sqlda=# SELECT * FROM emails LIMIT 5;

-- W celu sprawdzenia hipotezy musisz pobrać wartość kolumny customer_id nabywców skuterów Bat z tabel emails i bat_sales, a także
-- kolumny opened, sent_date, opened_date i email_subject z tabeli emails oraz kolumnę sales_transaction_date z tabeli bat_sales. 
-- Ponieważ potrzebne są tylko rekordy z danymi o e-mailach do klientów, którzy kupili skuter Bat, złącz tabele na podstawie 
-- kolumny customer_id. Następnie wstaw wyniki do nowej tabeli — bat_mails

sqlda=# SELECT emails.email_subject, emails.customer_id, emails.opened, emails.sent_date, emails.opened_date, bat_sales.sales_transaction_date INTO bat_emails FROM emails INNER JOIN bat_sales ON bat_sales.customer_id=emails.customer_id ORDER BY bat_sales.sales_transaction_date;

-- Pobierz pierwszych 10 wierszy z tabeli bat_emails. Uporządkuj wyniki według kolumny sales_transaction_date.

sqlda=# SELECT * FROM bat_emails LIMIT 10;

-- Pobierz wszystkie wiersze, w których wartość z kolumny sent_date jest wcześniejsza niż wartość z 
-- kolumny sales_transaction_date. Uporządkuj dane według kolumny customer_id i ogranicz liczbę danych wyjściowych do 22 wierszy.

sqlda=# SELECT * FROM bat_emails WHERE sent_date < sales_transaction_date ORDER BY customer_id LIMIT 22;

-- Usuń z tabeli bat_mails wiersze wysłane ponad sześć miesięcy przed rozpoczęciem produkcji.

sqlda=# DELETE FROM bat_emails WHERE sent_date < '2016-04-10';

-- Usuń też wiersze, w których data wysłania wiadomości jest późniejsza niż data zakupu, ponieważ takie e-maile nie są związane z transakcją.

sqlda=# DELETE FROM bat_emails WHERE sent_date > sales_transaction_date;

-- Usuń wiersze, w których różnica między datą transakcji a datą wysłania wiadomości 
-- przekracza 30, ponieważ tu ważne są tylko e-maile przesłane niedługo przed zakupem skutera.

sqlda=# DELETE FROM bat_emails WHERE (sales_transaction_date-sent_date) > '30 days';

-- Ponownie sprawdź pierwsze 22 wiersze uporządkowane według kolumny customer_id.

sqlda=# SELECT * FROM bat_emails ORDER BY customer_id LIMIT 22;

-- Pobierz unikatowe wartości z kolumny email_subject, aby uzyskać listę różnych e-maili przesłanych do klientów.

sqlda=# SELECT DISTINCT(email_subject) FROM bat_emails;

-- Usuń wszystkie rekordy z tekstem Black Friday w temacie. Te e-maile nie są związane ze sprzedażą skuterów Bat.

sqlda=# DELETE FROM bat_emails WHERE position('Black Friday' in email_subject)>0;

-- Usuń wszystkie wiersze z tekstem 25% off all EVs. It's a Christmas Miracle! lub A New Year, And Some New EVs w kolumnie email_subject.

sqlda=# DELETE FROM bat_emails WHERE position('25% off all EV' in email_subject)>0;
sqlda=# DELETE FROM bat_emails WHERE position('Some New EV' in email_subject)>0;

-- Na tym etapie masz ostateczny zbiór danych z e-mailami wysłanymi do klientów. Zlicz wiersze, które pozostały w tym zbiorze.

sqlda=# SELECT count(sales_transaction_date) FROM bat_emails;

-- Teraz oblicz, jaki procent e-maili związanych ze sprzedażą został otwartych. Zlicz otwarte e-maile.

sqlda=# SELECT count(opened) FROM bat_emails WHERE opened='t'

-- Zlicz klientów, którzy otrzymali e-maile i dokonali zakupu. W tym celu zlicz unikatowych klientów z tabeli bat_emails.

sqlda=# SELECT COUNT(DISTINCT(customer_id)) FROM bat_emails;

-- Zlicz unikatowych klientów, którzy dokonali zakupu.

sqlda=# SELECT COUNT(DISTINCT(customer_id)) FROM bat_sales;

-- Oblicz procent klientów, którzy kupili skuter Bat po otrzymaniu e-maila.

sqlda=# SELECT 396.0/6659.0 AS email_rate;

-- Ogranicz zakres dat do wszystkich transakcji sprzed 1 października 2016 r. Umieść dane w nowej tabeli, bat_emails_threewks.

sqlda=# SELECT * INTO bat_emails_threewks FROM bat_emails WHERE sales_transaction_date < '2016-11-01';

-- Teraz zlicz otwarte e-maile z tego okresu.

sqlda=# SELECT COUNT(opened) FROM bat_emails_threewks;

-- Teraz zlicz otwarte e-maile z pierwszych trzech tygodni.

sqlda=# SELECT COUNT(opened) FROM bat_emails_threewks WHERE opened='t';

-- Zlicz klientów, którzy otrzymali e-maile w pierwszych trzech tygodniach sprzedaży, a następnie dokonali zakupu.

sqlda=# SELECT COUNT(DISTINCT(customer_id)) FROM bat_emails_threewks;

-- Oblicz procent klientów, którzy w pierwszych trzech tygodniach otworzyli e-mail dotyczący skutera Bat, a następnie dokonali zakupu.

sqlda=# SELECT 15.0/82.0 AS sale_rate;

-- Oblicz, ilu unikatowych klientów odnotowano w pierwszych trzech tygodniach sprzedaży.

sqlda=# SELECT COUNT(DISTINCT(customer_id)) FROM bat_sales WHERE sales_transaction_date < '2016-11-01';
