-- Wczytaj bazę danych sqlda.

$ psql sqlda

-- Przeanalizuj inne produkty z bazy.

sqlda=# SELECT * FROM products;

-- Wyświetl wszystkie skutery z tabeli products (w porównaniach istotne są tylko skutery).

sqlda=# SELECT * FROM products WHERE product_type='scooter'; 

-- Pobierz pięć pierwszych wierszy z tabeli sales.

sqlda=# SELECT * FROM sales LIMIT 5;

-- Z tabel products i sales pobierz kolumny model i sales_transaction_date dotyczące modelu Bat Limited Edition. 
-- Zapisz wyniki w tabeli bat_ltd_sales. Uporządkuj je według kolumny sales_transaction_date od najstarszych do najnowszych transakcji. 

sqlda=# SELECT products.model, sales.sales_transaction_date INTO bat_ltd_sales FROM sales INNER JOIN products ON sales.product_id=products.product_id WHERE sales.product_id=8 ORDER BY sales.sales_transaction_date;

-- Pobierz pierwszych pięć wierszy z tabeli bat_ltd_sales.

sqlda=# SELECT * FROM bat_ltd_sales LIMIT 5;

-- Ustal łączną liczbę sprzedanych skuterów Bat Limited Edition. Możesz ją sprawdzić za pomocą funkcji COUNT.

sqlda=# SELECT COUNT(model) FROM bat_ltd_sales;

-- Sprawdź informacje o ostatniej transakcji modelu Bat Limited Edition. Możesz w tym celu użyć funkcji MAX.

sqlda=# SELECT MAX(sales_transaction_date) FROM bat_ltd_sales;

-- Dostosuj tabelę, aby uwzględnić tylko datę z kolumny (pomiń informacje o godzinie). Podobnie jak 
-- w trakcie analiz bazowego modelu Bat istotna jest tylko data sprzedaży, a nie jej godzina.

sqlda=# ALTER TABLE bat_ltd_sales ALTER COLUMN sales_transaction_date TYPE date;

-- Ponownie pobierz pięć pierwszych rekordów z tabeli bat_ltd_sales.

sqlda=# SELECT * FROM bat_ltd_sales LIMIT 5;

-- Podobnie jak w czasie analiz bazowego modelu Bat przygotuj liczbą transakcji z określonych dni. Wstaw wyniki do tabeli bat_ltd_sales_count.

sqlda=# SELECT sales_transaction_date, count(sales_transaction_date) INTO bat_ltd_sales_count FROM bat_ltd_sales GROUP BY sales_transaction_date ORDER BY sales_transaction_date;

-- Wyświetl liczbę transakcji wszystkich skuterów Bat Limited Edition.

sqlda=# SELECT * FROM bat_ltd_sales_count;

-- Oblicz sumę skumulowaną dziennej sprzedaży i zapisz wynikową tabelę jako bat_ltd_sales_growth.

sqlda=# SELECT *, sum(count) OVER (ORDER BY sales_transaction_date) INTO bat_ltd_sales_growth FROM bat_ltd_sales_count;

-- Pobierz dane sprzedażowe z pierwszych 22 dni z tabeli bat_ltd_sales_growth.

sqlda=# SELECT * FROM bat_ltd_sales_growth LIMIT 22;

-- Porównaj te dane sprzedażowe z wartościami dla bazowego modelu Bat zwracanymi przez poniższy kod.

sqlda=# SELECT * FROM bat_sales_growth LIMIT 22;

-- Za pomocą funkcji lag wyznacz wartości kolumny sum sprzed siedmiu dni i wstaw wyniki do tabeli bat_ltd_sales_delay.

sqlda=# SELECT *, lag(sum , 7) OVER (ORDER BY sales_transaction_date) INTO bat_ltd_sales_delay FROM bat_ltd_sales_growth;

-- Oblicz wzrost liczby sprzedanych sztuk w tabeli bat_ltd_sales_delay w podobny sposób jak w 
-- zadaniu 7.01 — ilościowa ocena spadku sprzedaży. Kolumnę z wynikami tych obliczeń nazwij volume, a 
-- wynikową tabelę zapisz jako bat_ltd_sales_vol.

sqlda=# SELECT *, (sum-lag)/lag AS volume INTO bat_ltd_sales_vol FROM bat_ltd_sales_delay;

-- Przyjrzyj się pierwszym 22 rekordom danych sprzedażowych z tabeli bat_ltd_sales_vol.

sqlda=# SELECT * FROM bat_ltd_sales_vol LIMIT 22;

