USE StoreEvent
GO

-- Tworzenie kolejki na szczegółowe informacje o zdarzeniach
IF OBJECT_ID('dbo.NotifyQueue') IS NULL
CREATE QUEUE dbo.NotifyQueue
WITH STATUS = ON
    ,RETENTION = OFF
GO

-- Tworzenie usługi, dzięki czemu po wystąpieniu zdarzenia
-- serwer może przesłać komunikat do usługi.
-- Używany jest tu wcześniej zdefiniowany kontrakt
IF NOT EXISTS(SELECT * FROM sys.services WHERE name = 'EventNotificationService')
CREATE SERVICE EventNotificationService
ON QUEUE NotifyQueue
([http://schemas.microsoft.com/SQL/Notifications/PostEventNotification])

IF NOT EXISTS(SELECT * FROM sys.routes WHERE name = 'NotifyRoute')

CREATE ROUTE NotifyRoute
WITH SERVICE_NAME = 'EventNotificationService',
ADDRESS = 'LOCAL';
GO

