-- Tworzenie nowej sesji zdarzeń
create event session long_running_queries on server
-- Dodawanie zdarzenia sql_statement_complete
add event sqlserver.sql_statement_completed	
(
	-- Dla tego zdarzenia pobierane są kolumny sql_text i tsql_stack
	action(sqlserver.sql_text, sqlserver.tsql_stack)	
	-- Predykat dotyczący czasu trwania powyżej 30 milisekund
	where sqlserver.sql_statement_completed.duration > 30	
)

-- Wysyłanie danych wyjściowych do wskazanego pliku XML
add target package0.asynchronous_file_target			
(
	set filename=N'c:\chapter_12_samples\XEvents\long_running_queries.xel'
	, metadatafile = N'c:\chapter_12_samples\XEvents\long_running_queries.xem'
)
-- Ustawianie opcji sesji.
-- Opcja max_dispatch_latency określa, jak długo dane są przechowywane w pamięci przed 
-- przesłaniem do jednostki docelowej
with (max_dispatch_latency = 1 seconds)				


-- Podawanie modyfikowanej sesji zdarzeń
alter event session long_running_queries on server
-- Teraz można wprowadzić zmiany:
-- zmień opcję state na start
state = start

-- Podawanie modyfikowanej sesji zdarzeń
alter event session long_running_queries on server
-- Wprowadzanie zmian:
-- dodawanie zdarzenia (tym razem jest to zdarzenie long_io_detected)
add event sqlserver.long_io_detected
(
-- Na potrzeby tego zdarzenia pobierane są kolumny sql_text i tsql_stack
	action(sqlserver.sql_text, sqlserver.tsql_stack)
	-- Bez predykatu - rejestrowane są wszystkie wystąpienia w celu wykrycia korelacji
)
