--------------------------------------------------------------------------------------------------------

-- Ręczne przełączanie awaryjne.
-- Ręczne przełączanie awaryjne wymaga ustawienia SAFETY FULL, ale obecność świadka jest opcjonalna.
-- Kolumna mirroring_state (z widoku sys.database_mirroring) musi mieć wartość Synchronized,
-- aby przełączanie awaryjne zakończyło się powodzeniem
ALTER DATABASE AdventureWorks SET PARTNER FAILOVER
--------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------

-- Wymuszone przełączanie awaryjne
-- Wymuszone przełączanie awaryjne wymaga ustawienia SAFETY OFF (choć jest możliwe także przy ustawieniu
-- SAFETY FULL, jeśli serwer lustrzany nie może utworzyć kworum).
-- Kolumna mirroring_state (z widoku sys.database_mirroring) nie ma tu znaczenia, ponieważ przy wymuszonym
-- przełączaniu awaryjnym może nastąpić utrata danych
ALTER DATABASE AdventureWorks SET PARTNER FORCE_SERVICE_ALLOW_DATA_LOSS
--------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------

-- Aby zatrzymać tworzenie kopii lustrzanych, wywołaj poniższe polecenie na serwerze głównym lub lustrzanym
ALTER DATABASE AdventureWorks SET PARTNER OFF
--------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------

-- W celu usunięcia świadka uruchom poniższe polecenie na serwerze głównym lub lustrzanym
ALTER DATABASE AdventureWorks SET WITNESS OFF
--------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------

-- Aby włączyć w sesji tworzenia kopii lustrzanych tryb wysokiej
-- wydajności, wywołaj na serwerze głównym tę instrukcję 
ALTER DATABASE AdventureWorks SET SAFETY OFF
--------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------

-- Aby włączyć w sesji tworzenia kopii lustrzanych tryb wysokiego 
-- bezpieczeństwa, wywołaj na serwerze głównym tę instrukcję 
ALTER DATABASE AdventureWorks SET SAFETY FULL
--------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------

-- Wstrzymywanie sesji tworzenia kopii lustrzanych. Możesz wywołać to polecenie na dowolnym serwerze.
-- Powoduje ono wstrzymanie przesyłania dziennika na serwer lustrzany
ALTER DATABASE AdventureWorks SET PARTNER SUSPEND
--------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------

-- Wznawianie sesji tworzenia kopii lustrzanych bazy
ALTER DATABASE AdventureWorks SET PARTNER RESUME
--------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------
