// Wersja końcowa 
package com.apress.springrecipes.court.web;

import com.apress.springrecipes.court.domain.PeriodicReservation;
import com.apress.springrecipes.court.domain.PeriodicReservationValidator;
import com.apress.springrecipes.court.domain.Player;
import com.apress.springrecipes.court.service.ReservationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.util.WebUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;


@Controller
// Wiązanie kontrolera z adresem URL /periodicReservationForm
// Początkowy widok jest określany na podstawie nazwy zwracanej przez domyślną metodę obsługi żądań GET.
@RequestMapping("/periodicReservationForm")
// Dodawanie obiektu Reservation do sesji, ponieważ jest używany na różnych stronach i formularzach
@SessionAttributes("reservation")

public class PeriodicReservationController {
    private ReservationService reservationService;
    private PeriodicReservationValidator validator;

    // Podłączanie dostępnych w kontekście aplikacji usługi i walidatora w konstruktorze
    @Autowired
    public PeriodicReservationController(ReservationService reservationService, PeriodicReservationValidator periodicReservationValidator) {
        this.reservationService = reservationService;
        this.validator = periodicReservationValidator;
    }

	// Kontroler zawsze najpierw szuka domyślnej metody obsługi żądań GET (niezależnie od jej nazwy).
	// Tu ta metoda to setupForm, co ułatwia jej identyfikację
    @RequestMapping(method = RequestMethod.GET)
	// Metoda przyjmuje parametr Model, aby ustawić obiekt typu Reservation
    public String setupForm(Model model) {
        // Tworzenie obiektu Reservation
        PeriodicReservation reservation = new PeriodicReservation();
        // Ustawianie gracza w tym obiekcie
        reservation.setPlayer(new Player());
        // Dodawanie obiektu Reservation do modelu, aby można go było wyświetlić w widoku
        model.addAttribute("reservation", reservation);

        // Zwracanie łańcucha znaków z widokiem.
        // Na podstawie konfiguracji widok reservationCourtForm jest wiązany
        // z plikiem JSP /WEB-INF/jsp/reservationCourtForm.jsp 
        return "reservationCourtForm";
    }

    // Kontroler zawsze najpierw szuka domyślnej metody obsługi żądań POST (niezależnie od jej nazwy),
	// gdy dane są przesyłane pod dany adres URL (@RequestMapping(/periodicReservationForm)).
	// Tu ta metoda to submitForm, co ułatwia jej identyfikację	
    @RequestMapping(method = RequestMethod.POST)
    public String submitForm(HttpServletRequest request, HttpServletResponse response, @ModelAttribute("reservation")
    PeriodicReservation reservation, BindingResult result, SessionStatus status, @RequestParam("_page")
    int currentPage, Model model) {
        // Definiowanie odwzorowania z numerami stron i widokami.
		// Używane, gdy użytkownik kliknie Dalej lub Anuluj.
        // Widoki są wiązane z odpowiednimi stronami JSP z katalogu /WEB-INF/jsp/
        Map pageForms = new HashMap();
        pageForms.put(0, "reservationCourtForm"); // Wiązany z plikiem /WEB-INF/jsp/reservationCourtForm.jsp
        pageForms.put(1, "reservationTimeForm"); // Wiązany z plikiem /WEB-INF/jsp/reservationTimeForm.jsp
        pageForms.put(2, "reservationPlayerForm"); // Wiązany z plikiem /WEB-INF/jsp/reservationPlayerForm.jsp
                                                   // Sprawdzanie, czy użytkownik kliknął przycisk Anuluj

        if (request.getParameter("_cancel") != null) {
            // Zwracanie widoku bieżącej strony, ponieważ użytkownik kliknął Anuluj
            return (String) pageForms.get(currentPage);
			
			// Sprawdzanie, czy użytkownik kliknął przycisk Zakończ
        } else if (request.getParameter("_finish") != null) {
            // Zakończono walidację rezerwacji
            new PeriodicReservationValidator().validate(reservation, result);

			// Sprawdzanie wyniku pod kątem błędów po walidacji
            if (!result.hasErrors()) {
                // Brak błędów, można dodać rezerwację
                reservationService.makePeriodic(reservation);
				// Należy wywołać setComplete(), co powoduje zakończenie przetwarzania sesji. 
				// Pozwala to usunąć atrybuty sesji.
                status.setComplete();

                // Przekierowanie pod adres URL reservationSuccess (zdefiniowany w kontrolerze ReservationSuccessController)
                return "redirect:reservationSuccess";
            } else {
				// Wykryto błędy. Zawsze powinien to być formularz reservationPlayerForm, ponieważ
				// był używany jako ostatni. Jednak mimo to można zastosować typ HashMap
				// Należy ponownie wyświetlić bieżący widok, aby użytkownik mógł wprowadzić poprawki.
                return (String) pageForms.get(currentPage);
            }

			// Użytkownik kliknął Dalej lub Cofnij (_target - różny od _cancel lub _finish)
        } else {
            // Pobieranie strony docelowej
            int targetPage = WebUtils.getTargetPage(request, "_target", currentPage);

			// Jeśli targetPage ma wartość mniejszą niż bieżąca strona, użytkownik kliknął Cofnij
            if (targetPage < currentPage) {
                // Powrót do widoku docelowej strony
                return (String) pageForms.get(targetPage);
            }

            // Użytkownik kliknął Dalej.
            // Należy sprawdzić dane na podstawie strony
            switch (currentPage) {
            case 0:
                new PeriodicReservationValidator().validateCourt(reservation, result);

                break;

            case 1:
                new PeriodicReservationValidator().validateTime(reservation, result);

                break;

            case 2:
                new PeriodicReservationValidator().validatePlayer(reservation, result);

                break;
            }

            if (!result.hasErrors()) {
                // Brak błędów. Należy zwrócić docelową stronę
                return (String) pageForms.get(targetPage);
            } else {
                // Wykryto błędy. Należy zwrócić bieżącą stronę.
                return (String) pageForms.get(currentPage);
            }
        }
    }

    // Tworzenie atrybutu do modelu.
    // Będzie on reprezentowany jako lista rozwijana z wartościami "Codziennie, Co tydzień" w formularzu reservationTimeForm
    @ModelAttribute("periods")
    public Map<Integer, String> periods() {
        Map<Integer, String> periods = new HashMap<Integer, String>();
        periods.put(1, "Codziennie");
        periods.put(7, "Co tydzień");

        return periods;
    }
}
