package com.apress.springrecipes.embedded;

import org.springframework.context.support.ClassPathXmlApplicationContext;

import javax.sql.DataSource;

/**
 * Ilustruje stosowanie zagnieżdżonych baz danych w Springu.
 *
 */
public class EmbeddedMain {
    public static void main (String [] args) throws Throwable {

        ClassPathXmlApplicationContext classPathXmlApplicationContext =
                new ClassPathXmlApplicationContext("jdbc-ns.xml");
        classPathXmlApplicationContext.start();

        DataSource dataSource = classPathXmlApplicationContext.getBean(DataSource.class);
        
        System.out.println( "Źródło danych: " + dataSource );
    }
}
