package com.apress.springrecipes.jbpm.jbpm4.customers;


/**
 * Usługa obsługująca zarządzanie klientami. Oferuje operacje CRUD, a także zarządzanie cyklem życia obiektów
 * typu Customer. Obsługuje BPM.
 */
public interface CustomerService {
    /**
     * Wysyła do klienta e-mail powitalny 
     *
     * @param customerId
     */
    void sendWelcomeEmail(Long customerId);

    /**
     * Usuwa uprawnienia klienta
     *
     * @param customerId
     */
    void deauthorizeCustomer(Long customerId);

    /**
     * Przyznaje klientowi określone uprawnienia. W tym prostym przykładzie użytkownik otrzymuje 
     * dostęp do systemu (informuje o tym flaga).
     *
     * @param customerId
     */
    void authorizeCustomer(Long customerId);

    /**
     * Zwraca klienta na podstawie klucza głównego użytego do jego zapisania
     */
    Customer getCustomerById(Long customerId);

    /**
     * Tworzy klienta na podstawie podanych parametrów email, password, firstName, and lastName
     */
    Customer createCustomer(String email, String password, String firstName, String lastName);

    void sendCustomerVerificationEmail(Long customerId);
}
