// Wersja końcowa 
package com.apress.springrecipes.court.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.ui.Model;
import org.springframework.web.servlet.ModelAndView;

public class ExtensionInterceptor extends HandlerInterceptorAdapter {

    public void postHandle(HttpServletRequest request,
            HttpServletResponse response, Object handler,
			   //Model model) throws Exception {
			   ModelAndView modelAndView) throws Exception {
	// Data raportu występuj w żądaniu
	String reportName = null;
	String reportDate = request.getQueryString().replace("date=","").replace("-","_");
	if(request.getServletPath().endsWith(".pdf")) { 
	    reportName= "ReservationSummary_" + reportDate + ".pdf";
	}
	if(request.getServletPath().endsWith(".xls")) { 
	    reportName= "ReservationSummary_" + reportDate + ".xls";
	}
	// TYLKO dla rozszerzeń PDF i XLS należy zmodyfikować adres URL odpowiedzi.
	// Jeśli nazwa reportName została zmodyfikowana, używany jest format PDF lub XLS
	if (reportName != null) { 
	    // Ustawianie nagłówka HTTP "Content-Disposition", aby użytkownik zobaczył elegancki adres w oknie 'Zapisz jako'
	    response.setHeader("Content-Disposition","attachment; filename="+reportName);
	}
    }
}
