﻿<%-- Source project: sip05, branch: 03 (Maven Project) --%>
<%@ include file="/WEB-INF/jsp/taglibs.jspf" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html
  xmlns:c="http://java.sun.com/jsp/jstl/core"
  xmlns:jsp="http://java.sun.com/JSP/Page"
  xmlns:spring="http://www.springframework.org/tags"
  xmlns:form="http://www.springframework.org/tags/form">
  
  <c:set var="foundPlayer" 
    scope="request" value="${!empty player}"/>
  
  <head><title>Wyniki wyszukiwania</title></head>

  <body>
    <h2>Wyniki wyszukiwania</h2>
    
    <c:choose>
      <c:when test="${foundPlayer}">
	      <table border="1">
	        <tr>
	          <th>Zawodnik</th>
	          <th>Lokalizacja</th>
	          <th>Telefon</th>
	          <th>Uwagi</th>
	          <th>Kliknij łącze, aby kontynuować</th>
	        </tr>
	        <tr>
	          <td>${player.firstName}&nbsp;${player.lastName}</td>
	          <td>${player.guardian.address1}</td>
	          <td>${player.guardian.homePhone}</td>
	          <td>
	            Konto już istnieje<br/>
	            Username=${player.guardian.username}
	          </td>
	          <td>
	            <a href="${flowExecutionUrl}&_eventId=existingAccountFound">
	              Zaloguj się na to konto</a>
	          </td>
	        </tr>
	      </table>
      </c:when>
      <c:otherwise>
        Nie znaleziono zawodnika<br/>
      </c:otherwise>
    </c:choose>

    </br>
    <a href="${flowExecutionUrl}&_eventId=back">Wstecz</a>
      &nbsp;&nbsp;&nbsp;&nbsp;
    <a href="${flowExecutionUrl}&_eventId=newSearch">Nowe wyszukiwanie</a>
      &nbsp;&nbsp;&nbsp;&nbsp;
            
    <a href="${flowExecutionUrl}&_eventId=noneMatch">
    <c:choose>
      <c:when test="${foundPlayer}">
    	  Nie znaleziono dopasowania - Utwórz nowe konto
    	</c:when>
      <c:otherwise>
        Pomiń - Utwórz nowe konto
      </c:otherwise>
    </c:choose>
    </a>
  </body>
</html>
