/* 
 * Copyright 2011-2013 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.springinpractice.ch11.repository;

import java.util.Set;

import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.GraphRepository;

import com.springinpractice.ch11.model.Application;
import com.springinpractice.ch11.model.Person;

/**
 * @author Willie Wheeler (willie.wheeler@gmail.com)
 */
public interface PersonRepository extends GraphRepository<Person> {
	
	/**
	 * Returns the person having the given username.
	 * 
	 * @param username username
	 * @return person with the given username
	 */
	Person findByUsername(String username);
	
	// Return a Set here (instead of an Iterable) to eliminate duplicates
	@Query("start project=node({0}) match application<--person return person")
	Set<Person> findByApplication(Application application);
	
	/**
	 * @param person
	 * @return
	 */
	// Return a Set here (instead of an Iterable) to eliminate duplicates
	@Query("start person=node({0}) match person-[:MEMBER_OF]->project<-[:MEMBER_OF]-collaborator return collaborator")
	Set<Person> findCollaborators(Person person);
}
