import com.springbook.Bike;
import com.springbook.BikeValidator;
import com.springbook.BikesController;
import com.springbook.RentABike;
import com.springbook.interceptors.LoggingBefore;
import junit.framework.TestCase;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.servlet.ModelAndView;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Iterator;
import java.util.List;


public class ControllerTest extends TestCase {
   private ApplicationContext ctx;
   private RentABike store = null;

   public void setUp() throws Exception {
      ctx = new FileSystemXmlApplicationContext("war/WEB-INF/rentaBikeApp-servlet.xml");
      store = (RentABike)ctx.getBean("rentaBike");
   }
   public void testBikesController() throws Exception {
      BikesController controller = (BikesController) ctx.getBean("bikesController");
      ModelAndView mav = controller.handleRequest(null, null);
      RentABike store = (RentABike)mav.getModel().get("rentaBike");
      assertNotNull(store);
      assertEquals(3, store.getBikes().size());
   }

   public void testBikeValidator() throws Exception {
      BikeValidator v = (BikeValidator) ctx.getBean("bikeValidator");
      Bike bike = new Bike("test", "test", 1, "test", 2.00, "test");
      Errors errs = new BindException(bike, "bike");
      v.validate(bike, errs);
      assertFalse(errs.hasErrors());
      bike = new Bike();
      errs = new BindException(bike, "bike");
      v.validate(bike, errs);
      assertTrue(errs.hasErrors());
   }

   
    public void testGetName() {
      assertEquals("Bruce's Bikes", store.getStoreName());
   }

   public void testGetBike() {
      Bike bike = store.getBike("11111");
      assertNotNull(bike);
      assertEquals("Shimano", bike.getManufacturer());
   }

   public void testGetBikes() {
      List bikes = store.getBikes();
      assertNotNull(bikes);
      assertEquals(3, bikes.size());
   }

   public void testDeleteBike() {
      List bikes = store.getBikes();
      assertEquals(3, bikes.size());
      Bike bike = (Bike)bikes.get(0);
      store.deleteBike(bike);
      bikes = store.getBikes();
      assertEquals(2, bikes.size());
   }

   public void testSaveBike() {
      Bike bike = (Bike)store.getBikes().get(0);
      assertFalse ("Royal".equals(bike.getManufacturer()));
      bike.setManufacturer("Royal");
      store.saveBike(bike);
      Iterator iter = store.getBikes().iterator();
      boolean found = false;
      while(iter.hasNext()) {
         Bike b = (Bike)iter.next();
         if(b.getManufacturer().equals("Royal")) found = true;
      }
      assertTrue(found);
   }


   public void testJDBC() throws Exception {
      try {
         System.setProperty("jdbc.drivers", "com.mysql.jdbc.Driver");
         Connection conn = DriverManager.getConnection("jdbc:mysql://localhost/bikestore");
      } catch (Exception ex) {
         assertTrue(ex.getMessage().indexOf("authorization") > 0);
      }
      assertTrue(true);
   }

   public void testLocal() throws Exception {
      LoggingBefore lb = new LoggingBefore();
      SessionFactory factory = (SessionFactory)ctx.getBean("sessionFactory");
      int initialCount = getCurEventsCount();

      lb.setSessionFactory(factory);
      try {
         lb.before((Method)this.getClass().getMethods()[0], null, null);
      } catch (Throwable t) {
         fail(t.getMessage());
      }

      int afterCount = getCurEventsCount();
      assertEquals("Ilo powinna zosta powikszona o 1", initialCount, afterCount - 1);
   }

   private int getCurEventsCount() {
      SessionFactory factory = (SessionFactory)ctx.getBean("sessionFactory");
      Session s = null;
      int result = -1;
      try {
         s = factory.openSession();
         result = s.find("from LogEvent").size();
      } catch (Exception ex) {
         return -1;
      }
      return result;
   }

   public void testRemoveNonExistentBike() throws Exception {
      Bike b = new Bike(99, "ja", "mj", 1, "1", 12.00, "dobry");
      store.deleteBike(b);
   }

   public void testAddBadBike() throws Exception {
      int origCount = store.getBikes().size();
      // konflikt numerw seryjnych stanowicych klucz o unikalnych wartociach
      Bike bike = new Bike(-1, "MjCzowiek", "MjRower",
            12, "11111", 12.00, "Nowy");        
      try {
         store.saveBike(bike);
      } catch (Exception ex) {
         assertEquals(origCount, store.getBikes().size());
         return;
      }
      fail("Naleao zgosi bd niewaciwego zapisu.");
   }


}
