package com.springbook;

import com.springbook.exceptions.AddReservationException;
import com.springbook.exceptions.ReservationTransferException;
import net.sf.hibernate.Session;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.activemq.message.ActiveMQTextMessage;

import javax.jms.JMSException;
import javax.jms.Message;
import java.util.Date;
import java.util.List;

public class HibRentABike extends HibernateDaoSupport implements RentABike {
    private String name;
    private PlatformTransactionManager transactionManager;
    private Accounts accountsFacade;
    private JmsTemplate jmsTemplate;
     private List testBikes;

   public List getTestBikes() {
      return testBikes;
   }

   public void setTestBikes(List testBikes) {
      this.testBikes = testBikes;
   }

   int curBike = 0;
   public Bike getNewBikeFromQueue() {
      try {
         ActiveMQTextMessage m = (ActiveMQTextMessage)testBikes.get(curBike);
         curBike++;
         Bike b = new Bike();
         String s = m.getText();
         String[] vals = s.split(":");
         b.setManufacturer(vals[0]);
         b.setModel(vals[1]);
         return b;
      } catch (Exception ex) {
         return null;

      }
   }

   public JmsTemplate getJmsTemplate() {
      return jmsTemplate;
   }

   public void setJmsTemplate(JmsTemplate jmsTemplate) {
      this.jmsTemplate = jmsTemplate;
   }

   public Accounts getAccountsFacade() {
      return accountsFacade;
   }

   public void setAccountsFacade(Accounts accountsFacade) {
      this.accountsFacade = accountsFacade;
   }

   public PlatformTransactionManager getTransactionManager() {
      return transactionManager;
   }

   public void setTransactionManager(PlatformTransactionManager transactionManager) {
      this.transactionManager = transactionManager;
   }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List getBikes() {

        return getHibernateTemplate().find("from Bike");
    }

    // metoda pokazuje jedynie jak naleaoby wykonywa te seme operacje
    // bez wykorzystania szablonu
    public List getBikesOldWay() throws Exception {
        List bikes = null;
        Session s = null;
        try {
            s = getHibernateTemplate().getSessionFactory().openSession();
            bikes = s.find("from Bike");
        }catch (Exception ex) {
            // obsuga wyjtkw
        }finally {
            s.close();
        }
        return bikes;
    }

    public Bike getBike(String serialNo) {
        Bike b = null;
        List bikes = getHibernateTemplate().find("from Bike where serialNo = '" + serialNo + "'");
        if(bikes.size() > 0) {
            b = (Bike)bikes.get(0);
        }
        return b;
    }

    public Bike getBike(int bikeId) {
        return (Bike)getHibernateTemplate().load(Bike.class, new Integer(bikeId));
    }

    public void saveBike(Bike bike) {
        System.out.println("To save or update: " + bike);
        getHibernateTemplate().saveOrUpdate(bike);
    }

    public void deleteBike(Bike bike) {
        getHibernateTemplate().delete(bike);
    }

    public void setStoreName(String name) {
        this.name = name;
    }

    public String getStoreName() {
        return this.name;
    }

    public List getCustomers() {
       return getHibernateTemplate().find("from Customer");
    }

    public Customer getCustomer(int custId) {
       return (Customer)getHibernateTemplate().load(Customer.class, new Integer(custId));
    }

    public void saveCustomer(Customer customer) {
        getHibernateTemplate().saveOrUpdate(customer);
    }

    public void deleteCustomer(Customer customer) {
        getHibernateTemplate().delete(customer);
    }

    public List getReservations() {
        return getHibernateTemplate().find("from Reservation");
    }

    public List getReservations(Customer customer) {
        return getHibernateTemplate().find("from Reservation where custId = " + customer.getCustId());
    }

    public List getReservations(Bike bike) {
        return getHibernateTemplate().find("from Reservation where bikeId = " + bike.getBikeId());
    }

    public List getReservations(Date date) {
        return getHibernateTemplate().find("from Reservation where resdate = ?", date);
    }

    public Reservation getReservation(int resId) {
        return (Reservation)getHibernateTemplate().load(Reservation.class, new Integer(resId));
    }

   public void transferReservation(final Reservation oldRes, final Reservation newRes) throws ReservationTransferException {
      TransactionTemplate template = new TransactionTemplate(this.transactionManager);
      template.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRED);
      try {
         template.execute(new TransactionCallbackWithoutResult() {
            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
               getHibernateTemplate().save(newRes);
               getHibernateTemplate().delete(oldRes);
            }
         });
      } catch (Exception ex) {
         throw new ReservationTransferException();
      }

   }


   public void addReservation(final Reservation reservation, double amount)
         throws AddReservationException {
      try {
         MonetaryTransaction tx = new MonetaryTransaction(reservation.getReservationId(), amount);
         getHibernateTemplate().saveOrUpdate(reservation);
         accountsFacade.addTx(tx);
         jmsTemplate.send("billingQueue", new MessageCreator() {
            public Message createMessage(javax.jms.Session session)
                  throws JMSException {
               return session.createTextMessage("Nowa rezerwacja: " +
                     reservation.toString());
            }
         });
      } catch (Exception ex) {
         throw new AddReservationException();
      }
   }


}
