package com.springbook.interceptors;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;


public class ProfilingInterceptor implements MethodInterceptor {
   public Object invoke(MethodInvocation methodInvocation) throws Throwable {
      long start = System.currentTimeMillis();
      Object results = methodInvocation.proceed();
      long end = System.currentTimeMillis();
      System.out.println("Wywoanie metody: " + methodInvocation.getMethod().getName() +
            " zajo " + (end - start) + " ms.");
      return results;
   }
}
