package com.springbook;

import com.springbook.exceptions.ReservationTransferException;

import java.util.List;
import java.util.Date;
import java.io.Serializable;

public interface RentABike extends Serializable {
   List getBikes();
   Bike getBike(String serialNo);
   Bike getBike(int bikeId);
   void setStoreName(String name);
   void saveBike(Bike bike);
   void deleteBike(Bike bike);
   String getStoreName();
   void transferReservation(Reservation oldRes, Reservation newRes) throws ReservationTransferException;

   List getCustomers();

   Customer getCustomer(int custId);

   void saveCustomer(Customer customer);

   void deleteCustomer(Customer customer);

   List getReservations();

   List getReservations(Customer customer);

   List getReservations(Bike bike);

   List getReservations(Date date);

   Reservation getReservation(int resId);
}
