
import junit.framework.TestCase;
import com.springbook.RentABike;
import com.springbook.Reservation;
import com.springbook.exceptions.ReservationTransferException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

import java.util.Date;

public class TransactionTemplateTest extends TestCase {
    private ApplicationContext ctx;
    RentABike store = null;

     public void setUp() throws Exception {
         ctx = new FileSystemXmlApplicationContext("/war/WEB-INF/rentaBikeApp-servlet.xml");
         store = (RentABike)ctx.getBean("rentaBike");
     }

     public void testTx() throws Exception {
         Reservation oldres = new Reservation(1234, store.getBike(1), store.getCustomer(1), new Date());
         Reservation newres = new Reservation(-1, store.getBike(1), store.getCustomer(2), new Date());
         int rescount = store.getReservations().size();
         try {
             store.transferReservation(oldres, newres);
         } catch (ReservationTransferException rte) {
             System.out.println("Przechwycono wyjtek RTE.");
         } catch (Exception ex) {
             System.out.println("Przechwycono zwyczajny wyjtek.");
         }

         assertEquals(rescount, store.getReservations().size());
     }

     public void testTxSucceed() throws Exception {
        Reservation oldres = store.getReservation(1);
        Reservation newres = new Reservation(-1, store.getBike(1), store.getCustomer(2), new Date());
        int rescount = store.getReservations().size();
        try {
           store.transferReservation(oldres, newres);
        } catch (ReservationTransferException rte) {
           fail("Przechwycono wyjtek RTE, cho nie powinien zosta zgoszony.");
        } catch (Exception ex) {
           fail("Przechwycono nieoczekiwany wyjtek: " + ex.getMessage());
        }

        assertEquals(rescount, store.getReservations().size());

     }
}
