package com.springbook;

import org.springframework.orm.ibatis.support.SqlMapDaoSupport;

import java.util.Date;
import java.util.List;


public class IBatisRentABike extends SqlMapDaoSupport
        implements RentABike {


    private String storeName = "";


    public List getBikes() {
        return getSqlMapTemplate().executeQueryForList("getBikes", null);
    }

    public Bike getBike(String serialNo) {
        return (Bike) getSqlMapTemplate().executeQueryForObject("getBikeBySerialNo", serialNo);
    }

    public Bike getBike(int bikeId) {
        return (Bike) getSqlMapTemplate().executeQueryForObject("getBikeByID", new Integer(bikeId));
    }

    public void saveBike(Bike bike) {
        getSqlMapTemplate().executeUpdate("saveBike", bike);
    }

    public void deleteBike(Bike bike) {
        getSqlMapTemplate().executeUpdate("deleteBike", bike);
    }

    public void setStoreName(String name) {
        this.storeName = name;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public List getCustomers() {
        return getSqlMapTemplate().executeQueryForList("getCustomers", null);
    }

    public Customer getCustomer(int custId) {
        return (Customer) getSqlMapTemplate().executeQueryForObject("getCustomer", new Integer(custId));
    }

    public void saveCustomer(Customer customer) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    public void deleteCustomer(Customer customer) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    public List getReservations() {
        return getSqlMapTemplate().executeQueryForList("getReservations", null);
    }

    public List getReservations(Customer customer) {
        return getSqlMapTemplate().executeQueryForList("getReservationsForCustomer", customer);
    }

    public List getReservations(Bike bike) {
        return getSqlMapTemplate().executeQueryForList("getReservationsForBike", bike);
    }

    public List getReservations(Date date) {
        return getSqlMapTemplate().executeQueryForList("getReservationsForDate", date);
    }

    public Reservation getReservation(int resId) {
        return (Reservation) getSqlMapTemplate().executeQueryForObject("getReservation", new Integer(resId));
    }

    public void transferReservation(Reservation oldRes, Reservation newRes) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

}
