package com.springbook.interceptors;

import org.springframework.aop.ThrowsAdvice;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;

import java.lang.reflect.Method;


public class ExceptionInterceptor implements ThrowsAdvice {
   private MailSender mailSender;
   private SimpleMailMessage mailMessage;

   public SimpleMailMessage getMailMessage() {
      return mailMessage;
   }

   public void setMailMessage(SimpleMailMessage mailMessage) {
      this.mailMessage = mailMessage;
   }

   public MailSender getMailSender() {
      return mailSender;
   }

   public void setMailSender(MailSender mailSender) {
      this.mailSender = mailSender;
   }

     public void afterThrowing(Method m, Object[] args,
                               Object target, Exception ex) {
        try {
         mailMessage.setText(ex.getMessage());
         mailSender.send(mailMessage);
        } catch (Exception mex) {
           // obsuga wyjtku zwizanego z wysyaniem wiadomoci
           System.out.println("BD WYSYANIA WIADOMOCI: " + mex.getMessage());
        }
     }


}
