package com.springbook;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class StandaloneListener {
   public static void main(String[] args) {
      String queueName = "billingQueue";
      Context jndiContext = null;
      QueueConnectionFactory queueConnectionFactory = null;
      QueueConnection queueConnection = null;
      QueueSession queueSession = null;
      Queue queue = null;
      QueueReceiver queueReceiver = null;
      TextMessage message = null;
      
      try {
         jndiContext = new InitialContext();
      }
      catch (NamingException e) {
         System.out.println("Nie mona utworzy kontekstu JNDI API " +
               + e.toString());
         System.exit(1);
      }
      try {
         queueConnectionFactory = (QueueConnectionFactory)
               jndiContext.lookup("QueueConnectionFactory");
         queue = (Queue) jndiContext.lookup(queueName);
      }
      catch (NamingException e) {
         System.out.println("Bd wyszukiwania JNDI API: " +
               e.toString());
         System.exit(1);
      }
      try {
         queueConnection =
               queueConnectionFactory.createQueueConnection();
         queueSession =
               queueConnection.createQueueSession(false,
                     Session.AUTO_ACKNOWLEDGE);
         queueReceiver = queueSession.createReceiver(queue);
         queueConnection.start();
         while (true) {
            Message m = queueReceiver.receive(1);
            if (m != null) {
               if (m instanceof TextMessage) {
                  message = (TextMessage) m;
                  System.out.println("Odczytuje wiadomo: " +
                        message.getText());
               }
               else {
                  break;
               }
            }
         }
      }
      catch (JMSException e) {
         System.out.println("Zgoszono wyjtek: " +
               e.toString());
      }
      finally {
         if (queueConnection != null) {
            try {
               queueConnection.close();
            }
            catch (JMSException e) {
            }
         }
      }
   }
}