package com.springbook.interceptors;

import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Session;
import org.springframework.aop.MethodBeforeAdvice;

import java.lang.reflect.Method;
import java.util.Date;

import com.springbook.LogEvent;

public class LoggingBefore implements MethodBeforeAdvice {
   private SessionFactory factory;

   public SessionFactory getSessionFactory() {
      return this.factory;
   }

   public void setSessionFactory(SessionFactory factory) {
      this.factory = factory;
   }

   public void before(Method method, Object[] objects, Object o) throws Throwable {
      Session s = null;
      LogEvent le = new LogEvent(method.getName(), new Date());
      try {
         s = factory.openSession();
         s.save(le);
      } catch (Exception ex) {
         // rejestracja wyjtku
      } finally {
         s.close();
      }
   }
}
