/*
  Demo instrumentów MIDI 
  Kontekst: Arduino

  Odtwarza wszystkie instrumenty w banku instrumentów General MIDI 
*/

#include <SoftwareSerial.h>
// ustaw port Software Serial do wysyłania MIDI:
SoftwareSerial midi(2,3);

const byte resetMIDI = 4; // linia resetu syntezatora Midi

void setup() {
  // zainicjuj komunikację szeregową z prędkością 9600 b/s:
  Serial.begin(9600);
  // zainicjuj szeregowe MIDI na pinach Software Serial:
  midi.begin(31250);

  // zresetuj syntezator MIDI:
  pinMode(resetMIDI, OUTPUT);
  digitalWrite(resetMIDI, LOW);
  delay(20);
  digitalWrite(resetMIDI, HIGH);
  delay(20);
  // wyślij polecenie MIDI do zmiany banku dźwięku na General MIDI:
  sendMidi(0xB0, 0, 0);
}

void loop() {
  // cykl przez wszystkie instrumenty w banku:
  for(int instrument = 0 ; instrument < 127 ; instrument++) {
    Serial.print(" Instrument: ");
    Serial.println(instrument + 1);
    // Program select ma tylko jeden bajt stanu:
    sendMidi(0xC0, instrument, 0);
    // zmiana kanałów w ramach instrumentu:
    for (int thisChannel = 0; thisChannel < 16; thisChannel++) {
      Serial.print("Kanał: ") ;
      Serial.println(thisChannel + 1);
      for (int thisNote = 21; thisNote < 109; thisNote++) {
        // włącz nutę
        noteOn(thisChannel, thisNote, 127);
        delay(30);

        // wyłącz nutę
        noteOff(thisChannel, thisNote, 0);
        delay(30);
      }
    }
  }
}

// wyślij komunikat MIDI note-on. 
// To jak naciśnięcie klawisza pianina,
// kanał ma zakres 0 – 15
void noteOn(byte channel, byte note, byte velocity) {
  sendMidi( (0x90 | channel), note, velocity);
}

// Wwyślij wiadomość MIDI note-off. 
// To jak jak zwalnianie klawisza pianina
void noteOff(byte channel, byte note, byte velocity) {
  sendMidi( (0x80 | channel), note, velocity);
}

void sendMidi(int cmd, int data1, int data2) {
  midi.write(cmd);
  midi.write(data1);
  midi.write(data2);
}

