/*
  Serwer WWW RGB Wi-Fi
  Kontekst: Arduino
*/

 #include <SPI.h>
#include <WiFi.h>

// użyj tych ustawień dla WPA:
char ssid[] = "mojaSieć";         // nazwa Twojej sieci 
char password[] = "tajneHasło";   // hasło, którego używasz do połączenia 
int status = WL_IDLE_STATUS;      // status radia Wi-Fi 
 
// użyj tych ustawień dla WEP: 
char keyIndex = 0;                   // sieci WEP mogą mieć wiele kluczy 
// 128-bitowy klucz WEP, używany do połączenia:
char key[] = "FACEDEEDDADA01234567890ABC";

int status = WL_IDLE_STATUS;        // status radia Wi-Fi
 
WiFiServer server(80);
int lineLength = 0;               // długość przychodzącego wiersza tekstu 


void setup() {
  // inicjuj port szeregowy:
  Serial.begin(9600);
 
  Serial.println("Próba połączenia z siecią...");
  // próba połączenia za pomocą szyfrowania WPA:
  status = WiFi.begin(ssid, password);
 
  // lub użyj tego do próby połączenia za pomocą 
  // 128-bitowego szyfrowania WEP:
  // status = WiFi.begin(ssid, keyIndex, key);
 
  Serial.print("SSID: ");
  Serial.println(ssid);
 
  // jeśli nie udało się połączyć, zatrzymaj się tutaj:
  if ( status != WL_CONNECTED) {
    Serial.println("Nie można nawiązać połączenia Wi-Fi");
    while(true);
  }
}


void loop() {
  // nasluchuj przychodzących klientów
  WiFiClient client = server.available();
  if (client) {
    Serial.println("Got a client");

    while (client.connected()) {
      if (client.available()) {
        // odczytaj bajt i wyślij go szeregowo:
        char thisChar = client.read();
        Serial.write(thisChar);
        // jeśli dostaeś znak powrotu karetki i wiersz żadania jest pusty,
        // to jest koniec żądania:
        if (thisChar == '\n' && lineLength < 1) {
          // odeślij standardowy naglówek odpowiedzi http
          makeResponse(client);
          break;
        }
        // jeśli dostaniesz znak nowego wiersza lub powrotu karetki,
        // jesteś na końcu wiersza:
        if (thisChar == '\n' || thisChar == '\r') {
          lineLength = 0;
        } 
        else {
          // dla każdego innego znaku, zwiększ dlugość wiersza:
          lineLength++;

        }
      }    
    }
    Serial.println("Breaking");
    // give the web browser time to receive the data
    delay(1);
    // close the connection:
    client.stop();
  }
}


void makeResponse(WiFiClient thisClient) {
  thisClient.print("HTTP/1.1 200 OK\n");
  thisClient.print("Content-Type: text/html\n\n");
  thisClient.print("<html><head><meta http-equiv=\"refresh\" content=\"3\">");
  thisClient.print("<title>Cześć z Arduino</title></head>");
  // ustaw znacznik koloru tła:
  thisClient.print("<body bgcolor=#");
  // odczytaj trzy czujniki analogowe:
  int red = analogRead(A0)/4;
  int green = analogRead(A1)/4;
  int blue = analogRead(A2)/4;
  // wypisz je jako jeden ciąg szesnastkowy:
  thisClient.print(red, HEX);
  thisClient.print(green, HEX);
  thisClient.print(blue, HEX);
  // zamknij znacznik:
  thisClient.print(">");
  // teraz wypisz kolor w treści strony HTML:
  thisClient.print("Kolor światła padającego na Arduino to #");
  thisClient.print(red, HEX);
  thisClient.print(green, HEX);
  thisClient.println(blue, HEX);
  // zamknij stronę:
  thisClient.println("</body></html>\n");
}

