/*
 Odczyt temperatury z czujnika TMP36 i sterowanie przekaźnikiem
 Kontekst: Arduino
 Odczytuje czujnik temperatury TMP36
 */

#include <EEPROM.h>

const int relayPin = 2;               // pin, do którego podłączony 
                                      // jest przekaźnik 
const long tempCheckInterval = 10000; // czas między sprawdzeniami (w ms)
const int thermostatAddress = 10;     // adres EEPROM dla termostatu
long now;                             // ostatni czas sprawdzania 
                                      // temperatury 
// punkt aktywacji termostatu:
int thermostat = EEPROM.read(thermostatAddress);

void setup() {
  // zainicjuj komunikację szeregową:
  Serial.begin(9600);
  // zainicjuj wyjście przekaźnika:
  pinMode(relayPin, OUTPUT);
  // ogranicz termostat do akceptowalnego przedziału:
  thermostat = constrain(thermostat, 20, 40);  
}

void loop() {
  // okresowo sprawdzaj temperaturę, aby określić,
  // czy należy włączyć termostat:
  if (millis() - now > tempCheckInterval) {
    Serial.print("Temperatura: ");
    Serial.println(readSensor());
    if (checkThermostat()) {
      Serial.println("Termostat jest włączony");
    }
    else {
      Serial.println("Termostat jest wyłączony");
    }
    now = millis();
  }
}

// odczytaj czujnik temperatury:
float readSensor() {
  // odczytaj wartość z czujnika:
  int sensorValue = analogRead(A0);
  // skonwertuj odczyt na wolty:
  float voltage = (sensorValue *  5.0) / 1024.0; 
  // skonwertuj napięcie do temperatury w st. Celsujsza
  // (100 mv na stopień - 500mV przesunięcie):
  float temperature = (voltage - 0.5) * 100;
  // zwróć temperaturę:
  return temperature; 
}

// sprawdź temperaturę i odpowiednio steruj przekaźnikiem:
boolean checkThermostat() {
  // załóżmy, że przekaźnik powinien być wyłączony:
  boolean relayState = LOW;
  // jeżeli temperatura jest większa niż punkt aktywacji 
  // termostatu, przekaźnik powinien być włączony:
  if(readSensor() > thermostat) {
    relayState = HIGH;
  }
  // włącz lub wyłącz przekaźnik:
  digitalWrite(relayPin, relayState);
  return relayState;
}

