package sample.spring.chapter05.bankapp.postprocessor;

import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

import sample.spring.chapter05.bankapp.common.InstanceValidator;

public class InstanceValidationBeanPostProcessor implements BeanPostProcessor,
		Ordered {
	private static Logger logger = Logger
			.getLogger(InstanceValidationBeanPostProcessor.class);
	private int order;

	public InstanceValidationBeanPostProcessor() {
		logger.info("Utworzono egzemplarz InstanceValidationBeanPostProcessor.");
	}

	@Override
	public Object postProcessBeforeInitialization(Object bean, String beanName)
			throws BeansException {
		logger.info("Wywołanie metody postProcessBeforeInitialization() klasy InstanceValidationBeanPostProcessor dla komponentu " + beanName + " typu " + bean.getClass());
		return bean;
	}

	@Override
	public Object postProcessAfterInitialization(Object bean, String beanName)
			throws BeansException {
		logger.info("Wywołanie metody postProcessAfterInitialization() klasy InstanceValidationBeanPostProcessor dla komponentu " + beanName + " typu " + bean.getClass());
		if (bean instanceof InstanceValidator) {
			((InstanceValidator) bean).validateInstance();
		}
		return bean;
	}

	public void setOrder(int order) {
		this.order = order;
	}

	@Override
	public int getOrder() {
		return order;
	}
}