package sample.spring.chapter11.web;

import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

import sample.spring.chapter11.domain.FixedDepositDetails;

public class FixedDepositDetailsValidator implements Validator {

	@Override
	public boolean supports(Class<?> clazz) {
		return FixedDepositDetails.class.isAssignableFrom(clazz);
	}

	@Override
	public void validate(Object target, Errors errors) {
		FixedDepositDetails fixedDepositDetails = (FixedDepositDetails) target;

		long depositAmount = fixedDepositDetails.getDepositAmount();
		String email = fixedDepositDetails.getEmail();

		if (depositAmount < 1000) {
			errors.rejectValue("depositAmount", "error.depositAmount.less",
					"Wartość musi wynosić co najmniej 1000.");
		}

		if (email == null || "".equalsIgnoreCase(email)) {
			ValidationUtils.rejectIfEmptyOrWhitespace(errors, "email",
					"error.email.blank", "Pole nie może być puste.");
		} else if (!email.contains("@")) {
			errors.rejectValue("email", "error.email.invalid",
					"Podaj prawidłowy adres e-mail.");
		}
	}
}
