package sample.spring.chapter02.bankapp;

import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import sample.spring.chapter02.bankapp.controller.FixedDepositController;

public class BankApp {
	private static Logger logger = Logger.getLogger(BankApp.class);

	public static void main(String args[]) {
		ApplicationContext context = new ClassPathXmlApplicationContext(
				"classpath:META-INF/spring/applicationContext.xml");

		FixedDepositController fixedDepositController = (FixedDepositController) context
				.getBean("controller");

		logger.info("Stan wysłania żądania informacji o lokacie : "
				+ fixedDepositController.submit());
		logger.info("Otrzymane informacje o lokacie : "
				+ fixedDepositController.get());
	}
}
