<?php
/*
 * Typ:    outputfilter
 * Nazwa:    gzip
 * Autor:    Joscha Feth, joscha@feth.com
 */
function smarty_outputfilter_gzip($tpl_source, &$smarty)
 
{
    /* wykorzystany poziom kompresji
       domylnie: 9
       -------------------------------------
                     0 -> 9
       gorsza kompresja -> lepsza kompresja
       mniej intensywne uycie procesora -> bardziej intensywne uycie procesora
       -------------------------------------
    */
    $compression_level = 9;

    /* wymuszenie kompresji nawet wtedy, gdy w nagwku HTTP_ACCEPT_ENCODING nie przesano wartoci gzip,
       na przykad system Norton Internet Security filtruje ten nagwek, ale 95% procent
       przegldarek, w tym Firefox i Opera obsuguj kompresj 
       .
       domylnie: true
    */
    $force_compression = true;

    // komunikat dodawany do rda szablonu, jeli ten jest skompresowany
    $append_message = "\n<!-- poziom kompresji zlib " . 
            $compression_level . " -->";

    // kompresja wyniku tylko wtedy, gdy:
    // - jeszcze nie przesano nagwkw
    // - jest dostpne rozszerzenie zlib
    // -w systemie smarty jest wyczone buforowanie
    // - przesano waciwy znacznik kodowania bd wymuszono kompresj
    if ((!headers_sent()) && (extension_loaded('zlib')) && (!$smarty->caching)
            && (strstr($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip')
            || $force_compression)) { 
        $tpl_source = $tpl_source . $append_message;
        $tpl_source = gzencode($tpl_source, $compression_level);
        header('Content-Encoding: gzip');
        header('Vary: Accept-Encoding');
        header('Content-Length: ' . strlen($tpl_source));
    }
    return $tpl_source;
}
?>
