#!/bin/bash
# Author: @theurbanpenguin
# Web: www.theurbapenguin.com
# Skrypt prosi o podanie typu plikw do skopiowania
# oraz docelowej lokalizacji kopii zapasowej w katalogu $HOME
# Wyszukiwanie plikw rozpoczyna si od katalogu domowego uytkownika
# Data ostatniej aktualizacji: July 4 2015
read -p "Podaj typ plikw, ktrych kopi zapasow chcesz utworzy: " file_suffix
read -p "Podaj nazw katalogu, w ktrym zostanie zapisana kopia zapasowa: " dir_name
# Kolejny wiersz tworzy katalog docelowy (o ile taki katalog jeszcze nie zosta utworzony)
test -d $HOME/$dir_name || mkdir -m 700 $HOME/$dir_name
# Polecenie find kopiuje pliki speniajce kryteria wyszukiwania
# np. .sh. Opcje -path, -prune oraz -o pozwalaj na wykluczenie 
# katalogu kopii zapasowej z wyszukiwania.
find $HOME -path $HOME/$dir_name -prune -o \
 -name "*$file_suffix" -exec cp {} $HOME/$dir_name/ \;
exit 0

