/*
 * nodeunit_suite.js
  * Zestaw testów jednostkowych dla aplikacji SPA.
 *
 * Zestaw należy uruchomić za pomocą polecenia /nodeunit <nazwa_tego_pliku>/.
*/

/*jslint         node    : true, continue : true,
  devel  : true, indent  : 2,    maxerr   : 50,
  newcap : true, nomen   : true, plusplus : true,
  regexp : true, sloppy  : true, vars     : false,
  white  : true
*/
/*global $, spa */

// Moduły zewnętrzne i zmienne globalne.
global.jQuery = require( 'jquery' );
global.TAFFY  = require( './js/jq/taffydb-2.6.2.js' ).taffy;
global.$      = global.jQuery;
require( './js/jq/jquery.event.gevent-0.1.9.js' );

// Nasze moduły i zmienne globalne.
global.spa = null;
require( './js/spa.js'       );
require( './js/spa.util.js'  );
require( './js/spa.fake.js'  );
require( './js/spa.data.js'  );
require( './js/spa.model.js' );

// Przykładowy kod.
spa.initModule();
spa.model.setDataMode( 'fake' );

var $t = $( '<div/>' );
$.gevent.subscribe(
  $t, 'spa-login',
  function ( event, user ){
    console.log( 'Login użytkownika to:', user );
  }
);

spa.model.people.login( 'Fred' );
