/*
 * socket.js — przykład dynamicznego ładowania kodu JS.
*/

/*jslint         node    : true, continue : true,
  devel  : true, indent  : 2,    maxerr   : 50,
  newcap : true, nomen   : true, plusplus : true,
  regexp : true, sloppy  : true, vars     : false,
  white  : true
*/
/*global */

// ------------ ROZPOCZĘCIE SEKCJI ZMIENNYCH ZAKRESU MODUŁU --------------
'use strict';
var
  setWatch,

  http      = require( 'http'      ),
  express   = require( 'express'   ),
  socketIo  = require( 'socket.io' ),
  fsHandle  = require( 'fs'        ),

  app       = express(),
  server    = http.createServer( app ),
  io        = socketIo.listen( server ),
  watchMap  = {}
  ;
// ------------- ZAKOŃCZENIE SEKCJI ZMIENNYCH ZAKRESU MODUŁU ---------------

// --------------- ROZPOCZĘCIE SEKCJI METOD NARZĘDZIOWYCH ------------------
setWatch = function ( url_path, file_type ) {
  console.log( 'Metoda setWatch wywołana w ' + url_path );

  if ( ! watchMap[ url_path ] ) {
    console.log( 'Ustawienie obserwowania w ' + url_path);

    fsHandle.watchFile(
      url_path.slice(1),
      function ( current, previous ) {
        console.log( 'Dostęp do pliku uzyskany' );
        if ( current.mtime !== previous.mtime ) {
          console.log( 'Plik zmieniony' );
          io.sockets.emit( file_type, url_path );
        }
      }
    );
    watchMap[ url_path ] = true;
  }
};
// ---------------- ZAKOŃCZENIE SEKCJI METOD NARZĘDZIOWYCH  -------------------

// ------------- ROZPOCZĘCIE SEKCJI KONFIGURACJI SERWERA ---------------
app.configure( function () {
  app.use( function ( request, response, next ) {
    if ( request.url.indexOf( '/js/'  ) >= 0 ) {
      setWatch( request.url, 'script' );
    }
    else if ( request.url.indexOf( '/css/' ) >= 0 ) {
      setWatch( request.url, 'stylesheet' );
    }
    next();
  });
  app.use( express.static( __dirname + '/' ) );
});

app.get( '/', function ( request, response ) {
  response.redirect( '/socket.html' );
});
// -------------- ZAKOŃCZENIE SEKCJI KONFIGURACJI SERWERA ----------------

// ----------------- ROZPOCZĘCIE SEKCJI URUCHAMIANIA SERWERA -------------------
server.listen( 3000 );
console.log(
  'Serwer Express nasłuchuje na porcie %d w trybie %s',
   server.address().port, app.settings.env
);
// ------------------ ZAKOŃCZENIE SEKCJI URUCHAMIANIA SERWERA --------------------
