/*
 * app.js — serwer Express z przykładowym modułem.
*/

/*jslint         node    : true, continue : true,
  devel  : true, indent  : 2,    maxerr   : 50,
  newcap : true, nomen   : true, plusplus : true,
  regexp : true, sloppy  : true, vars     : false,
  white  : true
*/
/*global */

// ------------ ROZPOCZĘCIE SEKCJI ZMIENNYCH ZAKRESU MODUŁU --------------
'use strict';
var
  http    = require( 'http'     ),
  express = require( 'express'  ),
  routes  = require( './routes' ),

  app     = express(),
  server  = http.createServer( app );
  
routes();
// ------------- ZAKOŃCZENIE SEKCJI ZMIENNYCH ZAKRESU MODUŁU ---------------

// ------------- ROZPOCZĘCIE SEKCJI KONFIGURACJI SERWERA ---------------
app.configure( function () {
  app.use( express.bodyParser() );
  app.use( express.methodOverride() );
  app.use( express.static( __dirname + '/public' ) );
  app.use( app.router );
});

app.configure( 'development', function () {
  app.use( express.logger() );
  app.use( express.errorHandler({
    dumpExceptions : true,
    showStack      : true
  }) );
});

app.configure( 'production', function () {
  app.use( express.errorHandler() );
});

// Wszystkie poniższe konfiguracje dotyczą tras.
app.get( '/', function ( request, response ) {
  response.redirect( '/spa.html' );
});

app.all( '/:obj_type/*?', function ( request, response, next ) {
  response.contentType( 'json' );
  next();
});

app.get( '/:obj_type/list', function ( request, response ) {
  response.send({ title: request.params.obj_type + ' lista' });
});

app.post( '/:obj_type/create', function ( request, response ) {
  response.send({ title: request.params.obj_type + ' utworzony' });
});

app.get( '/:obj_type/read/:id([0-9]+)',
  function ( request, response ) {
    response.send({
      title: request.params.obj_type
        + ' z id ' + request.params.id + ' znaleziony'
    });
  }
);

app.post( '/:obj_type/update/:id([0-9]+)',
  function ( request, response ) {
    response.send({
      title: request.params.obj_type 
        + ' z id ' + request.params.id + ' zaktualizowany'
    });
  }
);

app.get( '/:obj_type/delete/:id([0-9]+)',
  function ( request, response ) {
    response.send({
      title: request.params.obj_type 
        + ' z id ' + request.params.id + ' usunięty'
    });
  }
);
// -------------- ZAKOŃCZENIE SEKCJI KONFIGURACJI SERWERA ----------------

// ----------------- ROZPOCZĘCIE SEKCJI URUCHAMIANIA SERWERA -------------------
server.listen( 3000 );
console.log(
  'Serwer Express nasłuchuje na porcie %d w trybie %s',
   server.address().port, app.settings.env
);
// ------------------ ZAKOŃCZENIE SEKCJI URUCHAMIANIA SERWERA --------------------
