﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace Rozdzial5
{
    public partial class MediaElement : UserControl
    {
        public MediaElement()
        {
            InitializeComponent();
        }

        private void Play_Click(object sender, RoutedEventArgs e)
        {
            Video.Play();
            Pause.IsEnabled = true;
            Stop.IsEnabled = true;
        }

        private void Pause_Click(object sender, RoutedEventArgs e)
        {
            Video.Pause();
            Pause.IsEnabled = false;
        }

        private void Stop_Click(object sender, RoutedEventArgs e)
        {
            Video.Stop();
            Stop.IsEnabled = false;
            Pause.IsEnabled = false;
        }

        private void Video_MediaEnded(object sender, RoutedEventArgs e)
        {
            Video.Stop();
        }

        private void Video_MediaOpened(object sender, RoutedEventArgs e)
        {
            TextBlockPlaybackLenght.Text = Video.NaturalDuration.TimeSpan.Seconds.ToString() + "s";
        }

        private void Video_BufferingProgressChanged(object sender, RoutedEventArgs e)
        {
            if (Video.BufferingProgress == 1)
            {
                Play.IsEnabled = true;
            }
            
        }

        private void Video_CurrentStateChanged(object sender, RoutedEventArgs e)
        {
            TextBlockPlaybackState.Text = Video.CurrentState.ToString();
        }
    }
}
