﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace Rozdzial7
{
    public partial class AnimationControl : UserControl
    {
        public AnimationControl()
        {
            InitializeComponent();
        }

        private void LayoutRoot_Loaded(object sender, RoutedEventArgs e)
        {
            Animacja.Begin();
        }

        private void Play_Click(object sender, RoutedEventArgs e)
        {
            if ((sender as Button).Content.ToString() == "Odtwarzaj")
            {
                Animacja.Resume();
                (sender as Button).Content = "Pauza";
            }
            else
            {
                Animacja.Pause();
                (sender as Button).Content = "Odtwarzaj";
            }
        }

        private void Rwd_Click(object sender, RoutedEventArgs e)
        {
            if (Animacja.GetCurrentTime() >= TimeSpan.Parse("0:0:5"))
                Animacja.Seek(Animacja.GetCurrentTime() - TimeSpan.Parse("0:0:5"));
            else
                Animacja.Seek(TimeSpan.Parse("0:0:0"));
            Animacja.Resume();
        }

        private void Fwd_Click(object sender, RoutedEventArgs e)
        {
            Animacja.Seek(Animacja.GetCurrentTime() + TimeSpan.Parse("0:0:5"));
            Animacja.Resume();
        }

        private void Begin_Click(object sender, RoutedEventArgs e)
        {
            Animacja.Begin();
        }

        private void End_Click(object sender, RoutedEventArgs e)
        {
            Animacja.SkipToFill();
        }

        private void Stop_Click(object sender, RoutedEventArgs e)
        {
            Animacja.Stop();
            foreach (UIElement b in PanelStosu.Children)
                if (b is Button)
                    b.Visibility = Visibility.Collapsed;
        }
    }
}
