from matplotlib.ticker import FuncFormatter


def image_size_in_cm(width: float, height: float) -> tuple[float, float]:
    """
    Konwertuje żądany rozmiar obrazu z centymetrów na cale dla matplotlib.

    Funkcja przyjmuje żądany rozmiar w centymetrach i zwraca rozmiar w calach,
    który może być bezpośrednio użyty jako parametr figsize w matplotlib.

    Parameters
    ----------
    width : float
        Żądana szerokość obrazu w centymetrach.
    height : float
        Żądana wysokość obrazu w centymetrach.

    Returns
    -------
    tuple[float, float]
        Rozmiar obrazu w calach (szerokość, wysokość) gotowy do użycia w matplotlib.
    """
    inches_per_cm = 1 / 2.54
    return width * inches_per_cm, height * inches_per_cm


def change_comma_separator(x, pos):
    """
    Zmienia separator dziesiętny na przecinek.
    Parameters
    ----------
    x : float
        Wartość do formatowania.
    pos : float
        Pozycja na osi.

    Returns
    -------
    str: Wartość zmieniona na przecinek.
    """
    return ("{:.2f}".format(x)).replace(".", ",")


def change_plot_comma_separator(ax, x_change: bool = False, y_change: bool = True):
    """
    Zmienia separator dziesiętny na przecinek na osi x i y.
    """
    if x_change:
        ax.xaxis.set_major_formatter(FuncFormatter(change_comma_separator))
    if y_change:
        ax.yaxis.set_major_formatter(FuncFormatter(change_comma_separator))
